{ telnum.pas -- Algorithm #6: Telephonic Mnemonic by Tom Swan }

program TelNum;

var
  TelNumber: String;
  TelDial: array[0 .. 9] of String[3];
  inString: String;
  outString: String;

function ValueOfChar(c: Char): Integer;
begin
  ValueOfChar := Ord(c) - Ord('0')
end;

procedure Permute(n: Integer);
var 
  i, digit: Integer;
begin
  digit := ValueOfChar(inString[n]);
  for i := 1 to 3 do
  begin
    outString[n] := TelDial[digit][i];
    if (n = Length(inString)) then 
      Writeln(outString)
    else 
      Permute(n + 1)
  end
end;

begin
  TelDial[0] := '   ';  TelDial[1] := '   ';
  TelDial[2] := 'ABC';  TelDial[3] := 'DEF';
  TelDial[4] := 'GHI';  TelDial[5] := 'JKL';
  TelDial[6] := 'MNO';  TelDial[7] := 'PRS';
  TelDial[8] := 'TUV';  TelDial[9] := 'WXY';
  Write('Telephone number? ');
  Readln(inString);
  if (Length(inString) > 0) then
  begin
    outString := inString;
    Permute(1)
  end
end.


(*
// --------------------------------------------------------------
// Copyright (c) 1993 by Tom Swan. All rights reserved
// Revision 1.00    Date: 02/13/1993   Time: 02:54 pm
*)
