(* ----------------------------------------------------------- *(
**  sample.pas -- Algorithm #12: Selection Sampling            **
** ------------------------------------------------------------**
**  Creates a file SAMPLE.DAT with a specified number of names **
**  extracted from Grady Ward's Moby Words. The first line of  **
**  the output file indicates the number of selections.        **
**  Assumes the number of names in the source is known.        **
**                                                             **
**  Reference: Knuth, Vol 2, p122                              **
** ------------------------------------------------------------**
**     Copyright (c) 1993 by Tom Swan. All rights reserved.    **
)* ----------------------------------------------------------- *)

program Sample;
const
  M = 21420;  { Number of records in source }
  INFNAME = 'C:\moby\21400nam';  { Source file }
  OUTFNAME = 'sample.dat'; { Destination file }
var
  infile, outfile: Text;  { File variables }
  word: String;           { Holds each record from source }
  requested,              { Requested number of samples }
  examined,               { Total records examined }
  selected: Integer;      { Total records selected }
  r: Real;                { Random number 0 <= r < 1.0 }
begin
  Randomize;
  Writeln('Write selected names to ', OUTFNAME);
  Write('How many names? ');
  Readln(requested);
  if (requested <= 0) or (requested > M) then
  begin
    Writeln('Number must be >= 0 and <= ', M);
    Exit
  end;
  examined := 0;
  selected := 0;
  Assign(infile, INFNAME);
  Reset(infile);
  Assign(outfile, OUTFNAME);
  Rewrite(outfile);
  Writeln(outfile, requested);  { Save 'requested' in file }
  while (selected < requested) and (not Eof(infile)) do
  begin
    examined := examined + 1;
    r := Random;
    if (M + 1 - examined) * r >= requested - selected
    then
      Readln(infile)             { Skip next record }
    else
    begin                        { Select next record }
      selected := selected + 1;  { Count selections so far }
      Readln(infile, word);      { Read record from source }
      Writeln(outfile, word);    { Write record to destination }
      Writeln(word)              { Echo selection to display }
    end
  end;
  Close(infile);
  Close(outfile)
end.


(*
// ---------------------------------------------------------------
// Copyright (c) 1993 by Tom Swan. All rights reserved
// Revision 1.00    Date: 07/09/1993   Time: 11:00 am
// Revision 1.01    Date: 11/02/1993   Time: 08:36 am
   1. M should be equal to the number of records PLUS 1
      per Alexander J. Oss [71212,1674]
   2. While loop should also test for the end of file
*)
