/*	dosdir.h

	Defines structures, macros, and functions for dealing with
	directories and pathnames.

	Copyright (C) 1994 by Jason Mathews.
	Permission is granted to any individual or institution to use, copy
	or redistribute this software so long as it is not sold for profit,
	provided this copyright notice is retained.

	Modification history:

	 13-May-94  - Original version.
	 08-Jun-94  - Added VMS definitions.
*/

#ifndef _DOSDIR_H
#define _DOSDIR_H

/* Set up portability */
#include "tailor.h"

#if defined(MSDOS)
#  ifdef __TURBOC__
#    include <dos.h>
#    include <dir.h>
#  endif /* ?TURBOC */
#  ifndef FA_NORMAL
#    define FA_NORMAL 0x00
#  endif
#  define ALL_FILES_MASK "*.*"
#  define DIR_PARENT ".."
#  define DIR_END '\\'
#elif defined (UNIX)
#  include <memory.h>
#  include <dirent.h>
#  define ALL_FILES_MASK "*"
#  define DIR_PARENT ".."
#  define DIR_END '/'
#elif defined(VMS)
#  include <rms.h>
#  define ALL_FILES_MASK "*.*"
#  define DIR_PARENT "[-]"
#  define DIR_END  ']'
#endif /* ?__TURBOC__ */

#if (defined(UNIX) || defined(VMS))

#  include <string.h>
#  include <errno.h>

#  ifndef ENOENT
#    define ENOENT -1
#  endif
#  ifndef ENMFILE
#    define ENMFILE ENOENT
#  endif
#  if (defined(VMS) || !defined(vaxc$errno))
#    define vaxc$errno errno
#  endif

#  define FA_NORMAL   0x00        /* Normal file, no attributes */
#  define FA_RDONLY   0x01        /* Read only attribute */
#  define FA_HIDDEN   0x02        /* Hidden file */
#  define FA_SYSTEM   0x04        /* System file */
#  define FA_LABEL    0x08        /* Volume label */
#  define FA_DIREC    0x10        /* Directory */
#  define FA_ARCH     0x20        /* Archive */

#  define WILDCARDS 0x01
#  define EXTENSION 0x02
#  define FILENAME  0x04
#  define DIRECTORY 0x08
#  define DRIVE     0x10

#endif /* ?UNIX/VMS */

#ifdef UNIX

/*
 * MAXPATH defines the longest permissable path length,
 * including the terminating null. It should be set high
 * enough to allow all legitimate uses, but halt infinite loops
 * reasonably quickly.
 */
#define MAXPATH   1024
#define MAXDRIVE  1
#define MAXDIR    768
#define MAXFILE   256
#define MAXEXT    1

typedef struct dirent DIR_ENT;

struct ffblk {
  /* private data: */
  DIR*		ff_dirp;		/* Directory ptr */
  DIR_ENT*	ff_dp;			/* Directory entry */
  char          ff_attribs;             /* File search attributes */
  char          ff_filespec[MAXFILE];   /* File search mask */
  /* public data: */
  char*		ff_name;		/* File name */
  unsigned	ff_ftime;		/* File time */
  unsigned	ff_fdate;		/* File date */
  off_t         ff_fsize;               /* File length */
  char          ff_attrib;              /* Attribute byte of file */
};

#endif /* ?UNIX */

#ifdef VMS

#define MAXPATH   NAM$C_MAXRSS
#define MAXDRIVE  1
#define MAXDIR    NAM$C_MAXRSS
#define MAXFILE   80
#define MAXEXT    32

struct ffblk {
  /* private data: */
    struct FAB fab;
    struct NAM nam;
    char rms_filespec[MAXPATH];
    char esa[MAXPATH];
    char rsa[MAXPATH];
    char path[MAXPATH];
    char* filespec;
    char attribs;
  /* public data: */
    char*         ff_name;
    unsigned      ff_ftime;
    unsigned      ff_fdate;
    long          ff_fsize;
    char          ff_attrib;
};
#endif /* ?VMS */

#if (defined(UNIX) || defined(VMS))

#ifdef __cplusplus
extern "C" {
#endif

int  findfirst  OF((const char *path, struct ffblk *fb, int attrib));
int  findnext   OF((struct ffblk *fb));
int  fnsplit    OF((const char *path, char * drive, char * dir,
		    char * name, char * ext));
int  getdisk    OF((void));
int  setdisk    OF((int drive));

#ifdef __cplusplus
}
#endif

#endif /* ?UNIX/VMS */

#endif /* _DOSDIR_H */
