
(*********************************************************************
*                                                                    *
*   2M-INFO 2.1  -  Pequeo programa de informacin sobre 2M.        *
*                                                                    *
*********************************************************************)

(*$A+,B-,D-,E-,F-,I-,L-,N-,O-,R-,S-,V-*)

uses
  Dos, Crt;

const
  ID_ESPACIO     = 1886; (* lmite en las grficas *)
  ID_VELOCIDAD   = 4850;

  CM_CIRIT       = 14;   (* colores para la pantalla inicial/final *)
  CM_CIRIP       =  4;
  CM_2M          = 10;
  CM_2MS         = 10;
  CM_VERT        = 13;
  CM_VERF        =  6;
  CM_VERS        =  5;
  CM_INFO        =  9;
  CM_PAUSA       = 11;
  CC_RECUERDO    = 12;
  CC_DIR         = 14;

  CE_BARRADOST   = 11;   (* colores para la grafica de capacidad *)
  CE_BARRADOSP   =  1;
  CE_BARRA2MT    = 14;
  CE_BARRA2MP    =  4;
  CE_INDICE      = 13;
  CE_TITULOT     = 11;
  CE_TITULOP     =  1;
  CE_NOTA        = 14;
  CE_BASECOL     = 15;
  CE_LEYENDAS    = 10;

  CV_BARRADOST   =  3;   (* colores para la grafica de velocidad *)
  CV_BARRADOSP   =  1;
  CV_BARRA2MT    = 12;
  CV_BARRA2MP    =  6;
  CV_INDICE      = 13;
  CV_TITULOT     = 11;
  CV_TITULOP     =  5;
  CV_NOTA        = 14;
  CV_BASECOL     = 15;
  CV_LEYENDAS    = 10;

  M_FONDO        =  1;   (* color del men *)
  M_SOMBRA       =  3;
  M_TINTA        = 15;
  M_IDIOMA       = 11;
  M_TBARRA       =  0;
  M_FBARRA       =  7;

  R_CABT         = 14;   (* color para el readme *)
  R_CABP         =  5;
  R_TINTA        = 11;
  R_PAPEL        =  0;
  R_DIR          = 14;
  R_BRILLO       = 10;

  N_CABT         = 14;   (* color de las novedades *)
  N_CABP         =  4;
  N_TINTA        = 11;
  N_PAPEL        =  1;

  O2_TINTA       = 14;   (* color de las informacin de OS/2 *)
  O2_PAPEL       =  1;

  XT_TINTA       = 15;   (* color de la informacin de PC/XT *)
  XT_PAPEL       =  1;   

  I_2M1          = 15;   (* color para la informacin de registro *)
  I_2M2          = 13;
  I_FONDO        =  0;
  I_CIRI         = 14;
  I_FLECHA       = 12;
  I_STAR         = 15;
  I_REG          = 11;
  I_REGTT        = 11;
  I_REGTP        =  1;
  I_CON          = 10;
  I_CONT         = 14;


type
  Vram=array [1..4096] of Byte;  (* tamao de la memoria de vdeo *)
  Matriz=array [0..3] of array [0..2] of Integer;

var
  xPrev,yPrev,      (* coordenadas del cursor previas al programa *)
  modo:Byte;        (* modo de pantalla previo a este programa *)
  ScrColor:Vram absolute $b800:0;  (* direccin memoria pantalla color *)
  ScrMono: Vram absolute $b000:0;  (*    "        "        " monocroma *)
  pantalla:Vram;                   (* para preservar memoria de vdeo *)
  opcion,                          (* Opcin del men en curso *)
  ultopc: Integer;                 
  idioma: Integer;                 (* 34 si castellano *)


function ModoPantalla:Byte;
var
  r:Registers;
begin
  r.ah:=15; intr(16,r);  (* funcin BIOS para averiguar modo de pantalla *)
  ModoPantalla:=r.al;
end;


procedure GuardarPantalla;
begin
  modo:=ModoPantalla; (* inicializar aqu esta variable global *)
  if modo=7 then pantalla:=ScrMono else pantalla:=ScrColor;
  xPrev:=whereX; yPrev:=whereY;
  if (modo<>2) and (modo<>3) then TextMode(CO80);
end;


procedure ReponerPantalla;
begin
  textMode(modo);
  window(1,1,80,25); gotoXY(xPrev,yPrev);
  if (modo<=3) or (modo=7) then
    if ModoPantalla=7 then ScrMono:=pantalla else ScrColor:=pantalla;
end;


procedure CursorOff;
var
  r:Registers;
begin
  r.dh:=100; r.dl:=0; r.bh:=0; (* coordenadas fuera de pantalla *)
  r.ah:=2; intr(16,r)  (* servicio del BIOS para localizar el cursor *)
end;


function sp:Boolean;
var
  r:     Registers;
  id:    Byte;
  datos: array[1..128] of byte;
begin
  if idioma<2 then begin     (* 0-evaluar, 1-invertir, 2-sp, 3-eng *)
        r.ah:=$30; MsDos(r);
        if r.al>=3 then begin  (* DOS = 3.0 *)
          r.ax:=$3800; r.ds:=SEG(datos); r.dx:=OFS(datos); msdos (r);
          case r.bx of
            54, 591, 57, 506, 56, 593, 503, 34, 63, 502,
            504, 212, 52, 505, 507, 595, 51, 80, 508, 598,
            58, 3, 0: id:=34;
          end
        end;
        if idioma=0 then if id=34 then idioma:=2 else idioma:=3;
        if idioma=1 then if id=34 then idioma:=3 else idioma:=2;
      end;
  sp:=idioma=2;
end;


procedure Pausa;
var
  t:Char;
begin
  CursorOff;
  t:=readkey; if t=chr(0) then t:=readkey;
end;


procedure PantallaGalactica (logo: Boolean);
var
  x: Integer;
procedure escribir (cad: String);
var
  i:Integer;
begin
  gotoxy (8, WhereY);
  for i:=1 to length(cad) do
    case cad[i] of
      ' ':            write (' ');
      '.', '':       begin TextColor(random(6)+10); write (cad[i]); end;
      '':            if i<35 then
                          begin TextColor(CM_2M); write (''); end
                        else
                          begin TextColor(CM_VERT); TextBackGround(CM_VERF);
                                write (''); TextBackGround(0); end;
      '', '', '':  if i<35 then
                          begin TextColor(CM_2MS); write (cad[i]); end
                        else
                          begin TextColor(CM_VERS); write (cad[i]); end;
    end;
  writeLn;
end; (* escribir *)
begin
  TextBackGround(0); ClrScr;
  RandSeed:=7;
  for x:=1 to 79 do begin
      gotoXY (x,random(25)); TextColor(random(6)+2);  write('.');
      gotoXY (x,random(25)); TextColor(random(6)+2);  write('');
      gotoXY (x,random(25)); TextColor(random(6)+10); write('.');
      gotoXY (x,random(25)); TextColor(random(6)+10); write('');
      gotoXY (x,random(25)); TextColor(random(6)+10); write('');
    end;
  if logo=TRUE then begin
    gotoxy (1,6);
    escribir('        ');
    escribir('      ');
    escribir(' ߱.   ');
    escribir('       .    ܱ');
    escribir('      .     ۱۱');
    escribir('  ߱  .   .     .');
    escribir('           ߱       ');
    escribir('   .       .           ߱');
    escribir('    .         .       .     ');
    escribir('   .                    .    .');
    escribir('     .         .          ');
    escribir(' .        .   ');
    escribir('       .           ');
    CursorOff;
  end;
end;


procedure Presentacion;
begin
  gotoxy(10,3); TextColor (CM_CIRIT); TextBackGround (CM_CIRIP);
  write(' C I R I A C O    G A R C I A    D E    C E L I S    ');
  if sp then write('presenta ') else write('presents ');
  gotoxy(6-ord(sp),21); TextColor (CM_INFO); TextBackGround(0);
  if sp then
      write('El formateador de discos de mayor capacidad y velocidad ... en el mundo')
    else
      write('The highest capacity formatter of faster diskettes ... over the world');
  gotoxy(34-ord(sp)*2,24); TextColor (CM_PAUSA);
  if sp then
      write('(Pulsa una tecla)')
    else
      write('(Press any key)');
  CursorOff;
end;


procedure menu (var opcion: Integer);
var
  i:Integer;
  t:Char;
procedure PintaOp (opcion: Integer);
begin
  gotoXY (3,opcion+1);
  case opcion of
    1: if sp then
           write(' 1.- COMPARATIVA DE CAPACIDAD DE LOS DISQUETES 2M ')
         else
           write(' 1.- STORAGE COMPARISON BETWEEN 2M AND DOS FORMAT ');
    2: if sp then
           write(' 2.- COMPARATIVA DE VELOCIDAD DE LOS DISQUETES 2M ')
         else
           write(' 2.- SPEED COMPARISON BETWEEN 2M AND DOS FORMAT ');
    3: if sp then
           write(' 3.- 2M ES MUY FACIL DE USAR ')
         else
           write(' 3.- USING 2M IS VERY EASY ');
    4: if sp then
           write(' 4.- NOVEDADES DE ESTA VERSION ')
         else
           write(' 4.- WHAT IS NEW ON THIS RELEASE ');
    5: if sp then
           write(' 5.- USO DE 2M BAJO OS/2 2.0+ ')
         else
           write(' 5.- USING 2M UNDER OS/2 2.0+ ');
    6: if sp then
           write(' 6.- USO DE ALTA DENSIDAD Y 2M EN SISTEMAS PC/XT ')
         else
           write(' 6.- USING HIGH DENSITY AND 2M ON PC/XT COMPUTERS ');
    7: if sp then
           write(' 7.- LICENCIA DE USO DE ESTE PROGRAMA ')
         else
           write(' 7.- LICENSE TO USE THIS PROGRAM ');
    8: if sp then
           write(' 8.- SALIR ')
         else
           write(' 8.- EXIT ');
  end
end;
begin  (* menu *)
  if (opcion=9) then opcion:=ultopc else begin
    opcion:=opcion+1;
    Pantallagalactica (FALSE);
    window (16,9,69,18); TextBackGround (M_SOMBRA); ClrScr;
  end;
  window (14,8,67,17);
  TextBackGround (M_FONDO); TextColor (M_FONDO); ClrScr;
  window (14,8,68,17);
  write(''); for i:=1 to 52 do write(''); write('');
  for i:=2 to 9 do begin  (* slo visible en MDA *)
    gotoXY(1,i); write(''); gotoXY(54,i); write('');
  end;
  writeLn;
  write(''); for i:=1 to 52 do write(''); write('');
  TextColor (M_IDIOMA); gotoXY(42,10);
  if sp then write('F9 - ENGLISH') else write('F9 - ESPAOL');
  TextColor (M_TINTA); for i:=1 to 8 do PintaOp(i);
  ultopc:=opcion;
  repeat
    TextColor (M_TBARRA); TextBackGround (M_FBARRA); PintaOp (opcion);
    CursorOff;
    t:=ReadKey; if ord(t)=0 then t:=ReadKey;
    case ord(t) of
      67:     begin opcion:=9; t:=chr(13); end;
      72:     if (opcion>1) then opcion:=opcion-1 else opcion:=8;
      80, 32: if (opcion<8) then opcion:=opcion+1 else opcion:=1;
      71, 73: opcion:=1;
      79, 81: opcion:=8;
      27:     if opcion=8 then t:=chr(13) else opcion:=8;
      else
        if ((ord(t)>=49) and (ord(t)<=57)) then
          begin opcion:=ord(t)-48; t:=chr(13); end;
    end;
  TextColor (M_TINTA); TextBackGround (M_FONDO);
  PintaOp(ultopc); if (opcion<>9) then ultopc:=opcion;
  until (ord(t)=13);
  if (opcion<>9) then begin
    window (1,1,80,25); TextBackGround(0); TextColor(15); ClrScr;
  end;
end;


procedure readme;
begin
  TextColor(R_TINTA); TextBackGround(R_PAPEL); write('            ');
  TextColor(R_CABT); TextBackGround(R_CABP);
  if sp then
      writeLn(' Slo quiero decirte 3 cosas: ')
    else
      writeLn(' Only three things I want to tell you: ');
  TextColor(R_TINTA); TextBackGround(R_PAPEL);
  writeLn;
  if sp then begin
      writeLn('       - 2M  no es solo el formateador de mayor capacidad hasta el momento;');
      writeLn('     los disquetes 2M son tambin los ms rpidos (lee 2M-PERF.DOC para ms');
      writeLn('     informacin). Aviso: los disquetes ED de 2.88M NO HAN SIDO PROBADOS.');
      writeLn;
      writeLn('       - Los disquetes 2M son tan fiables como los de 360-1.2-720-1.44-2.88');
      writeLn('     del sistema,  el secreto es un mayor tamao de sector (as, el espacio');
      writeLn('     empleado por los GAP entre sectores es menor al haber menos sectores).');
      writeLn('     Es mejor emplear los formatos estndar (820-1476-984-1804-3608). No es');
      writeLn('     recomendable emplear los formatos mximos (902-1558-1066-1886-3772) al');
      writeLn('     ser menos seguros (los GAP son muy pequeos) y muchsimo ms lentos.');
      writeLn;
      TextColor(R_BRILLO);
      writeLn('       - 2M es fcil de usar.  Simplemente, ejectalo en tu AT (normalmente');
      writeLn('     desde el autoexec.bat) para que se quede en memoria (o 2M.SYS desde el');
      writeLn('     config.sys) y si an no tienes un disco 2M, cralo con 2MF A: o 2MF B:');
      TextColor(R_TINTA);
      writeLn;
      writeLn('     Para cualquier cuestin/comentario... Email > Internet: ciri@gui.uva.es');
      writeLn('                                                 > Fidonet:  2:341/21.8');
      write('     Mi direccin:  '); TextColor(R_DIR);
      writeLn('Ciriaco Garca de Celis');
      writeLn('                       C/Renedo, 2, 4-C'); TextColor (R_DIR);
      write('                       47005 Valladolid'); TextColor (R_TINTA); writeLn('    Recuerda: Yo digo "2M es seguro",');
      TextColor (R_DIR);
      write('                           (ESPAA)'); TextColor (R_TINTA); writeLn('         y yo solo uso disquetes 3M! :)');
    end else begin
      writeLn('       - 2M  is not only the highest capacity formatter at this moment,  but');
      writeLn('     also  2M  diskettes  are  the  fastest  ones (see  2M-PERF.DOC for more');
      writeLn('     information). Note that 2.88M ED diskettes HAVE NOT BEEN TESTED.');
      writeLn;
      writeLn('       - 2M diskettes are as reliable as DOS standard 360-1.2-720-1.44-2.88;');
      writeLn('     the secret is a greater sector size (space used by GAPs between sectors');
      writeLn('     is lower because the number of sectors is lower).  I  always  recommend');
      writeLn('     the standard formats  (820-1476-984-1804-3608).  You should not use the');
      writeLn('     maximum  capacity  formats  (902-1558-1066-1886-3772), because they are');
      writeLn('     less reliable (GAPs are very small) and too much slower.');
      writeLn;
      TextColor(R_BRILLO);
      writeLn('       - 2M is easy to use.  Simply  execute 2M on your AT computer (usually');
      writeLn('     from autoexec.bat) to install 2M on memory  (or 2M.SYS from config.sys)');
      writeLn('     and, if you don''t have a 2M diskette, make it with 2MF A: or 2MF B:');
      TextColor(R_TINTA);
      writeLn;
      writeLn('     For any questions or comments, E-mail me at > Internet: ciri@gui.uva.es');
      writeLn('                                                 > Fidonet:  2:341/21.8');
      write('     or Mail me at: '); TextColor(R_DIR);
      writeLn('Ciriaco Garca de Celis');
      writeLn('                       C/Renedo, 2, 4-C'); TextColor (R_DIR);
      write('                       47005 Valladolid'); TextColor (R_TINTA); writeLn('    Remember: I say "2M is secure",');
      TextColor (R_DIR);
      write('                           (SPAIN)'); TextColor (R_TINTA); writeLn('         and I only use 3M diskettes! :)');
    end;
end;


procedure Nuevo2M;
begin
  TextColor(N_TINTA); TextBackGround(N_PAPEL); ClrScr;
  if sp then begin
      WriteLn; write('            ');
      TextColor(N_CABT); TextBackGround(N_CABP);
      writeLn(' LA VERSION 2.1 DE 2M AADE A LAS VERSIONES 2.0 Y 1.3 ');
      TextColor(N_TINTA); TextBackGround(N_PAPEL);
      writeLn;
      writeLn('  + En los disquetes de las versiones anteriores a la 2.0 se permite alterar');
      writeLn('    de nuevo el sector de arranque, dentro de ciertos lmites,  mejorando la');
      writeLn('    compatibilidad con ciertas utilidades (los disquetes de la versin 2.0 y');
      writeLn('    posteriores poseen un arranque virtual totalmente modificable).');
      writeLn('  + 2M-ABIOS y 2M-XBIOS actualizan la informacin DOS acerca del tipo de las');
      writeLn('    unidades, con lo que la totalidad del software  (no slo el que accede a');
      writeLn('    nivel BIOS) conoce correctamente su tipo.  Con FORMAT ya no es necesario');
      writeLn('    ahora en ningn caso indicar el nmero de pistas o sectores.');
      writeLn('  + Corregido un fallo de DMA que poda colgar el PC en la instalacin de 2M.');
      writeLn;
      TextColor(N_TINTA); TextBackGround(N_PAPEL); write('                ');
      TextColor(N_CABT); TextBackGround(N_CABP);
      writeLn(' LA VERSION 2.0 DE 2M AADIO A LA VERSION 1.3 ');
      TextColor(N_TINTA); TextBackGround(N_PAPEL);
      writeLn;
      writeLn('  + Los disquetes 2M pueden ser empleados sin 2M.COM ni 2M.SYS instalados en');
      writeLn('    el disco duro, si son de alta densidad (ver 2MF /?).');
      writeLn('  + Los disquetes 2M soportan el comando SYS y pueden ser botables si son de');
      writeLn('    alta densidad, gracias al cdigo SuperBOOT y al arranque virtual.');
      writeLn('  + La utilidad SecureDrive 1.3d de (entre otros autores) Edgar Swank (USA),');
      writeLn('    trabaja correctamente con disquetes 2M gracias a la valiosa contribucin');
      writeLn('    de Edgar Swank encontrando y corrigiendo fallos en el listado de 2M.');
      writeLn('  + Nuevos formatos de disco para 2.88M');
      writeLn('  + Soporte total para alta densidad en PC/XT (discos estndar y 2M).');
    end else begin
      WriteLn; write('            ');
      TextColor(N_CABT); TextBackGround(N_CABP);
      writeLn(' THE 2.1 RELEASE OF 2M ADDS TO 2.0 AND 1.3 RELEASE ');
      TextColor(N_TINTA); TextBackGround(N_PAPEL);
      writeLn;
      writeLn('  + In 2M diskettes prior to 2.0 release it is allowed again to modify some');
      writeLn('    fields of boot record, within some reasonable limits,  in  order to get');
      writeLn('    more compatibility with some utilities (2M 2.0 diskettes and successive');
      writeLn('    have a virtual boot sector which can be completely modified).');
      writeLn('  + Now, 2M-ABIOS and 2M-XBIOS set the DOS disk drives type info;  so, most');
      writeLn('    software  (not only at BIOS access level)  can detect now correctly the');
      writeLn('    diskette types. For example, with FORMAT it is not necessary to set the');
      writeLn('    number of tracks or sectors per track.');
      writeLn('  + A DMA problem that could hang system while loading 2M has been fixed.');
      writeLn;
      TextColor(N_TINTA); TextBackGround(N_PAPEL); write('                ');
      TextColor(N_CABT); TextBackGround(N_CABP);
      writeLn(' THE 2.0 RELEASE OF 2M ADDED TO 1.3 RELEASE ');
      TextColor(N_TINTA); TextBackGround(N_PAPEL);
      writeLn;
      writeLn('  + 2M diskettes can be used on computers without 2M.COM or 2M.SYS installed');
      writeLn('    on hard disk (only high density ones, see 2MF /? for more information).');
      writeLn('  + DOS standard SYS command is now able to make full bootable 2M diskettes,');
      writeLn('    in the new 2M SuperBOOT mode, using a virtual boot sector.');
      writeLn('  + SecureDrive 1.3d program from (between others)  Edgar Swank (USA)  works');
      writeLn('    now correctly with 2M 2.0 diskettes, due to the valuable contribution of');
      writeLn('    Edgar Swank finding and correcting bugs in 2M source code.');
      writeLn('  + New 2.88M diskettes support added.');
      writeLn('  + PC/XT systems full high density support (DOS standard and 2M diskettes).');
    end;
end;


procedure UsoOS2;
begin
  window(1,2,80,24);
  TextColor(O2_TINTA); TextBackGround(O2_PAPEL); ClrScr;
  if sp then begin
      writeLn;
      writeLn('    OS/2  puede trabajar con 2M siempre que se cargue el DOS desde un disquete,');
      writeLn('  desde una particin tipo DOS, o desde un fichero imagen de un disquete DOS de');
      writeLn('  arranque que se puede crear con la utilidad VMDISK de OS/2. En estas ventanas');
      writeLn('  DOS se puede acceder a las particiones HPFS,  instalando  en el CONFIG.SYS la');
      writeLn('  utilidad FSFILTER.SYS;  adems,  este driver es necesario para poder escribir');
      writeLn('  sobre las particiones FAT ordinarias.  Despus,  con FSACCESS se podra hacer');
      writeLn('  que A: vuelva a ser la disquetera (si se ha arrancado de un fichero imagen).');
      writeLn;
      writeLn('    Sin embargo, FSFILTER anula las llamadas del DOS a la BIOS de disco, motivo');
      writeLn('  por el cual el cdigo residente de 2M no puede trabajar. Para solucionar este');
      writeLn('  fallo, hay que instalar despus DRIVER.SYS en el CONFIG.SYS para cada unidad:');
      writeLn;
      writeLn('                DEVICE=DRIVER.SYS /D:n  (n=0 para A:, 1 para B:...)');
      writeLn;
      writeLn('    Desde ese momento se podr acceder a los disquetes 2M en esas ventanas  DOS');
      writeLn('  a travs de las nuevas unidades lgicas creadas,  aunque  para  formatear con');
      writeLn('  2MF ser necesario indicar A: o B: como siempre.  Cuando  un  disquete  2M no');
      writeLn('  est siendo accedido, es conveniente retirarlo de la unidad,  para evitar que');
      writeLn('  una de las peridicas inspecciones que OS/2  realiza  sobre  las  disqueteras');
      writeLn('  detenidas  pueda  colapsar la ventana  (aunque slo se detendra hasta que el');
      writeLn('  usuario retirase el disquete).');
    end else begin
      writeLn;
      writeLn('    OS/2 can work with 2M while using DOS from diskette drive,  from a DOS hard');
      writeLn('  disk partition,  or booting DOS from DOS boot disk file image created by OS/2');
      writeLn('  VMDISK utility.  In these DOS windows, the HPFS partitions can be accessed by');
      writeLn('  installing the FSFILTER.SYS driver in CONFIG.SYS;  this driver is also needed');
      writeLn('  to write on FAT partitions.  After installing FSFILTER,  FSACCESS can be used');
      writeLn('  to  make  A:  corresponding to the real disk drive if boot has been done from');
      writeLn('  disk file image.');
      writeLn;
      writeLn('    But FSFILTER overrides DOS calls to disk BIOS routines:  the  resident code');
      writeLn('  of 2M can not work in this mode.  To  solve  this problem,  you  can  install');
      writeLn('  DRIVER.SYS program in CONFIG.SYS for each diskette drive:');
      writeLn;
      writeLn('               DEVICE=DRIVER.SYS /D:n  (n=0 para A:, 1 para B:...)');
      writeLn;
      writeLn('    From now on,  in these DOS windows,  diskette drives can be accesed through');
      writeLn('  the new drive letters assigned by DRIVER.SYS, but for 2MF format the original');
      writeLn('  ones (A: and B:) must be selected. While 2M diskette isn''t being used it must');
      writeLn('  be retired from diskette drive in order to avoid the OS/2 periodical diskette');
      writeLn('  drives inspection when drives are stopped.  Otherwise, the DOS window may get');
      writeLn('  colapsed,  although when user will retire the diskette, it will turn into the');
      writeLn('  normal function.');
    end;
  window(1,1,80,25);
end;


procedure UsoPCXT;
begin
  TextColor(XT_TINTA); TextBackGround(XT_PAPEL); ClrScr;
  if sp then begin
      writeLn;
      writeLn('    2MX permite trabajar en PC/XT equipados con controladoras de alta densidad,');
      writeLn('  tales como Amstrad 2086 u Olivetti Cuaderno. El nico requisito es equiparlos');
      writeLn('  tambin con una unidad de alta densidad si no la incorporaban de fbrica.');
      writeLn;
      writeLn('    En las dems mquinas PC/XT se puede sustituir la controladora de disquetes');
      writeLn('  por otra de AT (incluso de 16 bits; no importa que quede la mitad de la misma');
      writeLn('  sin insertar en el slot de expansin; se pueden deshabilitar las funciones no');
      writeLn('  necesarias con los jumpers adecuados, aunque ni eso es necesario).');
      writeLn;
      writeLn('    Si la BIOS no soporta alta densidad, caso ms probable si se ha aadido una');
      writeLn('  controladora de AT, habr que cargar 2M-XBIOS antes que 2MX, y disponer de un');
      writeLn('  disco duro o de una unidad A: de doble densidad de donde poder arrancar el PC');
      writeLn('  al principio.  Este programa moderniza y agiliza el acceso a disco incluso en');
      writeLn('  mquinas con controladoras de doble densidad,  constituyendo por s mismo una');
      writeLn('  opcin interesante. 2M-XBIOS sustituye por completo a la BIOS original del PC');
      writeLn('  en las tareas de control de disquetes,  por lo que debe ser instalado siempre');
      writeLn('  antes que cualquier otro residente que acceda al disco (para no anularlo).');
      writeLn;
      writeLn('    Con 2MX se podr adems acceder a los disquetes 2M sin limitaciones.  Si la');
      writeLn('  mquina  posee  un  conmutador de turbo, al cambiar la velocidad de la CPU se');
      writeLn('  afecta al normal funcionamiento de 2M-XBIOS y 2MX. Si hubiera problemas en el');
      writeLn('  acceso a disco,  se pueden ejecutar estos programas en cualquier momento para');
      writeLn('  actualizar las constantes internas de retardo a la velocidad actual del PC.');
    end else begin
      writeLn;
      writeLn('    2MX improves 2M diskettes support for your PC/XT, if it has an high density');
      writeLn('  diskette controller, as Amstrad 2086 or Olivetti Cuaderno.  All what you need');
      writeLn('  is to install an high density drive if the original one is double density.');
      writeLn;
      writeLn('    In the rest of PC/XT machines, the diskette controller can be replaced by a');
      writeLn('  AT controller (if to find a PC/XT high density card is difficult).  There  is');
      writeLn('  no problem with 16-bit cards: insert only half card on the expansion slot and');
      writeLn('  disable the unused functions with jumpers (often this is neither necessary).');
      writeLn;
      writeLn('    If BIOS don''t support high density (the most common situation when adding a');
      writeLn('  AT high density controller) then it is necessary to load 2M-XBIOS before 2MX,');
      writeLn('  and the machine must be equiped with a hard disk or a double density drive A:');
      writeLn('  where  boot  from  at start up time.  This program upgrades and improves disk');
      writeLn('  access techniques,  also with double density drives and controllers, so it is');
      writeLn('  an interesting option by itself. 2M-XBIOS replaces the complete original BIOS');
      writeLn('  diskette functions;  it  always must be installed before the rest of diskette');
      writeLn('  TSR software (to avoid override them).');
      writeLn;
      writeLn('    With 2MX loaded on memory 2M diskettes can be used with no restrictions. If');
      writeLn('  the computer has a turbo switch,  changing  the  CPU speed may cause abnormal');
      writeLn('  function  on  2M-XBIOS  and 2MX.  If you detect  any  problem in disk access,');
      writeLn('  this  programs  can  be  executed  in any moment to update the internal delay');
      writeLn('  constants to the current system speed.');
    end;
end;


procedure Licencia;
procedure pr(color2m: Integer; cadena:String);
var
  i:Integer;
begin
  for i:=1 to length(cadena) do begin
    if i=1  then TextColor(I_REG);
    if i=34 then TextColor(color2m);
    if i=52 then TextColor(I_CON);
    write(cadena[i]);
  end;
  writeLn;
end;
begin
  TextColor(I_REGTT); TextBackGround(I_FONDO);
  writeLn; write('    '); TextBackGround(I_REGTP);
  if sp then begin
      writeLn(' INFORMACION DE REGISTRO ');
      TextBackGround(I_FONDO); TextColor(I_2M1);
      write('                                         '); TextColor(I_CONT); writeLn('    Condiciones del contrato:');
      pr(I_2M2,'  2M no es un programa gratuito,              - No modificar el programa,');
      pr(I_2M1,'sino un programa CARDWARE.  Esto              excepto para uso propio.');
      pr(I_2M2,'quiere decir que  si usted ya lo            - Distribuirlo  siempre  de');
      pr(I_2M1,'utilizaba o piensa hacerlo desde               manera gratuta.');
      pr(I_2M2,'ahora,  adems  de aceptar todas        - No distribuyendo completo');
      pr(I_2M1,'las condiciones,  debe  enviarme                todo el paquete indquese');
      pr(I_2M2,'una tarjeta postal  desde  donde                la manera de obtenerlo.');
      pr(I_2M1,'vive (no enve dinero) a:                     - El autor no asume ninguna');
      pr(I_2M2,'                                                garanta, ni es responsa-');
      pr(I_2M1,'    Ciriaco Garca de Celis                     ble de los fallos y daos');
      pr(I_2M2,'       C/Renedo, 2, 4-C                    que pudieran ocasionarse.');
      pr(I_2M1,'       47005 Valladolid                             - Enviar la tarjeta postal.');
      pr(I_2M2,'           (ESPAA)');
    end else begin
      writeLn(' REGISTER INFORMATION ');
      TextBackGround(I_FONDO); TextColor(I_2M1);
         write('                                         '); TextColor(I_CONT); writeLn('      Contract conditions:');
      pr(I_2M2,'  2M  is  not a freeware program              - Do not modify the program');
      pr(I_2M1,'but it is CARDWARE.  This  means              except for personal use.');
      pr(I_2M2,'that if you are already using it            - Distribute it always with');
      pr(I_2M1,'or you decide to use it from now               no charge.');
      pr(I_2M2,'on, then you must agree with all        - If you do not  distribute');
      pr(I_2M1,'contract conditions and you must                the whole ZIP you have to');
      pr(I_2M2,'send me a postcard from the pla-                tell where to get it from');
      pr(I_2M1,'ce you live (do not send money):              - The author doesn''t assume');
      pr(I_2M2,'                                                any  warranty  about  any');
      pr(I_2M1,'    Ciriaco Garca de Celis                     possible damage / failure');
      pr(I_2M2,'       C/Renedo, 2, 4-C                    caused by this program.');
      pr(I_2M1,'       47005 Valladolid                             - You must send me a card.');
      pr(I_2M2,'           (SPAIN)');
    end;
  TextColor(I_FLECHA);
  writeLn('                                                                          ');
  writeLn('                    ');
  writeLn('                                                                           ');
  TextColor(I_CIRI);
  write('                                ');
  TextColor(I_STAR); write('');
  TextColor(I_FLECHA); writeLn('    '); TextColor(I_CIRI);
  writeLn('                                                       ');
  writeLn('                                        ');
  writeLn('                                                 ');
  writeLn('                                  ');
end;


Procedure MensajeCardware;
begin
  TextColor (CC_RECUERDO); TextBackGround(0);
  gotoxy(12-ord(sp)*3,21);
  if sp then
      write('2M es CARDWARE. Por favor, recuerde enviar una tarjeta postal a:')
    else
      write('2M is CARDWARE. Please, remember to mail me a postcard at:');
  TextColor (CC_DIR);
  gotoxy(30,22); write('Ciriaco Garca de Celis');
  gotoxy(34,23); write('C/Renedo, 2, 4-C');
  gotoxy(30-ord(sp),24); write('47005 Valladolid ');
  if sp then write ('(Espaa)') else write ('(Spain)');
  CursorOff;
end;


procedure Grafica (id, ctI, cpI, ctD, cpD, cI, cB: Integer; datos:Matriz);
var
  disco, columna, altura, x, maxx: Integer;
begin
  TextBackGround (0); ClrScr;
  for disco:=0 to 3 do
    for columna:=0 to 1 do begin
      if columna=0 then begin
          TextColor (ctI); textBackGround (cpI); end
        else begin
          TextColor (ctD); textBackGround (cpD); end;
      for altura:=0 to round(datos[disco,columna]/(id/20.0)) do begin
        maxx:=7+disco*18+columna*6;
        for x:=maxx to maxx+4 do begin
          gotoxy (x, 22-altura);
          if columna=0 then write('') else write('');
          end;
        end;
      TextBackGround(0); TextColor (cI);
      if (columna=0) or (id=ID_VELOCIDAD) then begin
          gotoxy (maxx, 21-altura);
          if (id=ID_ESPACIO) then
              write(datos[disco, columna]:5)
            else
              write(datos[disco, columna]/100:2:2);
          end
        else begin
          gotoxy (maxx-2, 21-altura);
          write(datos[disco, columna+1]:4,'/',datos[disco, columna]); end
    end;
  TextColor (ctI); textBackGround (cpI);
  gotoxy(7,25); write('');
  TextColor (ctD); textBackGround (cpD);
  gotoxy(26,25); write('');
  TextBackGround(0); gotoxy (10,23); TextColor (cB);
  write('5-DD             5-HD             3-DD             3-HD');
end;


procedure GraficaEspacio;
var
  datos : Matriz;
begin
  datos[0,0]:= 360; datos[0,1]:= 902; datos[0,2]:= 820;
  datos[1,0]:=1200; datos[1,1]:=1558; datos[1,2]:=1476;
  datos[2,0]:= 720; datos[2,1]:=1066; datos[2,2]:= 984;
  datos[3,0]:=1440; datos[3,1]:=1886; datos[3,2]:=1804;
  Grafica (ID_ESPACIO, CE_BARRADOST, CE_BARRADOSP, CE_BARRA2MT,
           CE_BARRA2MP, CE_INDICE, CE_BASECOL, datos);
  TextBackGround(CE_TITULOP); TextColor(CE_TITULOT);
  gotoxy (3,1); if sp then write('Ŀ') else write('Ŀ');
  gotoxy (3,2); if sp then write(' CAPACIDAD ') else write('   DISK   ');
  gotoxy (3,3); if sp then write(' DEL DISCO ') else write(' CAPACITY ');
  gotoxy (3,4); if sp then write('') else write('');
  TextBackGround(0); TextColor (CE_NOTA);
  gotoxy (4,6); if sp then write (' En') else write('In'); write(' Kbytes');
  TextColor(CE_LEYENDAS);
  gotoxy (10,25);
  if sp then write('FORMAT') else write('DOS FORMAT');
  gotoxy (29,25);
  if sp then write('2M Normal/Mxima') else write('2M Normal/Maximum');
  gotoxy (57-ord(sp)*2,25);
  if sp then write('(Pulsa una tecla)') else write('(Press any Key)');
end;


procedure GraficaVelocidad;
var
  datos:Matriz;
begin
  datos[0,0]:=1816; datos[0,1]:=2502;
  datos[1,0]:=3013; datos[1,1]:=4633;
  datos[2,0]:=1505; datos[2,1]:=2574;
  datos[3,0]:=3014; datos[3,1]:=4850;
  Grafica (ID_VELOCIDAD, CV_BARRADOST, CV_BARRADOSP, CV_BARRA2MT,
           CV_BARRA2MP, CV_INDICE, CV_BASECOL, datos);
  TextBackGround(CV_TITULOP); TextColor(CV_TITULOT);
  gotoxy (4,1);            write('Ŀ');
  gotoxy (4,2); if sp then write(' VELOCIDAD A ') else write(' BIOS  LEVEL ');
  gotoxy (4,3); if sp then write(' NIVEL  BIOS ') else write(' PERFORMANCE ');
  gotoxy (4,4);            write('');
  TextBackGround(0); TextColor (CV_NOTA);
  gotoxy (3,6);
  if sp then write('Tasa de transferencia') else write('Data transfer rate');
  gotoxy (3,7);
  if sp then write('  en Kbytes/segundo') else write(' in Kbytes/second');
  TextColor(CV_LEYENDAS);
  gotoxy (10,25);
  if sp then write('FORMAT') else write('DOS FORMAT');
  gotoxy (29,25);
  if sp then write('Disquete 2M normal') else write('2M Normal Diskette');
  gotoxy (57-ord(sp)*2,25);
  if sp then write('(Pulsa una tecla)') else write('(Press any Key)');
end;


procedure SonidoEstelar;
var
  i,j,z:Integer;

procedure eco_sube;
begin
  i:=25;
  repeat
    sound(i+1000); delay(1); sound (i); delay(1); i:=i+5;
  until (i>5000) or KeyPressed;
  nosound;
end;

procedure eco_baja;
begin
  i:=2500;
  repeat
    sound(i+1000); delay(1); sound (i); delay(1); i:=i-2;
  until (i<500) or KeyPressed;
end;

procedure eco_desploma;
begin
  repeat
    sound(i+1000); delay(1); sound (i); delay(1); i:=i-1;
  until (i<25) or KeyPressed;
  nosound;
end;

begin (* SonidoEstelar *)
  eco_sube; eco_baja; eco_desploma;
  i:=25;
  repeat
    sound(i); delay(1); sound (i+2000); delay(1); i:=i+2;
  until (i>2000) or KeyPressed;
  nosound;
  i:=500;
  for z:=1 to 2 do begin
    repeat
      sound(i); delay(1); sound (i+3000); delay(1);
       sound (i+1500); delay(1); i:=i+1;
    until (i>2000) or KeyPressed;
    nosound;
  end;
  eco_baja; eco_desploma; eco_sube; eco_baja; eco_desploma;
  i:=700; eco_desploma; i:=1000; eco_desploma; i:=2000; eco_desploma;
end;


begin
  idioma:=0;                      (* idioma an sin determinar *)
  if (ParamCount>0) then
    if (ParamStr(1)='/I') or (ParamStr(1)='/i') then idioma:=1;
  GuardarPantalla;
  PantallaGalactica (TRUE);
  Presentacion;
  while not KeyPressed do SonidoEstelar;
  Pausa;

  opcion:=0;
  repeat
    Menu (opcion);
    case opcion of
      1: GraficaEspacio;
      2: GraficaVelocidad;
      3: Readme;
      4: Nuevo2M;
      5: UsoOS2;
      6: UsoPCXT;
      7: Licencia;
      9: idioma:=idioma XOR 1; (* F9 *)
    end;
    if (opcion<8) then Pausa;
  until opcion=8;

  PantallaGalactica (TRUE);
  MensajeCardware;
  SonidoEstelar;
  if KeyPressed then Pausa;
  ReponerPantalla;
end.
