#ifndef __GNU_STAB__

/* Indicate the GNU stab.h is in use.  */

#define __GNU_STAB__

#define __define_stab(NAME, CODE, STRING) NAME=CODE,

enum __stab_debug_code
{
/* Table of DBX symbol codes for the GNU system.
   Copyright (C) 1988 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* This contains contribution from Cygnus Support.  */

/* Global variable.  Only the name is significant.
   To find the address, look in the corresponding external symbol.  */
__define_stab (N_GSYM, 0x20, "GSYM")

/* Function name for BSD Fortran.  Only the name is significant.
   To find the address, look in the corresponding external symbol.  */
__define_stab (N_FNAME, 0x22, "FNAME")

/* Function name or text-segment variable for C.  Value is its address.
   Desc is supposedly starting line number, but GCC doesn't set it
   and DBX seems not to miss it.  */
__define_stab (N_FUN, 0x24, "FUN")

/* Data-segment variable with internal linkage.  Value is its address.  */
__define_stab (N_STSYM, 0x26, "STSYM")

/* BSS-segment variable with internal linkage.  Value is its address.  */
__define_stab (N_LCSYM, 0x28, "LCSYM")

/* Name of main routine.  Only the name is significant.
   This is not used in C.  */
__define_stab (N_MAIN, 0x2a, "MAIN")

/* Register variable.  Value is number of register.  */
__define_stab (N_RSYM, 0x40, "RSYM")

/* Structure or union element.  Value is offset in the structure.  */
__define_stab (N_SSYM, 0x60, "SSYM")

/* Parameter variable.  Value is offset from argument pointer.
   (On most machines the argument pointer is the same as the frame pointer.  */
__define_stab (N_PSYM, 0xa0, "PSYM")

/* Automatic variable in the stack.  Value is offset from frame pointer.
   Also used for type descriptions.  */
__define_stab (N_LSYM, 0x80, "LSYM")

/* Alternate entry point.  Value is its address.  */
__define_stab (N_ENTRY, 0xa4, "ENTRY")

/* Name of main source file.
   Value is starting text address of the compilation.  */
__define_stab (N_SO, 0x64, "SO")

/* Name of sub-source file.
   Value is starting text address of the compilation.  */
__define_stab (N_SOL, 0x84, "SOL")

/* Line number in text segment.  Desc is the line number;
   value is corresponding address.  */
__define_stab (N_SLINE, 0x44, "SLINE")
/* Similar, for data segment.  */
__define_stab (N_DSLINE, 0x46, "DSLINE")
/* Similar, for bss segment.  */
__define_stab (N_BSLINE, 0x48, "BSLINE")

/* Beginning of an include file.  Only Sun uses this.
   In an object file, only the name is significant.
   The Sun linker puts data into some of the other fields.  */
__define_stab (N_BINCL, 0x82, "BINCL")
/* End of an include file.  No name.
   These two act as brackets around the file's output.
   In an object file, there is no significant data in this entry.
   The Sun linker puts data into some of the fields.  */
__define_stab (N_EINCL, 0xa2, "EINCL")
/* Place holder for deleted include file.
   This appears only in output from the Sun linker.  */
__define_stab (N_EXCL, 0xc2, "EXCL")

/* Beginning of lexical block.
   The desc is the nesting level in lexical blocks.
   The value is the address of the start of the text for the block.
   The variables declared inside the block *precede* the N_LBRAC symbol.  */
__define_stab (N_LBRAC, 0xc0, "LBRAC")
/* End of a lexical block.  Desc matches the N_LBRAC's desc.
   The value is the address of the end of the text for the block.  */
__define_stab (N_RBRAC, 0xe0, "RBRAC")

/* Begin named common block.  Only the name is significant.  */
__define_stab (N_BCOMM, 0xe2, "BCOMM")
/* Begin named common block.  Only the name is significant
   (and it should match the N_BCOMM).  */
__define_stab (N_ECOMM, 0xe4, "ECOMM")
/* End common (local name): value is address.
   I'm not sure how this is used.  */
__define_stab (N_ECOML, 0xe8, "ECOML")
/* Second symbol entry containing a length-value for the preceding entry.
   The value is the length.  */
__define_stab (N_LENG, 0xfe, "LENG")

/* Global symbol in Pascal.
   Supposedly the value is its line number; I'm skeptical.  */
__define_stab (N_PC, 0x30, "PC")

/* Modula-2 compilation unit.  Can someone say what info it contains?  */
__define_stab (N_M2C, 0x42, "M2C")
/* Modula-2 scope information.  Can someone say what info it contains?  */
__define_stab (N_SCOPE, 0xc4, "SCOPE")

/* Sun's source-code browser stabs.  ?? Don't know what the fields are.
   Supposedly the field is "path to associated .cb file".  */
/* This conflicts with the definition of N_BSLINE.  */
__define_stab (N_BROWS, 0x48, "BROWS")

/* GNU C++ exception stabs.  */

/* GNU C++ `catch' clause.  Value is its address.  Desc is nonzero if
   this entry is immediately followed by a CAUGHT stab saying what exception
   was caught.  Multiple CAUGHT stabs means that multiple exceptions
   can be caught here.  If Desc is 0, it means all exceptions are caught
   here.  */
__define_stab (N_CATCH, 0x54, "CATCH")

/* The above information, in matrix format.

                        STAB MATRIX
        _________________________________________________
        | 00 - 1F are not dbx stab symbols              |
        | Entries with bits 01 set are external symbols |
        | N_UNDEF   | N_ABS     | N_TEXT    | N_DATA    |
        | N_BSS     | N_COMM    |           | N_FN      |
        |_______________________________________________|
        | 20 GSYM   | 22 FNAME  | 24 FUN    | 26 STSYM  |
        | 28 LCSYM  | 2A MAIN   | 2C        | 2E        |
        | 30 PC     | 32        | 34        | 36        |
        | 38        | 3A        | 3C        | 3E        |
        | 40 RSYM   | 42 M2C    | 44 SLINE  | 46 DSLINE |
        | 48 BROWS/BSLINE | 4A  | 4C        | 4E        |
        | 50 EHDECL | 52        | 54 CATCH  | 56        |
        | 58        | 5A        | 5C        | 5E        |
        | 60 SSYM   | 62        | 64 SO     | 66        |
        | 68        | 6A        | 6C        | 6E        |
        | 70        | 72        | 74        | 76        |
        | 78        | 7A        | 7C        | 7E        |
        | 80 LSYM   | 82 BINCL  | 84 SOL    | 86        |
        | 88        | 8A        | 8C        | 8E        |
        | 90        | 92        | 94        | 96        |
        | 98        | 9A        | 9C        | 9E        |
        | A0 PSYM   | A2 EINCL  | A4 ENTRY  | A6        |
        | A8        | AA        | AC        | AE        |
        | B0        | B2        | B4        | B6        |
        | B8        | BA        | BC        | BE        |
        | C0 LBRAC  | C2 EXCL   | C4 SCOPE  | C6        |
        | C8        | CA        | CC        | CE        |
        | D0        | D2        | D4        | D6        |
        | D8        | DA        | DC        | DE        |
        | E0 RBRAC  | E2 BCOMM  | E4 ECOMM  | E6        |
        | E8 ECOML  | EA        | EC        | EE        |
        | F0        | F2        | F4        | F6        |
        | F8        | FA        | FC        | FE LENG   |
        +-----------------------------------------------+

*/
LAST_UNUSED_STAB_CODE
};

#undef __define_stab

#endif /* __GNU_STAB_ */

