#include <stdio.h>
#include <std.h>
#include <graphics.h>
#include <pc.h>

double x, y;

#if 1
#define ESCAPE	2.0
#define LEFT	(0.0)
#define RIGHT	(1.0)
#define TOP	(1.0)
#define BOTTOM	(0.0)
void escape()
{
  if (y>0.5)
    { x = 2*x; y = 2*y-1; }
  else if (x>0.5)
    { x = 2*x-1; y = 2*y; }
  else
    { x = 2*x; y = 2*y; }
}
#endif

#if 0
#define ESCAPE 2
#define LEFT	(-1.0)
#define RIGHT	(1.0)
#define TOP	(1.0)
#define BOTTOM	(-1.0)
escape()
{
  double nx, ny, mx, my;
  nx = x*x - y*y;
  ny = 2 * x * y;
  mx = nx*nx - ny*ny;
  my = 2 * nx * ny;
  x = mx - x - 0.78;
  y = my - y;
}
#endif

#if 0
#define ESCAPE 2
#define LEFT	(-1.0)
#define RIGHT	(1.0)
#define TOP	(1.0)
#define BOTTOM	(-1.0)
escape()
{
  double nx, ny, mx, my;
  nx = x*x - y*y;
  ny = 2 * x * y;
  x = nx - 1;
  y = ny;
}
#endif

main()
{
  GrSetMode(GR_default_graphics);
  GrRegion *s = GrScreenRegion();
  int px, py;
  int pxmax = s->MaxX();
  int pymax = s->MaxY();
  int n;
  for (n=2; n<256; n++)
  {
    GrSetColor(n, (n&1)*255, (n&2)*127, (n&4)*63);
  }
  double escape2 = ESCAPE*ESCAPE;
  double ix, iy;
  for (py=0; py<pymax; py++)
  {
    iy = py * (BOTTOM-TOP) / pymax + TOP;
    for (px=0; px<pxmax; px++)
    {
      s->Plot(px, py, GrWhite());
      ix = px * (RIGHT-LEFT) / pxmax + LEFT;
      x = ix;
      y = iy;
      n = 0;
      while (n<256)
      {
        if ((x*x+y*y) > escape2)
        {
          s->Plot(px, py, n);
          break;
        }
        escape();
        n++;
      }
    }
    if (kbhit())
      py = pymax;
  }
  getkey();
  GrSetMode(GR_default_text);
}
