#include "emu.h"
#include "rmov.h"
#include "compare.h"

void emu_25()
{
  if (empty())
    return;
  if (modrm > 0277)
  {
    // fucompp
    if ((modrm&7) != 1)
      emu_bad();
    else
    {
    if (empty(modrm&7))
    {
      setcc(SW_C3|SW_C2|SW_C0);
      return;
    }
    int c = compare(st(), st(1));
    st().tag = TW_E;
    top++;
    st().tag = TW_E;
    top++;
    int f;
    if (c & COMP_SNAN)
    {
      exception(EX_I);
      f = SW_C3 | SW_C2 | SW_C0;
    }
    else
      switch (c)
      {
        case COMP_A_LT_B:
          f = SW_C0;
          break;
        case COMP_A_EQ_B:
          f = SW_C3;
          break;
        case COMP_A_GT_B:
          f = 0;
          break;
        case COMP_NOCOMP:
          f = SW_C3 | SW_C2 | SW_C0;
          break;
      }
    setcc(f);
    }
  }
  else
  {
    // fisubr m32int
    reg t1, t2;
    r_mov((long *)get_modrm(), t1);
    r_sub(t1, st(), t2);
    r_mov(t2, st());
  }
}
