#include <stdio.h>
#include <alloc.h>
#include <dir.h>
#include <dos.h>
#include <ctype.h>
#include <string.h>

static char **newargv;

static int fscan_q(FILE *f, char *buf)
{
  char *ibuf = buf;
  int c, quote=-1, gotsome=0, addquote=0;
  while ((c = fgetc(f)) != EOF)
  {
    if (c == '\\')
    {
      char c2 = fgetc(f);
      if (! strchr("\"'`\\ \t\n\r", c2))
        *buf++ = c;
      *buf++ = c2;
      addquote = 0;
    }
    else if (c == quote)
    {
      quote = -1;
      if (c == '\'')
        addquote = 1;
    }
    else if (isspace(c) && (quote==-1))
    {
      if (gotsome)
      {
        if (addquote)
          *buf++ = '\'';
        *buf = 0;
        return 1;
      }
      addquote = 0;
    }
    else
    {
      if ((quote == -1) && ((c == '"') || (c == '\'')))
      {
        quote = c;
        gotsome=1;
        if ((c == '\'') && (buf == ibuf))
          *buf++ = c;
      }
      else
      {
        *buf++ = c;
        gotsome=1;
      }
      addquote = 0;
    }
  }
  return 0;
}

static glob(char *buf, int (*func)())
{
  if (strpbrk(buf, "*?"))
  {
    char *dire, *cp;
    struct ffblk ff;
    int done, upcase=0;
    done = findfirst(buf, &ff, FA_RDONLY|FA_DIREC|FA_ARCH);
    if (done)
      func(buf);
    else
    {
      char nbuf[80];
      strcpy(nbuf, buf);
      for (dire=cp=nbuf; *cp; cp++)
      {
        if (strchr("/\\:", *cp))
          dire = cp + 1;
        if (isupper(*cp))
          upcase = 1;
      }
      while (!done)
      {
        strcpy(dire, ff.ff_name);
        if (!upcase)
          strlwr(dire);
        func(nbuf);
        done = findnext(&ff);
      }
    }
  }
  else
    func(buf);
}

static foreach_arg(char **argv, int (*func)())
{
  int i;
  char firstc;
  FILE *f;
  char buf[80];
  for (i=0; argv[i]; i++)
  {
    if (argv[i][0] == '@')
    {
      f = fopen(argv[i]+1, "rt");
      while (fscan_q(f, buf) == 1)
      {
        if (!strcmp(buf, "\032"))
          continue;
        glob(buf, func);
      }
      fclose(f);
    }
    else
      glob(argv[i], func);
  }
}

static int num_actual_args;

static just_incr()
{
  num_actual_args++;
}

static pusharg(char *ar)
{
  int s = strlen(ar);
  if ((ar[0] == '\'') && (ar[s-1] == '\''))
  {
    ar[s-1] = '\0';
    ar++;
  }
  newargv[num_actual_args] = strdup(ar);
  num_actual_args++;
}

static getlongargs(int *ac, char ***av)
{
  char *_argcs = getenv("_argc");
  int _argc, i;
  char tmp[10];
  char **_argv;

  if (_argcs == 0)
    return;
  if (*ac > 1)
    return;

  _argc = atoi(_argcs);
  _argv = (char **)malloc((_argc+1)*sizeof(char*));
  for (i = 0; i<_argc; i++)
  {
    sprintf(tmp, "_argv%d", i);
    _argv[i] = getenv(tmp);
  }
  _argv[i] = 0;
  *av = _argv;
  *ac = _argc;
  putenv("_argc=");
}

set_argc_argv(int *argc, char ***argv)
{
  getlongargs(argc, argv);
  num_actual_args = 0;
  foreach_arg(*argv, just_incr);

  newargv = (char **)malloc((num_actual_args+1)*sizeof(char *));
  if (newargv == 0)
  {
    printf("Fatal! no memory to copy arguments\n");
    exit(1);
  }
  num_actual_args = 0;
  foreach_arg(*argv, pusharg);
  newargv[num_actual_args] = 0;

  *argv = newargv;
  *argc = num_actual_args;
}
