#include <sys/stat.h>
#include <errno.h>
#include <process.h>
#include <ctype.h>

bcopy(a,b,c)
{
  return memcpy(b,a,c);
}

bzero(a,b)
{
  return memset(a,0,b);
}

index(a,b)
{
  return strchr(a,b);
}

kill()
{
}

#undef getpid
getpid()
{
  return 42;
}

int system(const char *p)
{
  char fn[128];
  char line[128];
  sscanf(p, " %s %s", fn, line);
  return spawnlp(P_WAIT, fn, fn, line, 0);
}

char *
mktemp(path)
	char *path;
{
	extern int errno;
	register char *start, *trv;
	struct stat sbuf;
	unsigned int pid;

	pid = getpid();
	for (trv = path; *trv; ++trv);		/* extra X's get set to 0's */
	while (*--trv == 'X') {
		*trv = (pid % 10) + '0';
		pid /= 10;
	}

	/*
	 * check the target directory; if you have six X's and it
	 * doesn't exist this runs for a *very* long time.
	 */
	for (start = trv + 1;; --trv) {
		if (trv <= path)
			break;
		if (*trv == '/') {
			*trv = '\0';
			if (trv[-1] == ':') {
				*trv = '/';
				break;
			}
			if (stat(path, &sbuf))
				return(0);
			if (!(sbuf.st_mode & S_IFDIR)) {
				errno = ENOTDIR;
				return(0);
			}
			*trv = '/';
			break;
		}
	}

	for (;;) {
		if (stat(path, &sbuf))
			return(errno == ENOENT ? path : 0);

		/* tricky little algorithm for backward compatibility */
		for (trv = start;;) {
			if (!*trv)
				return(0);
			if (*trv == 'z')
				*trv++ = 'a';
			else {
				if (isdigit(*trv))
					*trv = 'a';
				else
					++*trv;
				break;
			}
		}
	}
	/*NOTREACHED*/
}

