Jouni Miettunen * jon@stekt.oulu.fi * Oulu * Finland * Europe * 1993-94

FILEX(1)                    USER COMMANDS                      FILEX(1)



NAME
     filex - determine the type of a file by examining its name
     and extension.

SYNOPSIS
     file [ -1abdfnpqR?* ] target ...

DESCRIPTION
     filex studies the filename extension and tells what kind of
     files and what programs usually use that specific extension.

     filex uses the database file extensio.txt or any other user
     defined data file to look up the extension information.

OPTIONS
     -1   Show and study each different file extension only once.

     -a   Show all known possibilities.

     -b filename.ext
          Identify only given filename extension, these bogus
          files don't have to exist.

     -d   Show the current directory name at the beginning.

     -f   Don't handle hidden or system files (Force).

     -n   Show only unknown files (Noise).

     -p   Pause after each screen page and wait for a key press.

     -q   Show only known files (Quiet).

     -R   Recurse through all subdirectories.

     -?   Info.

     -*   Print the database Redblack search tree

EXAMPLES

     Command line options can be given separated or together and
     the switch can be either unixlike "-" or DOSlike "/":

         filex -1 -n *.*
         filex /1 /n *.*
         filex -n1   *.*
         filex /n -1 *.*

     Period "." is same as "*.*" and giving a directory name
     identifies all files in that directory:

         filex *.*
         filex .
         filex d:
         filex c:\dir\subdir

     You can have several targets specified on command line,
     including wildcards:

         filex ..\a*.* project.* d: dir1\ dir2

     You can identify files that don't exist with -b (bogus) option:

         filex -b file.a file.b file.c
         filex -b .ext

     If you don't want to identify some files and have a tool to
     temporarily change their file attribute to hidden:

         except (a*.*) filex -f *.*

     Listfiles are supported and thus you can check the database:

         filex @extensio.txt

     Little mark (Ascii 250) in front of description notifies if
     there are available several descriptions for the extension.
     You can see all of them by using -a (all) option:

         C:\>filex filex.c
         filex.c      C source code file

         C:\>filex -a filex.c
         filex.c      C source code file
                       compressed unix file archive created by COMPACT


     Or you could first locate all extensions with more than one
     possible description and then check only them more closely:

         filex . | grep "" > tmp             (   is Ascii 250)
         filex -ap @tmp

     If you want to know all file extensions related to some area,
     you can use option -w to search the database. Please remember
     the search is case sensitive ie. a is not A:

         filex -w graphics
         filex -w "source code"
         filex -w source code

    NOTE: the last feature is at the moment disabled. It was part
    of an ambitious idea, which was never realized. This is a note
    for myself to remember the fact and an excuse for old users..

ENVIRONMENT
     Environment variable FILEX can be set to point to any valid
     File Extension Database.

FILES
     extensio.txt

     First Filex checks if environment variable FILEX exists and
     then if a file named "extensio.txt" exist in any directory
     specified in the PATH.

     Format of File Extansion Database is the following:
     - first character of every line is . (period, ASCII 46)
     - 1 to 3 characters (extension)
     - TAB character (horizontal TAB, ASCII 9)
     - min 5 to max 63 characters (description of extension)
     - every line has to end with CR/LF, except the last

     At the moment the max allowed database size is 64K (65534
     bytes), the last byte (65535th) is needed for terminating
     NULL character.

     A self-balancing red-black tree is created so that the first
     found description for extension will always be told as first.
     You can customize the output by changing the order of lines 
     in database. They can be in any order, I just like to see them
     alphabetically for other purposes.

     @listfile

     The program supports listfiles eg. you can collects filenames
     into a file and then give that preceded by @ character as an
     argument to Filex. For every line only the first possible filename
     extension is identified as a bogus filename, there can be more
     text on same line, but please note that if there is a colon (:)
     everything up to that will be translated as a directory name.

HISTORY
     1.0    30-Jan-93    original version based on file.btm (jambtm02.zip)
                         (1000 extensions)
     1.1    28-Feb-93    red-black tree functions & large memory model
     1.2    27-Jun-93    2x faster start up (64K data limit)
                         (1200 extensions)
     1.21   03-Jul-93    I forgot to enable "notify if several"..
     1.3    02-Aug-93    @listfile support, bugfix in Notify, credits,
                         removed all DEBUG code (about 10K smaller),
                         pause after each screen page, long extensions,
                         word search in database
                         (1500 extensions)
     1.4    13-Jun-94    Cormen,Leiserson,Rivest bottom-up redblack tree
                         About 10% faster start == datatree creation
                         Ported to TC3++ -> exe 26k instead of 45k
                         (1600 extensions)

SEE ALSO
     Robert Sedgewick: "Algorithms in C" ISBN 0-201-51425-7 (p.220)

     Dr. Dobb's Journal #187 April 1992 (p.42) Bruce Schneier:
         "Red-Black Trees"

     Cormen, Leiserson, Rivest: "Introduction to Algorithms" (p.263)
         ISBN 0-262-03141-8 (MIT Press)

     Filex is not perfect, but it's a perfect companion for a fully
     unixlike File utility. At the moment I know two good ones:

     Ricki's File2, Filed39a (see Fileinfo.txt for more information)

BUGS
     If file has a wrong filename extension, filex obviously makes
     a wrong identification. No other known bugs.

STATUS
     This program is Freeware. Use, share and enjoy. The File Extension
     database can be freely used (see Credits.txt for terms).

AUTHOR
     Mr. Jouni Miettunen
     Rautatienkatu 20 A 10
     90100 OULU
     FINLAND - EUROPE



FILEX(1)                    USER COMMANDS                      FILEX(1)

Jouni Miettunen * jon@stekt.oulu.fi * Oulu * Finland * Europe * 1993-94
