/*
 * what.c: version 2.0 88-8-14 Copyright 1988 R. T. Coates
 *******************************************************************************
 * INVOCATION:
 *
 *   what file [file file ...]
 *******************************************************************************
 * DESCRIPTION:
 *
 * looks for the string @(#) in files and prints the characters following
 * the key string until newline, null, double quote, greater than, or
 * back slash (\n, \0, ", >, \) is found.
 *******************************************************************************
 */

static char *PROGID =
"@(#) what.c 2.0 88-8-14 Copyright 1987 R. T. Coates";

#include <stdlib.h>
#include <stdio.h>

main(int argc,char **argv)
{
    FILE *fp;
    register int c,sv;

    if(argc < 2) {			/* wrong number of parameters */
        fprintf(stderr,"usage: %s file file ...\n",argv[0]);
        exit(1); }

    while(--argc) {			/* do all files */
        if((fp = fopen(*++argv,"rb")) == NULL) {
            fprintf(stderr,"warning: %s: %s\n", *argv,sys_errlist[errno]);
            continue; }

	printf("%s: \n\t",*argv);	/* print file name */
        sv = 0;				/* init to state 0 */

        while((c = getc(fp)) != EOF) {
            if(sv == 4) {		/* found entire key string */
		/* look for terminating character */
                if ((char)c == '\0' || (char)c == '\n' ||
                  (char)c == '"' || (char)c == '>' ||
                  (char)c == '\\') {
		    sv = 0;			/* termination found */
                    putchar('\n');
                    putchar('\t');
                    continue; }			/* keep on looking for key */
                putchar((char) c);
                continue; }
            if((char)c == '@' && sv == 0) {	/* found first char: @ */
                sv = 1;
                continue; }
            if((char)c == '(' && sv == 1) {	/* found second char: ( */
                sv = 2;
                continue; }
            if((char)c == '#' && sv == 2) {	/* found third char: # */
                sv = 3;
                continue; }
            if((char)c == ')' && sv == 3) {	/* found fourth char: ) */
                sv = 4;
                continue; }
            sv = 0; }
	printf("\n");
	fclose(fp); }
    printf("\n");
}

/* end of what.c */
