#include "allwind.h"

#define TWindow_type 1
#define TStatic_type 2
#define TListBox_type 3
#define TComboBox_type 4
#define TButton_type 5
#define TScrollBar_type 6
#define TGroupBox_type 7
#define TRadioButton_type 8
#define TCheckBox_type 9
#define TDialog_type 10

//NODE *xxx;

HICON hCursorSave = 0;           /* handle for saved cursor */

char *Windowname[]={"?","Window","Static","ListBox","ComboBox","Button","ScrollBar","GroupBox","RadioButton","CheckButton","Dialog"};

char mainwindow[]="ROOT";

/* class structure for storing information about users windows */

class slink
   {
   friend class slist;
   
   slink *next;
   slink *prev;
   char *key;
   char *parent;
   int type;
   ent e;
   
   slink(ent a, slink* n, slink* p, char *k, char *par, int t)
      {
      e=a;
      next=n;
      prev=p;
      key=k;
      parent=par;
      type=t;
      }
   };

class slist
   {
   slink* last;
   public:
   void insert(ent a, char* k, char* par, int t);
   ent get(char* k);
   ent get2(char* k, int t);
   char *getparent(char* par);
   void zap(char* k);
   void list(char* k, int lev);
   void clear();
   
   slist()
      {
      last = NULL;
      }
   
   slist(ent a, char *k, char *par, int t)
      {
      last=new slink(a, NULL, NULL, k, par, t);
      last->next=last;
      last->prev=last;
      }
   
   ~slist()
      {
      clear();
      }
   };

void slist::insert(ent a, char* k, char *par, int t)
   {
   if (last)
      {
      last->next = new slink(a, last->next, last, k, par, t);
      last->next->next->prev = last->next;
      }
   else
      {
      last = new slink(a, NULL, NULL, k, par, t);
      last->next = last;
      last->prev = last;
      }
   }

ent slist::get2(char *k,int t)
   {
   slink* f;
   
   if (last==NULL) return NULL;
   
   f = last;
   
   do
      {
      if (strcmp(f->key,k)==0)
         {
         if (f->type == t) return(f->e); else return(NULL);
         }
      f = f->next;
      } while (f != last);
   
   return NULL;
   }

ent slist::get(char *k)
   {
   slink* f;
   
   if (last==NULL) return NULL;
   
   f = last;
   
   do
      {
      if (strcmp(f->key,k)==0)
         {
         return(f->e);
         }
      f = f->next;
      } while (f != last);
   
   return NULL;
   }

char *slist::getparent(char *k)
   {
   slink* f;
   
   if (last==NULL) return NULL;
   
   f = last;
   
   do
      {
      if (strcmp(f->parent,k)==0)
         {
         return(f->key);
         }
      f = f->next;
      } while (f != last);
   
   return NULL;
   }

void slist::zap(char* k)
   {
   slink* f;
   slink* p;
   char* t;
   
   if (last==NULL) return;
   
   f = last;
   p = NULL;
   
   do
      {
      if (strcmp(f->key,k)==0)
         {
         p = f;
         break;
         }
      f = f->next;
      } while (f != last);
   
   // delete any children first
   
   while ((t=getparent(k)) != NULL) { zap(t); }
   
   if (p != NULL)
      {
      f = p->next;
      
      if (f == p)
         {
         last = NULL;
         }
      else
         {
         if (p == last) last = p->prev;
         
         p->prev->next = p->next;
         f->prev = p->prev;
         }
      
      delete p;
      }
   
   }

void slist::list(char *k,int level)
   {
   slink* f;
   slink* ff;
   slink* p;
   char temp[128];
   char indent[128];
   int i;
   
   if (last==NULL) return;
   
   f = last;
   p = NULL;
   
   do
      {
      if (strcmp(f->key,k)==0)
         {
         p = f;
         break;
         }
      f = f->next;
      } while (f != last);
   
   if (p != NULL)
      {
      
      indent[0] = '\0';
      for (i=0;i<level;i++) strcat(indent," ");
      
      if (level == 0)
         {
         sprintf(temp,"%s %s",Windowname[p->type],p->key);
         putcombobox(temp);
         }
      
      ff = last;
      
      do
         {
         if (strcmp(ff->parent,k)==0)
            {
            sprintf(temp,"  %s%s %s",indent,Windowname[ff->type],ff->key);
            putcombobox(temp);
            list(ff->key,level+1);
            }
         ff = ff->next;
         } while (ff != last);
      
      }
   }

void slist::clear()
   {
   slink* l = last;
   
   if (l == NULL) return;
   
   do
      {
      slink* ll = l;
      l = l->next;
      delete ll;
      }
   while (l!=last);
   
   }

// class structures for the controls we support, for the most part they
// are the same as the original with just a key and callback string added

class TMxWindow : public TWindow
   {
   public:
   char key[MAX_BUFFER_SIZE];
   TMxWindow(PTWindowsObject AParent, LPSTR AText, PTModule AModule = NULL) :
   (AParent, AText, AModule) {};
   };

class TMxDialog : public TDialog
   {
   public:
   char key[MAX_BUFFER_SIZE];
   char callback[MAX_BUFFER_SIZE];
   char caption[MAX_BUFFER_SIZE];
   int x,y,h,w;
   TMxDialog(PTWindowsObject AParent, LPSTR AText, PTModule AModule = NULL) :
   (AParent, AText, AModule) {};
   virtual void SetupWindow();
   };

void TMxDialog::SetupWindow()
   {
   SetWindowPos(HWindow, NULL, x, y, w, h, 0);
   SetCaption(caption);
   
   do_execution(callback);
   
   TDialog::SetupWindow();
   }

class TMyListBox : public TListBox
   {
   public:
   char key[MAX_BUFFER_SIZE];
   TMyListBox(PTWindowsObject AParent, int AnId, int X, int Y,
   int W, int H, PTModule AModule = NULL) :
   (AParent, AnId, X, Y, W, H, AModule) {};
   };

class TMxComboBox : public TComboBox
   {
   public:
   char key[MAX_BUFFER_SIZE];
   TMxComboBox(PTWindowsObject AParent, int AnId, int X, int Y,
   int W, int H, DWORD AStyle, WORD ATextLen, PTModule AModule = NULL) :
   (AParent, AnId, X, Y, W, H, AStyle, ATextLen, AModule) {};
   };

class TMyStatic : public TStatic
   {
   public:
   char key[MAX_BUFFER_SIZE];
   TMyStatic(PTWindowsObject AParent, int AnId, LPSTR AText, int X, int Y,
   int W, int H, WORD ATextLen, PTModule AModule = NULL) :
   (AParent, AnId, AText, X, Y, W, H, ATextLen, AModule) {};
   };

class TMyButton : public TButton
   {
   public:
   char key[MAX_BUFFER_SIZE];
   char callback[MAX_BUFFER_SIZE];
   //   NODE *callbackx;
   int critical;
   TMyButton(PTWindowsObject AParent, int AnId, LPSTR AText, int X, int Y,
   int W, int H, BOOL IsDefault, PTModule AModule = NULL) :
   (AParent, AnId, AText, X, Y, W, H, IsDefault, AModule) {};
   virtual void DefWndProc(RTMessage Msg);
   };

NODE *leventcheck(void)
   {
   MSG msg;
   
   //   checkqueue();
   
   while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
      {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
      }
   
   return (UNBOUND);
   }

/* function that processes our own queued events */

void checkqueue()
   {
   callthing *thing;
   int save_yield_flag;
   int sv_val_status;
   
   while (thing=calllists.get())
      {
      
      sv_val_status = val_status;
      
      calllists.zap();
      switch (thing->kind)
         {
         
         // mouse event must not yield while processing
         
         case 1:
            {
            save_yield_flag = yield_flag;
            yield_flag = 0;
            mouse_posx = thing->arg1;
            mouse_posy = thing->arg2;
            do_execution(thing->func);
            yield_flag = save_yield_flag;
            break;
            }
         
         // keyboard  event must not yield while processing
         
         case 2:
            {
            save_yield_flag = yield_flag;
            yield_flag = 0;
            keyboard_value = thing->arg1;
            do_execution(thing->func);
            yield_flag = save_yield_flag;
            break;
            }
         
         // Button, timer or other event ok to yield while processing
         
         case 3:
            {
            do_execution(thing->func);
            break;
            }
         
         // Scrollbar, timer or other event must not yield while processing
         
         case 4:
            {
            save_yield_flag = yield_flag;
            yield_flag = 0;
            do_execution(thing->func);
            yield_flag = save_yield_flag;
            break;
            }
         }
      
      delete thing;    
      
      val_status = sv_val_status;
      }
   }

/* function to dump the queue */

void emptyqueue()
   {
   callthing *thing;
   
   while (thing=calllists.get())
      {
      calllists.zap();
      delete thing;
      }
   }

/* if the button gets clicked we end up here and queue the event */

void TMyButton::DefWndProc(RTMessage Msg)
   {
   callthing *callevent;
   
   TButton::DefWndProc( Msg );
   
   if (Msg.Message == WM_LBUTTONUP)
      {
      callevent = new callthing;
      callevent->func = callback;
      callevent->kind = 3;
      calllists.insert(callevent,3);
      checkqueue();
      }
   }

class TMyScrollBar : public TScrollBar
   {
   public:
   char key[MAX_BUFFER_SIZE];
   char callback[MAX_BUFFER_SIZE];
   int critical;
   TMyScrollBar(PTWindowsObject AParent, int AnId, int X, int Y,
   int W, int H, BOOL IsHScrollBar, PTModule AModule = NULL) :
   (AParent, AnId, X, Y, W, H, IsHScrollBar, AModule) {};

   virtual void SBLineDown(RTMessage Msg) = [NF_FIRST + SB_LINEDOWN];
   virtual void SBLineUp(RTMessage Msg) = [NF_FIRST + SB_LINEUP];
   virtual void SBPageDown(RTMessage Msg) = [NF_FIRST + SB_PAGEDOWN];
   virtual void SBPageUp(RTMessage Msg) = [NF_FIRST + SB_PAGEUP];
   virtual void SBThumbPosition(RTMessage Msg) = [NF_FIRST + SB_THUMBPOSITION];
   virtual void SBThumbTrack(RTMessage Msg) = [NF_FIRST + SB_THUMBTRACK];
   };

void TMyScrollBar::SBLineDown(RTMessage Msg)
   {
   callthing *callevent;
   
   TScrollBar::SBLineDown( Msg );
   
   callevent = new callthing;
   callevent->func = callback;
   callevent->kind = 4;
   calllists.insert(callevent,4);
   checkqueue();
   }

void TMyScrollBar::SBLineUp(RTMessage Msg)
   {
   callthing *callevent;
   
   TScrollBar::SBLineUp( Msg );
   
   callevent = new callthing;
   callevent->func = callback;
   callevent->kind = 4;
   calllists.insert(callevent,4);
   checkqueue();
   }

void TMyScrollBar::SBPageDown(RTMessage Msg)
   {
   callthing *callevent;
   
   TScrollBar::SBPageDown( Msg );
   
   callevent = new callthing;
   callevent->func = callback;
   callevent->kind = 4;
   calllists.insert(callevent,4);
   checkqueue();
   }

void TMyScrollBar::SBPageUp(RTMessage Msg)
   {
   callthing *callevent;
   
   TScrollBar::SBPageUp( Msg );
   
   callevent = new callthing;
   callevent->func = callback;
   callevent->kind = 4;
   calllists.insert(callevent,4);
   checkqueue();
   }

void TMyScrollBar::SBThumbPosition(RTMessage Msg)
   {
   callthing *callevent;
   
   TScrollBar::SBThumbPosition( Msg );
   
   callevent = new callthing;
   callevent->func = callback;
   callevent->kind = 4;
   calllists.insert(callevent,4);
   checkqueue();
   }

void TMyScrollBar::SBThumbTrack(RTMessage Msg)
   {
   callthing *callevent;
   
   TScrollBar::SBThumbTrack( Msg );
   
   callevent = new callthing;
   callevent->func = callback;
   callevent->kind = 4;
   calllists.insert(callevent,4);
   checkqueue();
   }

class TMyGroupBox : public TGroupBox
   {
   public:
   char key[MAX_BUFFER_SIZE];
   TMyGroupBox(PTWindowsObject AParent, int AnId, LPSTR AText, int X, int Y,
   int W, int H, PTModule AModule = NULL) :
   (AParent, AnId, AText, X, Y, W, H, AModule) {};
   };

class TMyRadioButton : public TRadioButton
   {
   public:
   char key[MAX_BUFFER_SIZE];
   int critical;
   char callback[MAX_BUFFER_SIZE];
   TMyRadioButton(PTWindowsObject AParent, int AnId, LPSTR ATitle, int X, int Y,
   int W, int H, PTGroupBox AGroup, PTModule AModule = NULL) :
   (AParent, AnId, ATitle, X, Y, W, H, AGroup, AModule) {};
   };

class TMyCheckBox : public TCheckBox
   {
   public:
   char key[MAX_BUFFER_SIZE];
   int critical;
   char callback[MAX_BUFFER_SIZE];
   TMyCheckBox(PTWindowsObject AParent, int AnId, LPSTR ATitle, int X, int Y,
   int W, int H, PTGroupBox AGroup, PTModule AModule = NULL) :
   (AParent, AnId, ATitle, X, Y, W, H, AGroup, AModule) {};
   };

typedef struct dialogthing
   {
   union
      {
      TMxWindow *TWmybox;
      TMyStatic *TSmybox;
      TMyListBox *TLmybox;
      TMxComboBox *TCmybox;
      TMyButton *TBmybox;
      TMyScrollBar *TSCmybox;
      TMyGroupBox *TGmybox;
      TMyRadioButton *TRmybox;
      TMyCheckBox *TCBmybox;
      TMxDialog *TDmybox;
      };
   };

struct dialoglist : slist
   {
   void insert(dialogthing* a, char* k, char* par, int t) { slist::insert(a, k, par, t); }
   dialogthing* get(char* k)                       { return(dialogthing*)slist::get(k); }
   dialogthing* get2(char* k, int t)               { return(dialogthing*)slist::get2(k,t); }
   dialoglist()                                    {}
   dialoglist(dialogthing* a, char* k, char* par, int t) : (a, k, par, t) {}
   };

dialoglist dialogboxes;

/* User function to create a modeless window */

NODE *lwindowcreate(NODE *args)
   {
   dialogthing *child;
   dialogthing *parent;
   int x;
   int y;
   int w;
   int h;
   char parentname[MAX_BUFFER_SIZE];
   char childname[MAX_BUFFER_SIZE];
   char titlename[MAX_BUFFER_SIZE];
   char *ptr;
   
   /* get all the args */
   
   cnv_strnode_string(parentname, args);
   cnv_strnode_string(childname, args=cdr(args));
   cnv_strnode_string(titlename, args=cdr(args));
   x = getint(pos_int_arg(args=cdr(args)));
   y = getint(pos_int_arg(args=cdr(args)));
   w = getint(pos_int_arg(args=cdr(args)));
   h = getint(pos_int_arg(     cdr(args)));
   
   // convert them to "DIALOG" units this is the key to making
   // all Graphics Modes work correctly.
   
   x = (x*BaseUnitsx)/4;
   y = (y*BaseUnitsy)/8;
   w = (w*BaseUnitsx)/4;
   h = (h*BaseUnitsy)/8;
   
   // if not akready exist continue
   
   if (dialogboxes.get(childname) == NULL)
      {
      
      child = new dialogthing;
      
      // if parent exists use it else use main window
      
      if ((parent = dialogboxes.get2(parentname,TWindow_type)) != NULL)
         {
         child->TWmybox = new TMxWindow(parent->TWmybox,titlename);
         ptr = parent->TWmybox->key;
         }
      else
         {
         child->TWmybox = new TMxWindow(MainWindowx,titlename);
         ptr = mainwindow;
         }
      
      // Set appropriate attributes
      
      child->TWmybox->Attr.Style |= WS_POPUPWINDOW | WS_CAPTION;
      
      // we don't want the user closing the window without going
      // through the proper channels
      
      child->TWmybox->Attr.Style ^= WS_SYSMENU;
      
      child->TWmybox->Attr.X = x;
      child->TWmybox->Attr.Y = y;
      child->TWmybox->Attr.W = w;
      child->TWmybox->Attr.H = h;
      
      ((TWindow *)MainWindowx)->GetApplication()->MakeWindow(child->TWmybox);
      
      // Make sure the window is up before we try to add controls?
      
      MyMessageScan();
      
      strcpy(child->TWmybox->key,childname);
      dialogboxes.insert(child,child->TWmybox->key,ptr,TWindow_type);
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Already exists", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lwindowdelete(NODE *arg1)
   {
   dialogthing *temp;
   char childname[MAX_BUFFER_SIZE];
   
   // get args
   
   cnv_strnode_string(childname, arg1);
   
   // Check if exact name and type exists and if does kill it and all
   // it's children too
   
   if ((temp = dialogboxes.get2(childname,TWindow_type)) != NULL)
      {
      
      ((TWindow *)temp->TWmybox)->CloseWindow();
      
      dialogboxes.zap(childname);
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *ldialogcreate(NODE *args)
   {
   dialogthing *child;
   dialogthing *parent;
   int x;
   int y;
   int w;
   int h;
   char parentname[MAX_BUFFER_SIZE];
   char childname[MAX_BUFFER_SIZE];
   char titlename[MAX_BUFFER_SIZE];
   char callback[MAX_BUFFER_SIZE];
   char *ptr;
   
   // get args
   
   cnv_strnode_string(parentname, args);
   cnv_strnode_string(childname, args=cdr(args));
   cnv_strnode_string(titlename, args=cdr(args));
   x = getint(pos_int_arg(args=cdr(args)));
   y = getint(pos_int_arg(args=cdr(args)));
   w = getint(pos_int_arg(args=cdr(args)));
   h = getint(pos_int_arg(args=cdr(args)));
   if (cdr(args) != NIL) cnv_strnode_string(callback, cdr(args));
   else callback[0] = '\0';
   
   // convert to "DIALOG" units. This is the key to getting consistent
   // results in all graphics MODEs.
   
   x = (x*BaseUnitsx)/4;
   y = (y*BaseUnitsy)/8;
   w = (w*BaseUnitsx)/4;
   h = (h*BaseUnitsy)/8;
   
   // if it does not exist continue
   
   if (dialogboxes.get(childname) == NULL)
      {
      
      // make one
      
      child = new dialogthing;
      
      // if parent of corect type exists use it
      
      if ((parent = dialogboxes.get2(parentname,TWindow_type)) != NULL)
         {
         child->TDmybox = new TMxDialog(parent->TWmybox,"DIALOGSTUB");
         ptr = parent->TWmybox->key;
         }
      
      // else use main window
      
      else
         {
         child->TDmybox = new TMxDialog(MainWindowx,"DIALOGSTUB");
         ptr = mainwindow;
         }
      
      // Modal windows have to have a callback to set them up
      // since it will not return until closed
      
      strcpy(child->TDmybox->callback,callback);
      strcpy(child->TDmybox->caption,titlename);
      
      // Most attributes are set in DIALOGSTUB
      
      child->TDmybox->x = x;
      child->TDmybox->y = y;
      child->TDmybox->w = w;
      child->TDmybox->h = h;
      
      strcpy(child->TDmybox->key,childname);
      dialogboxes.insert(child,child->TDmybox->key,ptr,TDialog_type);
      
      // Note will not return until the Window closes
      // But the LOGO program still has some control through
      // the callback which is done through OWLs "SetupWindow".
      
      ((TWindow *)MainWindowx)->GetApplication()->ExecDialog(child->TDmybox);
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Already exists", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *ldialogdelete(NODE *arg1)
   {
   dialogthing *temp;
   char childname[MAX_BUFFER_SIZE];
   
   // get args
   
   cnv_strnode_string(childname, arg1);
   
   // if it exists then kill it and all its children
   
   if ((temp = dialogboxes.get2(childname,TDialog_type)) != NULL)
      {
      
      ((TWindow *)temp->TWmybox)->CloseWindow();
      
      dialogboxes.zap(childname);
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *llistboxcreate(NODE *args)
   {
   dialogthing *child;
   dialogthing *parent;
   int x;
   int y;
   int w;
   int h;
   char parentname[MAX_BUFFER_SIZE];
   char childname[MAX_BUFFER_SIZE];
   
   // get args
   
   cnv_strnode_string(parentname, args);
   cnv_strnode_string(childname, args=cdr(args));
   x = getint(pos_int_arg(args=cdr(args)));
   y = getint(pos_int_arg(args=cdr(args)));
   w = getint(pos_int_arg(args=cdr(args)));
   h = getint(pos_int_arg(     cdr(args)));
   
   // convert to "DIALOG" units.
   
   x = (x*BaseUnitsx)/4;
   y = (y*BaseUnitsy)/8;
   w = (w*BaseUnitsx)/4;
   h = (h*BaseUnitsy)/8;
   
   // if unique continue
   
   if (dialogboxes.get(childname) == NULL)
      {
      
      // If modeless parent then continue
      
      if ((parent = dialogboxes.get2(parentname,TWindow_type)) != NULL)
         {
         child = new dialogthing;
         
         child->TLmybox = new TMyListBox(parent->TWmybox,MYLISTBOX_ID,x,y,w,h);
         
         ((TWindow *)MainWindowx)->GetApplication()->MakeWindow(child->TLmybox);
         
         MyMessageScan();
         
         strcpy(child->TLmybox->key,childname);
         dialogboxes.insert(child,child->TLmybox->key,parent->TWmybox->key,TListBox_type);
         }
      
      // else if modal window continue
      
      else if ((parent = dialogboxes.get2(parentname,TDialog_type)) != NULL)
         {
         child = new dialogthing;
         
         child->TLmybox = new TMyListBox(parent->TDmybox,MYLISTBOX_ID,x,y,w,h);
         
         ((TWindow *)MainWindowx)->GetApplication()->MakeWindow(child->TLmybox);
         
         MyMessageScan();
         
         strcpy(child->TLmybox->key,childname);
         dialogboxes.insert(child,child->TLmybox->key,parent->TDmybox->key,TListBox_type);
         }
      else
         {
         MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
         err_logo(STOP_ERROR,NIL);
         }
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Already exists", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *llistboxdelete(NODE *arg1)
   {
   dialogthing *temp;
   char childname[MAX_BUFFER_SIZE];
   
   // get args
   
   cnv_strnode_string(childname, arg1);
   
   // if it exists kill it
   
   if ((temp = dialogboxes.get2(childname,TListBox_type)) != NULL)
      {
      
      ((TListBox *)temp->TLmybox)->CloseWindow();
      
      dialogboxes.zap(childname);
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *llistboxgetselect(NODE *args)
   {
   dialogthing *parent;
   char parentname[MAX_BUFFER_SIZE];
   char stringname[MAX_BUFFER_SIZE];
   NODE *val = UNBOUND;
   
   // get args
   
   cnv_strnode_string(parentname, args);
   
   // If it exists continue
   
   if ((parent = dialogboxes.get2(parentname,TListBox_type)) != NULL)
      {
      
      // if success on fetching string return it
      
      if (((TListBox *)parent->TLmybox)->GetSelString(stringname,MAX_BUFFER_SIZE) >= 0)
         {
         
         // parsing it basically turns it into a list for us
         
         val = parser(make_strnode(stringname, NULL, strlen(stringname), STRING, strnzcpy),FALSE);
         return(val);
         }
      }
   else
      {
      MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *llistboxaddstring(NODE *args)
   {
   dialogthing *parent;
   char parentname[MAX_BUFFER_SIZE];
   char stringname[MAX_BUFFER_SIZE];
   
   // get args
   
   cnv_strnode_string(parentname, args);
   cnv_strnode_string(stringname, cdr(args));
   
   // if exists continue
   
   if ((parent = dialogboxes.get2(parentname,TListBox_type)) != NULL)
      {
      
      // add entry and reset Index for consistency
      
      ((TListBox *)parent->TLmybox)->AddString(stringname);
      ((TListBox *)parent->TLmybox)->SetSelIndex(0);
      }
   else
      {
      MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *llistboxdeletestring(NODE *args)
   {
   dialogthing *parent;
   int index;
   char parentname[MAX_BUFFER_SIZE];
   
   // get args
   
   cnv_strnode_string(parentname, args);
   index = getint(pos_int_arg(cdr(args)));
   
   // if exists continue
   
   if ((parent = dialogboxes.get2(parentname,TListBox_type)) != NULL)
      {
      
      // kill entry based on index
      
      ((TListBox *)parent->TLmybox)->DeleteString(index);
      ((TListBox *)parent->TLmybox)->SetSelIndex(0);
      }
   else
      {
      MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lcomboboxcreate(NODE *args)
   {
   dialogthing *child;
   dialogthing *parent;
   int x;
   int y;
   int w;
   int h;
   char parentname[MAX_BUFFER_SIZE];
   char childname[MAX_BUFFER_SIZE];
   
   // get args
   
   cnv_strnode_string(parentname, args);
   cnv_strnode_string(childname, args=cdr(args));
   x = getint(pos_int_arg(args=cdr(args)));
   y = getint(pos_int_arg(args=cdr(args)));
   w = getint(pos_int_arg(args=cdr(args)));
   h = getint(pos_int_arg(     cdr(args)));
   
   // convert to "DIALOG" units
   
   x = (x*BaseUnitsx)/4;
   y = (y*BaseUnitsy)/8;
   w = (w*BaseUnitsx)/4;
   h = (h*BaseUnitsy)/8;
   
   // if unique continue
   
   if (dialogboxes.get(childname) == NULL)
      {
      
      // if modeless window enter here
      
      if ((parent = dialogboxes.get2(parentname,TWindow_type)) != NULL)
         {
         // create thingy
         
         child = new dialogthing;
         
         child->TCmybox = new TMxComboBox(parent->TWmybox,MYCOMBOBOX_ID,x,y,w,h,CBS_SIMPLE,0);
         
         // set attributes
         
         child->TCmybox->Attr.Style |= CBS_DISABLENOSCROLL;
         
         // Display the control
         
         ((TWindow *)MainWindowx)->GetApplication()->MakeWindow(child->TCmybox);
         
         MyMessageScan();
         
         strcpy(child->TCmybox->key,childname);
         dialogboxes.insert(child,child->TCmybox->key,parent->TWmybox->key,TComboBox_type);
         }
      
      // if modal window enter here (same as above except names change)
      
      else if ((parent = dialogboxes.get2(parentname,TDialog_type)) != NULL)
         {
         child = new dialogthing;
         
         child->TCmybox = new TMxComboBox(parent->TDmybox,MYCOMBOBOX_ID,x,y,w,h,CBS_SIMPLE,0);
         
         child->TCmybox->Attr.Style |= CBS_DISABLENOSCROLL;
         
         ((TWindow *)MainWindowx)->GetApplication()->MakeWindow(child->TCmybox);
         
         MyMessageScan();
         
         strcpy(child->TCmybox->key,childname);
         dialogboxes.insert(child,child->TCmybox->key,parent->TDmybox->key,TComboBox_type);
         }
      else
         {
         MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
         err_logo(STOP_ERROR,NIL);
         }
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Already exists", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lcomboboxdelete(NODE *arg1)
   {
   dialogthing *temp;
   char childname[MAX_BUFFER_SIZE];
   
   // get args
   
   cnv_strnode_string(childname, arg1);
   
   // if it exists kill it
   
   if ((temp = dialogboxes.get2(childname,TComboBox_type)) != NULL)
      {
      
      ((TComboBox *)temp->TCmybox)->CloseWindow();
      
      dialogboxes.zap(childname);
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lcomboboxgettext(NODE *args)
   {
   dialogthing *parent;
   char parentname[MAX_BUFFER_SIZE];
   char stringname[MAX_BUFFER_SIZE];
   NODE *val;
   
   // get args
   
   cnv_strnode_string(parentname, args);
   
   // if exists continue
   
   if ((parent = dialogboxes.get2(parentname,TComboBox_type)) != NULL)
      {
      
      // if successful getting string return it
      
      if (((TComboBox *)parent->TCmybox)->GetText(stringname,MAX_BUFFER_SIZE) >= 0)
         {
         
         // parsing it turns it into a list
         
         val = parser(make_strnode(stringname, NULL, strlen(stringname), STRING, strnzcpy),FALSE);
         return(val);
         }
      }
   else
      {
      MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lcomboboxsettext(NODE *args)
   {
   dialogthing *parent;
   char parentname[MAX_BUFFER_SIZE];
   char stringname[MAX_BUFFER_SIZE];
   
   // get args
   
   cnv_strnode_string(parentname, args);
   cnv_strnode_string(stringname, cdr(args));
   
   // if exists continue
   
   if ((parent = dialogboxes.get2(parentname,TComboBox_type)) != NULL)
      {
      
      // set the editcontrol portion to the user specified text
      
      ((TComboBox *)parent->TCmybox)->SetText(stringname);
      }
   else
      {
      MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lcomboboxaddstring(NODE *args)
   {
   dialogthing *parent;
   char parentname[MAX_BUFFER_SIZE];
   char stringname[MAX_BUFFER_SIZE];
   
   // get args
   
   cnv_strnode_string(parentname, args);
   cnv_strnode_string(stringname, cdr(args));
   
   // if exists continue
   
   if ((parent = dialogboxes.get2(parentname,TComboBox_type)) != NULL)
      {
      
      // add string and reset selection
      
      ((TComboBox *)parent->TCmybox)->AddString(stringname);
      ((TComboBox *)parent->TCmybox)->SetSelIndex(0);
      }
   else
      {
      MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lcomboboxdeletestring(NODE *args)
   {
   dialogthing *parent;
   int index;
   char parentname[MAX_BUFFER_SIZE];
   
   // get args
   
   cnv_strnode_string(parentname, args);
   index = getint(pos_int_arg(cdr(args)));
   
   // if exists continue
   
   if ((parent = dialogboxes.get2(parentname,TComboBox_type)) != NULL)
      {
      
      // kill entrt and reset Index
      
      ((TComboBox *)parent->TCmybox)->DeleteString(index);
      ((TComboBox *)parent->TCmybox)->SetSelIndex(0);
      }
   else
      {
      MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

//xxxxxxxxxxxxxxxxxxxx

NODE *lscrollbarcreate(NODE *args)
   {
   dialogthing *child;
   dialogthing *parent;
   int x;
   int y;
   int w;
   int h;
   char parentname[MAX_BUFFER_SIZE];
   char childname[MAX_BUFFER_SIZE];
   char callback[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(parentname, args);
   cnv_strnode_string(childname, args=cdr(args));
   x = getint(pos_int_arg(args=cdr(args)));
   y = getint(pos_int_arg(args=cdr(args)));
   w = getint(pos_int_arg(args=cdr(args)));
   h = getint(pos_int_arg(args=cdr(args)));
   cnv_strnode_string(callback, cdr(args));
   //   if (cdr(args) != NIL) 
   //   else callback[0] = '\0';
   
   x = (x*BaseUnitsx)/4;
   y = (y*BaseUnitsy)/8;
   w = (w*BaseUnitsx)/4;
   h = (h*BaseUnitsy)/8;
   
   if (dialogboxes.get(childname) == NULL)
      {
      
      if ((parent = dialogboxes.get2(parentname,TWindow_type)) != NULL)
         {
         child = new dialogthing;
         
         if (w>h)
            {
            child->TSCmybox = new TMyScrollBar(parent->TWmybox,MYSCROLLBAR_ID,x,y,w,0,TRUE);
            }
         else
            {
            child->TSCmybox = new TMyScrollBar(parent->TWmybox,MYSCROLLBAR_ID,x,y,0,h,FALSE);
            }
         
         strcpy(child->TSCmybox->callback,callback);
         child->TSCmybox->critical = 0;
         
         ((TWindow *)MainWindowx)->GetApplication()->MakeWindow(child->TSCmybox);
         
         MyMessageScan();
         
         strcpy(child->TSCmybox->key,childname);
         dialogboxes.insert(child,child->TSCmybox->key,parent->TWmybox->key,TScrollBar_type);
         }
      else if ((parent = dialogboxes.get2(parentname,TDialog_type)) != NULL)
         {
         child = new dialogthing;
         
         if (w>h)
            {
            child->TSCmybox = new TMyScrollBar(parent->TDmybox,MYSCROLLBAR_ID,x,y,w,0,TRUE);
            }
         else
            {
            child->TSCmybox = new TMyScrollBar(parent->TDmybox,MYSCROLLBAR_ID,x,y,0,h,FALSE);
            }
         
         strcpy(child->TSCmybox->callback,callback);
         child->TSCmybox->critical = 0;
         
         ((TWindow *)MainWindowx)->GetApplication()->MakeWindow(child->TSCmybox);
         
         MyMessageScan();
         
         strcpy(child->TSCmybox->key,childname);
         dialogboxes.insert(child,child->TSCmybox->key,parent->TDmybox->key,TScrollBar_type);
         }
      else
         {
         MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
         err_logo(STOP_ERROR,NIL);
         }
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Already exists", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lscrollbarset(NODE *args)
   {
   dialogthing *parent;
   char parentname[MAX_BUFFER_SIZE];
   int lo;
   int hi;
   int pos;
   
   cnv_strnode_string(parentname, args);
   lo = getint(pos_int_arg(args=cdr(args)));
   hi = getint(pos_int_arg(args=cdr(args)));
   pos = getint(pos_int_arg(cdr(args)));
   
   if ((parent = dialogboxes.get2(parentname,TScrollBar_type)) != NULL)
      {
      ((TScrollBar *)parent->TSCmybox)->SetRange(lo,hi);
      ((TScrollBar *)parent->TSCmybox)->SetPosition(pos);
      }
   else
      {
      MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lscrollbarget(NODE *args)
   {
   dialogthing *parent;
   char parentname[MAX_BUFFER_SIZE];
   int pos;
   
   cnv_strnode_string(parentname, args);
   
   if ((parent = dialogboxes.get2(parentname,TScrollBar_type)) != NULL)
      {
      pos = ((TScrollBar *)parent->TSCmybox)->GetPosition();
      return(make_intnode(pos));
      }
   else
      {
      MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lscrollbardelete(NODE *arg1)
   {
   dialogthing *temp;
   char childname[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(childname, arg1);
   
   if ((temp = dialogboxes.get2(childname,TScrollBar_type)) != NULL)
      {
      
      ((TScrollBar *)temp->TSCmybox)->CloseWindow();
      
      dialogboxes.zap(childname);
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lstaticcreate(NODE *args)
   {
   dialogthing *child;
   dialogthing *parent;
   int x;
   int y;
   int w;
   int h;
   char parentname[MAX_BUFFER_SIZE];
   char childname[MAX_BUFFER_SIZE];
   char titlename[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(parentname, args);
   cnv_strnode_string(childname, args=cdr(args));
   cnv_strnode_string(titlename, args=cdr(args));
   x = getint(pos_int_arg(args=cdr(args)));
   y = getint(pos_int_arg(args=cdr(args)));
   w = getint(pos_int_arg(args=cdr(args)));
   h = getint(pos_int_arg(     cdr(args)));
   
   x = (x*BaseUnitsx)/4;
   y = (y*BaseUnitsy)/8;
   w = (w*BaseUnitsx)/4;
   h = (h*BaseUnitsy)/8;
   
   if (dialogboxes.get(childname) == NULL)
      {
      
      if ((parent = dialogboxes.get2(parentname,TWindow_type)) != NULL)
         {
         child = new dialogthing;
         
         child->TSmybox = new TMyStatic(parent->TWmybox,MYSTATIC_ID,titlename,x,y,w,h,0);
         
         ((TWindow *)MainWindowx)->GetApplication()->MakeWindow(child->TSmybox);
         
         MyMessageScan();
         
         strcpy(child->TSmybox->key,childname);
         dialogboxes.insert(child,child->TSmybox->key,parent->TWmybox->key,TStatic_type);
         }
      else if ((parent = dialogboxes.get2(parentname,TDialog_type)) != NULL)
         {
         child = new dialogthing;
         
         child->TSmybox = new TMyStatic(parent->TDmybox,MYSTATIC_ID,titlename,x,y,w,h,0);
         
         ((TWindow *)MainWindowx)->GetApplication()->MakeWindow(child->TSmybox);
         
         MyMessageScan();
         
         strcpy(child->TSmybox->key,childname);
         dialogboxes.insert(child,child->TSmybox->key,parent->TDmybox->key,TStatic_type);
         }
      else
         {
         MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
         err_logo(STOP_ERROR,NIL);
         }
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Already exists", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lstaticupdate(NODE *args)
   {
   dialogthing *temp;
   char childname[MAX_BUFFER_SIZE];
   char titlename[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(childname, args);
   cnv_strnode_string(titlename, cdr(args));
   
   if ((temp = dialogboxes.get2(childname,TStatic_type)) != NULL)
      {
      
      ((TStatic *)temp->TSmybox)->SetText(titlename);
      
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lstaticdelete(NODE *arg1)
   {
   dialogthing *temp;
   char childname[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(childname, arg1);
   
   if ((temp = dialogboxes.get2(childname,TStatic_type)) != NULL)
      {
      
      ((TStatic *)temp->TSmybox)->CloseWindow();
      
      dialogboxes.zap(childname);
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lbuttoncreate(NODE *args)
   {
   dialogthing *child;
   dialogthing *parent;
   int x;
   int y;
   int w;
   int h;
   char parentname[MAX_BUFFER_SIZE];
   char childname[MAX_BUFFER_SIZE];
   char titlename[MAX_BUFFER_SIZE];
   char callback[MAX_BUFFER_SIZE];
   //   NODE *callbackx;   
   
   cnv_strnode_string(parentname, args);
   cnv_strnode_string(childname, args=cdr(args));
   cnv_strnode_string(titlename, args=cdr(args));
   x = getint(pos_int_arg(args=cdr(args)));
   y = getint(pos_int_arg(args=cdr(args)));
   w = getint(pos_int_arg(args=cdr(args)));
   h = getint(pos_int_arg(args=cdr(args)));
   //   callbackx = cdr(args);
   //   lprint(callbackx);
   //   xxx = reref(xxx, cdr(args));
   //   lprint(xxx);
   if (cdr(args) != NIL) cnv_strnode_string(callback, cdr(args));
   else callback[0] = '\0';
   
   x = (x*BaseUnitsx)/4;
   y = (y*BaseUnitsy)/8;
   w = (w*BaseUnitsx)/4;
   h = (h*BaseUnitsy)/8;
   
   if (dialogboxes.get(childname) == NULL)
      {
      
      if ((parent = dialogboxes.get2(parentname,TWindow_type)) != NULL)
         {
         child = new dialogthing;
         
         child->TBmybox = new TMyButton(parent->TWmybox,MYBUTTON_ID,titlename,x,y,w,h,0);
         
         strcpy(child->TBmybox->callback,callback);
         child->TBmybox->critical = 0;
         
         ((TWindow *)MainWindowx)->GetApplication()->MakeWindow(child->TBmybox);
         
         MyMessageScan();
         
         strcpy(child->TBmybox->key,childname);
         dialogboxes.insert(child,child->TBmybox->key,parent->TWmybox->key,TButton_type);
         } 
      else if ((parent = dialogboxes.get2(parentname,TDialog_type)) != NULL)
         {
         child = new dialogthing;
         
         child->TBmybox = new TMyButton(parent->TDmybox,MYBUTTON_ID,titlename,x,y,w,h,0);
         
         strcpy(child->TBmybox->callback,callback);
         child->TBmybox->critical = 0;
         
         ((TWindow *)MainWindowx)->GetApplication()->MakeWindow(child->TBmybox);
         
         MyMessageScan();
         
         strcpy(child->TBmybox->key,childname);
         dialogboxes.insert(child,child->TBmybox->key,parent->TDmybox->key,TButton_type);
         } 
      else
         {
         MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
         err_logo(STOP_ERROR,NIL);
         }
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Already exists", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lbuttondelete(NODE *arg1)
   {
   dialogthing *temp;
   char childname[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(childname, arg1);
   
   if ((temp = dialogboxes.get2(childname,TButton_type)) != NULL)
      {
      
      ((TButton *)temp->TBmybox)->CloseWindow();
      
      dialogboxes.zap(childname);
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lgroupboxcreate(NODE *args)
   {
   dialogthing *child;
   dialogthing *parent;
   int x;
   int y;
   int w;
   int h;
   char parentname[MAX_BUFFER_SIZE];
   char childname[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(parentname, args);
   cnv_strnode_string(childname, args=cdr(args));
   x = getint(pos_int_arg(args=cdr(args)));
   y = getint(pos_int_arg(args=cdr(args)));
   w = getint(pos_int_arg(args=cdr(args)));
   h = getint(pos_int_arg(     cdr(args)));
   
   x = (x*BaseUnitsx)/4;
   y = (y*BaseUnitsy)/8;
   w = (w*BaseUnitsx)/4;
   h = (h*BaseUnitsy)/8;
   
   if (dialogboxes.get(childname) == NULL)
      {
      
      if ((parent = dialogboxes.get2(parentname,TWindow_type)) != NULL)
         {
         child = new dialogthing;
         
         child->TGmybox = new TMyGroupBox(parent->TWmybox,MYGROUPBOX_ID,NULL,x,y,w,h);
         
         ((TWindow *)MainWindowx)->GetApplication()->MakeWindow(child->TGmybox);
         
         MyMessageScan();
         
         strcpy(child->TGmybox->key,childname);
         dialogboxes.insert(child,child->TGmybox->key,parent->TWmybox->key,TGroupBox_type);
         }
      else if ((parent = dialogboxes.get2(parentname,TDialog_type)) != NULL)
         {
         child = new dialogthing;
         
         child->TGmybox = new TMyGroupBox(parent->TDmybox,MYGROUPBOX_ID,NULL,x,y,w,h);
         
         ((TWindow *)MainWindowx)->GetApplication()->MakeWindow(child->TGmybox);
         
         MyMessageScan();
         
         strcpy(child->TGmybox->key,childname);
         dialogboxes.insert(child,child->TGmybox->key,parent->TDmybox->key,TGroupBox_type);
         }
      else
         {
         MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
         err_logo(STOP_ERROR,NIL);
         }
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Already exists", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lgroupboxdelete(NODE *arg1)
   {
   dialogthing *temp;
   char childname[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(childname, arg1);
   
   if ((temp = dialogboxes.get2(childname,TGroupBox_type)) != NULL)
      {
      
      ((TGroupBox *)temp->TGmybox)->CloseWindow();
      
      dialogboxes.zap(childname);
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lradiobuttoncreate(NODE *args)
   {
   dialogthing *child;
   dialogthing *parent;
   dialogthing *group;
   int x;
   int y;
   int w;
   int h;
   char parentname[MAX_BUFFER_SIZE];
   char childname[MAX_BUFFER_SIZE];
   char titlename[MAX_BUFFER_SIZE];
   char groupname[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(parentname, args);
   cnv_strnode_string(groupname, args=cdr(args));
   cnv_strnode_string(childname, args=cdr(args));
   cnv_strnode_string(titlename, args=cdr(args));
   x = getint(pos_int_arg(args=cdr(args)));
   y = getint(pos_int_arg(args=cdr(args)));
   w = getint(pos_int_arg(args=cdr(args)));
   h = getint(pos_int_arg(args=cdr(args)));
   //   if (cdr(args) != NIL) cnv_strnode_string(callback, cdr(args));
   //   else callback[0] = '\0';
   
   x = (x*BaseUnitsx)/4;
   y = (y*BaseUnitsy)/8;
   w = (w*BaseUnitsx)/4;
   h = (h*BaseUnitsy)/8;
   
   if (dialogboxes.get(childname) == NULL)
      {
      if ((parent = dialogboxes.get2(parentname,TWindow_type)) != NULL)
         {
         if ((group = dialogboxes.get2(groupname,TGroupBox_type)) != NULL)
            {
            child = new dialogthing;
            
            child->TRmybox = new TMyRadioButton(parent->TWmybox,MYRADIOBUTTON_ID,titlename,x,y,w,h,group->TGmybox);
            
            //         strcpy(child->TRmybox->callback,callback);
            //         child->TRmybox->critical = 0;
            
            ((TWindow *)MainWindowx)->GetApplication()->MakeWindow(child->TRmybox);
            
            MyMessageScan();
            
            strcpy(child->TRmybox->key,childname);
            dialogboxes.insert(child,child->TRmybox->key,parent->TWmybox->key,TRadioButton_type);
            } 
         else
            {
            MessageBox(CmdHWindow, groupname, "Does not exist", MB_OK);
            err_logo(STOP_ERROR,NIL);
            }
         } 
      else if ((parent = dialogboxes.get2(parentname,TDialog_type)) != NULL)
         {
         if ((group = dialogboxes.get2(groupname,TGroupBox_type)) != NULL)
            {
            child = new dialogthing;
            
            child->TRmybox = new TMyRadioButton(parent->TDmybox,MYRADIOBUTTON_ID,titlename,x,y,w,h,group->TGmybox);
            
            //         strcpy(child->TRmybox->callback,callback);
            //         child->TRmybox->critical = 0;
            
            ((TWindow *)MainWindowx)->GetApplication()->MakeWindow(child->TRmybox);
            
            MyMessageScan();
            
            strcpy(child->TRmybox->key,childname);
            dialogboxes.insert(child,child->TRmybox->key,parent->TDmybox->key,TRadioButton_type);
            } 
         else
            {
            MessageBox(CmdHWindow, groupname, "Does not exist", MB_OK);
            err_logo(STOP_ERROR,NIL);
            }
         } 
      else
         {
         MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
         err_logo(STOP_ERROR,NIL);
         }
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Already exists", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lradiobuttondelete(NODE *arg1)
   {
   dialogthing *temp;
   char childname[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(childname, arg1);
   
   if ((temp = dialogboxes.get2(childname,TRadioButton_type)) != NULL)
      {
      
      ((TRadioButton *)temp->TRmybox)->CloseWindow();
      
      dialogboxes.zap(childname);
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lradiobuttonget(NODE *args)
   {
   dialogthing *parent;
   char parentname[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(parentname, args);
   
   if ((parent = dialogboxes.get2(parentname,TRadioButton_type)) != NULL)
      {
      if (BF_CHECKED == ((TCheckBox *)parent->TRmybox)->GetCheck())
      return(Truex);
      else
      return(Falsex);
      }
   else
      {
      MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lradiobuttonset(NODE *args)
   {
   dialogthing *parent;
   char parentname[MAX_BUFFER_SIZE];
   int pos;
   
   cnv_strnode_string(parentname, args);
   pos = getint(pos_int_arg(args=cdr(args)));
   
   if ((parent = dialogboxes.get2(parentname,TRadioButton_type)) != NULL)
      {
      if (pos == 1) 
      ((TCheckBox *)parent->TRmybox)->Check();
      else
      ((TCheckBox *)parent->TRmybox)->Uncheck();
      }
   else
      {
      MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lcheckboxcreate(NODE *args)
   {
   dialogthing *child;
   dialogthing *parent;
   dialogthing *group;
   int x;
   int y;
   int w;
   int h;
   char parentname[MAX_BUFFER_SIZE];
   char childname[MAX_BUFFER_SIZE];
   char titlename[MAX_BUFFER_SIZE];
   char groupname[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(parentname, args);
   cnv_strnode_string(groupname, args=cdr(args));
   cnv_strnode_string(childname, args=cdr(args));
   cnv_strnode_string(titlename, args=cdr(args));
   x = getint(pos_int_arg(args=cdr(args)));
   y = getint(pos_int_arg(args=cdr(args)));
   w = getint(pos_int_arg(args=cdr(args)));
   h = getint(pos_int_arg(args=cdr(args)));
   //   if (cdr(args) != NIL) cnv_strnode_string(callback, cdr(args));
   //   else callback[0] = '\0';
   
   x = (x*BaseUnitsx)/4;
   y = (y*BaseUnitsy)/8;
   w = (w*BaseUnitsx)/4;
   h = (h*BaseUnitsy)/8;
   
   if (dialogboxes.get(childname) == NULL)
      {
      if ((parent = dialogboxes.get2(parentname,TWindow_type)) != NULL)
         {
         if ((group = dialogboxes.get2(groupname,TGroupBox_type)) != NULL)
            {
            child = new dialogthing;
            
            child->TCBmybox = new TMyCheckBox(parent->TWmybox,MYCHECKBOX_ID,titlename,x,y,w,h,group->TGmybox);
            
            //         strcpy(child->TCBmybox->callback,callback);
            //         child->TCBmybox->critical = 0;
            
            ((TWindow *)MainWindowx)->GetApplication()->MakeWindow(child->TCBmybox);
            
            MyMessageScan();
            
            strcpy(child->TCBmybox->key,childname);
            dialogboxes.insert(child,child->TCBmybox->key,parent->TWmybox->key,TCheckBox_type);
            } 
         else
            {
            MessageBox(CmdHWindow, groupname, "Does not exist", MB_OK);
            err_logo(STOP_ERROR,NIL);
            }
         } 
      else if ((parent = dialogboxes.get2(parentname,TDialog_type)) != NULL)
         {
         if ((group = dialogboxes.get2(groupname,TGroupBox_type)) != NULL)
            {
            child = new dialogthing;
            
	    child->TCBmybox = new TMyCheckBox(parent->TDmybox,MYCHECKBOX_ID,titlename,x,y,w,h,group->TGmybox);
            
            //         strcpy(child->TCBmybox->callback,callback);
            //         child->TCBmybox->critical = 0;
            
            ((TWindow *)MainWindowx)->GetApplication()->MakeWindow(child->TCBmybox);
            
            MyMessageScan();
            
            strcpy(child->TCBmybox->key,childname);
            dialogboxes.insert(child,child->TCBmybox->key,parent->TDmybox->key,TCheckBox_type);
            } 
         else
            {
            MessageBox(CmdHWindow, groupname, "Does not exist", MB_OK);
            err_logo(STOP_ERROR,NIL);
            }
         } 
      else
         {
         MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
         err_logo(STOP_ERROR,NIL);
         }
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Already exists", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lcheckboxdelete(NODE *arg1)
   {
   dialogthing *temp;
   char childname[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(childname, arg1);
   
   if ((temp = dialogboxes.get2(childname,TCheckBox_type)) != NULL)
      {
      
      ((TCheckBox *)temp->TCBmybox)->CloseWindow();
      
      dialogboxes.zap(childname);
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lcheckboxget(NODE *args)
   {
   dialogthing *parent;
   char parentname[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(parentname, args);
   
   if ((parent = dialogboxes.get2(parentname,TCheckBox_type)) != NULL)
      {
      if (BF_CHECKED == parent->TCBmybox->GetCheck())
      return(Truex);
      else
      return(Falsex);
      }
   else
      {
      MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lcheckboxset(NODE *args)
   {
   dialogthing *parent;
   char parentname[MAX_BUFFER_SIZE];
   int pos;
   
   cnv_strnode_string(parentname, args);
   pos = getint(pos_int_arg(args=cdr(args)));
   
   if ((parent = dialogboxes.get2(parentname,TCheckBox_type)) != NULL)
      {
      if (pos == 1) 
      parent->TCBmybox->Check();
      else
      parent->TCBmybox->Uncheck();
      }
   else
      {
      MessageBox(CmdHWindow, parentname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *ldebugwindows(NODE *arg1)
   {
   char childname[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(childname, arg1);
   
   if (dialogboxes.get(childname) != NULL)
      {
      dialogboxes.list(childname,0);
      }
   else
      {
      MessageBox(CmdHWindow, childname, "Does not exist", MB_OK);
      err_logo(STOP_ERROR,NIL);
      }
   
   return (UNBOUND);
   }

NODE *lmessagebox(NODE *args)
   {
   char banner[MAX_BUFFER_SIZE];
   char body[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(banner, args);
   cnv_strnode_string(body, args=cdr(args));
   
   MessageBox(CmdHWindow, body, banner, MB_OK);
   
   return (UNBOUND);
   }

NODE *lsetcursorwait()
   {
   hCursorSave = SetCursor(hCursorWait);
   
   return (UNBOUND);
   }

NODE *lsetcursorarrow()
   {
   
   if (hCursorSave)
      {
      SetCursor(hCursorSave);
      hCursorSave = 0;
      }
   
   return (UNBOUND);
   }

NODE *ldialogfileopen(NODE *args)
   {
   NODE *arg, *val = UNBOUND;
   char filename[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(filename, args);
   
   if ( ((TWindow *)MainWindowx)->GetApplication()->ExecDialog(new TFileDialog(MainWindowx, SD_FILEOPEN, filename)) == IDOK )
      {
      arg = make_strnode(filename, NULL, strlen(filename), STRING, strnzcpy);
      val = parser(arg, FALSE);
      return(val);
      }
   else
      {
      return (NIL);
      }
   
   }

NODE *ldialogfilesave(NODE *args)
   {
   NODE *arg, *val = UNBOUND;
   char filename[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(filename, args);
   
   if ( ((TWindow *)MainWindowx)->GetApplication()->ExecDialog(new TFileDialog(MainWindowx, SD_FILESAVE, filename)) == IDOK )
      {
      arg = make_strnode(filename, NULL, strlen(filename), STRING, strnzcpy);
      val = parser(arg, FALSE);
      return(val);
      }
   else
      {
      return (NIL);
      }
   
   }

NODE *lwindowfileedit(NODE *args)
   {
   char filename[MAX_BUFFER_SIZE];
   char editexit[MAX_BUFFER_SIZE];
   
   cnv_strnode_string(filename, args);
   cnv_strnode_string(editexit, args=cdr(args));
   
   strcpy(edit_editexit,editexit);
   
   if (TMyWindow_MyPopupEdit(filename, (NODE *)NULL))
      {
      return (UNBOUND);
      }
   
   return (UNBOUND);
   }
