#include "allwind.h"

CUTMAP *CutBmp;		   /* Pointer to Bit Cut memory array malloc on init */
int CutIndex = 0;	   /* Pointer into CutBmp initially "ClipBoard" */

HANDLE HashHandle=0;	   /* Handle to Hashtable */
HANDLE StackHandle=0;      /* Handle to Gargebage Collector Stack */

HBITMAP MemoryBitMap;      /* Backing store bitmap */
HBITMAP AreaMemoryBitMap;  /* Used to store active area of backing store */

HICON hCursor;             /* handle for saved cursor */
HICON hCursorWait;         /* handle for hour glass cursor */

HPALETTE ThePalette;       /* Handle for the single color palette */

LPLOGPALETTE MyLogPalette; /* Handle for the single logical color palette */

NUMBER the_zoom = 1.0;     /* current zoom factor */
NUMBER ibmoldx;            /* global store for x "From" routine */
NUMBER ibmoldy;            /* global store for y "From" routine */

NODE *current_line = NIL;  /* current line to be parsed */

char LibPathName[EXE_NAME_MAX_SIZE+1];       /* path to library */
char TempPathName[EXE_NAME_MAX_SIZE+1];      /* path to temp file */
char szHelpFileName[EXE_NAME_MAX_SIZE+1];    /* path to help file */
char MCIHelpFileName[EXE_NAME_MAX_SIZE+1];   /* path to MCI help file */
char SelectedText[MAX_BUFFER_SIZE];          /* buffer for selected text */ 
char YABuffer[MAX_BUFFER_SIZE];              /* Yet Another buffer */
char commandarg[MAX_BUFFER_SIZE];            /* Routine to exec on start */

// holds callback code

char edit_editexit[MAX_BUFFER_SIZE];         /* callable editor cb */
char mci_callback[MAX_BUFFER_SIZE];          /* MCI callback code */
char *timer_callback[MAX_TIMERS];            /* timer cb malloc'd as needed */
char *mouse_lbuttondown = NULL;              /* Mouse Left button down cb */
char *mouse_lbuttonup = NULL;                /* Mouse Right button up cb */
char *mouse_rbuttondown = NULL;              /* Mouse Left button down cb */
char *mouse_rbuttonup = NULL;                /* Mouse Right button up cb */
char *mouse_mousemove = NULL;                /* Mouse Move cb */
char *keyboard_keydown = NULL;               /* KeyBoard key down */
char *keyboard_keyup = NULL;                 /* KeyBoard key up */

HINSTANCE ModulehInstance;                   /* About box instance handle */

HWND MainHWindow;                            /* Handle to Main(screen) window */
HWND CmdHWindow;                             /* Handle to commander window */
HWND StatusHWindow;			     /* Handle to status window */
HWND EdtHWindow;                             /* Handle to editor window */

/* Handles to each child windows of of the command window */

HWND ListHWindow;                         
HWND EditHWindow;                        
HWND ExecuteHWindow;
HWND HaltHWindow;
HWND TraceHWindow;
HWND PauseHWindow;
HWND StatHWindow;
HWND YieldHWindow;
HWND ResetHWindow;

/* place holders for windows resources */

HBITMAP OldBitmap;
HBITMAP OldBitmap2;

HPALETTE OldPalette;
HPALETTE OldPalette2;

HPEN OldPen;

HBRUSH OldBrush;

HFONT OldFont;

LOGFONT FontRec;

LOGPEN NormalPen;                 /* Handle to "Normal" logical Pen */
LOGPEN ErasePen;                  /* Handle to "Erase" logical Pen */

LOGBRUSH FloodBrush;              /* Handle to the "floodfill" brush */
LOGBRUSH ScreenBrush;             /* Handle to the "screen" background brush */

RECT FullRect;                    /* Ready rectangle of Full bitmap */
RECT TempRect;                    /* Temp rectangle */

PTWindowsObject MainWindowx;      /* Pointer to the Main window */

/* Active area dimensions (real and temp) */

int PrinterAreaXLow;
int PrinterAreaXHigh;
int PrinterAreaYLow;
int PrinterAreaYHigh;
int TPrinterAreaXLow;
int TPrinterAreaXHigh;
int TPrinterAreaYLow;
int TPrinterAreaYHigh;

int GCMAX = 8192;           /* Garbage Collector STack Size (Logo.ini) */
int MAX_PHYS_LINE = 8192;   /* Maximum Physical Line Size (Logo.ini) */
int dpenr;                  /* Current draw pen color red */
int dpeng;                  /* Current draw pen color green */
int dpenb;                  /* Current draw pen color blue */
int dfldr;                  /* Current flood pen color red */
int dfldg;                  /* Current flood pen color green */
int dfldb;                  /* Current flood pen color blue */
int dscnr;                  /* Current screen pen color red */
int dscng;                  /* Current screen pen color green */
int dscnb;                  /* Current screen pen color blue */
int IsDirty = 0;            /* Flag to signal to query user ok to quit */
int NumFonts;               /* Number of system fonts available */
int BitMapWidth  = 1000;    /* Current bitmap size in X */
int BitMapHeight = 1000;    /* Current bitmap size in Y */
int EnablePalette;          /* Flag to signal 256 color mode with palette */
int CustomFlag = 0;         /* Flag to signal Active area is active */
int TCustomFlag = 0;        /* Dynamic copy of CustomFlag */
int Command_OK = 0;         /* Flag to signal it's OK to write to recall box */
int halt_flag = 0;          /* Flag to signal it's OK to halt */
int traceflag = 0;          /* Flag to signal trace button is active */
int pause_flag = 0;         /* Flag to signal pause button is pushed */
int yield_flag = 1;         /* Flag to signal yield state */
int status_flag = 0;        /* Flag to signal status box is poped up */
int MaxWidth = 0;           /* Actual Main window size x */
int MaxHeight = 0;          /* Actual Main window size y */
int xoffset = 0;            /* Used to go from logo to windows coords x */
int yoffset = 0;            /* Used to go from logo to windows coords y */
int JustDidEdit = 0;        /* Flag to signal last command was edit (like) */
int MaxX;                   /* Yet another window size x */
int MaxY;		    /* Yet another window size y */
int Time_To_Exit = 0;	    /* Flag to signal it's time to exit */
int Time_To_Pause = 0;      /* UCBLOGO? pause flag */
int Time_To_Halt = 0;       /* UCBLOGO? halt flag */
int error_happen;	    /* FLag to signal Error happened on edit reload */
int keyboard_on = 0;        /* Flag to signal Keyboard is enabled */
int keyboard_value = 0;     /* Value of Keyboard key */
int mouse_on = 0;           /* Flag to signal Mouse is enabled */
int mouse_posx = 0;         /* Value of Mouse position x */
int mouse_posy = 0;         /* Value of Mouse position y */
int memory_count = 0;       /* Current amount of logo segments malloc'd */
int BaseUnitsx = 0;	    /* X Units Windows uses to for units in dialog */
int BaseUnitsy = 0;         /* Y Units Windows uses to for units in dialog */

long eval_count = 0;	    /* current count of "evaluations" calls */
long scolor = 1;            /* screen color */
long fcolor = 1;            /* flood color */
long pcolor = 1;	    /* pen color */
long width = 1;		    /* pen width */
long zoom_flag = 0;         /* flag to signal in zoomed state */
long MaxColors = 0;	    /* The maximum # of colors available */
long first_init = 0;        /* hack flag to signal one time initialization */

LINEX TurtlePoints[3];      /* used to store 3 vertices of turtle */

/* File editor members */

TMyFileEditWindow::TMyFileEditWindow(PTWindowsObject AParent, LPSTR ATitle)
: TDialog(AParent, ATitle)
   {
   }

TMyFileEditWindow::~TMyFileEditWindow()
   {
   }

void TMyFileEditWindow::DoAll(RTMessage Msg)
   { 
   
   FileEditAll = 1;
   CloseWindow(TRUE);
   
   }

void TMyFileEditWindow::DoCombo(RTMessage Msg)
   { 
   
   if ( Msg.LP.Hi == CBN_DBLCLK )
      {
      CloseWindow(TRUE);
      }
   }

BOOL TMyFileEditWindow::CanClose()
   {
   SendDlgItemMsg(ID_FILEEDITCOMBO, WM_GETTEXT, MAX_BUFFER_SIZE, (LONG)SelectedText);
   
   return TRUE;
   }

void TMyFileEditWindow::WMInitDialog(RTMessage Msg)
   { 
   NODE *proclst;
   char tempbuff[MAX_BUFFER_SIZE];
   
   // get procedures
   
   proclst = lprocedures();
   
   // pop them into the list box
   
   while (proclst != NIL)
      {
      cnv_strnode_string(tempbuff, proclst);
      SendDlgItemMsg(ID_FILEEDITCOMBO, CB_ADDSTRING, 0, (LONG)tempbuff);
      proclst = cdr(proclst);
      }
   }

void putfileeditcombo(char *str) /*routine*/
   {
   
   ((TMyFileEditWindow *)((TMyWindow *)MainWindowx)->
   FileEditWindow)->SendDlgItemMsg(ID_FILEEDITCOMBO, CB_ADDSTRING, 0, (LONG)str);
   
   }

void cnv_strnode_string(char *textbuf,NODE *arg) /*routine*/
   {
   print_stringptr = textbuf;
   print_stringlen = MAX_BUFFER_SIZE;
   ndprintf((FILE *)NULL,"%p",car(arg));
   *print_stringptr = '\0';
   }

long LoadColor(int dpenr, int dpeng, int dpenb) /*routine*/
   {
   
   /* adds color to palette */
   
   int Index;
   long color;
   
   /* convert to color and find nearest match */
   
   color = PALETTERGB(dpenr,dpeng,dpenb);
   
   Index = GetNearestPaletteIndex(ThePalette,color);
   
   /* if not exact and room for more then allocate it */
   
   if ((PALETTERGB(
   MyLogPalette->palPalEntry[Index].peRed,
   MyLogPalette->palPalEntry[Index].peGreen,
   MyLogPalette->palPalEntry[Index].peBlue) != color) && (MyLogPalette->palNumEntries < (MaxColors-1)))
      {
      
      /* Why do check again? */
      
      if (MyLogPalette->palNumEntries < 255)
         {
         
         /* kill old palette */
         
         DeleteObject(ThePalette);
         
         MyLogPalette->palPalEntry[MyLogPalette->palNumEntries].peRed = dpenr;
         MyLogPalette->palPalEntry[MyLogPalette->palNumEntries].peGreen = dpeng;
         MyLogPalette->palPalEntry[MyLogPalette->palNumEntries].peBlue = dpenb;
         MyLogPalette->palPalEntry[MyLogPalette->palNumEntries].peFlags = 0;
         MyLogPalette->palNumEntries++;
         
         /* if status window then update palette usage */
         
         if (status_flag) update_status_paletteuse();
         
         /* make new palette with added color */
         
         ThePalette = CreatePalette(MyLogPalette);
         }
      }
   
   /* return color new, matched or close */
   
   return(color);
   }   

/* __ahIncr, ordinal 114, is a 'magic' function. Defining this
function causes Windows to patch the value into the passed
reference.  This makes it a type of global variable. To use
the value of AHIncr, use FP_OFF(AHIncr). */

   extern "C" {
   void FAR PASCAL  __ahIncr();
   }

/* this routine is here to allow a non object call */

int TMyWindow_MyPopupEdit(char *FileName, NODE *args) /*routine*/
   {
   FILE *edfd;
   
   /* If no file (or empty) create template */
   
   if ((edfd = fopen(FileName,"r")) == NULL)
      {
      if ((edfd = fopen(FileName,"w")) != NULL)
         {
         if (args != NULL)
            {
            fwrite("to\n",1,3,edfd);
            fwrite("end\n",1,4,edfd);
            }
         else
            {
            fwrite("\n",1,1,edfd);
            }
         fclose(edfd);
         }
      }
   else
      {
      if (getc(edfd) == EOF)
         {
         fclose(edfd);
         edfd = fopen(FileName,"w");
         if (args != NULL)
            {
            fwrite("to\n",1,3,edfd);
            fwrite("end\n",1,4,edfd);
            }
         else
            {
            fwrite("\n",1,1,edfd);
            }
         }
      fclose(edfd);
      }
   
   ((TMyWindow *)MainWindowx)->MyPopupEdit(FileName,args);
   return(0);
   }

void clearcombobox() /*routine*/
   {
   
   /* clear the recall box */
   
   ((TMyCommandWindow *)((TMyWindow *)MainWindowx)->
   CommandWindow)->SendDlgItemMsg(ID_LISTBOX, LB_RESETCONTENT, 0, 0);
   }

void putcombobox(char *str) /*routine*/
   {
   DWORD Idx;
   DWORD Err;
   
   /* only if OK to write to recall box do we do it */
   
   if (Command_OK)
      {
      
      /* output to list box */
      
      Err = ((TMyCommandWindow *)((TMyWindow *)MainWindowx)->
      CommandWindow)->SendDlgItemMsg(ID_LISTBOX, LB_ADDSTRING, 0, (LONG)str);
      
      /* while out of space delete of top and try again */
      
      while (Err == LB_ERRSPACE)
         {
         ((TMyCommandWindow *)((TMyWindow *)MainWindowx)->
         CommandWindow)->SendDlgItemMsg(ID_LISTBOX, LB_DELETESTRING, (WORD)0, 0);
         
         Err = ((TMyCommandWindow *)((TMyWindow *)MainWindowx)->
         CommandWindow)->SendDlgItemMsg(ID_LISTBOX, LB_ADDSTRING, 0, (LONG)str);
         }
      
      /* make sure thumb wheel left at bottom */
      
      Idx = ((TMyCommandWindow *)((TMyWindow *)MainWindowx)->
      CommandWindow)->SendDlgItemMsg(ID_LISTBOX, LB_GETCOUNT, 0, 0);
      
      ((TMyCommandWindow *)((TMyWindow *)MainWindowx)->
      CommandWindow)->SendDlgItemMsg(ID_LISTBOX, LB_SETCURSEL, (WORD)Idx-1, 0);
      
      ((TMyCommandWindow *)((TMyWindow *)MainWindowx)->
      CommandWindow)->SendDlgItemMsg(ID_LISTBOX, LB_SETCURSEL, -1, 0);
      }
   }

void promptuser(char *str,char *pmt) /*routine*/
   {
   *str = '\0';
   if (((TMyWindow *)MainWindowx)->MyPopupInput(str,pmt) == 0)
      {
      //     if (halt_flag) Time_To_Halt = 1;
      }
   }

void single_step_box(NODE *the_line) /*routine*/
   {
   char textbuf[MAX_BUFFER_SIZE];
   
   // pop up single step box showing line of code
   
   print_stringptr = textbuf;
   print_stringlen = MAX_BUFFER_SIZE;
   ndprintf((FILE *)NULL,"%p",the_line);
   *print_stringptr = '\0';
   
   MessageBox(MainHWindow, textbuf, "Single Step", MB_OK);
   
   }

void getcombobox(char *str) /*routine*/
   {
   
   /* get it and clear it */
   
   ((TMyCommandWindow *)((TMyWindow *)MainWindowx)->CommandWindow)->SendDlgItemMsg(ID_EDITINPUT, WM_GETTEXT, MAX_BUFFER_SIZE, (LONG)str);
   
   SelectedText[0] = '\0';
   
   ((TMyCommandWindow *)((TMyWindow *)MainWindowx)->CommandWindow)->SendDlgItemMsg(ID_EDITINPUT, WM_SETTEXT, 0, (DWORD)SelectedText);
   }

int minx(int v1, int v2)
   {
   return ((v1 < v2) ? v1 : v2);
   }

int maxx(int v1, int v2)
   {
   return ((v1 > v2) ? v1 : v2);
   }

BOOL TMyApp::ProcessAppMsg( LPMSG msg )
   {
   if( ProcessAccels( msg ) )
   return( TRUE );
   return( TApplication::ProcessAppMsg( msg ) );
   }

void TMyApp::InitInstance()
   {
   TApplication::InitInstance();
   HAccTable = LoadAccelerators(hInstance, "LogoAcc");
   }

void TMyApp::IdleAction()
   {
   
   // this is the time to exit, when things are settled down
   
   if (Time_To_Exit)
      {
      Time_To_Exit = 0;
      PostMessage(MainHWindow, WM_CLOSE, 0, 0);
      }
   
   // if command arg loaded then execute
   
   if (commandarg[0] != '\0')
      {
      silent_load(NIL,commandarg);
      commandarg[0] = '\0';
      }
   
   checkqueue();
   }

void TMyApp::InitMainWindow()
   {
   
   /* Init the main window */
   
   char      *cp;
   char       szWinLocStr[WININISIZ];
   char       dfWinLocStr[WININISIZ];
   int        x, y, w, h;
   int        i;
   
   /* Get video mode parameters */
   
   TempDC = GetDC(0);
   
   MaxWidth = GetDeviceCaps(TempDC,HORZRES);
   MaxHeight = GetDeviceCaps(TempDC,VERTRES);
   MaxColors = pow(2,(GetDeviceCaps(TempDC,BITSPIXEL)+GetDeviceCaps(TempDC,PLANES)));
   BaseUnitsx = LOWORD(GetDialogBaseUnits());   
   BaseUnitsy = HIWORD(GetDialogBaseUnits());   
   
   ReleaseDC(0, TempDC);
   
   /* create the window */
   
   MainWindow = new TMyWindow(NULL, Name);
   
   /* save global handles */
   
   MainWindowx = MainWindow;
   
   /* turtle coords are in center */
   
   xoffset = BitMapWidth/2;
   yoffset = BitMapHeight/2;
   
   /* set appropriate default colors */
   
   pcolor = 0x00000000;
   scolor = 0x00ffffffL;
   fcolor = 0x00000000L;
   
   dpenr = 0x00;
   dpeng = 0x00;
   dpenb = 0x00;
   
   dfldr = 0x00;
   dfldg = 0x00;
   dfldb = 0x00;
   
   dscnr = 0xff;
   dscng = 0xff;
   dscnb = 0xff;
   
   // init the font structure
   
   FontRec.lfHeight         = 24;
   FontRec.lfWidth          = 0;
   FontRec.lfOrientation    = 0;
   FontRec.lfWeight         = 400;
   FontRec.lfItalic         = 0;
   FontRec.lfUnderline      = 0;
   FontRec.lfStrikeOut      = 0;
   FontRec.lfCharSet        = ANSI_CHARSET;
   FontRec.lfOutPrecision   = OUT_DEFAULT_PRECIS;
   FontRec.lfClipPrecision  = CLIP_DEFAULT_PRECIS;
   FontRec.lfQuality        = DEFAULT_QUALITY;
   FontRec.lfPitchAndFamily = DEFAULT_PITCH;
   FontRec.lfFaceName[0]    = '\0';
   
   /* init all the pens based on the color */
   
   NormalPen.lopnStyle   = PS_INSIDEFRAME;
   NormalPen.lopnWidth.x = width;
   NormalPen.lopnColor   = pcolor;
   
   ErasePen.lopnStyle   = PS_INSIDEFRAME;
   ErasePen.lopnWidth.x = width;
   ErasePen.lopnColor   = scolor;
   
   FloodBrush.lbStyle = BS_SOLID;
   FloodBrush.lbColor = fcolor;
   FloodBrush.lbHatch = HS_VERTICAL;
   
   ScreenBrush.lbStyle = BS_SOLID;
   ScreenBrush.lbColor = scolor;
   ScreenBrush.lbHatch = HS_VERTICAL;
   
   /* build default coords */
   
   x = 000;
   y = 000;
   w = minx(MaxWidth,BitMapWidth);
   h = minx((int)(MaxHeight*ScreenSz),BitMapHeight);
   
   /* convert */
   
   sprintf(dfWinLocStr, "%d,%d,%d,%d", x, y, w, h);
   szWinLocStr[0] = '\0';
   
   // Get last location and size of screen window from WIN.INI file.
   
   GetPrivateProfileString(
   "LOGO",
   "Screen",
   dfWinLocStr,
   szWinLocStr,
   sizeof(szWinLocStr),
   "LOGO.INI");
   
   // Decode location and size of window from profile string.
   
   cp = szWinLocStr;
   x = (int) strtol(cp, &cp, 10);
   cp++;
   y = (int) strtol(cp, &cp, 10);
   cp++;
   w = (int) strtol(cp, &cp, 10);
   cp++;
   h = (int) strtol(cp, &cp, 10);
   
   checkwindow(&x, &y, &w, &h);
   
   w = minx(w,BitMapWidth);
   h = minx(h,BitMapHeight);
   
   // set parameters
   
   ((TMyWindow *)MainWindow)->Attr.X = x;
   ((TMyWindow *)MainWindow)->Attr.Y = y;
   ((TMyWindow *)MainWindow)->Attr.W = w;
   ((TMyWindow *)MainWindow)->Attr.H = h;
   
   ModulehInstance = hInstance;
   
   /* init paths to library and help files based on locaation of .EXE */
   
   MakeHelpPathName(LibPathName,"logolib\\");
   logolib = LibPathName;
   MakeHelpPathName(szHelpFileName,"logo.hlp");
   if (getenv("TEMP") != NULL)
      {
      strcpy(TempPathName,getenv("TEMP"));
      }
   else
      {
      MessageBox(0, "The Environment variable TEMP is not defined\nUsing C:\\ as TEMP","Warning", MB_OK);
      strcpy(TempPathName,"C:");
      }
   i = strlen(TempPathName);
   if (TempPathName[i-1] == '\\') TempPathName[i-1] = '\0';
   strcat(TempPathName,"\\mswlogo.tmp");
   MakeHelpPathName(MCIHelpFileName,"mcistrwh.hlp");
   
   }

void MyMessageScan()
   {
   MSG msg;
   
   /* depending on yield flag check for messages */
   
   if (yield_flag)
      {
      while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
         {
         TranslateMessage(&msg);
         DispatchMessage(&msg);
         }
      }
   }

// Print page (or pages)

void TRulerOut::PrintPage(HDC DC, WORD, POINT, LPRECT, WORD)
   {
   ((TMyWindow *)MainWindowx)->Printit(DC);
   }

// Yes the MAIN is really burried in the Main :-)

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
   {
   int i;
   char *ptr;
   
   if (hPrevInstance) return FALSE;
   
   // parse -h height -w width as being the biymap size
   
   commandarg[0]='\0';
   
   for (ptr=lpCmdLine;*ptr!='\0';ptr++)
      {
      if (*ptr++ == '-')
         {
         switch (*ptr++)
            {
            case 'h':
               {
               i=0;
               for (;((*ptr==' ') || ((*ptr>='0') && (*ptr <='9')));ptr++) commandarg[i++]=*ptr;
               ptr--;
               commandarg[i]='\0';
               sscanf(commandarg,"%d",&BitMapHeight);
               commandarg[0]='\0';
               break;
               }
            case 'w':
               {
               i=0;
               for (;((*ptr==' ') || ((*ptr>='0') && (*ptr <='9')));ptr++) commandarg[i++]=*ptr;
               ptr--;
               commandarg[i]='\0';
               sscanf(commandarg,"%d",&BitMapWidth);
               commandarg[0]='\0';
               break;
               }
            case 'l':
               {
               i=0;
               for (;(*ptr==' ');ptr++);
               for (;(*ptr!='\0');ptr++) commandarg[i++]=*ptr;
               break;
               }
            }
         }
      }
   
   // Get garbage collector stack size from logo.ini
   
   GCMAX = GetPrivateProfileInt("LOGO", "GCStackSize", 8192, "LOGO.INI");
   
   // Get Max Physical line from logo.ini
   
   MAX_PHYS_LINE = GetPrivateProfileInt("LOGO", "MaxPhysLine", 8192, "LOGO.INI");
   
   // Init active area even if off
   
   PrinterAreaXLow  = -BitMapWidth/2;
   PrinterAreaXHigh = +BitMapWidth/2;
   PrinterAreaYLow  = -BitMapHeight/2;
   PrinterAreaYHigh = +BitMapHeight/2;
   
   //   SetMessageQueue(120);
   
   TMyApp MyApp("MswLogo Screen", hInstance, hPrevInstance, lpCmdLine, nCmdShow);
   
   srand(1);
   
   // Set two (historical reasons) handy rectangles of full bitmap
   
   SetRect(&TempRect,0,0,BitMapWidth+1,BitMapHeight+1);
   SetRect(&FullRect,0,0,BitMapWidth+1,BitMapHeight+1);
   
   // malloc and init hash table
   
   hash_table = (NODE **)malloc(sizeof(NODE *)*HASH_LEN);
   
   for (i=0;i<HASH_LEN;i++) hash_table[i] = NIL;
   
   // malloc garbage collector stack
   
   gcstack = (NODE **)malloc(sizeof(NODE *)*GCMAX);
   
   gctop = gcstack;
   
   // init the timer callback array
   
   for (i=0;i<MAX_TIMERS;i++) timer_callback[i] = NULL;
   
   // malloc init the the bitmap cut array
   
   CutBmp = (CUTMAP *)malloc(sizeof(CUTMAP)*MaxBitCuts);
   
   memset(CutBmp,0,sizeof(CUTMAP)*MaxBitCuts);
   
   // init logo kernel
   
   init();
   
   /* get an hourglass cursor */
   
   hCursorWait = LoadCursor(NULL, IDC_WAIT);
   
   // go for it
   
   MyApp.Run();
   
   return MyApp.Status;
   }

void transline(long modex,long fromx,long fromy,long tox,long toy) /*routine*/
   {
   HDC ScreenDC;
   HDC MemDC;
   
   HPEN JunkPen;
   
   fromx= fromx+xoffset;
   fromy=-fromy+yoffset;
   tox  = tox  +xoffset;
   toy  =-toy  +yoffset;
   
   JunkPen = CreatePenIndirect(&NormalPen);
   
   ScreenDC = GetDC(MainHWindow);
   
   // memory
   
   MemDC = CreateCompatibleDC(ScreenDC);
   OldBitmap = (HBITMAP)SelectObject(MemDC, MemoryBitMap);
   if (EnablePalette)
      {
      OldPalette = SelectPalette(MemDC, ThePalette, FALSE);
      RealizePalette(MemDC);
      }
   
   SetROP2(MemDC, modex);
   
   OldPen = (HPEN)SelectObject(MemDC, JunkPen);
   
   MoveTo(MemDC,fromx,fromy);
   
   LineTo(MemDC,tox,toy);
   
   if (EnablePalette) SelectPalette(MemDC, OldPalette, FALSE);
   SelectObject(MemDC, OldPen);
   SelectObject(MemDC, OldBitmap);
   DeleteDC(MemDC);
   
   // screen
   
   if (zoom_flag)
      {
      SetMapMode(ScreenDC, MM_ANISOTROPIC);
      SetWindowOrg(ScreenDC, 0, 0);
      SetWindowExt(ScreenDC, BitMapWidth, BitMapHeight);
      SetViewportOrg(ScreenDC, 0, 0);
      SetViewportExt(ScreenDC, (int)(BitMapWidth*the_zoom), (int)(BitMapHeight*the_zoom));
      }
   
   //   SetCapture(MainHWindow);
   SetROP2(ScreenDC, modex);
   
   if (EnablePalette)
      {
      OldPalette = SelectPalette(ScreenDC, ThePalette, FALSE);
      RealizePalette(ScreenDC);
      }
   
   OldPen = (HPEN)SelectObject(ScreenDC, JunkPen);
   
   MoveTo(ScreenDC,
   fromx-((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom,
   fromy-((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom);
   
   LineTo(ScreenDC,
   tox  -((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom,
   toy  -((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom);
   
   if (EnablePalette) SelectPalette(ScreenDC, OldPalette, FALSE);
   SelectObject(ScreenDC, OldPen);
   
   DeleteObject(JunkPen);
   //   ReleaseCapture();
   ReleaseDC(MainHWindow, ScreenDC);
   }

void translineDC(HDC ScreenDC, long modex,long fromx,long fromy,long tox,long toy) /*routine*/
   {
   HDC MemDC;
   HPEN JunkPen;
   
   fromx= fromx+xoffset;
   fromy=-fromy+yoffset;
   tox  = tox  +xoffset;
   toy  =-toy  +yoffset;
   
   JunkPen = CreatePenIndirect(&NormalPen);
   
   // memory
   
   MemDC = CreateCompatibleDC(ScreenDC);
   OldBitmap = (HBITMAP)SelectObject(MemDC, MemoryBitMap);
   
   SetROP2(MemDC, modex);
   
   OldPen = (HPEN)SelectObject(MemDC, JunkPen);
   
   MoveTo(MemDC,fromx,fromy);
   
   LineTo(MemDC,tox,toy);
   
   SelectObject(MemDC, OldPen);
   SelectObject(MemDC, OldBitmap);
   DeleteDC(MemDC);
   
   // screen
   
   SetROP2(ScreenDC, modex);
   
   OldPen = (HPEN)SelectObject(ScreenDC, JunkPen);
   
   MoveTo(ScreenDC,
   fromx-((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom,
   fromy-((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom);
   
   LineTo(ScreenDC,
   tox  -((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom,
   toy  -((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom);
   
   SelectObject(ScreenDC, OldPen);
   
   DeleteObject(JunkPen);
   }

void eraseline(long modex,long fromx,long fromy,long tox,long toy) /*routine*/
   {
   HDC ScreenDC;
   HDC MemDC;
   HPEN JunkPen;
   
   fromx= fromx+xoffset;
   fromy=-fromy+yoffset;
   tox  = tox  +xoffset;
   toy  =-toy  +yoffset;
   
   JunkPen = CreatePenIndirect(&ErasePen);
   
   ScreenDC = GetDC(MainHWindow);
   
   // memory
   
   MemDC = CreateCompatibleDC(ScreenDC);
   OldBitmap = (HBITMAP)SelectObject(MemDC, MemoryBitMap);
   
   SetROP2(MemDC, modex);
   
   OldPen = (HPEN)SelectObject(MemDC, JunkPen);
   
   MoveTo(MemDC,fromx,fromy);
   
   LineTo(MemDC,tox,toy);
   
   SelectObject(MemDC, OldPen);
   SelectObject(MemDC, OldBitmap);
   DeleteDC(MemDC);
   
   // screen
   
   if (zoom_flag)
      {
      SetMapMode(ScreenDC, MM_ANISOTROPIC);
      SetWindowOrg(ScreenDC, 0, 0);
      SetWindowExt(ScreenDC, BitMapWidth, BitMapHeight);
      SetViewportOrg(ScreenDC, 0, 0);
      SetViewportExt(ScreenDC, (int)(BitMapWidth*the_zoom), (int)(BitMapHeight*the_zoom));
      }
   
   //   SetCapture(MainHWindow);
   SetROP2(ScreenDC, modex);
   
   OldPen = (HPEN)SelectObject(ScreenDC, JunkPen);
   
   MoveTo(ScreenDC,
   fromx-((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom,
   fromy-((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom);
   
   LineTo(ScreenDC,
   tox  -((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom,
   toy  -((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom);
   
   SelectObject(ScreenDC, OldPen);
   
   DeleteObject(JunkPen);
   //   ReleaseCapture();
   ReleaseDC(MainHWindow, ScreenDC);
   }

void ibmturt(long hide) /*routine*/
/* nonzero to erase turtle */
   {
   
   HDC     ScreenDC;
   
   NUMBER angle;
   NUMBER ang;
   
   long j;
   long oldx;
   long oldy;
   long newx;
   long newy;
   long fromx;
   long fromy;
   long tox;
   long toy;
   
   hide = hide;
   
   newx = 0.0;
   newy = 0.0;
   
   ScreenDC = GetDC(MainHWindow);
   
   //   SetCapture(MainHWindow);
   SetROP2(ScreenDC, R2_NOT);
   
   OldPen = (HPEN)SelectObject(ScreenDC, CreatePen(PS_INSIDEFRAME, 1, scolor));
   
   for (j=0;j<4;j++)
      {
      switch (j)
         {
         case 0:ang = -90.0;break;
         case 1:ang =   0.0;break;
         case 2:ang =  90.0;break;
         case 3:ang = -90.0;break;
         }
      oldx = newx;
      oldy = newy;
      angle = (turtle_heading+ang)*RADCVT;
      
      newx = (long)turtle_x + (long)(15.0*sin(angle));
      newy = (long)turtle_y + (long)(15.0*cos(angle));
      if (j != 0)
         {
         fromx=          oldx+xoffset;
         fromy=         -oldy+yoffset;
         tox  =          newx+xoffset;
         toy  =         -newy+yoffset;
         
         MoveTo(ScreenDC,
         (fromx-((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom)*the_zoom,
         (fromy-((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom)*the_zoom);
         
         LineTo(ScreenDC,
         (tox  -((TMyWindow *)MainWindowx)->Scroller->XPos/the_zoom)*the_zoom,
         (toy  -((TMyWindow *)MainWindowx)->Scroller->YPos/the_zoom)*the_zoom);
         
         TurtlePoints[j-1].from.x = fromx;
         TurtlePoints[j-1].from.y = fromy;
         TurtlePoints[j-1].to.x = tox;
         TurtlePoints[j-1].to.y = toy;
         }
      }
   
   DeleteObject(SelectObject(ScreenDC, OldPen));
   //   ReleaseCapture();
   ReleaseDC(MainHWindow, ScreenDC);
   
   }

void ibmfrom(NUMBER x,NUMBER y) /*routine*/
   {
   ibmoldx = x;
   ibmoldy = y;
   }

void ibmto(NUMBER x,NUMBER y) /*routine*/
   {
   if (pen_vis == 0)
      {
      if (in_erase_mode)
         {
         eraseline(R2_COPYPEN,(long)ibmoldx,(long)ibmoldy,(long)x,(long)y);
         }
      else if (current_write_mode==XOR_PUT)
         {
         transline(R2_NOT,(long)ibmoldx,(long)ibmoldy,(long)x,(long)y);
         }
      else
         {
         transline(R2_COPYPEN,(long)ibmoldx,(long)ibmoldy,(long)x,(long)y);
         }  
      }
   }

void MakeHelpPathName(char *szFileName, char *TheFileName)
   {
   char *  pcFileName;
   int     nFileNameLen;
   
   nFileNameLen = GetModuleFileName(ModulehInstance,szFileName,EXE_NAME_MAX_SIZE);
   pcFileName = szFileName + nFileNameLen;
   
   while (pcFileName > szFileName)
      {
      if (*pcFileName == '\\' || *pcFileName == ':')
         {
         *(++pcFileName) = '\0';
         break;
         }
      nFileNameLen--;
      pcFileName--;
      }
   
   if ((nFileNameLen+13) < EXE_NAME_MAX_SIZE)
      {
      lstrcat(szFileName, TheFileName);
      }
   else
      {
      lstrcat(szFileName, "?");
      }
   
   return;
   }

BOOL FAR PASCAL About(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
   {
   switch (message)
      {
      case WM_INITDIALOG:
      return (TRUE);
      
      case WM_COMMAND:
      if (wParam == IDOK)
         {
         EndDialog(hDlg, TRUE);
         return (TRUE);
         }
      break;
      }
   
   return (FALSE);
   }

/* File edit Window members */

TMyFileWindow::TMyFileWindow(PTWindowsObject AParent, LPSTR ATitle,
LPSTR AFileName, NODE *args) : TxFileWindow(AParent, ATitle, AFileName)
   {
   args_list = args;
   
   AssignMenu("FileCommands");
   }

TMyFileWindow::~TMyFileWindow()
   {
   GlobalFree(hEditHeap);
   }

void TMyFileWindow::CMExit(RTMessage Msg)
   { 
   
   /* here on FILE-EXIT in editor */
   
   //   SendMessage(Editor->HWindow, EM_FMTLINES, 0, 0);
   //   SendMessage(HWindow, EM_FMTLINES, 0, 0);
   SendMessage(HWindow, WM_CLOSE, 0, 0);
   }

void TMyFileWindow::CMHelpEdit(RTMessage Msg)
   { 
   do_help("Editor");
   }

void TMyFileWindow::CMHelpEditTopic(RTMessage Msg)
   { 
   ContextHelp();
   }

void TMyFileWindow::ContextHelp(void)
   {
   char theText[80];
   char *ptr;
   int start, end;
   int i;
   
   // get the keyword selected
   
   Editor->GetSelection(start,end);
   Editor->GetSubText( (LPSTR) theText, start, end );
   
   // clean up line before passing to help
   
   i=strlen(theText)-1;
   while ((theText[i]==' ') && (i > 0)) theText[i--]='\0';
   
   i=0;
   while ((theText[i]==' ') && (i < 80)) i++;
   
   ptr = theText+i;
   
   do_help(ptr);
   }

void TMyFileWindow::CMTest(RTMessage Msg)
   {
   char *theText;
   char *ptr;
   char *ptr2;
   char *ptr3;
   int start, end;
   int more;
   
   // get the code selected
   
   Editor->GetSelection(start,end);
   theText = (char *)malloc(abs(end-start)+1);
   Editor->GetSubText( (LPSTR) theText, start, end );
   ptr = theText;
   
   // strip comments
   
   more = 1;
   while (more)
      {
      ptr2 = strchr(ptr,';');
      
      if (ptr2 != NULL)
         {
         *ptr2 = ' ';
         while ((*ptr2 != 10) && (*ptr2 != 13) && (*ptr2 != '~') && (*ptr2 != 10))
            {
            *ptr2++ = ' ';
            } 
         }
      else
         {
         more = 0;
         }
      }
   
   // paste continuation
   
   more = 1;
   while (more)
      {
      ptr2 = strchr(ptr,'~');
      
      if (ptr2 != NULL)
         {
         *ptr2 = ' ';
         ptr3 = strchr(ptr2,'\n');
         if (ptr3 != NULL)
            {
            *ptr3 = ' ';
            *(ptr3-1) = ' ';
            }
         }
      else
         {
         more = 0;
         }
      }
   
   // for each real line left execute it
   
   more = 1;
   while (more)
      {
      ptr2 = strchr(ptr,'\n');
      
      if (ptr2 != NULL)
         {
         *ptr2 = '\0';
         *(ptr2-1) = '\0';
         }
      
      putcombobox(ptr);
      do_execution(ptr);
      
      if (ptr2 != NULL)
         {
         ptr = ptr2+1;
         }
      else
         {
         more = 0;
         }
      }
   
   free(theText);
   
   }

void TMyFileWindow::DefWndProc( RTMessage msg )
   {
   int i;
   RECT  wrect;
   char  szWinLocStr[WININISIZ];
   int   w, h;
   int   realsave;
   callthing *callevent;
   
   // if right button do context sensitive help
   
   if (msg.WParam == WM_RBUTTONDOWN)
      {
      if (args_list != NULL) ContextHelp();
      }
   
   // if closing do the right thing
   
   if (msg.Message == WM_DESTROY)
      {
      
      // if args_list specified no user callabled editor
      
      if (args_list != NULL)
         {
         realsave = lendedit();
         }
      
      // else execute callback for user callable editor
      
      else
         {
         callevent = new callthing;
         
         callevent->func = edit_editexit;
         callevent->kind = 3;
         
         calllists.insert(callevent,3);
         }
      
      // Get location and size of our window on the screen so we can
      // come back up in the same spot next time we are invoked.
      
      if (!IsIconic(HWindow))
         {
         GetWindowRect(HWindow, (LPRECT) &wrect);
         w = wrect.right - wrect.left;
         h = wrect.bottom - wrect.top;
         
         // Make a string with our window location and size.
         
         sprintf(szWinLocStr, "%d,%d,%d,%d", wrect.left, wrect.top, w, h);
         
         // Save in WIN.INI file.
         
         WritePrivateProfileString(
         "LOGO",
         "Editor",
         szWinLocStr,
         "LOGO.INI");
         }
      
      if (args_list != NULL)
         {
         
         // an "endedit" has already occured check for error
         
         error_happen = 0;
         
         for (i=0;i<1;i++)
            {
            if (stopping_flag == THROWING)
               {
               if (compare_node(throw_node, Error, TRUE) == 0)
                  {
                  err_print();
                  error_happen = 1;
                  }
               else if (compare_node(throw_node, System, TRUE) == 0) break;
               else if (compare_node(throw_node, Toplevel, TRUE) != 0)
                  {
                  err_logo(NO_CATCH_TAG, throw_node);
                  err_print();
                  error_happen = 1;
                  }
               stopping_flag = RUN;
               }
            if (stopping_flag == STOP || stopping_flag == OUTPUT)
               {
               print_node(stdout, make_static_strnode("You must be in a procedure to use OUTPUT or STOP.\n"));
               stopping_flag = RUN;
               }
            }
         
         // if error the ask user to reedit
         
         if (error_happen)
            {
            if (MessageBox(MainHWindow, "Your edit cannot be loaded\nReturn to EDIT?","Reload error", MB_YESNO | MB_ICONQUESTION) == IDYES)
               {
               //          ledit(NULL);
               if (TMyWindow_MyPopupEdit(TempPathName,args_list))
                  {
                  MessageBox(MainHWindow, "Cannot restart editor","Fatal", MB_OK | MB_ICONQUESTION);
                  }
               else
                  {
                  unlink(TempPathName);
                  IsDirty = 1;
                  }
               }
            }
         else
            {
            // check for quit before erasing
            
            if (realsave)
               {
               lerase(args_list);
               
               // Since we erased we must load again, but no errors
               
               lendedit();
               }
            
            // free up args_list
            
            args_list = reref(args_list, NIL);
            
            unlink(TempPathName);
            }
         SetFocus(EditHWindow);
         }
      }
   
   TxFileWindow::DefWndProc( msg );
   }

/* Editbox members */

TMyEditboxWindow::TMyEditboxWindow(PTWindowsObject AParent, int AId, WORD Alen)
: TEdit(AParent, AId, Alen)
   {
   }

TMyEditboxWindow::~TMyEditboxWindow()
   {
   }

void TMyEditboxWindow::WMGetDlgCode( RTMessage msg )
   {
   TEdit::DefWndProc( msg );
   msg.Result |= DLGC_WANTARROWS;
   }

void TMyEditboxWindow::WMKeyDown(RTMessage Msg)
   { 
   
   // if up/down arrow keys then focus to list box
   
   if ((Msg.WParam == VK_UP) || (Msg.WParam == VK_DOWN))
      {
      SetFocus(ListHWindow);
      }
   else
      {
      DefWndProc( Msg );
      }
   }

/* Listbox members */

TMyListboxWindow::TMyListboxWindow(PTWindowsObject AParent, int AId)
: TListBox(AParent, AId)
   {
   }

TMyListboxWindow::~TMyListboxWindow()
   {
   }

void TMyListboxWindow::WMGetDlgCode( RTMessage msg )
   {
   TListBox::DefWndProc( msg );
   msg.Result |= DLGC_WANTARROWS;
   }

void TMyListboxWindow::WMKeyDown(RTMessage Msg)
   { 
   
   // if left/right arrow keys then focus to edit box
   
   if ((Msg.WParam == VK_LEFT) || (Msg.WParam == VK_RIGHT))
      {
      SetFocus(EditHWindow);
      }
   else
      {
      DefWndProc( Msg );
      }
   }

BOOL TMyFileWindow::CanClose()
   { 
   char S[MAXPATH+28];
   int Rslt;
   
   // if changed better ask user
   
   if ( Editor->IsModified() )
      {
      _fstrcpy(S, "Contents have changed.  Save?");
      
      Rslt = MessageBox(HWindow, S, "Contents Changed", MB_YESNOCANCEL | MB_ICONQUESTION);
      if ( Rslt == IDYES )
      return Save();
      else
      return Rslt != IDCANCEL;
      }
   return TRUE;
   }
