/*****************************************************************
Module name: SetupDlg.C
Programmer : Jeffrey M. Richter.
*****************************************************************/

#include <windows.h>
#include <windowsx.h>
#include <Ver.h>
#include <StdLib.h>
#include "Meter.H"
#include "Setup.h"
#include "SetupInf.h"

void PrepareDialogBox (HWND hWnd, BOOL fBeep) {
   RECT rc; char szBuf[MAXAPPNAME];
   GetWindowRect(hWnd, &rc);
   SetWindowPos(hWnd, NULL,
      (GetSystemMetrics(SM_CXSCREEN) - (rc.right - rc.left)) / 2,
      (GetSystemMetrics(SM_CYSCREEN) - (rc.bottom - rc.top)) / 3,
      0, 0, SWP_NOSIZE | SWP_NOZORDER);

   // Place the correct title in the dialog box caption
   _SetupInfo.GetAppName(szBuf);
   SetWindowText(hWnd, szBuf);
   if (fBeep) MessageBeep(0);
}


WORD WINAPI GetCheckedRadioBtn (HWND hDlg, WORD wStartId,
   WORD wEndId) {
   for (; wStartId <= wEndId; wStartId++) {
      if (IsDlgButtonChecked(hDlg, wStartId)) return(wStartId);
   }
   return(-1);
}

// ***************************************************************
// Setup's initializing screen.
#pragma argsused
BOOL CALLBACK InitDlgProc (HWND hDlg, UINT uMsg,
   WPARAM wParam, LPARAM lParam) {

   BOOL fProcessed = TRUE;

   switch (uMsg) {
      case WM_INITDIALOG:
         PrepareDialogBox(hDlg, FALSE);
         UpdateWindow(hDlg);
         break;

      default:
         fProcessed = FALSE;
         break;
   }
   return(fProcessed);
}


// ***************************************************************
// Initial sign on screen.  Asks user for destination directory.
BOOL CALLBACK WelcomeDlgProc (HWND hDlg, UINT uMsg,
   WPARAM wParam, LPARAM lParam) {

   BOOL fProcessed = TRUE;
   char szBuf[MAXDIR];
   OFSTRUCT ofStruct;

   switch (uMsg) {
      case WM_INITDIALOG:
         PrepareDialogBox(hDlg, FALSE);

         _SetupInfo.GetDefaultDstDir(szBuf);
         SetDlgItemText(hDlg, ID_DESTPATH, szBuf);
         Edit_LimitText(GetDlgItem(hDlg, ID_DESTPATH),
            sizeof(szBuf));
         break;

      case WM_COMMAND:
         switch (wParam) {
            case ID_DESTPATH:
               EnableWindow(GetDlgItem(hDlg, IDOK),
                  Edit_LineLength(LOWORD(lParam), 0) > 0);
               break;

            case IDOK:
               GetDlgItemText(hDlg, ID_DESTPATH,
                  szBuf, sizeof(szBuf));
               OpenFile(szBuf, &ofStruct, OF_PARSE);
               lstrcpy(_szDstDir, (LPSTR) ofStruct.szPathName);
               // Do IDCANCEL case

            case IDCANCEL:
               EndDialog(hDlg, wParam);
               break;
         }
         break;

      default:
         fProcessed = FALSE;
         break;
   }
   return(fProcessed);
}


// ***************************************************************
// Displays copying status.  Allows user to cancel Setup.
#pragma argsused
BOOL CALLBACK StatusDlgProc (HWND hDlg, UINT uMsg,
   WPARAM wParam, LPARAM lParam) {

   BOOL fProcessed = TRUE;
   int nResult;

   switch (uMsg) {
      case WM_INITDIALOG:
         PrepareDialogBox(hDlg, FALSE);
         break;

      case WM_SHOWWINDOW:
         fProcessed = FALSE;
         if (!wParam) break;
         EnableWindow(GetDlgItem(hDlg, IDCANCEL), TRUE);
         SetDlgItemText(hDlg, ID_STATLINE1, "");
         SetDlgItemText(hDlg, ID_STATLINE2, "");
         SendDlgItemMessage(hDlg, ID_METER,
            MM_SETPARTSCOMPLETE, 0, 0);
         SendDlgItemMessage(hDlg, ID_METER,
            MM_SETPARTSINJOB, 0, 0);
         break;

      case WM_COMMAND:
         switch (wParam) {
            case IDOK:
               // User presses ENTER.  DO IDCANCEL case.

            case IDCANCEL:
               nResult = MsgBox(_hInstance, hDlg, IDS_QUERYABORT,
                  _szAppName, MB_ICONQUESTION | MB_YESNO);
               if (nResult == IDYES)
                  EnableWindow(GetDlgItem(hDlg, IDCANCEL), FALSE);
               break;
         }
         break;

      default:
         fProcessed = FALSE;
         break;
   }
   return(fProcessed);
}

// ***************************************************************
// Prompt's user to insert a different diskette.
BOOL CALLBACK InsertDiskDlgProc (HWND hDlg, UINT uMsg,
   WPARAM wParam, LPARAM lParam) {

   BOOL fProcessed = TRUE;
   int nResult;

   switch (uMsg) {
      case WM_INITDIALOG:
         PrepareDialogBox(hDlg, TRUE);

         // lParam is address of diskette description.
         // Throw away the data segment and use the new one.
         // This is in case the data segment has moved.
         SetDlgItemText(hDlg, ID_DISKNAME, (LPSTR) lParam);
         SetDlgItemText(hDlg, ID_SRCPATH, _szSrcDir);
         Edit_LimitText(GetDlgItem(hDlg, ID_SRCPATH),
            sizeof(_szSrcDir));
         break;

      case WM_COMMAND:
         switch (wParam) {
            case ID_SRCPATH:
               EnableWindow(GetDlgItem(hDlg, IDOK),
                  Edit_LineLength(LOWORD(lParam), 0) > 0);
               break;

            case IDOK:
               GetDlgItemText(hDlg, ID_SRCPATH,
                  _szSrcDir, sizeof(_szSrcDir));
               EndDialog(hDlg, wParam);
               break;

            case IDCANCEL:
               nResult = MsgBox(_hInstance, hDlg, IDS_QUERYABORT,
                  _szAppName, MB_ICONQUESTION | MB_YESNO);
               if (nResult == IDNO) break;
               EndDialog(hDlg, wParam);
               break;
         }
         break;

      default:
         fProcessed = FALSE;
         break;
   }
   return(fProcessed);
}


// ***************************************************************
BOOL CALLBACK CurNEDestDlgProc (HWND hDlg, UINT uMsg,
   WPARAM wParam, LPARAM lParam) {

   BOOL fProcessed = TRUE;
   LPCURNEDESTSTRUCT lpCurNEDestStruct;
   UINT x;
   int nResult;

   switch (uMsg) {
      case WM_INITDIALOG:
         PrepareDialogBox(hDlg, TRUE);

         lpCurNEDestStruct = (LPCURNEDESTSTRUCT) lParam;
         SetDlgItemText(hDlg, ID_DSTFILENAME,
            lpCurNEDestStruct->szDstFileName);
         SetDlgItemText(hDlg, ID_DSTDIR,
            lpCurNEDestStruct->szDstDir);
         SetDlgItemText(hDlg, ID_CURDIR,
            lpCurNEDestStruct->szCurDir);
         CheckRadioButton(hDlg, ID_INSTALLANDDELETE,
            ID_ABORTINSTALL, ID_INSTALLANDDELETE);
         break;

      case WM_COMMAND:
         if (wParam != IDOK) break;
         x = GetCheckedRadioBtn(hDlg,
            ID_INSTALLANDDELETE, ID_ABORTINSTALL);
         if (x == ID_ABORTINSTALL) {
            nResult = MsgBox(_hInstance, hDlg, IDS_QUERYABORT,
               _szAppName, MB_ICONQUESTION | MB_YESNO);
            if (nResult == IDNO) break;
         }
         EndDialog(hDlg, x);
         break;

      default: fProcessed = FALSE; break;
   }
   return(fProcessed);
}


// ***************************************************************
BOOL CALLBACK FileInUseDlgProc (HWND hDlg, UINT uMsg,
   WPARAM wParam, LPARAM lParam) {

   BOOL fProcessed = TRUE;
   UINT x;
   int nResult;

   switch (uMsg) {
      case WM_INITDIALOG:
         PrepareDialogBox(hDlg, TRUE);
         SetDlgItemText(hDlg, ID_FILENAMEINUSE, (LPSTR) lParam);
         CheckRadioButton(hDlg, IDABORT, IDIGNORE, IDRETRY);
         break;

      case WM_COMMAND:
         if (wParam != IDOK) break;
         x = GetCheckedRadioBtn(hDlg, IDABORT, IDIGNORE);
         if (x == IDABORT) {
            nResult = MsgBox(_hInstance, hDlg, IDS_QUERYABORT,
               _szAppName, MB_ICONQUESTION | MB_YESNO);
            if (nResult == IDNO) break;
         }
         EndDialog(hDlg, x);
         break;

      default: fProcessed = FALSE; break;
   }
   return(fProcessed);
}



// ***************************************************************
char _szUnknown[] = "Unknown";

enum VERFILEFIXFIELD {
   VF_FF_FILEVER, VF_FF_PRODVER, VF_FF_FILEFLAGS,
   VF_FF_OPSYS, VF_FF_FILETYPE
};

char *szVerFileFixedField[] = {
   "File version",
   "Product version",
   "File flags",
   "Operating sys",
   "File type"
};



enum VERFILEVARFIELD {
   VF_VF_COMMENTS, VF_VF_COMPANY, VF_VF_DESC, VF_VF_FILEVER,
   VF_VF_INTERNALNAME, VF_VF_COPYRIGHT, VF_VF_TRADEMARKS,
   VF_VF_ORIGNAME, VF_VF_PRVTBLD, VF_VF_PRODNAME, VF_VF_PRODVER,
   VF_VF_SPECIALBLD
};

char *szVerFileVarField[][2] = {
   { "Comments",        "Comments"           },
   { "Company",         "CompanyName"        },
   { "Description",     "FileDescription"    },
   { "File version",    "FileVersion"        },
   { "Internal name",   "InternalName"       },
   { "Copyright",       "LegalCopyright"     },
   { "Trademarks",      "LegalTrademarks"    },
   { "Original name",   "OriginalFilename"   },
   { "Private build",   "PrivateBuild"       },
   { "Product name",    "ProductName"        },
   { "Product version", "ProductVersion"     },
   { "Special build",   "SpecialBuild"       }
};


static BOOL NEAR GetVerInfo (LPCSTR szPathname, HWND hwndLB) {
   LPSTR szFileType, szFileSubtype, p, q;
   void FAR *lpVerInfo;
   VS_FIXEDFILEINFO FAR *lpVSFixedFileInfo;
   UINT uLen, x, uMaxFieldLen = 0;
   DWORD dwVerInfoSize, dwHandle;
   HGLOBAL hGlbl;
   char szBuf[100], szVXDID[10];
   HDC hDC;
   HFONT hFont;

   ListBox_ResetContent(hwndLB);
   dwVerInfoSize = _GetFileVersionInfoSize(szPathname, &dwHandle);
   if (dwVerInfoSize == 0) // No version info exists
      return(FALSE);

   hGlbl = GlobalAlloc(GMEM_MOVEABLE, dwVerInfoSize);
   if (hGlbl == NULL)
      return(FALSE);

   lpVerInfo = GlobalLock(hGlbl);
   x = _GetFileVersionInfo(szPathname, dwHandle,
      dwVerInfoSize, lpVerInfo);
   if (x == 0) {
      // Couldn't get the version info for some reason.
      GlobalUnlock(hGlbl);
      GlobalFree(hGlbl);
      return(FALSE);
   }

   // Find the address of the VS_FIXEDFILEINFO structure
   if (!_VerQueryValue(lpVerInfo, "\\",
       (void FAR * FAR *) &lpVSFixedFileInfo, &uLen) ||
       (uLen == 0)) {
      // VS_FIXEDFILEINFO structure is not available
      ListBox_AddString(hwndLB,
         "Version information is not available.");
      GlobalUnlock(hGlbl);
      GlobalFree(hGlbl);
      return(FALSE);
   }

   SetWindowRedraw(hwndLB, FALSE);
   hDC = GetDC(hwndLB);
   hFont = GetWindowFont(hwndLB);
   if (hFont != NULL)
      SelectObject(hDC, hFont);

   // Cycle through all of the members in VS_FIXEDFILEINFO
   for (x = 0; x < ARRAY_LEN(szVerFileFixedField); x++) {
      p = szBuf +
         wsprintf(szBuf, "%s:\t", szVerFileFixedField[x]);

      uMaxFieldLen = max(uMaxFieldLen, LOWORD(
         GetTextExtent(hDC, szBuf, (int) (p - szBuf) - 1)));

      switch (x) {
      case VF_FF_FILEVER:
         wsprintf(p, "%d.%d.%d.%d",
            HIWORD(lpVSFixedFileInfo->dwFileVersionMS),
            LOWORD(lpVSFixedFileInfo->dwFileVersionMS),
            HIWORD(lpVSFixedFileInfo->dwFileVersionLS),
            LOWORD(lpVSFixedFileInfo->dwFileVersionLS));
         break;

      case VF_FF_PRODVER:
         wsprintf(p, "%d.%d.%d.%d",
            HIWORD(lpVSFixedFileInfo->dwProductVersionMS),
            LOWORD(lpVSFixedFileInfo->dwProductVersionMS),
            HIWORD(lpVSFixedFileInfo->dwProductVersionLS),
            LOWORD(lpVSFixedFileInfo->dwProductVersionLS));
         break;

      case VF_FF_FILEFLAGS:
         DWORD dwNum = lpVSFixedFileInfo->dwFileFlags;
         if (dwNum & VS_FF_DEBUG)
            lstrcat(p, "Debug ");
         if (dwNum & VS_FF_PRERELEASE)
            lstrcat(p, "Pre-release ");
         if (dwNum & VS_FF_PATCHED)
            lstrcat(p, "Patched ");
         if (dwNum & VS_FF_PRIVATEBUILD)
            lstrcat(p, "Private ");
         if (dwNum & VS_FF_INFOINFERRED)
            lstrcat(p, "Info ");
         if (dwNum & VS_FF_SPECIALBUILD)
            lstrcat(p, "Special ");
         if (dwNum == 0)
            lstrcat(p, "No flags");
         break;

      case VF_FF_OPSYS:
         switch (lpVSFixedFileInfo->dwFileOS) {
            case VOS_DOS:
               q = "DOS"; break;
            case VOS_DOS_WINDOWS16:
               q = "Windows 3.0 or later under DOS"; break;
            case VOS_DOS_WINDOWS32:
               q = "Windows-32 under DOS"; break;
            case VOS_OS216:
               q = "OS/2-16"; break;
            case VOS_OS216_PM16:
               q = "OS/2-16 PM-16"; break;
            case VOS_OS232:
               q = "OS/2-32"; break;
            case VOS_OS232_PM32:
               q = "OS/2-32 PM-32"; break;
            case VOS_NT:
               q = "Windows NT"; break;
            case VOS_NT_WINDOWS32:
               q = "Windows-32 under Windows-NT"; break;
            case VOS_UNKNOWN:
               default: q = _szUnknown; break;
         }
         lstrcat(p, q); break;

      case VF_FF_FILETYPE:
         szFileSubtype = NULL;
         switch (lpVSFixedFileInfo->dwFileType) {
         case VFT_UNKNOWN: default:
            szFileType = _szUnknown; break;
         case VFT_APP:
            szFileType = "Application"; break;
         case VFT_DLL:
            szFileType = "Dynamic-link library"; break;
         case VFT_DRV:
            szFileType = "Device driver";
            switch (lpVSFixedFileInfo->dwFileSubtype) {
            case VFT2_UNKNOWN:
               default: szFileSubtype = _szUnknown; break;
            case VFT2_DRV_PRINTER:
               szFileSubtype = "Printer"; break;
            case VFT2_DRV_KEYBOARD:
               szFileSubtype = "Keyboard"; break;
            case VFT2_DRV_LANGUAGE:
               szFileSubtype = "Language"; break;
            case VFT2_DRV_DISPLAY:
               szFileSubtype = "Display"; break;
            case VFT2_DRV_MOUSE:
               szFileSubtype = "Mouse"; break;
            case VFT2_DRV_NETWORK:
               szFileSubtype = "Network"; break;
            case VFT2_DRV_SYSTEM:
               szFileSubtype = "System"; break;
            case VFT2_DRV_INSTALLABLE:
               szFileSubtype = "Installable"; break;
            case VFT2_DRV_SOUND:
               szFileSubtype = "Sound"; break;
            case VFT2_DRV_COMM:
               szFileSubtype = "Communication"; break;
            }
            break;

         case VFT_FONT:
            szFileType = "Font";
            switch (lpVSFixedFileInfo->dwFileSubtype) {
            case VFT2_UNKNOWN: default:
               szFileSubtype = _szUnknown; break;
            case VFT2_FONT_RASTER:
               szFileSubtype = "Raster"; break;
            case VFT2_FONT_VECTOR:
               szFileSubtype = "Vector"; break;
            case VFT2_FONT_TRUETYPE:
               szFileSubtype = "TrueType"; break;
            }
            break;

         case VFT_VXD:
            szFileType = "Virtual device";
            ltoa(lpVSFixedFileInfo->dwFileSubtype,
               szFileSubtype = szVXDID, 10);
            break;

         case VFT_STATIC_LIB:
            szFileType = "Static-link library"; break;
         }  // switch (lpVSFixedFileInfo->dwFileType)

         wsprintf(p, "%s%s%s%s", szFileType,
            ((szFileSubtype == NULL) ? "" : " ("),
            ((szFileSubtype == NULL) ? "" : szFileSubtype),
            ((szFileSubtype == NULL) ? "" : ")"));
      }  // switch
      ListBox_AddString(hwndLB, szBuf);
   }  // for



   // Variable file Version information

   // Use the first translation Langauge-CharSet pair

   _VerQueryValue(lpVerInfo, "\\VarFileInfo\\Translation",
      (VOID FAR * FAR *) &p, &x);

   char szStringName[50];
   DWORD dwTranslation = * ((DWORD FAR *) p);
   WORD wRootLen = wsprintf(szStringName,
      "\\StringFileInfo\\%04x%04x\\",
      LOWORD(dwTranslation), HIWORD(dwTranslation));

   p = szBuf + wsprintf(szBuf, "Language:\t");
   _VerLanguageName(LOWORD(dwTranslation), p,
      (UINT) (sizeof(szBuf) - (p - szBuf)));
   ListBox_AddString(hwndLB, szBuf);

   // Cycle through all of the StringNames
   for (x = 0; x < ARRAY_LEN(szVerFileVarField); x++) {
      p = szBuf +
         wsprintf(szBuf, "%s:\t", szVerFileVarField[x][0]);

      uMaxFieldLen = max(uMaxFieldLen, LOWORD(
         GetTextExtent(hDC, szBuf, (int) (p - szBuf) - 1)));

      lstrcat(szStringName, szVerFileVarField[x][1]);
      WORD wStringLen;
      if (!_VerQueryValue(lpVerInfo, szStringName,
          (VOID FAR * FAR *) &p, (UINT FAR *) &wStringLen) ||
          (wStringLen == 0))
         lstrcat(szBuf, _szUnknown);
      else lstrcat(szBuf, p);
      ListBox_AddString(hwndLB, szBuf);

      // Be sure to reset to 0 so that we can concat
      szStringName[wRootLen] = 0;
   }
   ReleaseDC(hwndLB, hDC);

   RECT rc;
   SetRect(&rc, 4, 8, 0, 0);
   MapDialogRect(GetParent(hwndLB), &rc);
   x = 6 + ((uMaxFieldLen * 4) / rc.left);
   ListBox_SetTabStops(hwndLB, 1, &x);

   ListBox_SetHorizontalExtent(hwndLB,
      2 * GetSystemMetrics(SM_CXSCREEN));
   SetWindowRedraw(hwndLB, TRUE);
   InvalidateRect(hwndLB, NULL, TRUE);

   GlobalUnlock(hGlbl);
   GlobalFree(hGlbl);
   return(TRUE);
}

static LRESULT ListBoxSubclass (HWND hWnd, UINT uMsg,
   WPARAM wParam, LPARAM lParam) {

   if ((uMsg == WM_HSCROLL) || (uMsg == WM_VSCROLL))
      FORWARD_WM_COMMAND(GetParent(hWnd), GetWindowID(hWnd),
         hWnd, LBN_SELCHANGE, PostMessage);

   return(CallWindowProc((FARPROC)
      GetClassLong(hWnd, GCL_WNDPROC), hWnd, uMsg,
      wParam, lParam));
}

BOOL CALLBACK MismatchDlgProc (HWND hDlg, UINT uMsg,
   WPARAM wParam, LPARAM lParam) {

   BOOL fProcessed = TRUE;
   LPMISMATCHSTRUCT lpMismatchStruct;
   char szBuf[100];
   WORD x;
   int nResult;

   switch (uMsg) {
      case WM_INITDIALOG:
         PrepareDialogBox(hDlg, TRUE);

         lpMismatchStruct = (LPMISMATCHSTRUCT) lParam;

         // Tell the user why there is a file conflict
         DWORD dwVIFResult = lpMismatchStruct->dwVIFResult;
         x = 0;
         if (dwVIFResult & VIF_MISMATCH)   x = IDS_MISMATCH;
         if (dwVIFResult & VIF_SRCOLD)     x = IDS_SRCOLD;
         if (dwVIFResult & VIF_DIFFLANG)   x = IDS_DIFFLANG;
         if (dwVIFResult & VIF_DIFFCODEPG) x = IDS_DIFFCODEPG;
         if (dwVIFResult & VIF_DIFFTYPE)   x = IDS_DIFFTYPE;
         LoadString(_hInstance, x, szBuf, sizeof(szBuf));
         SetDlgItemText(hDlg, ID_VERMISMATCHTEXT, szBuf);

         GetVerInfo(lpMismatchStruct->szExistingPath,
            GetDlgItem(hDlg, ID_VERINFOEXISTING));

         GetVerInfo(lpMismatchStruct->szTmpPath,
            GetDlgItem(hDlg, ID_VERINFONEW));

         SubclassWindow(GetDlgItem(hDlg, ID_VERINFOEXISTING),
            ListBoxSubclass);
         SubclassWindow(GetDlgItem(hDlg, ID_VERINFONEW),
            ListBoxSubclass);
         break;

      case WM_COMMAND:
         switch (wParam) {
            case IDABORT:
               nResult = MsgBox(_hInstance, hDlg, IDS_QUERYABORT,
                  _szAppName, MB_ICONQUESTION | MB_YESNO);
               if (nResult == IDNO) break;
               EndDialog(hDlg, wParam); 
               break;

            case IDYES: case IDNO: 
               EndDialog(hDlg, wParam); 
               break;

            case ID_VERINFOEXISTING:
            case ID_VERINFONEW:
               if (HIWORD(lParam) != LBN_SELCHANGE) break;
               HWND hWndOtherLB = GetDlgItem(hDlg, 
                  ((wParam == ID_VERINFONEW)
                  ? ID_VERINFOEXISTING : ID_VERINFONEW));

               x = ListBox_GetCurSel(LOWORD(lParam));
               if (x != ListBox_GetCurSel(hWndOtherLB))
                  ListBox_SetCurSel(hWndOtherLB, x);

               x = ListBox_GetTopIndex(LOWORD(lParam));
               if (x != ListBox_GetTopIndex(hWndOtherLB))
                  ListBox_SetTopIndex(hWndOtherLB, x);
               break;
         }
         break;

      default: fProcessed = FALSE; break;
   }
   return(fProcessed);
}
