/*-----------------------------------------------------------------------*
 * Greg Stevens                                                   6/24/93*
 *                              NNLOADIN.C                               *
 *                                             [file 5 in a series of 6] *
 *                                                                       *
 * This file loads the inputs into the net and feeds the values forward. *
 *                                                                       *
 *-----------------------------------------------------------------------*/
#include "nndisply.c"                   /* links to rest of nn*.c utils  */
#include <math.h>                       /* for the exp() function        */

/* Function Prototypes */
NNETtype UpDateInputAct( PATTERNtype ptn, int p, NNETtype oldn );
NNETtype UpDateLayerAct( NNETtype oldn, int L );

/* Function Definitions */
NNETtype UpDateInputAct( PATTERNtype ptn, int P, NNETtype oldn )
{
   NNETtype n;                          /* for output net                */
   int u;                               /* unit counter (in each pattern)*/

   n = oldn;                            /* transfers current weight      */
                			/* values in the net to be out-  */
                                        /* putted.                       */

   for (u=0;(u<INPUT_LAYER_SIZE);++u)   /*for each node in input layer...*/
    {
      n.unit[0][u].state = ptn.p[P][u]; /* loads each element of the     */
                                        /* input pattern into the input  */
                                        /* layer's activation state      */
    }

   return( n );                         /* return net w/ new input layer */
}


NNETtype UpDateLayerAct( NNETtype oldn, int L )
{
  NNETtype n;                           /* to hold the updated network   */
  int u, v;                             /* unit looping counters         */
  float act;                            /* for holding activation states */

  n = oldn;

  if (L<1)
    {
      printf( "YOU FUCKED UP!" );
      return(n);                       /* if input layer, return ERROR   */
    }

  if (L>=NUMLAYERS)
    {
      printf( "YOU FUCKED UP!" );
      return(n);                       /* if not a layer, return ERROR   */
    }

  for (u=0; (u<NUMNODES[L]); ++u )     /* for each node in the layer...  */
   {
     act = n.unit[L][u].thresh;               /* set act to neg. thresh  */
     for (v=0; (v<NUMNODES[L-1]); ++v)        /* then sum weighted inputs*/
       {
         act += n.unit[L-1][v].state * n.unit[L][u].weights[v];
       }

     if (n.unit[L][u].actfn==0)               /* if its linear...        */
       {
         n.unit[L][u].state = act;
       }
     else if (n.unit[L][u].actfn==1)          /* if its logistic...      */
       {
         n.unit[L][u].state = 1.0 / (1.0 + exp( 0.0 - act ));
       }
   }

   return( n );
}
