PROGRAM DelayTest;
USES WinCrt, WinTypes, WinProcs;

  PROCEDURE Delay(T : LongInt);
    {T is time in ms}
  VAR Start : LongInt;
  BEGIN
    Start := GetTickCount;
    WHILE GetTickCount - Start <= T DO;
  END;

  PROCEDURE Gasp;
  VAR Msg : TMsg;
  BEGIN
    WHILE PeekMessage(Msg, 0, 0, 0, pm_Remove) DO
      IF Msg.Message = wm_Quit THEN Halt
      ELSE
        BEGIN
          TranslateMessage(Msg);
          DispatchMessage(Msg);
        END;
  END;

  PROCEDURE DelayOk(T : LongInt);
    {T is time in ms}
  VAR Start : LongInt;
  BEGIN
    Start := GetTickCount;
    WHILE GetTickCount - Start <= T DO Gasp;
  END;

BEGIN
  WriteLn('When you press Enter, a ten-second delay will');
  WriteLn('begin.  Try to switch to another window, or ');
  WriteLn('move THIS window.  You can''t!');
  ReadLn;
  WriteLn('Delay beginning...');
  Delay(10000);
  WriteLn;
  WriteLn('When you press Enter again, another ten-second');
  WriteLn('delay will begin, but this one includes code');
  WriteLn('to let Windows continue processing messages.');
  WriteLn('Try to move this window, or switch to another');
  WriteLn('window - this time you CAN.');
  ReadLn;
  WriteLn('Delay beginning...');
  DelayOk(10000);
  WriteLn('Demonstration complete.');
END.