/*
    TRYTD.C:    Demo of TD.C Time & Date Formatting Functions

    Ray Duncan, December 1987

    Compile:    C>CL TRYTD.C TD.C  <Enter>

*/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

union REGS regs;

extern char * systcvt(int);         /* function prototypes */
extern char * sysdcvt(int);
extern char * dirtcvt(int, unsigned);
extern char * dirdcvt(int, unsigned);
extern char * tcvt(int, int, int, int, int);
extern char * dcvt(int, int, int, int);

main()
{   
    char *tstr;                     /* pointer to formatted time */
    char *dstr;                     /* pointer to formatted date */
    unsigned dirtime,dirdate;

    tstr = systcvt(11);             /* format current time */
    dstr = sysdcvt(8);              /* format current date */

                                    /* display time & date */
    printf("\nThe current time and date are: %s %s\n", tstr, dstr);

    regs.x.ax = 0x3d00;             /* open TRYTD.EXE file */
    (char * ) regs.x.dx = "TRYTD.EXE";
    int86(0x21, &regs, &regs);

    if(regs.x.cflag)                /* exit if open failed */
    {   puts("Can't open TRYTD.EXE");
        exit(1);
    }

    regs.x.bx = regs.x.ax;          /* get file date & time */
    regs.x.ax = 0x5700;
    int86(0x21, &regs, &regs);
    dirtime = regs.x.cx;
    dirdate = regs.x.dx;

    regs.x.ax = 0x3e00;             /* close the file */
    int86(0x21, &regs, &regs);      /* BX still has handle */

    tstr = dirtcvt(11, dirtime);    /* format directory time */
    dstr = dirdcvt(8, dirdate);     /* format directory date */

                                    /* display time & date */
    printf("\nThe TRYTD.EXE file time and date are: %s %s\n",
            tstr, dstr);

}


