;----------------------------------------------------------------------
; TRYSTR2.ASM --- demo of MASM string package #2
; Copyright (c), 1988 Ziff Communications Co.
; PC Magazine * Ray Duncan * November 29, 1988
;----------------------------------------------------------------------
cr      equ     0dh             ; ASCII carriage return
lf      equ     0ah             ; ASCII line feed

stdin   equ     0               ; standard input handle
stdout  equ     1               ; standard output handle
stderr  equ     2               ; standard error handle

DGROUP  group   _DATA

_DATA   segment word public 'DATA'

str1    db      80 dup (0)      ; string 1 buffer
str2    db      80 dup (0)      ; string 2 buffer

s1len   dw      ?               ; string 1 length
s2len   dw      ?               ; string 2 length

msg1    db      cr,lf,lf,"Enter string 1:  "
msg1_len equ $-msg1

msg2    db      "Enter string 2:  "
msg2_len equ $-msg2

msg3    db      cr,lf,"STRCAT:  "
msg3_len equ $-msg3

msg4    db      cr,lf,"STRLWR:  "
msg4_len equ $-msg4

msg5    db      cr,lf,"STRUPR:  "
msg5_len equ $-msg5

_DATA   ends
;----------------------------------------------------------------------
_TEXT   segment word public 'CODE'
        extrn   strcat:near
        extrn   strupr:near
        extrn   strlwr:near
        assume  cs:_TEXT,ds:DGROUP

main    proc    near
                                
        mov     ax,_DATA        ; make our data segment
        mov     ds,ax           ; addressable...
        mov     es,ax

main1:                          ; display prompt for string 1...
        mov     dx,offset msg1  ; address of message
        mov     cx,msg1_len     ; length of message
        mov     bx,stdout       ; standard output handle
        mov     ah,40h          ; function 40h = write
        int     21h             ; transfer to MS-DOS
                                ; get first string...
        mov     dx,offset str1  ; address of buffer
        mov     cx,64           ; maximum entry length
        mov     bx,stdin        ; standard input handle
        mov     ah,3fh          ; function 3fh = read
        int     21h             ; transfer to MS-DOS

        sub     ax,2            ; anything entered?
        mov     s1len,ax        ; save string length
        
        jnz     main2           ; jump if something entered

        mov     ax,4c00h        ; exit if empty line
        int     21h             ; transfer to MS-DOS
main2:                          ; display prompt for string 2...
        mov     dx,offset msg2  ; address of message
        mov     cx,msg2_len     ; length of message
        mov     bx,stdout       ; standard output handle
        mov     ah,40h          ; function 40h = write
        int     21h             ; transfer to MS-DOS
                                ; get second string...
        mov     dx,offset str2  ; address of buffer
        mov     cx,64           ; maximum entry length
        mov     bx,stdin        ; standard input handle
        mov     ah,3fh          ; function 3fh = read
        int     21h             ; transfer to MS-DOS

        sub     ax,2            ; save string length
        mov     s2len,ax
                                ; display STRCAT title
        mov     dx,offset msg3  ; address of message
        mov     cx,msg3_len     ; length of message
        call    pmsg
                                ; concatenate strings
        mov     si,offset str1  ; string1 address
        mov     bx,s1len        ; string1 length
        mov     di,offset str2  ; string2 address
        mov     dx,s2len        ; string2 length
        call    strcat
                                ; display result string
        mov     dx,si           ; result string address
        mov     cx,bx           ; result string length
        call    pmsg
                                ; display STRLWR title
        mov     dx,offset msg4  ; address of message
        mov     cx,msg4_len     ; length of message
        call    pmsg

        call    strlwr          ; translate concatenated string to lower case
                                ; display translated string
        mov     dx,si           ; result string address
        mov     cx,bx           ; result string length
        call    pmsg
                                ; display STRUPR title
        mov     dx,offset msg5  ; address of message
        mov     cx,msg5_len     ; length of message
        call    pmsg

        call    strupr          ; translate concatenated string to upper case
                                ; display translated string
        mov     dx,si           ; result string address
        mov     cx,bx           ; result string length
        call    pmsg

        jmp     main1           ; get more strings

main    endp
;----------------------------------------------------------------------
; PMSG:         display message on standard output
;
; Call with:    DS:DX = message address
;               CX    = message length
;
; Returns:      nothing
;
; Uses:         nothing
;----------------------------------------------------------------------
pmsg    proc

        push    ax              ; save registers
        push    bx

        mov     bx,stdout       ; standard output handle
        mov     ah,40h          ; function 40h = write
        int     21h             ; transfer to MS-DOS

        pop     bx              ; restore registers
        pop     ax
        ret                     ; back to caller

pmsg    endp

_TEXT   ends
;----------------------------------------------------------------------
STACK   segment para stack 'STACK'
        db      128 dup (?)
STACK   ends
        end     main
