/*---------------------------------------------------------------
   RANDRECT.C -- Random Rectangles for OS/2 Presentation Manager
                 (c) 1988, Ziff Communications Co.
                 PC Magazine * Charles Petzold, July 1988
  ---------------------------------------------------------------*/

#define INCL_WIN
#define INCL_GPI
#include <os2.h>
#include <stdlib.h>
#define ID_TIMER 1

MRESULT EXPENTRY ClientWndProc (HWND, USHORT, MPARAM, MPARAM) ;
HAB  hab ;

int main (void)
     {
     static CHAR szClientClass[] = "RandRect" ;
     HMQ         hmq ;
     HWND        hwndClient, hwndFrame ;
     QMSG        qmsg ;
     ULONG       flFrameFlags = FCF_STANDARD & ~FCF_MENU ;

     hab = WinInitialize (0) ;
     hmq = WinCreateMsgQueue (hab, 0) ;
     WinRegisterClass (hab, szClientClass, ClientWndProc, 0L, 0) ;

     hwndFrame = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE,
                                     &flFrameFlags, szClientClass,
                                     "Random Rectangles",
                                     0L, NULL, 0, &hwndClient) ;
     if (hwndFrame != NULL)
          {
          while (WinGetMsg (hab, &qmsg, NULL, 0, 0))
               WinDispatchMsg (hab, &qmsg) ;

          WinDestroyWindow (hwndFrame) ;
          }
     WinDestroyMsgQueue (hmq) ;
     WinTerminate (hab) ;
     return 0 ;
     }

VOID DrawIt (HPS hps, SHORT cxClient, SHORT cyClient)
     {
     POINTL ptl ;

     GpiSetPattern (hps, 1L + rand() % 16) ;           // Pattern = 1 to 16
     GpiSetColor (hps, (LONG) (rand() % 16)) ;         // Color = 0 to 15
     GpiSetBackColor (hps, (LONG) (rand () % 16)) ;    // Background color
     GpiSetBackMix (hps, BM_OVERPAINT) ;               // Background mix

     ptl.x = rand() % cxClient ;                       // First corner
     ptl.y = rand() % cyClient ;
     GpiMove (hps, &ptl) ;

     ptl.x = rand() % cxClient ;                       // Opposite corner
     ptl.y = rand() % cyClient ;
     GpiBox (hps, DRO_FILL, &ptl, 0L, 0L) ;
     }

MRESULT EXPENTRY ClientWndProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
     {
     static SHORT cxClient, cyClient ;
     HPS          hps ;

     switch (msg)
          {
          case WM_CREATE:                          // Start the timer
               if (!WinStartTimer (hab, hwnd, ID_TIMER, 0))
                    {
                    WinMessageBox (HWND_DESKTOP, hwnd,
                         "Cannot run program - Too many clocks or timers",
                         "RANDRECT", 0, MB_OK | MB_ICONEXCLAMATION) ;
                    return 1 ;
                    }
               return 0 ;

          case WM_SIZE:                           // Save size of client
               cxClient = SHORT1FROMMP (mp2) ;
               cyClient = SHORT2FROMMP (mp2) ;
               return 0 ;

          case WM_TIMER:                          // Draw a rectangle
               hps = WinGetPS (hwnd) ;

               DrawIt (hps, cxClient, cyClient) ;

               WinReleasePS (hps) ;
               return 0 ;

          case WM_ERASEBACKGROUND:                // Erase the background
               return 1 ;

          case WM_DESTROY:                        // Stop the timer
               WinStopTimer (hab, hwnd, ID_TIMER) ;
               return 0 ;
          }
     return WinDefWindowProc (hwnd, msg, mp1, mp2) ;
     }
