RHAVA$FI          p. pn of fp

PT3AL1LM0RM80
;----------------------------------------------------------------------
;  freq.asm - count the letter frequency on the command line
;  PC Magazine * PC Tutor
;----------------------------------------------------------------------
CSEG    SEGMENT PARA PUBLIC 'CODE'              ;Start CODE segment
        ASSUME  CS:CSEG,DS:CSEG,ES:CSEG,SS:CSEG ;Set by DOS Loader
                ORG     100H                    ;COM file format

ENTPT:          JMP     MAIN

CR              EQU     0DH
LF              EQU     0AH

COPYRIGHT	DB	"FREQ 1.0 (c) Ziff Communications Co.",CR,LF
		DB	"PC Magazine ",254," Robert L. Hummel",CR,LF,"$",26

USAGE$          DB      "Usage: FREQ text",CR,LF,"$"

ABC             DB      26 DUP(0)

MAIN    PROC    NEAR

		MOV	DX,OFFSET COPYRIGHT
		MOV	AH,9
		INT	21H

                XOR     CH,CH			;Zero high byte
                MOV     CL,DS:[80H]		;Get command line length
                OR      CL,CL			;If > 0
                JNZ     HAVE_INPUT		; count letters

                MOV     DX,OFFSET USAGE$	;Address of message
                MOV     AH,9			;Display string
                INT     21H			; Thru DOS
                MOV     AX,4C01H		;Terminate with error
                INT     21H			; Thru DOS
HAVE_INPUT:
                MOV     SI,81H			;Start of command tail
                XOR     BH,BH			;Zero high byte of index
READ_CHAR:                LODSB				;Get character in AL
                OR      AL,20H			;Make lower case
                SUB     AL,"a"			;Convert to number
		CMP	AL,25
		JA	NEXT
                MOV     BL,AL			;Put into BL
                INC     BYTE PTR ABC[BX]	; to use as index
NEXT:
                LOOP    READ_CHAR		;Scan entire line

                MOV     SI,OFFSET ABC		;Offset of table
                MOV     CX,26			;Number of entries
                XOR     BL,BL			;BL = 0
PR_CHAR:
                MOV     AH,2                    ;Write TTY
                MOV     DL,CR                   ; carriage return
                INT     21H                     ; thru DOS

                MOV     AH,2                    ;Write TTY
                MOV     DL,LF			; line feed
                INT     21H                     ; thru DOS

                MOV     DL,BL                   ;Build character in DL
                INC     BL			; move char counter
                ADD     DL,"A"			;Make ASCII value
                MOV     AH,2			;Write TTY
                INT     21H			; Thru DOS

                MOV     AH,2			;Write TTY
                MOV     DL,20H			; a space
                INT     21H			; Thru DOS

                LODSB                           ;Get character count
                CALL    BYTE2DEC		;Print as decimal number

                LOOP    PR_CHAR			;Continue for entire table

                MOV     AX,4C00H                ;Terminate program
                INT     21H                     ;Thru DOS
MAIN    ENDP

;======================================================================
; binary to decimal conversion.  arguments 0 - 99 in AL
; Destroys AX, DL
;----------------------------------------------------------------------
BYTE2DEC        PROC    NEAR

                XOR     AH,AH
                AAM
                OR      AX,"00"         ;Make them ascii
                PUSH    AX
                MOV     DL,AH                   ; carriage return
                MOV     AH,2                    ;Write TTY
                INT     21H                     ; thru DOS
                POP     AX
                MOV     DL,AL
                MOV     AH,2
                INT     21H
                RET

BYTE2DEC        ENDP

;-----------------------------------------------------------------------------

CSEG    ENDS
        END     ENTPT
