	Title NETSND - Sends Messages to NETRCV using NETBIOS

;	Usage:
;
;	NETSEND FRED Meeting at 8:00, BE THERE!
;	NETSEND ADMIN* Administrative conference has been canceled
;	NETSEND * The server is going down in 5 minutes!
;
;	You may send to a specific workstation, a group of workstations
;	or everyone on the LAN as in the three examples above.
;
;
;	Author: Jack Schoof, President, ARTISOFT, Inc. Tucson, AZ
;
	ASSUME CS:MAIN_CODE,DS:MAIN_DATA

COMMAND_LINE	EQU 80H 		;LOCATION OF THE COMMAND LINE IN PSP
;
;	NCB DEFINITION
;
NCBDEF	STRUC				;PRE FILLED WITH ALL ZEROES
NCB_COMMAND	DB 0
NCB_RETCODE	DB 0
NCB_LSN 	DB 0
NCB_NUM 	DB 0
NCB_BUFFER	DD 0			;POINTER TO MESSAGE BUFFER
NCB_LENGTH	DW 0			;NUMBER OF BYTES IN BUFFER
NCB_CALLNAME	DB 16 DUP (0)
NCB_NAME	DB 16 DUP (0)
NCB_RTO 	DB 0
NCB_STO 	DB 0
NCB_POST	DD 0			;POINTER TO POST ADDRESS
NCB_LANA_NUM	DB 0
NCB_CMD_CPLT	DB 0
NCB_RESERVED	DB 14 DUP (0)		;RESERVED
NCBDEF	ENDS

;
;	NCB COMMANDS
;
NCB_SEND_DATAGRAM	EQU 20H

MAIN_DATA	SEGMENT PUBLIC 'DATA'

ERROR		DB 7,'NETBIOS ERROR: '
SIZE_ERROR	EQU $-ERROR
CHAR		DB 0

SNCB		NCBDEF <>			;DEFINE NCB

	ORG SNCB.NCB_CALLNAME		;NAME TO CALL
	DB 'NETSEND_GROUP',0,0,10	;10 AT THE END TO NOT NAME CONFLICT
	ORG SNCB+SIZE NCBDEF		;WITH NETWORK OPERATING SYSTEMS

MAIN_DATA	ENDS

MAIN_CODE	SEGMENT PUBLIC 'CODE'

BEGIN:	MOV AX,SEG MAIN_DATA		;POINT TO MAIN_DATA
	MOV DS,AX			;AND PLACE IN DS
	MOV DI,COMMAND_LINE		;POINT TO THE COMMAND LINE
	MOV CL,ES:[DI]			;AND GET THE COMMAND LINE LENGTH
	TEST CL,CL			;MUST BE NON ZERO
	JZ QUIT 			;QUIT IF ZERO
	XOR CH,CH			;ZERO AH
GETNXT: INC DI				;POINT TO COMMAND LINE TEXT
	MOV AL,ES:[DI]			;GET A CHARACTER
	CMP AL,' '			;IS IT A SPACE?
	LOOPZ GETNXT			;YES THEN LOOP UNTIL NOT A SPACE
	INC CX				;ADJUST COUNT UP BY ONE
	MOV SNCB.NCB_LENGTH,CX		;LENGTH OF MESSAGE TO SEND
	MOV WORD PTR SNCB.NCB_BUFFER,DI ;POINT TO THE COMMAND LINE
	MOV WORD PTR SNCB.NCB_BUFFER+2,ES
	MOV SNCB.NCB_NUM,1		;USE OUR PERMANENT NAME #1
	MOV AX,SEG SNCB 		;WHICH IS THE ADAPTER NUMBER
	MOV ES,AX
	MOV BX,OFFSET SNCB		;ES:BX IS NCB ADDRESS FOR NETBIOS
	MOV SNCB.NCB_COMMAND,NCB_SEND_DATAGRAM
	INT 5CH 			;PERFORM THE NETBIOS SEND
	TEST AL,AL			;ANY PROBLEMS?
	JZ EXITOK			;NOPE
	MOV CX,SIZE_ERROR
	MOV DX,OFFSET ERROR
	CALL OUT_ERR			;OUTPUT TO ERROR DEVICE
	MOV AL,SNCB.NCB_CMD_CPLT	;GET THE NETBIOS COMPLETION CODE
	CALL HEX2			;DISPLAY AL AS 2 HEX DIGITS
QUIT:	MOV AL,SNCB.NCB_CMD_CPLT	;IF ERROR, RETURN CODE=NETBIOS ERROR
EXITOK: MOV AH,4CH			;TO ALLOW ERROR TESTS IN BATCH FILE
	INT 21H 			;TOODLES

HEX2:	MOV BL,AL
	MOV CL,4
	ROL BL,CL			;ROTATE TO GET THE TOP DIGIT
	CALL HEXDIG			;DISPLAY THE FIRST DIGIT
	MOV CL,4
	ROL BL,CL			;THEN FALL INTO HEXDIG FOR LAST ONE
HEXDIG: MOV AL,BL			;HEX CHARACTER IN BL
	AND AL,0FH			;MASK OFF THE BOTTOM NIBBLE
	ADD AL,'0'			;ADD ASCII DIGIT OFFSET
	CMP AL,'9'			;ABOVE 9?
	JLE PRINT_CHAR
	ADD AL,'A'-'9'-1		;THEN ADD THE RIGHT AMOUNT TO GET A-F
PRINT_CHAR:
	MOV CHAR,AL
	MOV DX,OFFSET CHAR		;PLACE THE CHARACTER IN MEMORY
	MOV CX,1			;WRITE ONE CHARACTER
	CALL OUT_ERR			;TO THE ERROR DEVICE
	RET

OUT_ERR: PUSH BX		;PRESERVE BX
	MOV BX,2		;STANDARD ERROR HANDLE
	MOV AH,40H		;WRITE TO FILE
	INT 21H
	POP BX
	RET

MAIN_CODE	ENDS

	END BEGIN

