PROGRAM PokerSolitaire;
USES crt, cards;

TYPE
  PokerHand = (nothing, OnePair, TwoPair, ThreeOfAKind,
               straight, flush, FullHouse, FourOfAKind,
               StraightFlush, RoyalFlush);
  PokerSol = OBJECT (game)
    topcard     : LCardP;
    places      : array[0..24] of LCardP;
    cur, played : Byte;
    CONSTRUCTOR Init;
    DESTRUCTOR Done; virtual;
    PROCEDURE display; virtual;
    PROCEDURE Play;
  END;

  CONSTRUCTOR PokerSol.Init;
  VAR N : Byte;
  BEGIN
    Game.Init($1E);
    D := New(LDeckP, Init(61, 15, TableColor)); D^.shuffle;
    TopCard := LCardP(D^.FromTop);
    TopCard^.TurnUp;
    FillChar(places, SizeOf(places), 0);
    cur := 0; played := 0;
  END;

  DESTRUCTOR PokerSol.Done;
  VAR N : Byte;
  BEGIN
    FOR N := 0 to 24 DO
      IF places[N] <> NIL THEN Dispose(Places[N], done);
    Game.done;
  END;

  PROCEDURE PokerSol.display;
  VAR ro, co, N : Byte;
  BEGIN
    TextAttr := TableColor;
    ClrScr;
    Frame(1, 1, 40, 23, 2, true, ' ');

    Frame(50, 1, 80, 11, 2, true, ' ');
    GotoXY(53, 2);  WriteLn('    *** SCORING ***');
    GotoXY(53, 3);  WriteLn('Straight Flush       30');
    GotoXY(53, 4);  WriteLn('Four of a kind       16');
    GotoXY(53, 5);  WriteLn('Straight             12');
    GotoXY(53, 6);  WriteLn('Full house           10');
    GotoXY(53, 7);  WriteLn('Three of a kind       6');
    GotoXY(53, 8);  WriteLn('Flush                 5');
    GotoXY(53, 9);  WriteLn('Two pairs             3');
    GotoXY(53, 10); WriteLn('One pair              1');

    Frame(60, 14, 64, 17, 2, true, ' ');
    D^.Display;
    Frame(50, 14, 54, 17, 2, true, ' ');
    TopCard^.DrawAt(51, 15);
  END;

  PROCEDURE PokerSol.Play;
  TYPE OneRow = ARRAY [0..4] of Byte;
  VAR co, ro : Byte;
    YourScore : Word;
    CH : Char;

    FUNCTION Analyze(O : OneRow) : PokerHand;
    VAR
      valu, suit   : OneRow;
      same1, same2, 
      N, M, P      : Byte;
      IsF, IsS     : boolean; {IsFlush and IsStraight}
    BEGIN
      FOR N := 0 to 4 DO
        BEGIN
          valu[N] := O[N] MOD 13; 
          suit[N] := O[N] DIV 13; 
        END; 
      {Sort the values into order}
      FOR N := 4 DOWNTO 1 DO
        FOR M := 0 to pred(N) DO
          IF valu[M] > valu[N] THEN
            BEGIN
              P := valu[M]; valu[M] := valu[N]; valu[N] := P; 
            END; 

      IsF := true; IsS := true; {-- true 'til proven false --}
      FOR M := 1 to 4 DO IF suit[M]<>suit[0] THEN IsF := false; 

      FOR N := 3 downto 1 DO IF valu[N+1]-valu[N]<>1 THEN IsS := false;
      IF IsS THEN IsS := valu[1]-valu[0] IN [1, 9]; 

      IF IsF THEN
        BEGIN
          IF IsS THEN
            IF valu[1] = 10 THEN Analyze := RoyalFlush
            ELSE Analyze := StraightFlush
          ELSE Analyze := Flush;
          EXIT; 
        END;
      IF IsS THEN BEGIN Analyze := Straight; EXIT; END; 

      {-- no straight, no flush, try same-rank hands --}
      same1 := 0; same2 := 0; 
      FOR N := 0 to 3 DO
        IF valu[N] = valu[succ(N)] THEN
          BEGIN
            inc(same1); 
            P := valu[N]; 
          END; 
      IF same1 > 0 THEN
        FOR N := 0 to 4 DO IF valu[N] = P THEN Inc(same2); 
      CASE same1 OF
        0 : Analyze := nothing; 
        1 : Analyze := OnePair; 
        2 : CASE same2 OF
              2 : Analyze := TwoPair; 
              3 : Analyze := ThreeOfAKind; 
            END; 
        3 : CASE same2 OF
              2, 3 : Analyze := FullHouse;
              4 : Analyze := FourOfAKind; 
            END; 
      END; 
    END;

    PROCEDURE NameScore(S : PokerHand);
    BEGIN
      GotoXY(1, 24); ClrEol;
      CASE S OF
        nothing       : Write('Nothing               0'); 
        OnePair       : Write('One pair              1'); 
        TwoPair       : Write('Two pairs             3'); 
        ThreeOfAKind  : Write('Three of a kind       6'); 
        straight      : Write('Straight             12'); 
        flush         : Write('Flush                 5'); 
        FullHouse     : Write('Full house           10'); 
        FourOfAKind   : Write('Four of a kind       16'); 
        StraightFlush, 
        RoyalFlush    : Write('Straight Flush       30'); 
      END; 
    END; 

    FUNCTION Score : Word; 
    VAR col, row : Byte;
      arow : OneRow; 
      temp : Word; 
    CONST
      scoreFor : ARRAY[PokerHand] of Byte =
                 (0, 1, 3, 6, 12, 5, 10, 16, 30, 30);

    BEGIN
      temp := 0;
      FOR row := 0 to 4 DO
        BEGIN
          Frame(4,row*4+2,36,row*4+5,1,false,' ');
          FOR col := 0 to 4 DO arow[col] := places[col+5*row]^.GetValue;
          NameScore(Analyze(aRow));
          Inc(Temp, ScoreFor[Analyze(aRow)]);
          ReadLn;
          Frame(4,row*4+2,36,row*4+5,0,false,' ');
        END;
      FOR col := 0 to 4 DO
        BEGIN
          Frame(col*7+4,2,col*7+8,21,1,false,' ');
          FOR row := 0 to 4 DO arow[row] := places[col+5*row]^.GetValue;
          NameScore(Analyze(aRow));
          Inc(Temp, ScoreFor[Analyze(aRow)]);
          ReadLn;
          Frame(col*7+4,2,col*7+8,21,0,false,' ');
        END;
      score := temp;
    END;

    PROCEDURE BkwdNonNIL;
    BEGIN WHILE places[cur]<>NIL DO cur := (cur+24) MOD 25; END;

    PROCEDURE FrwdNonNIL;
    BEGIN WHILE places[cur]<>NIL DO cur := (cur+ 1) MOD 25; END;

  BEGIN
    REPEAT
      co := (cur MOD 5)*7+4;
      ro := (cur DIV 5)*4+2;
      Frame(co, ro, co+4, ro+3, 1, true, ' ');
      CH := ReadKey;
      Frame(co, ro, co+4, ro+3, 0, true, ' ');
      CASE CH OF
	#0 : CASE ReadKey OF
	       #$48 : BEGIN cur := (cur+20) MOD 25; BkwdNonNIL; END;
	       #$50 : BEGIN cur := (cur+ 5) MOD 25; FrwdNonNIL; END;
	       #$4B : BEGIN cur := (cur+24) MOD 25; BkwdNonNIL; END;
	       #$4D : BEGIN cur := (cur+ 1) MOD 25; FrwdNonNIL; END;
	     END;
	#27 : ; 
	#13 : BEGIN
               Inc(played);
               Places[cur] := topCard;
               Places[cur]^.DrawAt(succ(co), succ(ro));
	       TopCard := LCardP(D^.FromTop);
               WITH TopCard^ DO BEGIN TurnUp; DrawAt(51, 15); END;
               IF played < 25 THEN FrwdNonNIL;
             END;
      END;
    UNTIL (CH = #27) OR (played = 25);
    IF CH <> #27 THEN
      BEGIN
        YourScore := Score;
        TextAttr := $2E; GotoXY(1, 24); ClrEOL;
        Write('Your final score is ', YourScore);
      END;
  END;

VAR
  pgame :    PokerSol;
BEGIN
  pgame.Init;
  pgame.display;
  pgame.play;
END.