;		ping.asm
;========================================================================

; Copyright (C) 1991-94 by Jan.Engvald@ldc.lu.se, see file COPYING.


;************************************************************************
;*		EchoAwhile
;************************************************************************

EchoAwhile	proc	near
		assume	ds:code_s
		call	HwTicksNoHi
		mov	EchoStart,si		; note start ticks
		mov	EchoStart+2,dx
		mov	EchoLoadTime,dx

		mov	di,offset EchoSizeVec	; clear error size table
		mov	cx,(EchoSizeEnd-EchoSizeVec)/2
		xor	ax,ax
		rep	stosw

		cmp	EchoTarget,ax		; want to ping someone?
		jne	EchoYes

		test	ArgFlags,TERM_WAIT	; ping serving?
		jz	EchoNo
		mov	dx,offset MsgEchoStats
		call	DosPr$
                or      GenFlags,ECHO_DISPL
  EchoNo:
		ret

  EchoYes:
		call	InitTimer		; prepare millisecond timing

		mov	ax,ArgFlags
		and	ax,STOP_ON_ERR
		xor	ax,NO_ERR_YET+STOP_ON_ERR+NO_DROP_YET+PING_DELAY
		or	GenFlags,ax

		call	HardwareTicks
		mov	EchoStart,si		; note start ticks
		mov	EchoStart+2,dx
		mov	EchoStart+4,ax
		mov	EchoLoadTime,dx
		mov	EchoLoadTime+2,ax
		mov	si,dx

		call	DblShrX
		mov	EchoNext,ax

		cmp	EchoTarget,127		; dns lookup to do?
		jne	EchoIpAddr

		mov	dx,offset MsgCalling
		call	DosPr$

		mov	dx,2345h		; ping udp src port
		xor	ax,ax			; NsId
		mov	si,offset EchoNameBuf	; Ns question string

		call	NsResolve		; call nameserver(s)

		call	HardwareTicks		; response time
		mov	si,dx
		sub	ax,EchoStart+4
		sbb	dx,EchoStart+2
		div	kTimerScale
		mov	di,offset MsgNameRepTim
		call	PutNumD4Fb

		mov	dx,offset MsgNameRep	; display it.
		call	DosPr$

		cmp	EchoTarget,127		; name resolved?
		jne	EchoIpAddr
  EchoErrTerm:
		mov	dx,offset MsgBadName
		mov	al,'e'-'0'
		call	PrTerminate
  
  EchoIpAddr:
		mov	EchoTxTime,si		; intialize timers
		mov	EchoRxTime,si
if TBLBUILD
		call	TableReady		; allow tablebuilding now
endif ; TBLBUILD
		mov	ax,EchoInterval		; check interval
		test	ArgFlags,NOT_SAFE
		jnz	EchoAsIs

		cmp	ax,110
		jge	EchoAsItIs
		mov	ax,110
  EchoAsItIs:
		test	ArgFlags,MICRO_100
		jz	EchoAsIs
		cmp	ax,128*10
		jge	EchoAsIs
		mov	ax,128*10
  EchoAsIs:
		mov	EchoInterval,ax
if HOPCHK
		test	MoreFlags,HOP_CHK	; hop check going on?
		jz	EchoNoHopBuf

		mov	cx,(MAXHOP+1)*80/2
		mov	di,offset HopTabDsp-80
		mov	ax,'  '			; blank display buff
		rep	stosw

		mov	byte ptr MsgEchoHead+6,'e'
		mov	byte ptr MsgEchoStats,'$'

		mov	dx,MyIpNr
		mov	ax,MyIpNr+2
		mov	word ptr HopTabIp,dx
		mov	word ptr HopTabIp+2,ax
		call	BufAlloc
		call	MakeSendDescr
		mov	di,[bx].dPtrIp
		mov	[di].iIpSrc,dx		; my IP # to IP src
		mov	[di].iIpSrc+2,ax
		call	PutPhysSrc
		mov	si,offset TblToDo
		call	AddToList		; find my name
  EchoNoHopBuf:
endif ; HOPCHK
		call	BufAlloc		; get a send buf
		assume	ds:nothing
		call	MakeSendDescr

		mov	[di].uIcmpTypeCode,8	; type = echo request
		test	cs:GenFlags,UDP_ECHO	; ping or udpecho?
		jz	EchoUseIcmp		; print "Ping  to"

		mov	dx,'cE'			; print "Echo  to"
		mov	ax,'oh'
if HOPCHK
		test	cs:MoreFlags,HOP_CHK	; hop checking?
		jz	EchoFillEcho
		mov	dx,'rT'			; print "Trace to"
		mov	ax,'ca'
  EchoFillEcho:
endif ; HOPCHK
		mov	word ptr cs:MsgEchoHead+2,dx
		mov	word ptr cs:MsgEchoHead+4,ax

		mov	word ptr [di].uUdpSrc,0703h	; my udp echo port
		mov	word ptr [di].uUdpDst,0900h	; dst discard port
		test	cs:ArgFlags,UDP_DISCARD
		jnz	EchoUseIcmp
		mov	word ptr [di].uUdpDst,0700h	; dst echo port
  EchoUseIcmp:
		mov	cx,cs:MyGiant		; fill buffer with data
                sub     cx,HWHDRLEN+IPHDRLEN+ICMPHDRLEN+6
		shr	cx,1
		add	di,ICMPHDRLEN+6
		mov	ax,cs:EchoData
  EchoFillLoop:
		stosw
		add	ax,cs:EchoDataIncW
		loop	EchoFillLoop
  EchoFillEnd:
		mov	dx,cs:EchoTarget	; set IP destination
		mov	ax,cs:EchoTarget+2
		call	SetIpDst

		mov	ds,cs:MySegm
		assume	ds:code_s
		mov	EchoBufSeg,es

		mov	si,offset EchoTarget
		mov	di,offset MsgEchoTarget
		call	PutIpNum		; tell who we are pinging

		mov	dx,EchoMinSize
		sub	dx,IPHDRLEN
		cmp	dx,ICMPHDRLEN+6
		jns	EchoMinOK
		mov	dx,ICMPHDRLEN+6
  EchoMinOK:
		mov	ax,EchoSize
		neg	ax
		jns	EchoSizeNeg
		mov	dx,GIANTTR
		neg	ax
		mov	MsgEchoSweep,' '
  EchoSizeNeg:
                mov     cx,MyGiant
                sub     cx,HWHDRLEN+IPHDRLEN+ICMPHDRLEN+6
                sub     ax,IPHDRLEN+ICMPHDRLEN+6
                cmp     ax,cx
		jbe	EchoOkSize
		xor	ax,ax
  EchoOkSize:
		add	ax,ICMPHDRLEN+6
		mov	EchoSize,ax
		mov	EchoMaxSize,ax

		cmp	dx,ax
		jbe	EchoMinMax
		mov	dx,ax
  EchoMinMax:
		mov	EchoMinSize,dx

		cmp	ax,dx
		je	EchoFixedSz
		push	ax
		mov	ax,dx
		add	ax,IPHDRLEN
		mov	di,offset MsgEchoSweep-4
		call	PutNumD4Fb		;   and the min size used
		pop	ax
  EchoFixedSz:
		add	ax,IPHDRLEN
		mov	di,offset MsgEchoSize
		mov	PutMinDigits,1
		call	PutNum			;   and the packet size used

		mov	ax,EchoInterval
		push	ax
		mov	di,offset MsgEchoMs
		mov	PutMinDigits,6
		call	PutNumFb		;   and interval in ms
		pop	ax
		test	ArgFlags,MICRO_100
		jz	Echo1ms
		mov	dh,MsgEchoMs+5
		mov	dl,'.'
		mov	word ptr MsgEchoMs+5,dx
		mul	k51200			; make interval close to 0.1 ms
		jmp	short EchoPrHdr
  Echo1ms:
		mul	k64000			; make interval close to 1 ms
  EchoPrHdr:
		div	k54925
		mov	EchoInterval,ax
		mov	dx,offset MsgEchoHead
		call	DosPr$
if HOPCHK
		mov	byte ptr MsgEchoStats,' '
endif ; HOPCHK
                or      GenFlags,ECHO_DISPL


  EchoLoop:
		call	Something2Do		; process other things

		test	GenFlags,NO_ERR_YET+CONT_ON_ERR	; want to stop on sequence errs?
		jz	EchoEnd0

		call	AnyKey			; first key stops sending
		jz	EchoNoKey
  EchoEnd0:
		jmp	EchoEnd
  EchoNoKey:
		call	Something2Do		; called to slow down client

		call	HardwareTicks
		mov	es,EchoBufSeg
		mov	di,es:[bx].dPtrUdp
		mov	es:[di].uUdpData,ax
		mov	es:[di].uUdpData+2,dx

		call	DblShrX
		mov	dx,EchoNext
		cmp	ax,dx			; time to send next echo pkt?
		js	EchoLoop

		add	dx,EchoInterval
		cmp	dx,ax
		jns	EchoSetNext
		mov	dx,ax
  EchoSetNext:
		mov	EchoNext,dx		; next send time

		mov	dx,es:[di].uUdpData+2
		mov	EchoTxTime,dx

		mov	cx,EchoSize		; compute packet size
		inc	cx
		cmp	cx,EchoMaxSize
		jbe	EchoNormSize
		mov	cx,EchoMinSize
  EchoNormSize:
		mov	EchoSize,cx
if HOPCHK
		test	MoreFlags,HOP_CHK
		jnz	EchoNoVec
endif ; HOPCHK
		mov	di,cx		 	; IP data length
		shl	di,1
		inc	word ptr EchoSizeVec[di]
  EchoNoVec:
		mov	ax,EchoTxLo		; increment send counters
		add	ax,1
		mov	EchoTxLo,ax
		adc	EchoTxHi,0
		mov	EchoFudge,1

		mov	ds,EchoBufSeg
		assume	ds:nothing
		mov	di,[bx].dPtrUdp		; put sequence number
		mov	[di].uUdpData+4,ax
		mov	[bx].dPktLen,cx		; and IP data length

		test	cs:GenFlags,UDP_ECHO
		jnz	EchoUdp
		call	SendIcmpPkt		; send icmp echo pkt
  EchoLoop8:
		mov	ds,cs:MySegm
		assume	ds:code_s
		jnz	EchoErr 		; any errors?
  EchoLoop9:
		mov	EchoLastErr,cx
		jmp	EchoLoop

  EchoErr:
		cmp	cx,EchoLastErr
		je	EchoLoop9

		push	cx
		xor	ch,ch
		test	cl,01			; odd errs not allowed
		jnz	EchoErrUndef
		cmp	cl,SERRTABLEN
		jb	EchoErrExist
  EchoErrUndef:
		mov	cl,SERRTABLEN
  EchoErrExist:
		mov	si,cx
		mov	dx,MsgSerrTbl[si]
		call	DosPr$
		pop	cx
		mov	ds,EchoBufSeg
		test	ArgFlags,TERM_WAIT
		jnz	EchoLoop9

  EchoEnd:
if 0
		mov	ds,cs:EchoBufSeg
		assume	ds:nothing
		call	BufRelease		; release send buffer
		push	cs
		pop	ds
endif
		assume	ds:code_s
		push	cs
		pop	es

		mov	EchoFudge,0
		or	ArgFlags,TERM_WAIT	; allow late packets to arrive
		ret

  EchoUdp:
if HOPCHK
		test	cs:MoreFlags,HOP_CHK	; hop checking?
		jnz	EchoHop
endif ; HOPCHK
		call	SendUdpPkt		; send udp echo pkt
		jmp	EchoLoop8

if HOPCHK
  EchoHop:
		call	HardwareTicks		; time stamp in ms
		mov	cl,6
		call	DblShl
		or	dh,080h			;   + 8000h
		xchg	dh,dl
		mov	[di].uUdpDst,dx		;   into dst port

		push	ds
		push	cs
		pop	ds

		mov	cx,word ptr HopCycle	; cl = HopCycle, ch = HopCount
		mov	dx,word ptr HopMax	; dl = MAXHOP, dh = MAXHOP-1
		mov	ax,word ptr HopStopThis
		div	dl			; hop cycle into al
		cmp	al,cl			; limit THIS turn?
		je	HopNextTurn

		mov	ah,HopMaxAll
		cmp	ah,dh
		jbe	HopInLim
		mov	ah,dh
  HopInLim:
		cmp	ch,ah			; reached max hops any turn?
		jb	HopSameTurn
  HopNextTurn:
		mov	HopStopThis,dh		; ignore host/net unr limit
		xor	ch,ch
		inc	cl
		cmp	cl,3			; all turns done?
		jb	HopGoOn
		pop	ax			; (ds)
		jmp	EchoEnd
  HopGoOn:
		mov	HopCycle,cl

		push	cx
		mov	dx,19			; wait 1 sec before next turn
		call	DblShrX
		sub	ax,EchoInterval
		add	EchoNext,ax
		pop	cx
if 1
		mov	dx,EchoMaxSize
		mov	ax,EchoMinSize
		cmp	ax,dx			; fixed pkt size?
		jne	HopSameTurn
		inc	ax			; increase by 1 each turn
		mov	dx,MyGiant
		sub	dx,HWHDRLEN+IPHDRLEN
		cmp	ax,dx			; unless at GIANT already
		ja	HopSameTurn
		mov	EchoMinSize,ax
		mov	EchoMaxSize,ax
endif ; 1

  HopSameTurn:
		mov	al,MAXHOP		; compute cycle and cnt
		mul	cl
		inc	ch
		add	al,ch
		mov	HopCount,ch

		pop	ds

		mov	ah,al
		mov	al,080h
		mov	[di].uUdpSrc,ax		; 8000h+cycle into src port

		mov	si,[bx].dPtrIp
		mov	[si].iIpTtl,ch		; set ttl
		or	[si].iIpFlFrag,0040h	; set don't fragment
if 1
		test	cs:ArgFlags,UDP_DISCARD	; use *PROTOCOL* unreachable?
		jz	EchoHopUdp
		mov	[si].iIpProt,241
		call	SendIpPkt
		xor	cx,cx
		jmp	EchoLoop8
  EchoHopUdp:
endif ; 1
		call	SendUdpPkt		; send udp echo pkt
		xor	cx,cx
		jmp	EchoLoop8
endif ; HOPCHK
EchoAwhile	endp



if DEBUG or TBLBUILD
TstEqual	proc	near
		assume	ds:nothing
		jne	TstErr
		ret
TstEqual	endp
endif ; DEBUG or TBLBUILD

if DEBUG

  TstBufLinks	proc	near
		assume	ds:nothing
		ja	TstErr
		mov	si,di
		inc	cx
    TstLinkLoop:
if DEBUG ge 6
		.386
		push	di
		push	eax
		push	cx

		cmp	di,offset FreeBufs
		je	BufChkEnd
ifdef SMALLBUFS
		cmp	di,offset FreeSmal
		je	BufChkEnd
endif ; SMALLBUFS
		push	ax
		mov	cx,(dHwDst-dPtrIp)/4
if DEBUG ge 8
		mov	cx,((dHwDst-dPtrIp)+(BUFSIZESML-DESCRLEN))/4
		mov	ax,es:[di].dHomeList
		cmp	ax,offset FreeBufs
		jne	BufChkSml
		mov	cx,((dHwDst-dPtrIp)+(BUFSIZE-DESCRLEN))/4
  BufChkSml:
endif ; DEBUG ge 8
		lea	di,[di].dPtrPhys
		mov	eax,0aaaaaaaah		; contents changed?
		scasw
		repe	scasd
		pop	ax
		call	TstEqual
  BufChkEnd:
		pop	cx
		pop	eax
		pop	di

		mov	bp,bx
		mov	ax,dx
		mov	bx,di
		mov	dx,es
		.8086
endif ; DEBUG ge 6
		les	di,es:[di].dNext
		lds	si,[si].dPrev
		loop	TstLinkLoop

		cmp	si,di
		jne	TstErr
		mov	cx,ds
		cmp	cx,cs:MySegm
		jne	TstErr
		ret
TstBufLinks	endp

endif ; DEBUG

TstErr:
		call	Terminate



;************************************************************************
;*		EchoDisplay
;************************************************************************


EchoDisplay	proc	near
		assume	ds:code_s
if DEBUG or TBLBUILD
		mov	al,'s'-'0'
		cmp	word ptr StackLow,0	; stack overflowed?
		call	TstEqual
endif ; DEBUG or TBLBUILD

if DEBUG
		mov	al,'t'-'0'
		cmp	word ptr phd_dioa,0	; stack overflowed?
		call	TstEqual

		mov	al,'i'-'0'
		test	GenFlags,DBGINTERR	; any interrupt debug errs?
		call	TstEqual

		mov	cx,MyNbufs		; any buffers damaged?
		mov	bx,offset BufStart
		mov	al,'u'-'0'
  BufTestLoop:
		cmp	[bx].dHomeList,offset FreeBufs
		call	TstEqual
		add	bx,MyBufSize
		loop	BufTestLoop

		push	cs
		pop	es
		mov	di,offset FreeBufs
		cli
		mov	cx,[di].lBufsAvail
		cmp	cx,MaxAvail
		call	TstBufLinks
		cmp	di,offset FreeBufs
		call	TstEqual
		sti

ifdef SMALLBUFS
		mov	bx,offset BufStart+NBUFS*BUFSIZE
		mov	cx,NBUFSMALL
		mov	al,'v'-'0'
  TstSmlLoop:
		cmp	[bx].dHomeList,offset FreeSmal
		call	TstEqual
		add	bx,BUFSIZESML
		loop	TstSmlLoop

		cli
		mov	di,offset FreeSmal
		mov	cx,[di].lBufsAvail
		cmp	cx,NBUFSMALL
		call	TstBufLinks
		cmp	di,offset FreeSmal
		call	TstEqual
		sti
endif ; SMALLBUFS
		SHOW_EVENT	'o'
endif ; DEBUG

if TBLBUILD
		cmp	EchoTarget,0		; pinging or hopchecking?
		jne	EchoDispYes
		test	ArgFlags,MAKE_TABLE
		jz	EchoDispYes
		call	TblDisplay		; -no, must be tbl building
		ret

  EchoDispYes:					; -yes, we are pinging
endif ; TBLBUILD
                test    GenFlags,ECHO_DISPL
                jz      EchoDispRet

		mov	cx,SavedTicks
		shr	cx,1
		mov	ax,EchoLastDispl
		shr	ax,1
		cmp	ax,cx			; time to update display?
		jne	EchoDispNow
  EchoDispRet:
		ret

  EchoDispNow:
		cli
		mov	dx,EchoAvgSum
		mov	ax,EchoAvgSum+2
		mov	cx,EchoRxHi
		mov	bx,EchoRxLo
		sti
		call	AdjTo16Bits
		jz	EchoSkipAvg		; avoid div by zero

		div	bx
if DEBUG ge 2
		mov	ax,MinAvail		; Show min available bufs
endif ; DEBUG ge 2
		mov	EchoAvg,ax		; average delay
  EchoSkipAvg:

		cmp	EchoTarget,0
		jne	$+5
		jmp	EchoDspDiscard

		mov	dx,EchoTxHi		; compute difference tx - rx
		mov	ax,EchoTxLo
		sub	ax,EchoFudge		;   subtract one if just
		sbb	dx,0			;   sent a pkt
		push	ax
		push	dx
		cli
		sub	ax,EchoRxLo
		sbb	dx,EchoRxHi
		sti
		push	ax
		push	dx
		jns	EchoDifPos		; use abs(tx-rx)
		call	NegDxAx
  EchoDifPos:
		mov	EchoDifHi,dx
		mov	EchoDifLo,ax
		pop	dx
		pop	ax
		add	ax,word ptr EchoErRepLo	; don't count repeated as loss
		adc	dx,word ptr EchoErRepHi
		jns	EchoLossPos		; use abs(tx-rx+rep)
		call	NegDxAx
  EchoLossPos:

		mov	si,EchoMax		; convert ms delay to ticks
		or	si,si
		jnz	EchoGotMax
		mov	si,2000
  EchoGotMax:
		add	si,500
		mov	cl,5			;   with a margin
		shr	si,cl
		push	si			;   and save it

		mov	cx,EchoTxTime
		add	cx,si
		add	si,EchoRxTime
		cmp	cx,SavedTicks		; did we stop a while ago?
		jns	EchoDispNotStop
		and	GenFlags,not PING_DELAY
		jmp	short EchoDispLoss	; - yes, use diff
  EchoDispNotStop:
		cmp	si,EchoTxTime		; received anything lately?
		jns	EchoUseLoss		; - yes

		and	GenFlags,not (NO_ERR_YET+NO_DROP_YET) ; - no, he
		jmp	short EchoDispLoss	;    probably died
  EchoUseLoss:
		mov	ax,word ptr EchoErLosLo	; use loss cntr
		mov	dx,word ptr EchoErLosHi
  EchoDispLoss:
		mov	cl,2			; compute packet loss
		call	DblShl			;   multiply by 100
		mov	si,dx
		mov	bx,ax
		mov	cl,3
		call	DblShl
		add	bx,ax
		adc	si,dx
		shl	ax,1
		rcl	dx,1
		add	ax,bx
		adc	dx,si

		pop	si
		pop	cx
		pop	bx

		call	AdjTo16Bits
		jz	EchoSkipLoss		; avoid div by zero

		div	bx
		mov	EchoLoss,ax

		mov	ax,dx			;   fractional loss
		mul	k10000
		div	bx
		mov	EchoLoss+2,ax
  EchoSkipLoss:
		shr	si,1
		add	si,EchoErTmpTime
		cmp	si,SavedTicks
		jns	EchoDspTmp

		xor	dx,dx
		cli
		mov	ax,word ptr EchoErTmp	; make temp err permanent
		add	word ptr EchoErLosLo,ax
		adc	word ptr EchoErLosHi,dx
		mov	word ptr EchoErTmp,dx
		sti
  EchoDspTmp:

  EchoDspDiscard:
		push	cs			; edit echo values
		pop	es
if HOPCHK
		test	MoreFlags,HOP_CHK	; hop check going on?
		jz	EchoDspNoHop
		jmp	HopDisplay
  EchoDspNoHop:
endif ; HOPCHK
		mov	di,offset MsgEcho-1
		mov	si,offset EchoTxHi
		mov     PutNumFiller,' '
		mov	PutMinDigits,9
		mov	cx,3
		call	PutBigNums		; tx and rx and diff

		mov	PutMinDigits,6
		inc	di
		mov	cx,5
  EchoDispLoop:
		push	cx
		mov	cl,1
		call	PutNums 		; delays and loss
		pop	cx
		loop	EchoDispLoop

		inc	di
		mov	cl,1
		mov	PutMinDigits,4
		call	PutNumsF0		; .0000%

		call	HardwareTicks
		push	dx
		push	si

		dec	EchoLoadCnt		; update load every 4:th time
		jnz	EchoLoad1st

		mov	EchoLoadCnt,4
		mov	bx,ax
		mov	cx,dx
		sub	ax,EchoLoadTime+2
		sbb	dx,EchoLoadTime
		mov	EchoLoadTime+2,bx
		mov	EchoLoadTime,cx
		js	EchoLoad1st		; avoid overflow

		div	kTimerScale
		mov	bx,ax
		cli
		mov	ax,EchoLoad+2
		mov	dx,EchoLoad
		mov	EchoLoad+2,0
		mov	EchoLoad,0
		sti
		mov	cl,3
		call	DblShl
		div	bx
		add	di,3
		inc	PutMinDigits
		call	PutNumFb		; load kb/s
  EchoLoad1st:
		pop	dx			; compute elapsed time
		pop	ax
		cmp	dx,EchoLastHi
		jae	EchoLastGrows

		mov	bx,EchoLastDispl
		mov	cx,EchoLastHi
		sub	EchoStart+2,bx
		sbb	EchoStart,cx
  EchoLastGrows:
		mov	EchoLastDispl,ax
		mov	EchoLastHi,dx
		sub	ax,EchoStart+2
		sbb	dx,EchoStart
		mov	cl,4			; divide # of ticks by 18.2
		call	DblShr
		mov	EchoElapsed+2,ax
		mov	EchoElapsed,dx
		mov	cl,3
		call	DblShr
		sub	EchoElapsed+2,ax
		sbb	EchoElapsed,dx
		mov	cl,5
		call	DblShr
		add	ax,EchoElapsed+2
		adc	dx,EchoElapsed
		mov     PutNumFiller,' '
		mov	PutMinDigits,8
		mov	di,offset MsgEchoTime
		call	PutBigNum		; elapsed time
if DEBUG
		mov	dx,280h+10h		; assume WD card at IO 280h
		xor	ax,ax
		xor	cx,cx
		cli
		out	dx,al			; set page 0
		call	IoDelay
		add	dx,0eh
		in	al,dx			; readnadclear bad CRC ctr
		add	cx,ax
		inc	dx
		in	al,dx			; readandclear lost frames ctr
		sti
		add	cx,ax
		add	EchoDrop,cx		; add out of bufs ctr
endif ; DEBUG
		mov	ax,EchoDrop
if DEBUG eq 0
		or	ax,ax
		jz	EchoNoDrops
endif ; DEBUG eq 0
		mov	di,offset MsgEcho+18	; place before diff
		mov	PutMinDigits,1
		call	PutNum			; show dropped packets
		mov	byte ptr [di],' '
  EchoNoDrops:
		xor	si,si
		cmp	word ptr EchoErRepLo,si	; any repeated pkts?
		jz	EchoDispNoRep
		inc	si
  EchoDispNoRep:
		test	GenFlags,NO_DROP_YET
		jz	EchoDispDrop
		mov	dx,word ptr EchoErLosLo	; any lost packet events?
		or	dx,word ptr EchoErTmp
		jz	EchoDispNoLoss
  EchoDispDrop:
		lodsw				; add	si,2
  EchoDispNoLoss:
		cmp	word ptr EchoErSeqLo,0	; any out of sequence?
		jz	EchoDispInSeq
		lodsw				; add	si,4
		lodsw
  EchoDispInSeq:
		mov	al,EchoErrChar[si]
		mov	MsgEchoSeqEr,al		; put rep/seq/lost char

if 1
		test	ArgFlags,AVOID_HDWR
		jnz	EchoDspDos

		call	GetDspRow
		mov	di,EchoDspRow
		push	es
		mov	es,EchoDispPar
		mov	si,offset MsgEcho
		mov	ax,es:[di]
  EchoDspL1:
		lodsb				; display echo values
		cmp	al,CR
		je	EchoDspLe
		stosw
		jmp	EchoDspL1
  EchoDspLe:
		pop	es
		jmp	short EchoDspRet
  EchoDspDos:
endif
		mov	dx,offset MsgEcho	; display echo values
		call	DosPr$
  EchoDspRet:
		ret

GetDspRow	proc	near
		test	GenFlags,GOT_DSP_ROW
		jnz	EchoDspGotRow

		mov	ah,15			; get screen mode
		int	10h			; call video BIOS
		cmp	al,7			; is it mono?
		mov	dx,0b000h
		jz	K1			; yes
		mov	dh,0b8h			; no, set for color
  K1:
		mov	EchoDispPar,dx

		mov	ah,03h
		xor	bx,bx
		int	10h			; get current row
if HOPCHK
		mov	HopTopRow,dh
		push	es
		mov	ax,0040h
		mov	es,ax
		mov	al,es:[0084h]		; get dsp # of rows
		mov	HopMaxRows,al
		pop	es
endif ; HOPCHK
		mov	al,160
		mul	dh
		mov	EchoDspRow,ax
		or	GenFlags,GOT_DSP_ROW
  EchoDspGotRow:
		ret
GetDspRow	endp

  EchoDispPar	dw	0b800h
  EchoDspRow	dw	(25-1)*160
EchoDisplay	endp


;				  seq   lost   rep
EchoErrChar	db	' '	;   0      0     0  space
		db	0eh	;   0      0     1  double music note
		db	'.'	;   0      1     0  dot
		db	':'	;   0      1     1  colon (double dot)
		db	"'"	;   1      0     0  apostrophe
		db	'"'	;   1      0     1  quote (double apostrophe)
		db	'!'	;   1      1     0  exclamation mark
		db	13h	;   1      1     1  double exclamation mark



;************************************************************************
;*		AdjTo16Bits
;************************************************************************

  Adjust:
		shr	dx,1			; shift 32 bits right
		rcr	ax,1
		shr	cx,1
		rcr	bx,1
AdjTo16Bits:
		or	cx,cx			; fits in 16 bits?
		jnz	Adjust
		or	dx,dx
		jnz	Adjust
		or	bx,bx			; avoid div by zero
		ret



;************************************************************************
;*		DblShrX
;************************************************************************

DblShrX 	proc	near
		mov	cl,7
		test	cs:ArgFlags,MICRO_100
		jnz	DblShr
DblShr10:
		mov	cl,10
DblShr:
		xor	ch,ch
  DblShrNext:
		shr	dx,1			; shift 32 bits right
		rcr	ax,1
		loop	DblShrNext
		ret
DblShrX 	endp



;************************************************************************
;*		DblShl
;************************************************************************

DblShl		proc	near
		xor	ch,ch
  DblShlNext:
		shl	ax,1			; shift 32 bits left
		rcl	dx,1
		loop	DblShlNext
		ret
DblShl		endp



;************************************************************************
;*		EchoCalc
;************************************************************************

EchoCalc	proc	near
		assume	ds:nothing
		mov	si,[bx].dPktLen

		mov	bp,ds			; save ds in bp until return
		mov	es,bp
		mov	ds,cs:MySegm
		assume	ds:code_s

		shl	si,1
		dec	word ptr EchoSizeVec[si] ; update error size table

		xor	cx,cx
		add	EchoRxLo,1		; increment receive counters
		adc	EchoRxHi,cx
		mov	EchoFudge,cx

		mov	ax,EchoSeqRx
		inc	ax
		mov	si,es:[di].uUdpData+4
		cmp	ax,si			; packet in sequence?
		jne	EchoCalcChkSeq
  EchoCalcInSeq:
		mov	EchoSeqRx,ax		; "highest" sequence yet
  EchoCalcDelay:
		and	si,REPVECLEN-1
		mov	byte ptr EchoRepVec[si],1 ; mark got this seq #

		call	HardwareTicks		; compute delay
		mov	EchoRxTime,dx
		sub	ax,es:[di].uUdpData
		sbb	dx,es:[di].uUdpData+2
		js	EchoCalcRet
		div	kTimerScale
		mov	EchoThis,ax		; delay for this packet

		add	EchoAvgSum+2,ax
		adc	EchoAvgSum,cx

		cmp	ax,EchoMin
		jb	EchoSetMin
  EchoChkMax:
		cmp	ax,EchoMax
		ja	EchoSetMax
  EchoCalcRet:
		ret

  EchoSetMin:
		mov	EchoMin,ax		; minimum delay
		jmp	short EchoChkMax
  EchoSetMax:
		mov	EchoMax,ax		; maximum delay
		ret

  EchoCalcChkSeq:
		js	EchoCalcDrop		; missing packet(s)?

		and	si,REPVECLEN-1
		cmp	byte ptr EchoRepVec[si],cl ; a repeated packet?
		jne	EchoCalcRepeat

		add	word ptr EchoErSeqLo,1	; inc out of sequence cntr
		adc	word ptr EchoErSeqHi,cx

		mov	ax,word ptr EchoErTmp
		dec	ax
		js	EchoLostMain		; use tmp or main counter?
		mov	word ptr EchoErTmp,ax
  EchoCalcNonSeq:
		and	GenFlags,not NO_ERR_YET	; note err detected
		jmp	short EchoCalcDelay

  EchoLostMain:
		mov	ax,word ptr EchoErLosLo
		or	ax,word ptr EchoErLosHi	; too much out of seq repeats
		jz	EchoCalcRepeat		;   have occured?

		sub	word ptr EchoErLosLo,1	; after all: wasn't lost
		sbb	word ptr EchoErLosHi,cx
		jmp	short EchoCalcNonSeq

  EchoCalcRepeat:
		add	word ptr EchoErRepLo,1	; inc repeated pkts cntr
		adc	word ptr EchoErRepHi,cx
		jmp	short EchoCalcNonSeq
  
  EchoCalcDrop:
		push	si
		mov	EchoSeqRx,si		; "highest" sequence yet
		sub	si,ax			; # of pkts missing
		mov	dx,word ptr EchoErTmp
		or	dx,dx			; old or new occurance?
		jnz	EchoDropMore
		mov	cx,SavedTicks
		mov	EchoErTmpTime,cx	; -new, initialize timer
		xor	cx,cx
  EchoDropMore:
		add	dx,si
		mov	word ptr EchoErTmp,dx	; add to temporary drops
		xchg	ax,si
  EchoDropL:
		and	si,REPVECLEN-1
		mov	byte ptr EchoRepVec[si],cl ; mark as not received
		inc	si
		dec	ax
		jnz	EchoDropL		; repeat for all "lost" pkts

		pop	si
		jmp	EchoCalcNonSeq
EchoCalc	endp



;========================================================================
;		endinclude
