;History:63,1

;  Copyright, 1992, Russell Nelson, <nelson@crynwr.com>

;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation, version 1.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

HT	equ	09h
CR	equ	0dh
LF	equ	0ah

segmoffs	struc			; defines offs as 0, segm as 2
offs		dw	?
segm		dw	?
segmoffs	ends

code	segment	public
	assume	cs:code, ds:code

	org	100h
start:
	jmp	start_1

highest_tsr	dw	0		;PHD of highest TSR program.
went_tsr	db	0		;non-zero if a previous cmd went TSR.
first_one	dw	0		;segment of command's line buffer.
done_one	db	0		;non-zero if we've printed a program
					;  name and hence should skip command.com
command		db	'COMMAND',0	;name of command.com

process_phd:
;enter with es = segment of a program header.

;
; Did the previous program go TSR?  If so, remember it as the highest TSR.
;
	cmp	went_tsr,0
	je	process_phd_1
	mov	highest_tsr,es
process_phd_1:

;
; Is this one a TSR or not?  If it's below the highest TSR, don't print it.
;
	cmp	ax,highest_tsr
	jbe	process_phd_7

;
; If this is COMMAND.COM, don't print [COMMAND] after the program that's
; spawned it.
;
	mov	si,offset command
	mov	di,8			;offset of name in MCB.
	mov	cx,8
	repe	cmpsb
	jne	process_phd_3		;not COMMAND.COM - go remember that.

	xor	al,al			;get and reset done_one
	xchg	al,done_one
	or	al,al			;did we just do a program?
	jne	process_phd_7		;yes, skip printing [COMMAND].
	jmp	short process_phd_4

process_phd_3:

	inc	done_one		;remember that we have a program.

process_phd_4:

;
; Print the name found in the MCB.
;
	mov	dl,'['
	mov	ah,2
	int	21h
	mov	cx,8			;8 characters max.
	mov	si,8			;name starts at offset 8.
process_phd_5:
	mov	al,es:[si]
	inc	si
	or	al,al			;give up when we hit the end.
	je	process_phd_6
	mov	dl,al
	mov	ah,2
	int	21h
	loop	process_phd_5
process_phd_6:
	mov	dl,']'
	mov	ah,2
	int	21h

process_phd_7:
	ret


highest_phd	dw	?		;highest PHD we found this time.


prompt:
	assume	ds:code

	cmp	first_one,0		;do we have command's segment yet?
	jne	prompt_0		;yes.
	mov	first_one,dx
prompt_0:
	cmp	first_one,dx		;is this command.com?
	jne	prompt_3		;no - don't print anything.

	mov	done_one,0		;say that we haven't done any yet.

;
; Get the first memory block into ES (undocumented).
;
	mov	ah,52h
	int	21h
	mov	es,es:[bx-2]

;
; Now we step through the phd's (program headers)
;
	mov	highest_phd,0
prompt_2:
	cmp	byte ptr es:[0],'M'	;All but the last block start with 'M'.
	jne	prompt_3

;
; Is this a PHD?  That is, does it start with CD 20?
;
	cmp	word ptr es:[16],0cdh + 20h*256
	jne	prompt_4

;
; Remember the highest PHD we find, in case they removed a TSR.
;
	mov	ax,es
	cmp	ax,highest_phd
	jbe	process_phd_2
	mov	highest_phd,ax
process_phd_2:

	call	process_phd
;
; Skip to the next memory block.
;
prompt_4:
	mov	ax,es			;add the size of this memory block
	add	ax,es:[3]		;  to get to the next segment.
	inc	ax
	mov	es,ax
	jmp	prompt_2
prompt_3:
;
; Now see if we've removed a TSR.
;
	mov	ax,highest_phd		;did they remove a TSR?
	cmp	ax,highest_tsr
	jae	prompt_6
	mov	highest_tsr,ax
prompt_6:
	mov	went_tsr,0		;Okay, we're done with TSRs.
	ret

	assume	ds:nothing

their_27 dd	?			;remember what their interrupt 27 was.

our_27:
	inc	went_tsr
	jmp	their_27


their_21 dd	?			;remember what their interrupt 21 was.

our_21:
;
; Check for buffered input, and save everything if we've got one.
;
	cmp	ah,31h			;TSR call?
	jne	our_21_2
	inc	went_tsr		;yes - remember it.
our_21_2:
	cmp	ah,0ah			;buffered input?
	jnz	our_21_1

	push	ax
	push	bx			;save regs
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es

	mov	dx,ds			;remember their buffer's segment in dx.

	mov	ax,cs			;set up ds
	mov	ds,ax

	call	prompt

	pop	es
	pop	ds
	pop	bp
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax

our_21_1:
	jmp	their_21


start_1:
	mov	dx,offset copyleft_msg
	mov	ah,9
	int	21h

;
; Check for MS-LOSS 4.x or greater
;
	mov	ah,30h
	int	21h
	cmp	al,4
	jae	start_3
	mov	dx,offset bad_ver_msg
	mov	ah,9
	int	21h
	int	20h
start_3:

;
; Intercept interrupt 21.
;
	mov	ax,3521h
	int	21h
	mov	their_21.offs,bx
	mov	their_21.segm,es

	mov	dx,offset our_21
	mov	ax,2521h
	int	21h
;
; Intercept interrupt 27.
;
	mov	ax,3527h
	int	21h
	mov	their_27.offs,bx
	mov	their_27.segm,es

	mov	dx,offset our_27
	mov	ax,2527h
	int	21h
;
; and TSR.
;
	mov	dx,offset start_1+15
	shr	dx,1
	shr	dx,1
	shr	dx,1
	shr	dx,1
	mov	ah,31h
	int	21h

copyleft_msg	label	byte
 db "Nosy Prompter v3.0 copyright 1989-1992, Russell Nelson.",CR,LF
 db "This program is free software; see the file COPYING for details.",CR,LF
 db "NO WARRANTY; see the file COPYING for details.",CR,LF,'$'

bad_ver_msg	db	"Requires MS-LOSS 4.x or greater$"

code	ends

	end	start
