/*
 * This file generates multiple fonts in a single pass; after all fonts have
 * been generated, it notifies dviwin to re-read all fonts. This feature
 * (the notification of dviwin) has only been tested in seamless mode; you
 * will probably need to make some modifications. Many thanks to Darrel
 * Hankerson for the REXX techniques.
 */
CALL RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
CALL SysLoadFuncs

temp_ = value('TEMP',,'OS2ENVIRONMENT')
IF temp_ = '' THEN temp_ = value('TMP',,'OS2ENVIRONMENT')
temp_ = translate(temp_, '\', '/')

lock_ = temp_'\lock_$_$.cmd'
IF stream(lock_,'c','query exists') <> '' THEN
  DO
   say ''
   say 'It seems that another instance of this batch file is already running.'
   say 'If this is true, please wait until it finishes and then run this batch'
   say 'file again. If on the other hand this is not true, delete the file'
   say lock_ ' and then run this batch file again.'
   SIGNAL ERROR_EXIT
  END
rc = lineout(lock_, '@echo off')
DO WHILE lines(ARG(1))
  rc = lineout(lock_, linein(ARG(1)))
END
rc = stream(ARG(1), 'c', 'close')
rc = stream(lock_, 'c', 'close')
CALL SysFileDelete(ARG(1))
IF stream(temp_'\error$_$','c','query exists') <> '' THEN
   CALL SysFileDelete(temp_'\error$_$')
'cmd /c'temp_'\lock_$_$.cmd'
CALL SysFileDelete(temp_'\lock_$_$.cmd')

/*
 * Notify dviwin to re-read the fonts. This is done by calling it with
 * the "-r" command line switch. If you normally start dviwin with the
 * "-1" command line switch, then you need to include that switch here
 * as well.
 *
 * First we need to test for the existence of the file temp_\error$_$.
 * If it exists, then an error has occured in genpk2.cmd and we should
 * not call dviwin.
 */
IF stream(temp_'\error$_$','c','query exists') <> '' THEN
  CALL SysFileDelete(temp_'\error$_$')
ELSE
  DO
    classname = 'WPProgram'
    title = 'dviwin -r'
    location = '<WP_DESKTOP>'
    ObjectID = '<dviwin_reset>'
    setup='OBJECTID=' || ObjectID || ';EXENAME=dviwin.exe;'||,
          'PARAMETERS=-r;OPEN=DEFAULT'
    IF SysCreateObject(classname,title,location,setup,'replace') = 0 THEN
      DO
        say 'SysCreateObject failed'
        SIGNAL ERROR_EXIT
      END
    ELSE IF SysDestroyObject(ObjectID) = 0 THEN
      DO
        say 'SysDestroyObject failed'
        SIGNAL ERROR_EXIT
      END
  END
EXIT

ERROR_EXIT:	say ''
		say "Press Enter to continue..."
		pull junk_
		EXIT
