@if "%debug%"=="" echo off
set snu_vers=23
set nul=nul
if not "%debug%"=="" set nul=con
set snu_inst_ver=1.06
rem ---------------------------------------------------------------------
rem  INSTALL.BAT
rem ---------------------------------------------------------------------
echo.
echo			Installing or Updating SNUUPM
echo			-----------------------------
echo.
echo Installs or updates the SNUUPM package. It must be used in conjunction
echo with INSTALL.MNU and DOUGMENU.EXE.
echo.
echo An attempt is made to preserve an existing SNUUPM installation when
echo this install is done. Certain key parameter files are preserved as
echo .BAK files in the \etc\uupc directory. If you have a multi-user or
echo a multi-host SNUUPM system, then it is assumed that you know how to
echo recover what is essential from those .BAK files.
echo.
rem ---------------------------------------------------------------------
rem  Based on uuInstal developed by Eberhard Lisse (el@lisse.na)
rem
rem  Adapted by Mike Lawrie (ccml@hippo.ru.ac.za)
rem
rem  Before running this install process, you must first alter your
rem  AUTOEXEC.BAT and CONFIG.SYS files as indicated in the Quickstart
rem  section of the SNUUPMxx.DOC file, and you must reboot of your PC
rem  in order for those changes to be effective. It is assumed that because
rem  you have this INSTALL.BAT file that you are in the directory that
rem  contains the various .ZIP files of the package, and that you have
rem  pkunzipped the SNUUPMxx.ZIP file - thus, you will have the INSTALL.BAT
rem  (ie this file), the INSTALL.MNU and half a dozen or so other .ZIP
rem  files all readily accessible.
rem ---------------------------------------------------------------------

rem ---------------------------------------------------------------------
rem  Don't be fooled, there is a tab at the end of the set tab= line!
rem ---------------------------------------------------------------------
set tab=	

rem ---------------------------------------------------------------------
rem  Check that the environment variables have been set.
rem ---------------------------------------------------------------------
if "%sndrive%"=="" goto noenv
if "%pmuser%"=="" goto noenv
if "%uupcsysrc%"=="" goto noenv
if "%uupcnews%"=="" goto noenv
if "%uupcusrrc%"=="" goto noenv
if "%snewsrc%"=="" goto noenv
if "%tz%"=="" goto noenv
if "%tmp%"=="" goto noenv
goto envok

:noenv
echo At least one of the SNUUPM environment variables:-
echo %tab% SNDRIVE, PMUSER, UUPCSYSRC, UUPCNEWS,
echo %tab% UUPCUSRRC, SNEWSRC, TZ and/or TMP
echo is not set. Read the Quickstart section of the SNUUPMxx.DOC file, and try again.
goto ends

:envok
if exist %sndrive%\nul goto gotdrive
echo The directory %sndrive% does not exist - you will have to create
echo this manually.
goto ends

:gotdrive
if not "%editor%"=="" goto tested
set askenv=n
echo The EDITOR environment variable is not set - you might have a problem
askenv if you try to run the SNEWS package. Do you want to continue? [n] /l
if "%askenv%"=="n" goto ends
if not "%askenv%"=="y" goto gotdrive
set askenv=
:tested
if exist %editor% goto goted
echo The editor %editor% can not be found in the search path.
goto ends

:goted
if exist %tmp%\nul goto gottmp
echo The directory %tmp% does not exist - you will have to create
echo this manually and re-run the install process.
goto ends

:gottmp
set t=%tmp%\temp.fil
set snu_p1=%sndrive%\etc\uupc
set snu_p2=%sndrive%\usr\lib\snuupm

rem ---------------------------------------------------------------------
rem  Test for the presence of the .ZIP files
rem  The settings of snu_f... are passed onto the installation process
rem  so the current versions of the filenames should be specified here.
rem ---------------------------------------------------------------------

if not exist SNUUPM.ZIP goto no_zip
set snu_fdm=DMENU168.ZIP
set snu_fpm=PMAIL301.ZIP
set snu_fsn=SNEWS191.ZIP
set snu_fad=UPC12BAD.ZIP
set snu_fd1=UPC12BD1.ZIP
set snu_fd2=UPC12BD2.ZIP
set snu_fd3=UPC12BD3.ZIP
for %%i in ( %snu_fdm% ) do if not exist %%i goto no_zip
for %%i in ( %snu_fpm% ) do if not exist %%i goto no_zip
for %%i in ( %snu_fsn% ) do if not exist %%i goto no_zip
for %%i in ( %snu_fad% ) do if not exist %%i goto no_zip
for %%i in ( %snu_fd1% ) do if not exist %%i goto no_zip
for %%i in ( %snu_fd2% ) do if not exist %%i goto no_zip
for %%i in ( %snu_fd3% ) do if not exist %%i goto no_zip
goto got_zip

:no_zip
echo One or more of the files that are required for installation are
echo not present in this directory. The files that must be present are
echo %tab% SNUUPM.ZIP
echo %tab% %snu_fdm%
echo %tab% %snu_fpm%
echo %tab% %snu_fsn%
echo %tab% %snu_fad%
echo %tab% %snu_fd1%
echo %tab% %snu_fd2%
echo %tab% %snu_fd3%
pause
goto ends

:got_zip

rem ---------------------------------------------------------------------
rem  Check that the INSTALL.MNU file is present as well...
rem ---------------------------------------------------------------------
if exist install.mnu goto got_mnu
echo The INSTALL.MNU file is not in the current directory. You need to
echo have all of the SNUUPM files in a single directory from which you
echo run the INSATLL.BAT program, having first pkunzipped the SNUUPMxx.ZIP
echo file.
pause
goto ends

:got_mnu

rem ---------------------------------------------------------------------
rem  Extract some of the files that are needed for installation
rem ---------------------------------------------------------------------

echo Extracting some files that are needed for installation.
echo This can take a minute or two, please be patient....
echo.

if exist dougmenu.exe del dougmenu.exe>%nul%
pkunzip %snu_fdm% dougmenu.exe>%nul%
if exist askenv.exe del askenv.exe>%nul%
pkunzip -o -d snuupm.zip . askenv.exe>%nul%
copy usr\lib\snuupm\askenv.exe askenv.exe>%nul%
del usr\lib\snuupm\askenv.exe>%nul%
rmdir usr\lib\snuupm>%nul%
rmdir usr\lib>%nul%
rmdir usr>%nul%
if exist %tmp%\mdm\nul del %tmp%\mdm\*.mdm
if exist %tmp%\mdm\nul for %%i in (%tmp%\mdm\*.*) do del %%i>%nul%
if not exist %tmp%\mdm\nul md %tmp%\mdm>%nul%
pkunzip snuupm.zip %tmp%\mdm *.mdm>%nul%
pkunzip %snu_fad% %tmp%\mdm *.mdm>%nul%

rem ---------------------------------------------------------------------
rem  Create a temporary file with a list of the files that are to be
rem  extracted from SNUUPM.ZIP in order to run as a mail-only system.
rem  Ie, don't force the installation of SNEWS, let it be an option.
rem  To balance things out, keep another file with the list for SNEWS.
rem
rem  Each file that is listed in /usr/lib/snuupm/distrib.fil should
rem  appear exactly once in these lists of files.
rem ---------------------------------------------------------------------
set snu_pmfil=%tmp%\snuupm.pm

echo HOSTATUS>%snu_pmfil%
echo HOSTPATH>>%snu_pmfil%
echo SEQF>>%snu_pmfil%
echo ADDUSER.BAT>>%snu_pmfil%
echo ASKENV.EXE>>%snu_pmfil%
echo BURST.BAT>>%snu_pmfil%
echo CALLIN.BAT>>%snu_pmfil%
echo CHANGES>>%snu_pmfil%
echo DISTRIB.BAT>>%snu_pmfil%
echo DISTRIB.FIL>>%snu_pmfil%
echo LOGTR.EXE>>%snu_pmfil%
echo PASSWD.EG>>%snu_pmfil%
echo PMAIL.CFG>>%snu_pmfil%
echo PMGATE.SYS>>%snu_pmfil%
echo RMUSER.BAT>>%snu_pmfil%
echo SNUUPM.PIF>>%snu_pmfil%
echo SNU_FPM.EXE>>%snu_pmfil%
echo UDG.BAT>>%snu_pmfil%
echo UU2PM.EXE>>%snu_pmfil%
echo FIRSTV22.MDM>>%snu_pmfil%
echo FX14400.MDM>>%snu_pmfil%
echo PENRIL.MDM>>%snu_pmfil%
echo SARONV22.MDM>>%snu_pmfil%
echo ZMFC9624.MDM>>%snu_pmfil%
echo BLANKLIN>>%snu_pmfil%
echo DIRECT1.BAT>>%snu_pmfil%
echo DIRECT2.BAT>>%snu_pmfil%
echo LOGTR101.C>>%snu_pmfil%
echo MAIN.BAT>>%snu_pmfil%
echo MAIN.MNU>>%snu_pmfil%
echo SNU_FPM.C>>%snu_pmfil%
echo UU2PM203.C>>%snu_pmfil%
echo ALIASES.TXT>>%snu_pmfil%
echo ROOT.SIG>>%snu_pmfil%
echo CNMAIL.PRO>>%snu_pmfil%
echo INETSIG.PMS>>%snu_pmfil%
echo LOCALSIG.PMS>>%snu_pmfil%

set snu_snfil=%tmp%\snuupm.sn
echo ACTIVE.BAT>%snu_snfil%

rem ---------------------------------------------------------------------
rem  Define some environment variables. These are handed over
rem  to the installation procedure where they can be changed during 
rem  the installation process.
rem  Take the installation default values if there is nothing better
rem  available.
rem
rem  Create the file INSTDEF.BAT
rem ---------------------------------------------------------------------
set snu_host=My_Host
set snu_dom=My_Domain
set snu_org=My_Organisation
set snu_mdm=My_Modem
set snu_baud=My_BaudRate
set snu_mserv=My_Mail_Server
set snu_phone=Host_Phone_Number
set snu_login=Host_Login
set snu_passwd=XxXxXxXx
set snu_file=INSTDEF.BAT
set snu_full=y
echo REM>%snu_file%
echo REM Created by SnuInst v%snu_inst_ver%>>%snu_file%
echo REM>>%snu_file%
echo set snu_baud=%snu_baud%>>%snu_file%
echo set snu_dom=%snu_dom%>>%snu_file%
echo set snu_host=%snu_host%>>%snu_file%
echo set snu_mserv=%snu_mserv%>>%snu_file%
echo set snu_mdm=%snu_mdm%>>%snu_file%
echo set snu_org=%snu_org%>>%snu_file%
echo set snu_passwd=%snu_passwd%>>%snu_file%
echo set snu_phone=%snu_phone%>>%snu_file%
echo set snu_login=%snu_login%>>%snu_file%
echo set snu_full=%snu_full%>>%snu_file%
goto got_def

:get_def
rem ---------------------------------------------------------------------
rem  Get the existing INSTDEF.BAT file
rem ---------------------------------------------------------------------
call INSTDEF.BAT
:got_def


rem ---------------------------------------------------------------------
rem  Override the installation default values (which were not very
rem  good anyway) with whatever was used during the last configuration
rem  on this system. The last configuration is saved in
rem  %sndrive%\usr\lib\snuupm\INSTSAVE.BAT.
rem
rem  That way changes made during run time will stay and we will not have to
rem  change all parameters necessary during a reinstallation, but only the
rem  ones we want.
rem ---------------------------------------------------------------------
set snu_sav=
if exist %sndrive%\usr\lib\snuupm\INSTSAVE.BAT set snu_sav=y
if "%snu_sav%"=="y" call %sndrive%\usr\lib\snuupm\INSTSAVE.BAT


rem ---------------------------------------------------------------------
rem  Use DOUGMENU for the interactive installation.
rem ---------------------------------------------------------------------
:loop
dougmenu.exe install.mnu
IF errorlevel==2 %t%
IF errorlevel==1 GOTO snuucheck
call %t%
GOTO loop
:snuucheck


rem ---------------------------------------------------------------------
rem  Save the installation values for a subsequent installation.
rem 
rem  Create the file %sndrive%\usr\lib\snuupm\INSTSAVE.BAT.
rem  Don't save if there has not been an installation, or if the
rem  default values have been selected.
rem ---------------------------------------------------------------------

if not "%snu_host%"=="My_Host" goto save
if not "%snu_dom%"=="My_Domain" goto save
if not "%snu_org%"=="My_Organisation" goto save
if not "%snu_mdm%"=="My_Modem" goto save
if not "%snu_baud%"=="My_BaudRate" goto save
if not "%snu_mserv%"=="My_Mail_Server" goto save
if not "%snu_phone%"=="Host_Phone_Number" goto save
if not "%snu_login%"=="Host_Login" goto save
if not "%snu_passwd%"=="XxXxXxXx" goto save
goto no_sav

:save
if exist %sndrive%\usr\lib\snuupm\nul goto save1
echo Cannot save the configuration, the directory %sndrive%\usr\lib\snuupm
echo does not exist.
goto error_exit

:save1
echo Saving the configuration to %sndrive%\usr\lib\snuupm\INSTSAVE.BAT
set snu_file=%sndrive%\usr\lib\snuupm\INSTSAVE.BAT
echo REM>%snu_file%
echo REM Created by SnuInst v%snu_inst_ver%>>%snu_file%
echo REM>>%snu_file%
echo set snu_host=%snu_host%>>%snu_file%
echo set snu_dom=%snu_dom%>>%snu_file%
echo set snu_org=%snu_org%>>%snu_file%
echo set snu_mdm=%snu_mdm%>>%snu_file%
echo set snu_baud=%snu_baud%>>%snu_file%
echo set snu_mserv=%snu_mserv%>>%snu_file%
echo set snu_phone=%snu_phone%>>%snu_file%
echo set snu_login=%snu_login%>>%snu_file%
echo set snu_passwd=XxXxXxXx>>%snu_file%
echo set snu_full=%snu_full%>>%snu_file%
goto tidyup

:no_sav
echo Configuration not saved


rem ---------------------------------------------------------------------
REM Find out if the user in fact DID install anything. If not exit
REM with an apropriate error message.
rem ---------------------------------------------------------------------
:tidyup
if not exist %sndrive%\usr\lib\snuupm\NUL goto error_exit
if not exist %sndrive%\usr\lib\snuupm\UUCICO.EXE goto error_exit
if not exist %sndrive%\etc\uupc\SYSTEMS goto error_exit
if not exist %sndrive%\etc\uupc\MODEM.MDM goto error_exit
goto ends

rem ---------------------------------------------------------------------
rem  Error exit
rem ---------------------------------------------------------------------
:error_exit
echo.
echo It seems that the installation is not complete, some critical files
echo have not been installed, and the package will not run.
echo.
echo Please make sure you actually installed the base packages after you
echo had configured the system.
echo.

:ends
rem ---------------------------------------------------------------------
rem  Clear all Environment Variables and any working files that were set up
rem  Delete all tmp\mdm\*.mdm files and remove the tmp\mdm directory.
rem  Remove the copy of dougmenu and askenv that were used for this
rem    installation process.
rem ---------------------------------------------------------------------
if exist %tmp%\mdm\nul del %tmp%\mdm\*.mdm>%nul%
if exist %tmp%\mdm\nul for %%i in (%tmp%\mdm\*.*) do del %%i>%nul%
if exist %tmp%\mdm\nul rmdir %tmp%\mdm
if exist %snu_pmfil% del %snu_pmfil%
set snu_pmfil=
if exist %snu_snfil% del %snu_snfil%
set snu_snfil=
if exist dougmenu.exe del dougmenu.exe
If EXIST %t% del %t%>%nul%
if exist askenv.exe del askenv.exe
set askenv=
set snu_inst_ver=
set snu_file=
set snu_host=
set snu_dom=
set snu_mserv=
set snu_phone=
set snu_login=
set snu_mdm=
set snu_baud=
set snu_org=
set snu_passwd=
set snu_full=
set tab=
set snu_fdm=
set snu_fpm=
set snu_fsn=
set snu_fad=
set snu_fd1=
set snu_fd2=
set snu_fd3=
set snu_tmp=
set snu_p1=
set snu_p2=
set snu_sav=
set nul=
set t=
set snu_vers=
rem ----ends----
set snu_vers=
rem ----ends----
