#include    "oldckit.h"          /* For version 2.0 CKit           */
#include    "ckit.h"             /* Include CKIT Header file!      */
#include    "ckitdemo.h"         /* Include file for demo          */
#include    <fcntl.h>
#pragma check_stack (off)


short       OPENED;             /* Flag to know if open_door has been called  */
short       CLOSED;             /* Flag to know if close_door has beeb called */

/******************************************************************************
 *                     Start of Main Program                                  *
 *****************************************************************************/
main(int argc, char **argv) {
short   result, i, j;
size_t  max_bytes;
char    *ptr, *des;
/******************************************************************************
*                        USER adjustments                                     *
* You will need to set these according to how you want CKIT to handle certain *
* options.  See the CKIT.DOC for more information                             *
* These are all Ckit options, if not defined it will use defaults             *
*******************************************************************************/
    FORCEOFFHOOK = TRUE;             /* Default is FALSE                      */
    USERSFILE = FALSE;               /* Default is FALSE anyway...            */
    NO_FKEYS = FALSE;                /* Default is FALSE anyway...            */
    DOTS = FALSE;                    /* Default is FALSE anyway...            */
    silent = FALSE;                  /* Turn on local beeps(default is FALSE) */
    logoff_color = (green);          /* Logoff msg to green (default=magenta) */
    ck_logoff_msgs = &logoffs[0];    /* Set message table to demo msgs        */
    ck_gen_msgs    = &ckit_msgs[0];  /* Set message table to demo msgs        */
    set_kybd_time(2,6);              /* Beep time 2, timeout 6 minutes        */
    OPENED = FALSE;
    if (argc > 1) {                  /* (default is 3, 5 minutes)             */
        strupr(argv[1]);
        if(strstr(argv[1], "CHAIN.TXT")) {  /* Check if WWIV */
            result = read_WWIV();    /* Ckit doesn't support WWIV directly    */
            if(result) {             /* so we will read the chain file        */
                result -= 1;
                print_msg(result, ckit_errors);
                if(!result) {
                    printf(" %s\n", argv[1]);
                }
                exit(1);
            }
            ck_NOSYSTEM = TRUE;     /* Tell Ckit not to expect a filename */
            ptr = &ck_gen.port[0];
        } else {
            ptr = argv[1];              /* Assume it is a system supported    */
            ck_NOSYSTEM = FALSE;
        }
        result = open_door(ptr,  argv[2]); /* Need arg2 for port:AAAA:X       */
        if(!result) {
            OPENED = TRUE;              /* Door has been opened               */
            atexit(shut_down);          /* call shut_down at exit time        */
        } else {
            OPENED = FALSE;             /* Door open failed for some reason   */
            print_msg(result-1, ckit_errors);
            if(result <= 3) {
                printf("%s\n", argv[1]);
            } else {
                if(result <= 6) {
                    printf("%s\n", argv[2]);
                }
            }
            exit(1);
        }
        if(GENERIC) {       /* If generic.sys file, we need to know user name */
            newline();
            s_puts("Please enter first and last name (MAX 25) ->");
            get_cmdline_raw(45);
            strncpy(fullname, cmdline, sizeof(ck_fullname)-1);
            i=1;
            ptr = &ck_fullname[0];
            des = &ck_firstname[0];     /* Copy firstname of fullname */
            while((i < sizeof(ck_firstname)) && (*ptr != 0x20)) {
                *des++ = *ptr++;
                i++;
            }
            *des = '\0';        /* NULL terminate */
        }
        display_info();               /* Display user information  */
        menu();                       /* Main program loop         */
    }
 return;
 }
/******************************************************************************
*                       End of Main Program                                   *
******************************************************************************/

/******************************************************************************
*                       Main Menu                                             *
******************************************************************************/
void    menu(void) {
    short   silent;

    silent = TRUE;
    newline();
    if(display_file("ckit.m")) {   /* If error display_file() return NON_ZERO */
        newline();
        printf("Error code %d\n", errno);
    }
    force_enter();
    /* main command loop */
    while(DUMP_USER != TRUE) {
          /* prompt for input only if there is not a stacked command pending */
        if ( strlen(cmdline) == 0) {
            color(white);
            newline();
            s_puts("Main menu:\r\n");
            color(red);
	    s_puts(" (I)  Display system information\r\n");
            color(green);
            s_puts(" (C)  Take a chance for more time online\r\n");
            color(magenta);
            s_puts(" (T)  Display a test pattern\r\n");
            color(cyan);
            s_puts(" (A)  Ansi graphics demo\r\n");
            color(violet);
            s_puts(" (D)  Display information on CKIT\r\n");
            color(green);
            s_puts(" (F)  Download CKIT.DOC using Zmodem \r\n");
            color(yellow);
            s_puts(" (M)  Color Mode On/Off \r\n");
	    color(red);
            s_puts(" (Q)  Return to PCBoard\r\n");
            color(green);
            s_puts(" (G)  Logoff  (Disconnect)\r\n");
            color(cyan);
            s_puts("\r\n\
While you are sitting here at the command line. Press some extended key\
board \r\nkeys. If you are on the remote end using Qmodem, go into the DOORWAY\r\n\
mode. Remember this is just a demo/usage for scan_code, so it's nothing \
fancy.\r\n");
            color(yellow);
            do {
                newline();
		display_time();
                color(green);
                s_puts("Command? ");
                get_cmdline();          /* read input into 'cmdline'  */

            } while((DUMP_USER != TRUE) && (strlen(cmdline) == 0) && (scan_code == 0));
        }
        if (DUMP_USER == TRUE) {
            exit(1);
        }
        if (scan_code != 0) {
            color(white);
            read_scancode();
	    newline();
        }
        if (get_nextpar()) {  /* scan next parameter from cmdline into par */
            newline();
      /* process commands */
            switch ( par[0] ) {
                case 'A':
                ansi_demo();
                break;
                case 'C':
                take_chance();
                break;
                case 'I':
		display_info();
                break;
                case 'T':
                test_pattern();
                break;
                case 'D':
                color(cyan);
                strcpy(error_msg11, "\a\nUnable to locate CKIT.DOC");
                if(display_file(doc_filename)) {
                    newline();
                    printf("Error code %d\n", errno);
                };
                break;
		case 'F':
                color(cyan);
                filexfer();
                break;
                case 'M':
                graphics ^= TRUE; /* Toggle graphics */
                ansi_ng |= TRUE;  /* Set ansi_ng (we only want to turn off color) */
                ck_set_ANSI(ansi_ng | graphics);
                break;
                case 'Q':
                option = EXITDOOR;
                return;
                case 'G':
		option = LOGOFF;
                return;
                default:
                newline();
                color(magenta);
                if(silent) {
                    send_byte(BELL);
                } else {
                    s_putc(BELL);
                }
                s_printf(" '%s' is not allowed!  Try again: %s", par, firstname);
                *cmdline = 0;
                break;
	    }
        }
    }
}

/******************************************************************************
*                       Display User information                              *
******************************************************************************/
void display_info(void) {
    clr_screen();
    newline();
    color(white);
    s_printf("%s, Here is your User information:", firstname);
    color(green);
    newline();
    s_putv("  Fullname        = ",fullname,"\r\n",NULL); /* could use sprintf() also */

/*    if(!GENERIC) { */
        if (!PCB &!RBBS) {
            s_printf("  Phone number(s) = ");
        }
        if (!WILDCAT && !PCB && !RBBS) {
            s_printf("User Business - %s", user.bphone);
        }
        if (!PCB && !RBBS) {
            s_printf("   Home - %s", user.phone);
	    newline();
        }
        if (!PCB) {
            s_printf("  City            = %s\r\n",user.city);
        }
        s_printf("  Modem Baud Rate = %s\r\n",baud_rate);
        if(!RBBS) {
            s_printf("  DTE Baud Rate   = %s\r\n",bps_open);
        }
        s_printf("  Minutes left    = %d\r\n",min_left+time_credit);

        if (!PCB && !RBBS) {
            s_printf("  Protocol is     = %s\r\n",protocol);
	}

        if (!WILDCAT && !PCB && !RBBS) {
            s_printf("  Last call date  = %s\r\n",user.last_date);
        }

        if (!PCB && !WILDCAT && !RBBS) {
            s_printf("  Event runs at   = %s\r\n",event_time);
            s_printf("  Total K bytes   = %s",download_Kbytes);
            newline();
            s_printf("  Total K bytes   = %s\r\n",upload_Kbytes);
        }
        if (!PCB && !RBBS) {
	    s_printf("  # of Downloads  = %s",dload_total);
            s_printf("  Today's K bytes = %s\r\n",daily_bytes);
            s_printf("  Allowed K bytes = %d\r\n",dload_limit);
            s_printf("  # of Uploads    = %s\r\n",upload_total);
            s_printf("  Your birthday   = %s\r\n",caller_bday);
            s_printf("  Last file scan  = %s\r\n",last_file_scan);
        }
        if (WILDCAT) {
            s_printf("  Monitor type    = %s\r\n", monitor_type);
            s_printf("  High msg. read  = %s\r\n", high_msg);
            s_printf("  Door opened     = %s\r\n", door_opened);
        }
        if(RBBS) {
	    s_printf("  BBS system name = %s", BBSname);
            newline();
        }
        s_puts("  Graphic         = ");
        if  (graphics) {
            s_puts("ON");
        } else {
            s_puts("OFF");
        }
        newline();
        s_printf("  Connected to port %s", aport);
        newline();
        if(!RBBS) {
	    s_puts("  Error correction = ");
            if  (error_connection) {
                s_puts("YES");
            } else {
                s_puts("NO");
            }
        newline();
        }
        s_printf("  Page length     = %d\r\n",page_length);
        color(yellow);
        newline();
        force_enter();
/*
 *  *cmdline = NULL;  Use this if you don't want cmd stacking
 */

/*    } */
}

/******************************************************************************
*                       ANSI Demo                                             *
******************************************************************************/
void ansi_demo(void) {

    short x,y;
    register    short  i;

    if (graphics || ansi_ng) {  /* Check if user is in ANSI mode */
        clr_screen();
        for (y=2; y < 24; y++) {
            pos_cursor(y,1);
            s_puts("");
            pos_cursor(y,79);
            s_puts("");
        }
        x = 2;
        pos_cursor(1,x);
        for(i = 0; i <= 1; i++) {
            while(x < 79) {
		s_puts("");
                x++;
            }
            x = 2;
            pos_cursor(23,x);
        }
        pos_cursor(1,1);
        s_puts("");
        pos_cursor(1,79);
        s_puts("");
        pos_cursor(23,1);
        s_puts("");
        pos_cursor(23,79);
	s_puts("");

        for(i = blue; i <= white; i++) {
            color(i);
            pos_cursor(i-8+3,11);
            s_puts("ANSI Color display");
        }
        for(i = grey; i >= dkblue; i--) {
            color(i);
            pos_cursor(i+3, 50);
            s_puts("ANSI Color display");
        }
        color(red);
	pos_cursor(13,34);
        s_puts("C - K I T");
        color(yellow);
        pos_cursor(16,14);
        s_puts("This is only a SMALL sample of what C-Kit can do! ");
        color(red);
        pos_cursor(20,26);
    } else {
        clr_screen();
        newline();
        s_puts("ANSI demo available only in GRAPHICS mode.\r\n");
    }
    force_enter();

/*
 *  *cmdline = NULL;  Use this if you don't want cmd stacking
 */
    clr_screen();
}

/*****************************************************************************
 *  Open  door                                                               *
 *****************************************************************************/
void    test_pattern(void) {
    int  i;

    newline();
    for (i = 1; i < 21; i++) {
           s_puts("(1234567890-abcdefghijklmnopqrstuvwxyz-ABCDEFGHIJKLMNOPQRSTUVWXYZ-0123456789)\r\n");
    }
/*
 *  *cmdline = NULL;  Use this if you don't want cmd stacking
 */

}


/*****************************************************************************
 *  Filexfer doc file                                                        *
 *****************************************************************************/
void    filexfer(void) {
    char    dszname[12];
    short   errorlevel;
    color(green);
    strcpy(dszname, "PCBDSZ.BAT");
    if(!FOSSIL) {
	s_printf("\nReady to send %s. Press <ENTER> to begin.",doc_filename);
	while(DUMP_USER != TRUE) {
	    if( check_CR() ) {
		break;
	    }
	}
	if(strstr(dszname, ".BAT")) {
        sprintf(zmodem_cmds, "/C %s %X, %X %s", \
			dszname, uart_base, irq, doc_filename);
        errorlevel = ck_dos_shell(getenv("COMSPEC"), zmodem_cmds);
	} else {
		sprintf(zmodem_cmds, "portx %X, %X sz %s", \
		    uart_base, irq, doc_filename);
        errorlevel = ck_dos_shell(dszname, zmodem_cmds);
	}
	if(errorlevel) {
		s_puts("\n\aTransfer aborted");
	} else {
		s_puts("\nTransfer complete");
	}
    } else {
	s_puts("\n\rNotify Sysop. Not support with FOSSIL driver usage.");
    }
/*
 *  *cmdline = NULL;  Use this if you don't want cmd stacking
 */
}

/******************************************************************************
*  Demostrate scan_code usage                                                 *
******************************************************************************/
void    read_scancode(void) {

     newline();
     newline();
      /* process scancodes */
    switch(scan_code) {
        case 0x3B00:
        s_puts("You pressed F1");
        break;
        case 0x3C00:
        s_puts("You pressed F2");
        break;
        case 0x3D00:
        s_puts("You pressed F3");
	break;
        case 0x3E00:
        s_puts("You pressed F4");
        break;
        case 0x3F00:
        s_puts("You pressed F5");
        break;
        case 0x4000:
        s_puts("You pressed F6");
        break;
        case 0x4100:
        s_puts("You pressed F7");
        break;
	case 0x4200:
        s_puts("You pressed F8");
        break;
        case 0x4300:
        s_puts("You pressed F9");
        break;
        case 0x4400:
        s_puts("You pressed F10");
        break;
        case 0x4800:
        s_puts("You pressed UP Arrow");
        break;
        case 0x5000:
	s_puts("You pressed Dn Arrow");
        break;
        case 0x4D00:
        s_puts("You pressed R Arrow");
        break;
        case 0x4B00:
        s_puts("You pressed L Arrow");
        break;
        case 0x4900:
        s_puts("You pressed PgUp");
        break;
        case 0x5100:
        s_puts("You pressed PgDn");
	break;
        case 0x5200:
        s_puts("You pressed Insert");
        break;
        case 0x5300:
        s_puts("You pressed Delete");
        break;
        case 0x4700:
        s_puts("You pressed Home");
        break;
        case 0x4F00:
        s_puts("You pressed End");
        break;
	case 0x4A00:
        s_puts("You pressed Grey - ");
        break;
        case 0x4E00:
        s_puts("You pressed Grey + ");
        break;
        default:
        break;
    }
    newline();
    s_puts(" - Press a key to continue - ");
    newline();
    while(!(wait_keypress())) {
    }
}

/*****************************************************************************
 *  Take a chance on on-line time                                            *
 *****************************************************************************/
void    take_chance(void) {
    char    thinking_of[5];

    if(PCB) {
        *cmdline = 0;
        itoa(random(10),thinking_of,10);
        if ( strlen(cmdline) == 0) {
	    color(cyan);
            s_puts("I'm thinking of a number from 0 to 9.  If you guess the\r\n");
            s_puts("number, you will be given an extra 10 minutes online.  If you\r\n");
            s_puts("get it wrong, your time will be reduced by 2 minutes.\r\n");
            newline();
            color(yellow);
            s_puts("What's your guess? ");
            get_cmdline();
            newline();
        }
        if (get_nextpar()) {  /* scan next parameter from cmdline into par */
            if (!strcmpi(thinking_of, par)) {
                color(green);
		s_puts("That's right!  You get a 10 minute bonus!");
                adjust_time_allowed(10);
            } else {
                color(blue);
                s_printf("Wrong! You lose 2 minutes! I was thinking of %s.",thinking_of);
                adjust_time_allowed(-2);
            }
        }
    } else {
        newline();
        s_puts("Take chance only available with PCBOARD.SYS usage.\r\n");
    }
}

/****************************************************************************
 *      Printf() function for sending output to port                        *
 ****************************************************************************/
void s_printf(char *s_format,...) {
    va_list arg_pointer;
    char buffer[256];
    va_start(arg_pointer, s_format);
    vsprintf(buffer, s_format, arg_pointer);
    s_puts(buffer);
    va_end(arg_pointer);
}

/****************************************************************************
 *      Close door, reset vectors etc.                                      *
 *  Need in case of a run time error occurs in door                         *
 ****************************************************************************/
 void   shut_down(void) {
    if(OPENED && !CLOSED) {
        close_door();
        CLOSED = TRUE;
    }
}

/*****************************************************************************
 *  Print (XXX used, XXX left)  (time in minutes)                            *
 *****************************************************************************/
void display_time(void) {
        color(yellow);
        s_puts("(");
        color(green);
        s_printf("%d used, ", system_time_used()+prev_used);
        color(red);
        s_printf("%d left",  mins_left_system()+time_credit);
        color(yellow);
        s_puts(") ");
 }

/*****************************************************************************
 *  Prints messages, enter with msg table to use                             *
 *****************************************************************************/
void    print_msg(short index, char **msg_table) {
    printf(msg_table[index]);
}

/*****************************************************************************
 *  Send a single byte to the remote only                                    *
 *****************************************************************************/
void    send_byte(BYTE data) {
    BYTE byte_out[2];
    *byte_out = data;
    *(byte_out+1) = 0x00;
    transmit_data(byte_out);
}

/****************************************************************************
 * This #if is needed since TURBOC has it's own random() function           *
 * This is needed for this demo source code only.                           *
 ****************************************************************************/
#if COMPILER == MICROSOFT
    int   random(short Modulo) {
        short   seed;
	check_time_left();
        seed = system_time_HHMMSS[7] - 0x30;    /* Strip ASCII off */
        return(RAND(seed));
    }
#endif

/****************************************************************************
 *    Read a WWIV v.4.07 or later CHAIN.TXT file.                           *
 ****************************************************************************/
short   read_WWIV(void) {
struct  ckitgeneric  *ck_info;
char    dump[256];
char    *des, *src, *str_ptrs[30];
size_t  bytes_read;
short   wwiv_handle, i;
float   fl;
ck_info = &ck_gen;

    if(!(des = create_buffer(BUFFER_SIZE))) {
	return(9);
    }
    if(!(wwiv_handle = open_file("chain.txt"))) {
	free(des);
	return(1);
    }
    if(!(bytes_read = ck_read_record(wwiv_handle, des, BUFFER_SIZE))) {
	free(des);
	return(1);
    }
    dosclose(wwiv_handle);
    parse_to_C(des, bytes_read, &str_ptrs[0], sizeof(str_ptrs)/sizeof(void *));
    ck_user_record = atoi(str_ptrs[0]);

    /* Copy fullname and firstname */
    strncpy(ck_fullname,str_ptrs[2], sizeof(ck_fullname)-1);
    i=1;
    src = str_ptrs[2];
    des = &ck_firstname[0];
    while((i < sizeof(ck_firstname)) && (*src != 0x20)) {
        *des++ = *src++;
        i++;
    }
    *des = '\0';        /* NULL terminate */

    /* Set user page length */
    ck_page_length = atoi(str_ptrs[9]);

    /* Set security levels */
    strncpy(ck_security_level, str_ptrs[10], sizeof(ck_security_level)-1);
    ck_user.security = atoi(str_ptrs[10]);  /* For status line */

    /* Set graphics mode */
    if((ck_graphics = atoi(str_ptrs[13])) != 0) { /* OK to use ANSI? 0=No 1=YES */
        ck_set_ANSI(ck_graphics);       /* Turn on ANSI in CKIT */
    }

    /* Set up ck_open_door() info in ck_gen structure */
    /* Read com port */
    strcpy(ck_info->port, "COM0:");        /* Local is default */
    if(atoi(str_ptrs[14])) {               /* Local or Remote? 0 = LOC 1 = REMOTE */
        ck_info->port[3] = *str_ptrs[20];  /* Set port number */
    }

    /* Read secs left, convert to mins */
    sscanf(str_ptrs[15],"%f",&fl);
    ck_info->min_left = (double)fl/60;

    /* Read rest of information for status line */
    strncpy(ck_baud_rate, str_ptrs[19], sizeof(ck_baud_rate)-1);
    strncpy(ck_bps_open, str_ptrs[19], sizeof(ck_baud_rate)-1);
    strncpy(ck_BBSname, str_ptrs[21], sizeof(ck_BBSname)-1);
    free(des);
    strcpy(ck_node, "0");           /* So status line looks correct */
    return(0);
}

/*****************************************************************************
 *  Open a file for read only, share deny none                               *
 *****************************************************************************/
short  open_file(char *filename) {
short filehandle;
#if COMPILER == MICROSOFT
    if ((dosopen(filename, O_RDONLY | SH_DENYNO, &filehandle)) != 0) {
        return(FALSE);
    }
#else    /* TURBO C */
    if ((filehandle = dosopen(filename, O_RDONLY | O_DENYNONE)) == -1) {
        return(FALSE);
    }
#endif
return(filehandle);
}

/*****************************************************************************
 *  Read buffersize bytes from file to buffer pointer                        *
 *****************************************************************************/
size_t ck_read_record(short handle, BYTE *record, size_t readcount) {
short    bytes_read;

#if COMPILER == MICROSOFT
    if ((dosread(handle, record, readcount, &bytes_read)) != 0) {
	return(FALSE);
    }
#else   /* TURBO C */
    if((bytes_read = dosread(handle, record, readcount)) == -1) {
	return(FALSE);
    }
#endif
return(bytes_read);
}

/*****************************************************************************
 *  Allocate a buffer for file use                                           *
 *****************************************************************************/
char * create_buffer(size_t size) {
char *buffer;
if ((buffer = (char *)malloc(size)) == NULL) {
    return(FALSE);
}
return(buffer);
}

/*****************************************************************************
 * Parse strings ending (with 0D/AH) to NULL terminated 'C' strings          *
 * Enter with buffer to parse and size of buffer.                            *
 * It will write the C strings back to the same buffer it is reading from    *
 * and return the number of line converted (strings)                         *
 *****************************************************************************/
short   parse_to_C(register char *buffer, size_t bytes_to_do, char **dat_ptrs, short array_size) {
register char    *buffer1;
short   line_number = 0;

buffer1 = buffer;
dat_ptrs[line_number] = buffer;
while((bytes_to_do != 0) && (line_number < array_size)) {
    if(*buffer != 0x0D && *buffer != 0x1A) {  /* Check if C/R or EOF     */
            if(*buffer == '\0') {
                dat_ptrs[line_number] = buffer1+1; /* Save ptr to string */
            }
            *buffer1++ = *buffer++; /* copy byte                         */
            bytes_to_do -= 1;       /* Decrement number of bytes to do   */
    } else {
	if(*++buffer == 0x0A) {     /* Check for line feed               */
            *buffer = '\0';         /* Terminate string with NULL        */
            line_number += 1;       /* Increment line counter            */
	} else {
            *buffer1++ = *buffer;
        }
        bytes_to_do -= 1;           /* Decrement number of bytes to do   */
    }
}
return(line_number);                /* Return number of lines read       */
}
/****************************************************************************/
/************************ E N D  O F   M O D U L E **************************/
