; ----- CONNECT: Autoanswer script
; ----------------------------------------------------------------
;	Note: This script waits for a received call.  It auto-bauds
;	according to the modem's CONNECT response.  It initializes
;	COM-AND to chat mode, CR -> CRLF, and CLOGs the fact.
; ----------------------------------------------------------------
;	Note: The hard coded autoanswer command here may need
;	recoding according to your modem.
; ----------------------------------------------------------------
;
;	Initialize
;
	ON ESCAPE GOSUB EXIT		; Escape pressed
	SET PARITY NONE 		; Turn off parity
	SET DATA 8			; Set 8 databits
	SET MASK ON			; Mask received text to 7 bits
;
;	Go into auto answer (echo off, answer on 2nd)
;	.. Also: Return result codes, word form, with CONNECT 1200
;
Restart:
	LEGEND " Waiting for call"
	Pause 3 			; Wait 3 seconds
	HANGUP				; HANGUP and leave modem in cmd mode
	PAUSE 3 			; Wait 3 secs
	MESSAGE "^MWaiting..."
	TRANSMIT "ATE0Q0V1X1S0=2 S7=30 S9=10^M"
;
; -----------------------------------------------------------------------
; ----- Wait for a connect
; -----------------------------------------------------------------------
;
Wait_Connect:
	RGET S9 80 180			; Wait for a line
	IF NOT SUCCESS			; If nothing was read
	   GOTO Wait_Connect
	   ENDIF

	FIND S9 "NO CARRIER"            ; Look for a disconn
	IF FOUND
	   GOTO Restart
	   ENDIF

	FIND S9 "CONNECT"               ; Anything else BUT CONNECT
	IF NOT FOUND			; .. waits
	   GOTO Wait_Connect
	   ENDIF

;***	IF NOT CONNECTED		; SOme modems aren't fast enough
;***	   GOTO Wait_Connect		; .. to set this right away
;***	   ENDIF
;
; -----------------------------------------------------------------------
; ----- Change baud rate according to connect
; -----------------------------------------------------------------------
;
	FIND S9 "1200"                  ; Test for 1200 baud
	IF FOUND			; IF found
	   SET BAUD 1200		; Set to 1200 baud
	   GOTO Finish			; We're done.
	   ENDIF

	FIND S9 "2400"                  ; Test for 1400 baud
	IF FOUND			; IF found
	   SET BAUD 2400		; Set to 1400 baud
	   GOTO Finish			; We're done.
	   ENDIF
;
;	None of the above... set to 300
;
	SET BAUD 300			; Set to 1200 baud
;
;	Exit - set-up for conversational mode
;
Finish:
	SET CHAT ON			; Set chat mode
	SET CR CR_LF			; Incoming Cr's as CRLF
	CLOG "* Auto-answer"            ; Log it
	ALARM				; Sound alarm
;
;	The exit is separately labelled to allow ESC to terminate quickly
;
Exit:
	EXIT
