/****************************************************************************/
/*   FILE JMODEM_B.C                                                        */
/*   Created 11-JAN-1990            Richard B. Johnson                      */
/*                                  405 Brougton Drive                      */
/*                                  Beverly, Massachusetts 01915            */
/*                                  BBS (508) 922-3166                      */
/*                                                                          */
/*   get port();         (Parse, get ASCII port)                            */
/*   get_inp();          (Parse, get filename)                              */
/*   get_fun();          (Parse, get function S,R )                         */
/*   get_prt();          (Convert ASCII port to numeric offset)             */
/*                                                                          */
/****************************************************************************/
#include <stdio.h>                              /* Used for _puts();        */
#include <string.h>                             /* Used for _strcpy(), etc  */
#include "jmodem.h"                             /* JMODEM primatives        */
/****************************************************************************/
/*                            Get filename                                  */
/****************************************************************************/
byte *get_inp (word argc, register char *argv[])
{
    register char *name;                   /* Filename string pointer       */
    if (argc > 2)                          /* Check command-line parameters */
    {
        name = argv[2];                    /* Copy the file name pointer    */
        do
        {                                  /* Cheap _toupper()              */
            if ( ( *name <  0x7B )         /* Check upper limit             */
              && ( *name >  0x60 ) )       /* Check lower limit             */
                   *name &= 0x5F;          /* Map to upper case             */
        } while (*(++name));               /* Until the NULL character      */
    return argv[2];                        /* Return a pointer to the name  */
    }
    return (byte *) 0x0000;
}
/****************************************************************************/
/*                          Get function  (S or R)                          */
/****************************************************************************/
byte get_fun(word argc, register char *argv[])
{
    if (argc > 2)                               /* Command-line parameters */
    {
        *argv[1] &= 0x5F;                        /* Map to upper case      */
        if (*argv[1] == 'S' || *argv[1] == 'R')  /* Check valid parameters */
            return *argv[1];                     /* Either 'R' or 'S'      */
    }
    return (byte) 0x00;                          /* Else NULL              */
}
/****************************************************************************/
/*                      Get port ASCII number (1 - 4)                       */
/****************************************************************************/
word get_port(word argc, register char *argv[])
{
    if (argc > 2)                               /* Command-line parameters  */
    {
        if (*(++argv[1]) > '0' && *argv[1] < '5') /* Check for valid ports  */
            return ((word)
                    *argv[1] - '0');            /* Return binary port value */
        if (*argv[1] == '(')                    /* Delimiter for port value */
        {
            word abs_port;
            word abs_irq;
            char test;
            argv[1]++;                          /* Get past the delimiter   */
            sscanf(argv[1],"%x%c%x",&abs_port,  /* Extract port address     */
                                    &test,      /* Extract the delimiter    */
                                    &abs_irq);  /* Extract IRQ number       */
            if (test != ':')                    /* Check the delimiter      */
                return (word) 0x0000;           /* Bad delimiter ret error  */
            abs_irq = abs_irq << 12;            /* Adjust position          */
            abs_port = abs_port | abs_irq;      /* OR in the IRQ            */
            return abs_port;                    /* Return complex result    */
        }
    }
    return (word) 0x0000;
}
/****************************************************************************/
/************************ E N D  O F   M O D U L E **************************/
