;-----------------------------------------------------------------------
; POSTLINK.rs -- Robocomm script to do PCRelay mail runs on PCBoard
;                systems running the POSTLINK net-mail system.
;
;   Author: Dan Parsons
;  Version: 1.1 -- 12/19/94
;
;     NOTE: You may want to update the TIMEOUT value indicated below
;           if you have problems with Robocomm timing out while the
;           BBS is scanning.
;
;-----------------------------------------------------------------------
TITLE "PostLink Mail run for PCBoard"
 
    PARAMETER 1 "Enter the PostLink door # or name"
    PARAMETER 2 "Enter the door password (optional)"
    PARAMETER 3 "Enter the path\name of the PREAMBLE"
    PARAMETER 4 "Enter the path\name of U### file"
    PARAMETER 5 "Enter the path\name of D### file"
    PARAMETER 6 "Enter the conference to join first"
    PARAMETER 7 "Hang up after D/L (Y=Yes/N=No)"
    ENDPARAMS

    ; Check to make sure that our preamble and U### files exist where we
    ; expect them to be
    IF NOT EXIST "%P3%" GOTO NO_PREAMBLE
    IF NOT EXIST "%P4%" GOTO NO_UFILE
    IF EXIST "%P5%" GOTO DFILE_FOUND

    ; Want a special capture log of the session?
    ; If so, un-comment the following line
    CAPTURE "POSTLINK.LOG" OVERWRITE

    ; Set the timeout value on the next line to however many seconds you think
    ; it might take for the BBS to start sending your D### packet:
    TIMEOUT 360

    ; Get to the proper conference
    VENUE MAIN
    IF NOT EMPTY "%P6%" JOIN "%P6%"

    ; Send the door number
    SEND "OPEN %P1%|"

    ; Send the password if one was eneterd
    IF NOT EMPTY "%P2%" SEND "%P2%|"

    ; Watch for part of the Zmodem header
    WAITFOR "PREAMBLE" FAILURE GOTO IM_LOST

    ; Send the preamble via internal Zmodem
    UPLOAD "%P3%" USING "ZMODEM"
    SEND "|"

    ; Watch for part of the Zmodem header
    WAITFOR "*" FAILURE GOTO IM_LOST

    ; Send the U### packet via internal Zmodem
    UPLOAD "%P4%" USING "ZMODEM"
    SEND "|"

    ; Wait for the door to start sending the D### packet
    WAITFOR "*" FAILURE GOTO IM_LOST

    ; Download the D### packet using internal zmodem
    DOWNLOAD "%P5%" USING "ZMODEM"

    IF YES "%P7%" GOSUB END_CALL
    IF NOT YES "%P7%" GOSUB STICK_AROUND

    CLOSE

EXIT 0

:END_CALL
    SEND "H|"
    DELAY 2
    HANGUP
RETURN

:STICK_AROUND
    CLEAR
    WAITFOR "PRESS SPACE BAR"
    SEND " "
    WAITFOR "DONE." FAILURE GOTO IM_LOST
    VENUE MAIN
RETURN

:IM_LOST
    MESSAGE "! Timeout in script"
    CLOSE
EXIT 1

:NO_PREAMBLE
    MESSAGE "! Unable to locate the %P3% (preamble) file."
EXIT 1

:NO_UFILE
    MESSAGE "! Unable to locate the %P4% (U###) file."
EXIT 1

:DFILE_FOUND
    MESSAGE "! %P5% (D###) already exists."
EXIT 1

; End of script file
