%LET Month = JAN;
   * Month is a constant.  Change to suit the data you analyze *;
                                 *                                   *
                                    DOCUMENTATION AT END OF PROGRAM
                                 *                                   * ;
OPTIONS NODATE ;
CMS FILEDEF DATS DISK CONSULT &MONTH A;
TITLE1 "CONSULTING LOG:  &MONTH 1988";



*=====================================================================*;
PROC FORMAT;       /* LIBRARY=LIBRARY; */
     VALUE $SYSTEM
           'APPLE','APPLEMAC','MAC','MACINTOSH',
           'MAC/PC','MAC/VAX','MACS',
           'MAC+','MACSE','MAC2','MACII'                          = 'MAC'

           'NAS','NASVM','NAS-VM','VM','VMCMS','VM/CMS',
           'CMS','VMPC','VM/PC','VMVAX'                        = 'VM/CMS'

           'IBMPC', 'APPLEIIC','APPLE2C', 'APPLE2E','APPLEIIE',
            'PC','MICRO','MICROS','IBM/PC','ZENITH', 'IBM-PC',
            'PCMAC','PC248','386PC','MSDOS','MS-DOS','MS DOS',
            'Z-100','Z1DISK','Z100','COMMODOR', 'PC(WANG)',
            'PC(200)','IBMSYS6','KAYPRO','LEADEDGE',
            'APPLEII','CSVENUS','IMBPC','COMPAQ','Z-159','Z159',
            'PS2','386','286','PS-2','PS/2','PC&MAC','PC/VM'       = 'PC'

           'VAX','VAX/VMS','VAXVMS','VMS','VAX-VMS','VAX/MAC',
           'MICROPRN','MICROPRI','MICROPRT'                       = 'VAX'

           'VAX/NAS','NAS/VAX','VAXNAS','NASVAX','NAS&VAX',
           'VAX&NAS','VMVMS','VMSVM', 'VM/VMS','VMS/VM',
           'BOTH','MAINFRAM','MAINFRAE','MAINFRM'           = 'VAX & NAS'

           'PLOT','PLOTS','PLOTTER'                           = 'PLOTTER'

           'BITNET','INTERNET','JNET','TELNET','TCPIP',
           'NSFNET','ETHERNET','APPLETAL','APPLETLK','TOPS',
           'NETS','NETWORKS','PSN','KUPSN'                   = 'NETWORKS'

           'IBM','IBMCICS','IBM/NAS','MVS','OLC','OCAT',
           'ONLIN','.LC','LC','CICS','ONLINE','IMB'               = 'MVS'

           'SUPER','SUPERCOM','CRAY'                   = 'SUPER COMPUTER'

           'GENINFO','WUP','WUPS','ALL','GENERAL','WRITEUP'   = 'GENINFO'
           ;

     VALUE $DEPT
           'ANTH','ANTHRO','ANTHROP','PALEO','ANTHR'           = 'ANTHRO'
           'ARCH','ARCHITEC','UBPL'                          = 'ARCHITEC'
           'BIO','BIOL','ENTYM','ENTOM','MICROBIO',
           'BOTANY','BIOLOG','BIOLO','BIOLOGY'                = 'BIOLOGY'
           'BUS','BUSINESS','BUSN','BIZ'                     = 'BUSINESS'
           'CHEM','PCHEM','CHEMISTY','CHEMISTR','CHEMIST'   = 'CHEMISTRY'
           'COM','COMM','COMS','COMMS','SPEECH','SPLH',
           'COMMUN','COM STUD','COMMSTUD'                    = 'COMMUNIC'
           'ECON','ECONOM','ECONOMIC'                            = 'ECON'
           'EPR','ED','EDUC','CPSY','COUNSPSY','COUN PSY','COUNSEL',
           'C&I','CI','EPA','SPEC ED','SPED','EDU','EDUCATIO',
           'EDUCATIN','ED PSYC', 'C.PSY','COUNPSYC',
           'ED-C&I','C & I','CONT ED'                         = 'EDUC'
           'ECE','CE','CHEMENG','C&PE','AE','E&CE','ENGR',
           'EE','CPE','CHEM ENG','PETR ENG','CHEM E','E & CE',
           'C E','ME','ENGIN','CIV ENGR','AEC','AEROSP',
           'AERO'                                            = 'ENGINEER'
           'ART HIST','MUS HIST','THEATER','ART MUS','ART',
           'FINEARTS','ART&DES'                               ='FINEARTS'
           'GEOG','GEOGR'                                   = 'GEOGRAPHY'
           'GEO','GEOL','KGS'                                 = 'GEOLOGY'
           'HS','HIGH SCH'                                    ='HIGH SCH'
           'I/O','COMP CNTR','COMP','INT','INTERN','INTERNAL',
           'COMP CTR','ACS','OIS','ACS-OPER','OPERATIN',
           'OPERATIO','OPERATIOS'                             ='INTERNAL'
           'MED','MED CENT','KUMED','KUMC','MEDCTR',
           'NURSING','MED CTR'                                 = 'KUMED'
           'LA','LIBARTS','LIBERAL','LIB ART','LAS','LIBART',
           'SPANISH','ENGLISH'                                = 'LIBERAL'
           'MUS','MUSIC'                                        = 'MUSIC'
           'NATHIST','NAT HIST','NATLHIST'                    ='NAT HIST'
           'PHAR','PHARM','PHARMCHEM','PHAR/CM','MED CHEM',
           'PHARM CE','PHARMACY','PHARMCHM'                   ='PHARMACY'
           'PHSX','PHYS'                                       ='PHYSICS'
           'POL','POLS','POLSCI','POL SCI','POLIT SC',
           'POLISCI','SOVIET','LATIN AM'                      ='POLI SCI'
           'PSY','PSYC','PSYCH','PSYCHOL','PSYCHOLY','PSYCHO',
           'PSYCHOLO'                                          ='PSYCHO'
           'PUB','PUB AD','PUBADM','PUB ADM','PUB ADMI'      ='PUB ADMIN'
           'SOC','SOCIO','SOCIOLOG','SOCIOL'                 ='SOCIOLOGY'
           'SOC WEL','SOC WELF'                             ='SOCIAL WEL'
            ;


      VALUE MOON 1='JAN' 2='FEBR' 3='MAR' 4 = 'APR' 5='MAY' 6='JUNE'
                7='JULY' 8='AUG' 9='SEPT' 10='OCT' 11='NOV' 12='DEC';
      VALUE STARTGRP 1='8-10 am' 2='10-Noon' 3='1-3 pm' 4='3-5 pm';
      VALUE WINDOGRP 1='10-Noon' 2='1-2:30' 3='2:30-4';
      VALUE $MODE 'C','D','W' = 'WINDOW' 'P' = 'PHONE'
                  'F' = 'FACE' 'Q' = 'QUESTION';
      VALUE $RANK 'U'= 'UNDERCLASS' 'F'='FACULTY' 'S'='STAFF'
                  'G'= 'GRAD' 'A'='ADMIN' 'T'='TA' 'R'='RA'
                  'I'='INTERNAL' 'O'= 'OTHER';


*=====================================================================*;
DATA SASDAT.&MONTH;
     INFILE DATS ;
     INPUT SYSTEM $8. DEPT $8. CLASSNUM 3. RANK $1. MODE $1.
           PROBLEM $25. COMMENT $25. START TIME5. ELAPSED TIME8.
           DATE MMDDYY8. INITIALS $3.;

     IF ELAPSED GT 7200 THEN ELAPSED = 1200;
 * Correction factor.  If Elapsed GT 2 hours, set it to 20 minutes *;


 *- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*;
   /* Divide time-of-day (seconds from midnight) into quadrants  */

     IF START  <= 35940             THEN STARTGRP = 1;   /* 8-10 am */
        ELSE IF START GE 36000 AND START LE 46740
                                    THEN STARTGRP = 2;  /* 10-12:30 */
        ELSE IF START GE 46800 AND START LE 54000
                                    THEN STARTGRP = 3;     /* 1-3 */
                                    ELSE STARTGRP = 4;     /* 3-5 */

      /* Same as above but for consult-window times */
     IF START GE 36000 & START LE 43200 THEN WINDOGRP = 1;  /* 10-12 */
        ELSE IF START GE 46800 & START LE 52199 THEN WINDOGRP = 2;
        ELSE IF START GE 52200 & START LE 59400 THEN WINDOGRP = 3;
 *- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*;





 *- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*;
                 /* Categorize PROBLEMS */
   /*  Find an identifying string and collapse into categories  */

     A1='EMAC'; A2='EDIT'; A3='XED'; A4='STEDI'; A5='WP'; A6='WS';
     A7='WORD'; A8='MACW'; A9='TEX'; A10='PAGEM';        /*Text editing*/

     B1='SPSS'; B2='SAS'; B3='BMDP';
     B4='IMSL';B5='MINI'; B6='NTSYS'; B7='MAPLE';        /*Stats & Math*/

     C1='LOTUS'; C2='DBASE'; C3='EXCEL'; C4='FOX';   /*Lotus,Dbase,etc*/

     D1='BATCH';                                                /*BATCH*/

     E1='DIAL'; E2='TERM'; E3='SIGN';
     E4='LOG'; E5='OCAT'; E6='ONLI';
     E7='CONN'; E8='ACCE'; E9='.LC';                           /*ACCESS*/

     F1='KERM';                                                /*KERMIT*/
     G1='FORTR'; G2='PASCA'; G3='TURBO';
     G4='LANGU'; G5='BASIC'; G6=' C '; G7='ADA'; G8='LISP';
                                                            /*LANGUAGES*/
     H1='MAIL';                                                  /*MAIL*/
     I1='WORKSH';                                           /*WORKSHOPS*/
     J1='PRIN'; J2='LASER';                                  /*PRINTING*/
     K1='TAPE';                                                  /*TAPE*/
     L1='NET'; L2='LANS'; L3='FTP';                          /*NETWORKS*/
     M1='WUP'; M2='WRITEUP';                                 /*WRITEUPS*/
     N1='SCANN';                                              /*SCANNER*/
     O1='GRAP'; O2='PLOT'; O3='SURF'; O4='CTRL';             /*GRAPHICS*/

     P1='FILE'; P2='UPLOAD';
     P3='DOWNLO';                                     /*FILE OPERATIONS*/
     Q1='DISK';                                              /*DISK OPS*/
     R1='VIRUS'; R2='VACCI'; R3='INFEC';                        /*VIRUS*/


     ARRAY TEXTEDIT  $6 A1-A10;
     ARRAY STATS $5 B1-B7;
     ARRAY SPREADS $5 C1-C4;
     ARRAY ACCESS $4 E1-E9;
     ARRAY LANGS $5 G1-G8;




 /* Now do a search for above-specified strings, then group them */

     DO OVER TEXTEDIT;
        IF INDEX(PROBLEM,TEXTEDIT) > 0 THEN PROBGRP='TEXTEDIT';
     END;
     DO OVER STATS;
        IF INDEX (PROBLEM,STATS) GT 0 THEN PROBGRP='STATPACKS';
     END;
     DO OVER ACCESS;
        IF INDEX (PROBLEM,ACCESS) GT 0 THEN PROBGRP='ACCESS';
     END;
     DO OVER LANGS;
        IF INDEX (PROBLEM,LANGS) GT 0 THEN PROBGRP='LANGUAGES';
     END;

     IF INDEX (PROBLEM,J1) GT 0 OR INDEX (PROBLEM,J2) GT 0
                                                 THEN PROBGRP='PRINTING';
   * (Want Print problems to override any other problems above);


    DO WHILE (PROBGRP EQ ' ');    /* Do if PROBGRP still has no value  */

     DO OVER SPREADS;
     IF INDEX (PROBLEM,SPREADS) GT 0 THEN PROBGRP = 'DB/LOTUS';
     END;
           IF INDEX (PROBLEM,D1) GT 0 THEN PROBGRP='BATCH';
      ELSE IF INDEX (PROBLEM,F1) GT 0 THEN PROBGRP='KERMIT';
      ELSE IF INDEX (PROBLEM,H1) GT 0 THEN PROBGRP='MAIL';
      ELSE IF INDEX (PROBLEM,I1) GT 0 THEN PROBGRP='WORKSHOP';
      ELSE IF INDEX (PROBLEM,K1) GT 0 THEN PROBGRP='TAPE';
      ELSE IF INDEX (PROBLEM,L1) GT 0 OR INDEX (PROBLEM,L2) GT 0
           OR INDEX (PROBLEM,L3) GT 0 THEN PROBGRP='NETWORKS';
      ELSE IF INDEX (PROBLEM,M1) GT 0 OR INDEX (PROBLEM,M2) GT 0
                                                 THEN PROBGRP='WRITEUPS';
      ELSE IF INDEX (PROBLEM,N1) GT 0 THEN PROBGRP='SCANNER';
      ELSE IF INDEX (PROBLEM,O1) GT 0 OR INDEX (PROBLEM,O2) GT 0
           OR INDEX (PROBLEM,O3) GT 0 OR INDEX (PROBLEM,O4) GT 0
                                                 THEN PROBGRP='GRAPHICS';
      ELSE IF INDEX (PROBLEM,P1) GT 0 OR INDEX (PROBLEM,P2) GT 0
           OR INDEX (PROBLEM,P3) GT 0  THEN PROBGRP='FILE OPS';
      ELSE IF INDEX (PROBLEM,Q1) GT 0 THEN PROBGRP='DISK OPS';
      ELSE IF INDEX (PROBLEM,R1) GT 0 OR INDEX (PROBLEM,R2) GT 0
           OR INDEX (PROBLEM,R3) GT 0 THEN PROBGRP='VIRUS';

      ELSE PROBGRP='OTHER';
     END;
    *- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*;


     SYSTEM=COMPRESS (SYSTEM);  /* REMOVE BLANKS BEFORE FORMATTING */
                            /* SO WE DON'T LOOK FOR IBM PC & IBMPC */

     DAY = DATE;   /* Retain original Date variable but make a new */
                    /* var so we can do things by Mon, Tues, etc. */

       IF PUT(DAY,WEEKDATE9.) = '   MONDAY' THEN DAYORDER=1;
          ELSE IF PUT(DAY,WEEKDATE9.) = '  TUESDAY' THEN DAYORDER=2;
          ELSE IF PUT(DAY,WEEKDATE9.) = 'WEDNESDAY' THEN DAYORDER=3;
          ELSE IF PUT(DAY,WEEKDATE9.) = ' THURSDAY' THEN DAYORDER=4;
          ELSE IF PUT(DAY,WEEKDATE9.) = '   FRIDAY' THEN DAYORDER=5;
          ELSE IF PUT(DAY,WEEKDATE9.) = ' SATURDAY' THEN DAYORDER=6;
          ELSE IF PUT(DAY,WEEKDATE9.) = '   SUNDAY' THEN DAYORDER=7;

     IF ELAPSED GT 7200 THEN ELAPSED = 1200;
 * Correction factor.  If Elapsed GT 2 hours, set it to 20 minutes *;

     WHEN=13;    ****** CHANGE THIS SOMEDAY   ***********;

     LABEL
       SYSTEM = 'WHAT SYSTEM'
       STARTGRP = 'TIME-OF-DAY'
       WINDOGRP = 'WINDOW TIMES'
       PROBGRP = 'PROBLEM CATEGORIES';


     FORMAT START HHMM.
            ELAPSED HHMM.
            DATE WEEKDATE11.
            DAY  WEEKDATE9.
            SYSTEM $SYSTEM.
            STARTGRP STARTGRP.
            RANK $RANK.
            MODE $MODE.
            WINDOGRP WINDOGRP.
            DEPT $DEPT.;
*=====================================================================*;



PROC SORT;  BY DAYORDER WINDOGRP;

DATA WINDOW;
     SET SASDAT.&MONTH;
         IF MODE = 'C' OR MODE = 'W' OR  MODE = 'D';

PROC TABULATE  DATA=SASDAT.&MONTH  FORMCHAR = '           '
     ORDER = DATA;
     CLASS DAY;
     VAR ELAPSED;
     KEYLABEL
          MEAN='Avg Time Per Question'
          SUM=' Total  Hrs:Min'
          ALL="&MONTH TOTALS";
     TABLE DAY ALL, ELAPSED *(N*F=4. (MEAN SUM)*F=HHMM8.) /
           BOX='    Logged   Consulting Time'  RTS=18;

PROC TABULATE  DATA=WINDOW  FORMCHAR = '           '
               ORDER = DATA;
     CLASS DAY WINDOGRP;
     VAR ELAPSED;
     KEYLABEL
          MEAN='Avg Time Per Question'
          SUM=' Total  Hrs:Min'
          ALL="&MONTH WINDOW TOTALS";
     TABLE DAY*WINDOGRP ALL, ELAPSED *(N*F=4. (MEAN SUM)*F=HHMM8.) /
           BOX= 'Logged Time At       THE WINDOW'
             RTS=22;

PROC FREQ DATA=SASDAT.&MONTH;
          TABLES STARTGRP;



PROC CHART DATA = SASDAT.&MONTH;
     PIE MODE / SUMVAR=ELAPSED;
TITLE3 'CONSULTING TIME SPENT IN EACH MEDIUM';

PROC SORT; BY START;
TITLE3 'WHEN ARE CONSULTANTS CONSULTED';
PROC CHART;
     STAR START / midpoints=54000 52200 50400 48600 46800
                            45000 43200 41400 39600
                    37800 36000 34200 32400 30600 28800 27000 25200
                  66600 64800 63000 61200 59400 57600 55800;
                     /* MID=15:00, (14:30 ETC.) To 1600  */

DATA JULY;
     SET SASDAT.JUL;
     WHEN=7;
DATA AUGUST;
     SET SASDAT.AUG;
     WHEN=8;
DATA SEPT;
     SET SASDAT.SEP;
     WHEN=9;
DATA OCT;
     SET SASDAT.OCT;
     WHEN=10;
DATA NOV;
     SET SASDAT.NOV;
     WHEN=11;
DATA DEC;
     SET SASDAT.DEC;
     WHEN=12;
PROC FORMAT;
     VALUE WEN 7='JULY' 8='AUG'  9='SEPT' 10='OCT' 11='NOV' 12='DEC'
                13='JAN';


DATA ALLSIE;
     SET JULY AUGUST SEPT OCT NOV DEC SASDAT.&MONTH;
     LABEL WHEN='MONTH';
     FORMAT WHEN WEN.;
PROC CHART;
     VBAR WHEN/ DISCRETE;
TITLE3;

PROC TABULATE  DATA=SASDAT.&MONTH  FORMCHAR = '           '  ORDER = FREQ;
     CLASS DEPT;
     VAR ELAPSED;
     KEYLABEL
          SUM=' Total  Hrs:Min'
          ALL="&MONTH TOTALS";
     TABLE DEPT ALL, ELAPSED *(N*F=4. (SUM)*F=HHMM8.) /
           BOX='Time Spent on Each Department'  RTS=18;
TITLE3;

PROC TABULATE  DATA=SASDAT.&MONTH  FORMCHAR = '           '  ORDER = FREQ;
     CLASS PROBGRP;
     VAR ELAPSED;
     KEYLABEL
          SUM=' Total  Hrs:Min'
          ALL="&MONTH TOTALS";
     TABLE PROBGRP ALL, ELAPSED *(N*F=4. (SUM)*F=HHMM8.) /
           BOX='Time Spent on Each Type of Problem'  RTS=18;



PROC CHART DATA=SASDAT.&MONTH; HBAR DEPT / FREQ DESCENDING TYPE = FREQ;
     TITLE3 'HOW OFTEN EACH DEPARTMENT QUESTIONS US';

PROC CHART DATA=SASDAT.&MONTH; HBAR DEPT /NOSTAT DESCENDING SUMVAR = ELAPSED;
     TITLE3 'HOW MUCH TIME WE SPEND ON A DEPARTMENT';

PROC CHART DATA=SASDAT.&MONTH; VBAR PROBGRP / ASCENDING TYPE=FREQ;
     TITLE3 'HOW OFTEN SOME PROBLEM CATEGORIES ARISE';

PROC CHART DATA=SASDAT.&MONTH; VBAR PROBGRP / ASCENDING SUMVAR=ELAPSED;
     TITLE3 'HOW MUCH TIME WE SPEND ON SOME PROBLEM CATEGORIES';

/* DATA BOSH;
     SET SASDAT.&MONTH;
     IF COMMENT NE ' ';   */
PROC PRINT DATA=SASDAT.&MONTH;
     VAR PROBLEM COMMENT ELAPSED;
TITLE3 'PROBLEMS ARIZEN, COMMENTS MADE';

PROC FREQ DATA=SASDAT.&MONTH ORDER=FREQ;
          TABLES SYSTEM CLASSNUM RANK MODE PROBGRP
                 WINDOGRP DEPT;
TITLE3;


/* PROC TABULATE  DATA=WINDOW  FORMCHAR = '           '
               ORDER = DATA;
     CLASS DAY WINDOGRP PROBGRP;
     FORMAT DAY WEEKDATE3.;
     KEYLABEL
          ALL="TOTALS"
          N=' ';
     TABLE DAY?WINDOGRP ALL, (PROBGRP ALL)?(N?F=8.) /
           BOX= 'Consulting Window  Problems'
           RTS=14;
** This Proc temporarily taken out of service - - - lack of interest. **
*/
