Unit Do_type;

(*
Ŀ
                         Unidad DO_TYPE.PAS                                
Ĵ
   Versin             : 1.0                                               
   Computadora         : IBM-PC o compatible                               
   Lenguaje            : Turbo Pascal 5.5                                  
   Autor               : Bernardo Zamora Etcharren                         
Ĵ
   Unit that defines variables for all units.                              

*)

INTERFACE

Const
  MaxOpSize      = 6;  { maximum size of operation's names ie [sin,cos,...] }

  MaxConstantes  = 4;  { How many constants defined         }
  MaxOperaciones = 30; { number of UNARY operations defined
                         sin, con, tanh, log, abs,...       }
  MaxStack       = 50;  { maximum stack size                }


Type
  do_element = record     { for each node in the stack }
    tipo       : char;    { Operacion,Unitaria,Numero,Variable,'X',Parentesis }
    operacion  : string[MaxOpSize]; { +,-,*,log... or name_of_variable }
    numero     : real;
  end;
  Do_Stack    = array[0..50] of do_element;
  Rpn_type = record
    error      : integer;  { any error?            }
    message,               { error message         }
    fun_string,            { original expression   }
    rpn_string : string;   { new RPN expression    }
    s1         : do_stack; { stack with the RPN function to be evaluated }
    p1         : integer;  { # of [numbers & ops] in the RPN stack       }
  end;
  Constant_type = record
    letra : char;          { constant letter       }
    valor : real;          { value of the letter   }
    expln : string;        { explanation of letter }
  end;



Const
  Constantes  : array [1..MaxConstantes] of constant_type = (
  (letra:'E';valor:2.718281828;expln:'Eulers constant'),
  (letra:'G';valor:9.80665;expln:'Gravity constant'),
  (letra:'P';valor:3.1415926535897932385;expln:'Pi'),
  (letra:'C';valor:2.99792458E8;expln:'Speed of light') );

  Arreglo : array [1..MaxOperaciones] of string[MaxOpSize] = (

  'SIN'  ,   'COS'  ,  'TAN'  ,   'COT'  , 'SEC'  ,   'CSC'  ,
  'LN'   ,   'LOG'  ,  'INT'  ,   'ROUND',
  'FRAC' ,   'ABS'  ,  'SGN'  ,   'SQRT' ,
  'SINH' ,   'COSH' ,  'TANH' ,   'COTH' , 'SECH' ,   'CSCH' ,
  'ASIN' ,   'ACOS' ,  'ATAN' ,   'ACOT' , 'ASEC' ,   'ACSC' ,
  'RAD'  ,   'GRADOS', '-'    ,   'EXP'  ) ;

{ ------------ Error codes returned during conversion --------------- }

  ERROR_PUSH_S           = 'Error in Push';
  ERROR_PUSH             = 1;
  ERROR_PARENTESIS_S     = 'Check the parenthesis';
  ERROR_PARENTESIS       = 2;
  ERROR_POP_S            = 'Error in Pop';
  ERROR_POP              = 3;
  ERROR_UNRECOGNIZE_S    = 'Cant recognize : ';
  ERROR_UNRECOGNIZE      = 4;
  ERROR_PARENTESIS_VACIOS_S = 'Empty group of parenthesis';
  ERROR_PARENTESIS_VACIOS   = 5;
  ERROR_EXTRA_PARENTESIS_S  = 'Extra parentesis : ';
  ERROR_EXTRA_PARENTESIS    = 6;
  ERROR_WEIRD_PARENTESIS_S  = 'Error in parenthesis : different class or incorrect order';
  ERROR_WEIRD_PARENTESIS    = 7;
  ERROR_EXTRA_SYMBOL_S      = 'Extra symbol : ';
  ERROR_EXTRA_SYMBOL        = 8;
  ERROR_NO_OPERATION_S      = 'No operation to evaluate!';
  ERROR_NO_OPERATION        = 9;


{ ------------ Error codes returned during evaluation --------------- }

  ERROR_TANGENTE_S       = 'Tan(pi/2)';   ERROR_TANGENTE         = 1;
  ERROR_COTANGENTE_S     = 'Cot(0)';      ERROR_COTANGENTE       = 2;
  ERROR_SECANTE_S        = 'Sec(pi/2)';   ERROR_SECANTE          = 3;
  ERROR_COSECANTE_S      = 'Csc(0)';      ERROR_COSECANTE        = 4;
  ERROR_LN_S             = 'Ln(x<=0)';    ERROR_LN               = 5;
  ERROR_LOG_S            = 'Log(x<=0)';   ERROR_LOG              = 6;
  ERROR_SQRT_S           = 'Sqrt(x<=)';   ERROR_SQRT             = 7;

  ERROR_SIN_INV_S        = 'SinI(?)';     ERROR_SIN_INV          = 8;
  ERROR_COS_INV_S        = 'CosI(?)';     ERROR_COS_INV          = 9;
  ERROR_SEC_INV_S        = 'SecI(?)';     ERROR_SEC_INV          = 10;
  ERROR_CSC_INV_S        = 'CscI(?)';     ERROR_CSC_INV          = 11;

  ERROR_TAN_HIP_S        = 'TanH(?)';     ERROR_TAN_HIP          = 12;
  ERROR_COT_HIP_S        = 'CotH(?)';     ERROR_COT_HIP          = 13;
  ERROR_SEC_HIP_S        = 'SecH(?)';     ERROR_SEC_HIP          = 14;
  ERROR_CSC_HIP_S        = 'CscH(?)';     ERROR_CSC_HIP          = 15;

  ERROR_X_ENTRE_0_S      = 'x/0';         ERROR_X_ENTRE_0        = 16;

  ERROR_EXP_Y_BASE_NEG_S = 'r^(-b)';      ERROR_EXP_Y_BASE_NEG   = 17;


IMPLEMENTATION


begin
end.