//======================================================================

//  File:        bstring.h

//  Author:      Timothy A. Budd

//  Description: This file contains the interface of the bstring

//               class.

//

//  Copyright (c) 1992 by Timothy A. Budd.  All Rights Reserved.

//  Modified 1994 by Jeff Goke.  Renamed to BSTRING and some
//  functions added (as noted later in the file).

//======================================================================

 

#ifndef bstring_H

#define bstring_H

 

#include <iostream.h>

 

 

class subbstring;			// forward declaration

 

 

 

//----------------------------------------------------------------------

//	class bstring

//		better bounds checking, assignments which result

//		in copies, comparisons using relational operators,

//		high level operations such as subbstrings

//----------------------------------------------------------------------

 

class bstring

{

public:

    // constructors

    bstring();

    bstring(char);

    bstring(int);

    bstring(const char *);

    bstring(const bstring &);

 

    // destructor

    ~bstring();

 

    // counting functions -- added by jjgoke@norcia.cs.csbsju.edu

    int		 num_letters () const;

    int		 num_words () const;

    int	 	 ave_words () const;


    char *	 return_string () const;


    // assignment an catenation

    void         operator =  (const bstring & right);

    void         operator += (const bstring & right);

 

    // subbstring access

    subbstring    operator () (unsigned int start, unsigned int length);

 

    // input of an entire line of text

    istream &    getline(istream &);

 

    // number of characters in the bstring

    unsigned int length() const;

 

    // access to a single character

    char &       operator [](unsigned int) const;

 

    // compare - used in relational operators

    int          compare(const bstring &) const;

 

    // conversion to ordinary C bstring

    operator     const char *() const;

 

    // allow access by subbstring class

    friend class subbstring;

private:

    // data fields - character buffer and length

    unsigned short int bufferlength;

    char *             buffer;

};

 

 

 

//----------------------------------------------------------------------

//	class subbstring

//		facilitator class to permit access to

//		portions of a bstring

//----------------------------------------------------------------------

 

class subbstring

{

public:

    // constructors

    subbstring(bstring & base, int start, int length);

    subbstring(const subbstring & source);

 

    // assignment of bstring to subbstring

    void operator = (const bstring &) const;

 

    // conversion of subbstring to bstring

    operator bstring () const;

 

private:

    // data areas

    bstring &        base;

    const short int index;

    const short int count;

};

 

 

 

// Function Prototypes: relational operators

 

int    operator <  (const bstring &, const bstring &);

int    operator <= (const bstring &, const bstring &);

int    operator != (const bstring &, const bstring &);

int    operator == (const bstring &, const bstring &);

int    operator >= (const bstring &, const bstring &);

int    operator >  (const bstring &, const bstring &);

 

 

 

// Function Prototype: concatenate operator

 

bstring operator +  (const bstring &, const bstring &);

 

 

 

// Function Prototypes: character classification

 

int isUpperCase(char c);

int isLowerCase(char c);

 

 

 

// Function Prototypes: bstring conversions

 

void toUpper(bstring & word);

void toLower(bstring & word);

 

 

// Function Prototype: stream input

 

istream & operator >> (istream & in, bstring & str);

 

 

 

#endif

