#include <stdio.h>
#include <string.h>
#include "gifford.h"

// function by jeff goke
int	gifford::weeknum (int month, int day, int year)
	{
	int result = day + DayOfWeek (month, day, year) - 1;
	result = result / 7;
	result = result + 1;

	return result;
	}


// function by Jeff Goke
int	gifford::timesoccured (int day, int month, int year)
	{
	int look_for = DayOfWeek (day, month, year);

	int result = 0;

	for (int i = 1; i <= day; i++)
		{
		if (DayOfWeek(i,month,year) == look_for)
			result++;
		}

	return result;
	}

// this function by jeff goke
bstring gifford::pretty_date (int month, int day, int year)
	{
	bstring result;

	result = MonthName(month);
	result += " ";
	if (day < 10)
		result += char(day+48);
	else
		{
		int ten = day/10;
		int one = day - (ten*10);


		result += char(ten+48);
		result += char(one+48);
		}
	result += ", ";
	int thou = year/1000;
	int hund = (year - (thou*1000)) / 100;
	int tens = (year - (thou*1000) - (hund*100)) / 10;
	int ones = (year - (thou*1000) - (hund*100) - (tens*10));

	result += char (thou+48);
	result += char (hund+48);
	result += char (tens+48);
	result += char (ones+48);

	return result;
	}



struct date gifford::ConvertGregorian(long JulianDate)
   {
   short DAYS[] = {0,0,31,59,90,120,151,181,212,243,273,304,334,365};
   short numDays;
   struct date d;
   d.da_mon = 1;

   d.da_year = (short)(JulianDate / 365.2475 + 1900);
   numDays = JulianDate - (d.da_year - 1900) * 365 - CountLeapYear(d.da_year,1900);
   while(DAYS[d.da_mon + 1] < numDays)
      d.da_mon++;
   d.da_day = numDays - DAYS[d.da_mon];
   return(d);
   } /* end of ConvertJulian */


unsigned short gifford::ConvertJulian(char day,char month,short year)
   {
   short DAYS[] = {0,0,31,59,90,120,151,181,212,243,273,304,334,365};
   long numDays;

   numDays = DAYS[month] + day;
   if(LeapYear(year) && month > 2)
      numDays++;
   numDays += ((year - 1900) * 365 + CountLeapYear(year,1900));
   return(numDays);
   } /* end of ConvertJulian */

short gifford::CountLeapYear(short year1,short year2)
   {
   short count = 0;
   short small;
   short large;

   small = year1 < year2 ? year1 : year2;
   large = year1 > year2 ? year1 : year2;
   for(small = small;small < large;small++)
      {
      if(LeapYear(small))
      count++;
      }
   return(count);
   } /* end of CountLeapYear */

short gifford::LeapYear(short year)
   {
   if(!(year % 4) && (year % 100 || !(year % 400)))
      return(1);
   else
      return(0);
   } /* end of LeapYear */

short gifford::DaysInMonth(char month,short year)
   {
   short DAYS[] = {0,0,31,59,90,120,151,181,212,243,273,304,334,365};
   char leapDay;

   if(month == 2 && LeapYear(year))
      leapDay = 1;
   else
      leapDay = 0;

   return(DAYS[month + 1] - DAYS[month] + leapDay);
   } /* end of DaysInMonth */

char gifford::DayOfWeek(char day,char month,short year)
   {
   return(ConvertJulian(day,month,year) % 7);
   } /* end of DayOfWeek */

char * gifford::MonthName(char month)
   {
   /*-------------------------------------------------------------------------
   **   Arrays to convert numbers to words.
   **
   **   Helpful hints:
   **      To get abbreviations use strncpy() for desired length.
   **      To get upper case use strupr().
   **      To get lower case use strlwr().
   */
   char *MONTHNAME[] = {"","January","February","March","April","May","June","July","August","September","October","November","December"};
   return(MONTHNAME[month]);
   } /* end of MonthName */

char * gifford::Number (int num)
	{
	switch (num)
		{
		case 1:
			return ("first");
		case 2:
			return("second");
		case 3:
			return ("third");
		case 4:
			return ("fourth");
		case 5:
			return ("fifth");
		}
	return ("ERROR");
	}


char * gifford::DayName(char day)
   {
   /*-------------------------------------------------------------------------
   **   Arrays to convert numbers to words.
   **
   **   Helpful hints:
   **      To get abbreviations use strncpy() for desired length.
   **      To get upper case use strupr().
   **      To get lower case use strlwr().
   */
   char *DAYNAME[] = {"Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"};
   return(DAYNAME[day]);
   } /* end of DayName */