#include "help.h"
#include "alter.h"
#include "update.h"
#include "messages.h"
#include <graphics.h>
#include "grafmess.h"



messages::messages (int m, int d, int y, bstring h, Mcursor & mouse, int c_mode) : the_data(10), the_mouse (mouse)
	{
	calendar_mode = c_mode;
	the_edit = -1;
	current = 0;
	found = 0;
	home = h;
	for (int i = 0; i < 10; i++)
		the_data[i].init(home);
	month = m;
	day = d;
	year = y;

//	the_mouse.arm ();
	}

messages::~messages()
	{
	}

void messages::gr_clear ()
	{
	the_mouse.hide();
	setbkcolor(BLACK);
	setfillstyle (SOLID_FILL,BLACK);
	bar (0,0,getmaxx(),getmaxy());

//	clearviewport();
//	cleardevice();
//	setbkcolor(BLACK);
	the_mouse.show();
	}

void messages::messages_help ()
	{
	bstring temp_filename = "IMPRO.HL4";
	bstring help_location = home + temp_filename;

	help the_help (the_mouse, help_location);

	the_help.show ();
	}


void messages::remove()
	{
	grafmess	the_graphics (the_mouse);

	int how_many = found - current;

	if (how_many > 5)
		how_many = 5;

	int option = the_graphics.remove_graphics(how_many);

	if (option > 0)
		{
		the_data[option + current - 1].remove();
		if (calendar_mode == 2)
			do_search ();
		else
			read ();

		if (current >= found)
			current -= 5;
		}
	}

void messages::read()
	{
	found = 0;

	gr_clear();

	reading_data();
	find();
	clear_reading_data();
	}


int messages::quickfind()
	{
	int got_one = 0;
	long int loc = 0;

	do
		{
		if (calendar_mode)
			loc = the_data[0].realquickfind (month, day, year, ++loc);
		else
			loc = the_data[0].quickfind (month, day, year, ++loc);


		if (loc)
			{
			got_one = 1;
			break;
			}
		}
	while (loc);

	return got_one;
	}

void messages::search(bstring the_string)
	{
	calendar_mode = 2;
	search_string = the_string;
	do_search();
	if (found == 0)
		{
		grafmess	the_graphics (the_mouse);
		the_graphics.no_match ();
//		the_mouse.show();
		return;
		}
	activate();

	return;
	}

void messages::activate()
	{
	int exit = 0;

	while (exit == 0)
		{
		if (!found)
			{
//			the_mouse.show();
			return;
			}

		exit = get();
		gr_clear();
		}

	if (exit == 2)
		{
		reading_data(1);
		for (int i = 0; i < found; i++)
			{
			update	the_updater(the_data[i]);
			the_data[i] = the_updater.advance();
			the_data[i].write();
			}
		clear_reading_data();
		}

//	the_mouse.show();
	}

void messages::show()
	{
	read();
	activate();
	}

int messages::edit()
	{
	grafmess	the_graphics (the_mouse);

	int how_many = found - current;

	if (how_many > 5)
		how_many = 5;

	int option = the_graphics.edit_graphics(how_many);

	return option;
	}

int messages::get()
	{
	flushkeys ();

	grafmess the_graphics (the_mouse);

//	the_graphics.init (the_mouse);

	int option;
	int more = 0;

	the_graphics.show_panels_set (month, day, year);

	the_mouse.hide ();
//	the_mouse.unarm ();


	for (int j = current; j < current+5; j++)
		{
		if (j < found)
			the_graphics.show_panels (j-current,the_data[j], calendar_mode);
		}

	if (current+5 < found)
		more = 1;
	if (current > 0)
		more += 2;

//	the_mouse.arm ();
	the_mouse.show ();

	option = the_graphics.bottom_buttons(more, calendar_mode);


	switch (option)
		{
		case 1:
			return (1); // regular exit
		case 2:
			int edit_opt = edit ();
			if (edit_opt > 0)
				{
				the_edit = the_data[edit_opt + current - 1].get_loc();
				return (1); // edit requested
				}
			break;
		case 3:
			remove ();
			break;
		case 4:
			return (2); // exit & update
		case 5:
			current += 5;
			break;
		case 6:
			current -= 5;
			break;
		case 7:
			messages_help ();
			break;
		}
	return 0;
	}

void messages::reading_data(int update)
	{
	the_mouse.hide();
	the_mouse.unarm ();

	Bevel	wait_bevel;
	wait_bevel.init (getmaxx()/2-75,getmaxy()/2-20,150,45,THICK);
	wait_bevel.show ();

	settextjustify (LEFT_TEXT, TOP_TEXT);

	if (!update)
		outtextxy (getmaxx()/2-50,getmaxy()/2,"Reading Data");
	if (update == 1)
		outtextxy (getmaxx()/2-54,getmaxy()/2,"Updating Data");
	if (update == 2)
		outtextxy (getmaxx()/2-58,getmaxy()/2,"Searching Data");

	the_mouse.arm ();
	the_mouse.show ();
	}

void messages::clear_reading_data ()
	{
	the_mouse.hide();

	setfillstyle(SOLID_FILL,BLACK);
	bar(getmaxx()/2-75,getmaxy()/2-20,getmaxx()/2+150,getmaxy()/2+45);

	the_mouse.show ();
	}

void messages::find()
	{
	long int	current_loc = 1;
	while (current_loc != 0)
		{
		if (calendar_mode)
			current_loc = the_data[found].realfind (month, day, year, current_loc);
		else
			current_loc = the_data[found].find (month, day, year, current_loc);


		if (current_loc > 0)
			{
			current_loc++;
			found++;

			if (found == the_data.length())
				{
				the_data.setSize (the_data.length()+5);

				for (int i = (the_data.length()-5); i < the_data.length(); i++)
					the_data[i].init(home);
				}
			}
		}
	}


void messages::do_search()
	{
	found = 0;

	gr_clear();

	reading_data(2);

	long int	current_loc = 1;
	while (current_loc != 0)
		{
		current_loc = the_data[found].search (search_string, current_loc);

		if (current_loc > 0)
			{
			current_loc++;
			found++;

			if (found == the_data.length())
				{
				the_data.setSize (the_data.length()+5);

				for (int i = (the_data.length()-5); i < the_data.length(); i++)
					the_data[i].init(home);
				}
			}
		}

	clear_reading_data();
	}
