/* class written by jeff goke, jjgoke@cs.csbsju.edu -- (c) 1994.
   this class may be freely used/distributed as long as credit is
   given to the author, jeff goke */


#include "dutil.h"

#include <stdio.h>                 /* fputs(), putchar(), perror(), _fmode */
#include <stdlib.h>                            /* malloc(), free(), exit() */
#include <sys\stat.h>                                          /* S_IWRITE */
#include <fcntl.h>                                             /* O_BINARY */
#include <dos.h>                               /* setverify(), getverify() */
#include <io.h>                       /* open(), creat(), read(), write(), close(), access(), filelength()   */

#define BUF_SIZE (32 * 1024U)      /* copy buffer size, DOS limit is < 64K */

dutil::dutil ()
	{
	}

dutil::~dutil ()
	{
	}

int dutil::fcopy(char *file1,char *file2, int overwrite)
   {
   long     numleft;                  /* number of bytes remaining to copy */
   unsigned numnow;                       /* number of bytes for this pass */
   unsigned numxfer;           /* number of bytes actually read or written */
   int      inhand;                                   /* input file handle */
   int      outhand;                                 /* output file handle */
   char    *buffer;           /* pointer which will be copy buffer address */
   char     ch;
   struct ftime ft;

   save_verify = getverify();
   setverify(1);                              /* set DOS' verify file flag */

   if((buffer = (char *)malloc(BUF_SIZE)) == NULL) /* allocate copy buffer */
      {
      setverify(save_verify);                      /* restore old verify flag */
      return(2);
      }

   if((inhand = open(file1,O_RDONLY|O_BINARY)) == -1)
      {
      setverify(save_verify);                      /* restore old verify flag */
      return(3);
      }

   if(!access(file2,0))             /* test for destination file existence */
      {
// what to do if file already exists?

//      fputs( "Destination file exists.  Overwrite? [Y/N] ", stderr);
//      fflush(stdin);
//      ch = getchar();

//      if((ch != 'y') && (ch != 'Y'))
//	 fatal("\nCopying aborted\n");
      if (!overwrite)
	   return (9);
      }

   _fmode = O_BINARY;                 /* creat() uses _fmode for file mode */

   if((outhand = creat(file2, S_IWRITE)) == -1)
      {
      setverify(save_verify);                      /* restore old verify flag */
      return(4);
      }

   numleft = filelength(inhand);                   /* get source file size */

   while(numleft > 0)
      {
//      putchar('.');                                       /* show activity */

      if(numleft > (long) BUF_SIZE)       /* decide on this pass copy size */
	 numnow = BUF_SIZE;
      else
	 numnow = (unsigned) numleft;

      numxfer = read(inhand, buffer, numnow);

      if(numxfer == (unsigned) -1)            /* if a DOS error on reading */
	 {
	 setverify(save_verify);                      /* restore old verify flag */
	 return(5);
	 }
      else if(numxfer == 0)           /* if 0, DOS doesn't report an error */
	 {
	 setverify(save_verify);                      /* restore old verify flag */
	 return(5);
	 }

      numxfer = write(outhand,buffer,numxfer);

      if(numxfer == (unsigned) -1)            /* if a DOS error on writing */
	 {
	 setverify(save_verify);                      /* restore old verify flag */
	 return(6);
	 }
      else if(numxfer == 0)           /* if 0, DOS doesn't report an error */
	 {
	 setverify(save_verify);                      /* restore old verify flag */
	 return(6);
	 }
      numleft -= numxfer;                 /* decrement amount left to copy */
      }

   getftime(inhand,&ft);                              /* get time and date */
   setftime(outhand,&ft);                             /* set time and date */

   if(close(inhand) == -1)
      {
      setverify(save_verify);                      /* restore old verify flag */
      return(7);
      }

   if(close(outhand) == -1)
      {
      setverify(save_verify);                      /* restore old verify flag */
      return(8);
      }

   free(buffer);
   return 0;
   }
