/* =======================================================================
/*  Nice-Install Master Environment
/*  INSTALL.NIT  -  Default Template Script File
/*  Copyright 1993,1994 Data Way Systems, All rights reserved
/*
/*  Note: Every command in this template script file which begins with
/*        a slash (/) is a Master Environment Template Directive.
/*        Please refer to the file named NIMETEMP.DOC for further
/*        explanation of these directives and how to use them within
/*        the template script.
/* =======================================================================
/*Ŀ
/*  Define Template Screen Colors      
/*
/SearchReplace $ClearCharacter=176
/SearchReplace DefaultFG=WHITE!
/SearchReplace DefaultBG=BLUE
/SearchReplace CompanyBoxFG=BLACK
/SearchReplace CompanyBoxBG=CYAN
/SearchReplace EntryBoxFG=BLACK
/SearchReplace EntryBoxBG=GREEN
/SearchReplace MenuBarFG=BLACK
/SearchReplace MenuBarBG=WHITE
/SearchReplace MenuBarUnSelFG=WHITE!
/SearchReplace MenuBarUnSelBG=GREEN
/SearchReplace MenuBarSelFG=RED
/SearchReplace MenuBarSelBG=WHITE
/SearchReplace FieldEntryFG=BLACK
/SearchReplace FieldEntryBG=WHITE
/SearchReplace ExitColorFG=WHITE
/SearchReplace ExitColorBG=BLACK
/SearchReplace ErrorMsgFG=WHITE!
/SearchReplace ErrorMsgBG=RED
/SearchReplace InfoMsgFG=WHITE!
/SearchReplace InfoMsgBG=GREEN
/SearchReplace PrinterMsgFG=WHITE!
/SearchReplace PrinterMsgBG=GREEN
/SearchReplace StatBarFG=WHITE
/SearchReplace StatBarBG=BLUE
*Ŀ
*  Setup Variables                    
*
/If_Check_For_Viewfile SETVALUE @ReadMeFile,$VIEWFILE
SETVALUE @ProgramInstalled,FALSE
SETVALUE @InstallDrive,C
SETVALUE @ApplicationName,$AppName
QUICKBARCONFIG FSM,ErrorMsgFG,ErrorMsgBG,MenuBarFG,MenuBarBG
*Ŀ
*  Display Logo                       
*
SETCOLOR DefaultFG,DefaultBG
SETCLEARCHAR $ClearCharacter
CLEARSCREEN
SETCLEARCHAR 32
SETBOXTYPE DOUBLE
*Ŀ
*  Display Company and Program Name   
*
MESSAGEBOXSETUP FS,CompanyBoxFG,CompanyBoxBG,2,0
MESSAGETEXT
MESSAGETEXT "} $AppCompanyName "
MESSAGETEXT "} @ApplicationName Installation Program "
MESSAGETEXT
MESSAGEBOX
SAVESCREEN 1
*Ŀ
*  Prepare For Main Bar Menu          
*
:Main
RESTORESCREEN 1
SETALTEXITKEY NONE
SETCOLOR EntryBoxFG,EntryBoxBG
BOX FSM,11,25,15,53
SETCOLOR CompanyBoxFG,CompanyBoxBG
DISPLAYTEXT 11,25,53,}Please Select Option.
SETCOLOR EntryBoxFG,EntryBoxBG
/*
/Begin_Check_For_Viewfile
BARMENUSETUP MenuBarFG,MenuBarBG,23
BARUNSELECTCOLOR MenuBarUnSelFG,MenuBarUnSelBG
BARSELECTCOLOR MenuBarSelFG,MenuBarSelBG
IF @ProgramInstalled,EQ,FALSE
   BAROPTION 13,28,I," Install Program"
ELSE
   BAROPTION 13,28,V," View @ReadmeFile"
ENDIF
BAROPTION 14,28,Q," Quit Installation"
BARMENU
IF @Lastkey,EQ,V
   GOSUB DisplayFile
ENDIF
/End
/*
/Begin_Not_Check_For_Viewfile
IF @ProgramInstalled,EQ,TRUE
   SETCOLOR ExitColorFG,ExitColorBG
   CLEARSCREEN
   QUIT
ENDIF
BARMENUSETUP MenuBarFG,MenuBarBG,23
BARUNSELECTCOLOR MenuBarUnSelFG,MenuBarUnSelBG
BARSELECTCOLOR MenuBarSelFG,MenuBarSelBG
BAROPTION 13,28,I," Install Program"
BAROPTION 14,28,Q," Quit Installation"
BARMENU
/End
/*
IF @Lastkey,EQ,I
   @SearchDrive=A
   SETVALUE @InstallDir,$APPDIR
   GOTO StartInstall
ENDIF
IF @Lastkey,EQ,Q
   SETCOLOR ExitColorFG,ExitColorBG
   CLEARSCREEN
   QUIT
ENDIF
GOTO Main
*Ŀ
*  Start The Install Process        
*
:StartInstall
*Ŀ
*  Get Output Drive                 
*
RESTORESCREEN 1
SETCOLOR EntryBoxFG,EntryBoxBG
BOX FSM,8,5,16,75
DISPLAYTEXT 9,5,75,"}Please select a target drive for the installation."
DRIVEMENU +MenuBarFG,MenuBarBG,11,10,@InstallDrive
IF %NIERROR,NE,0
   RESTORESCREEN 1
   QUICKBAR "} There were no valid available drives found. ","} Cannot install @ApplicationName ","}Installation Cancelled."," OK "
   QUIT
ENDIF
IF @LASTKEY,EQ,ESC
   GOTO MAIN
ENDIF
SETVALUE @InstallDrive,@LastKey
RESTORESCREEN 1
/*Ŀ
/*  See If Master Environment needs an Install Path      
/*
/Begin_Check_For_NeedInstallPath
/Begin_Check_For_SearchFiles
*Ŀ
* Search for Files                                       
* The @SearchDrive variable is used to determine if the  
* selected install drive was been searched the last time.
*
IF @InstallDrive,NE,@SearchDrive
   @SearchDrive=@InstallDrive
   MESSAGEBOXSETUP FSM,InfoMsgFG,InfoMsgBG,0,0
   MESSAGETEXT
   MESSAGETEXT "} Searching Drive @SearchDrive: for a "
   MESSAGETEXT "} previous version of @ApplicationName "
   MESSAGETEXT
   MESSAGEBOX
   REFRESHSCREEN
   @InstallDir=$APPDIR
   FindDirectory @InstallDir,@SearchDrive,$SEARCHFILES
ENDIF
/End
*Ŀ
*  Get Install Path                 
*
:GetInstallPath
RESTORESCREEN 1
SETCOLOR EntryBoxFG,EntryBoxBG
BOX FSM,8,5,13,75
DISPLAYTEXT 9,5,75,"}Please select a target directory for the installation."
DISPLAYTEXT 11,7,,Source Drive @InDrive:@InDir
DISPLAYTEXT 12,7,,Target Drive @InstallDrive:
EDITFIELD FieldEntryFG,FieldEntryBG,12,22,52,@InstallDir
IF @Lastkey,EQ,ESC
   GOTO StartInstall
ENDIF
IF @InstallDir,EQ,""
   QUICKBAR "} You must enter a target directory for the installation. ",,," OK "
   SETVALUE @InstallDir,$APPDIR
   GOTO GetInstallPath
ENDIF
SAVESCREEN 4
*Ŀ
*  Verify to Continue with Install  
*
SETCOLOR EntryBoxFG,EntryBoxBG
BOX FSM,19,9,23,71
DISPLAYTEXT 20,9,71,}Do you wish to continue with the above target path?
:CheckToContinue
BARMENUSETUP MenuBarFG,MenuBarBG
BARUNSELECTCOLOR MenuBarUnSelFG,MenuBarUnSelBG
BARSELECTCOLOR MenuBarSelFG,MenuBarSelBG
BAROPTION 22,22,Y," Yes "
BAROPTION 22,33,N," No "
BAROPTION 22,43,C," Cancel Install "
BARMENU Y
IF @Lastkey,EQ,Y
   RESTORESCREEN 4
   GOTO CheckOutSystem
ENDIF
IF @Lastkey,EQ,N
   GOTO StartInstall
ENDIF
IF @Lastkey,EQ,C
   GOTO Main
ENDIF
GOTO CheckToContinue
/End
*Ŀ
* Check if Users Computer is up to snuff. 
*
:CheckOutSystem
SETALTEXITKEY F10
/*Ŀ
/*  Test Version Number.              
/*
/Begin_Check_For_OsVer
IF %OSVER,LT,$OSVER
   QUICKBAR "} You must be using Dos version $OSVER or greater ","}in order to run this program.","}Installation Cancelled."," OK "
   QUIT
ENDIF
/End
/*Ŀ
/*  Test for Processor                
/*
/Begin_Check_For_CpuType
IF %CPUTYPE,LT,$CPUTYPE
   QUICKBAR "} You must have an 80$CPUTYPE processor or greater ","}in order to run this program.","}Installation Cancelled."," OK "
   QUIT
ENDIF
/End
/*Ŀ
/*  Test for Base Memory              
/*
/Begin_Check_For_BaseMem
IF %BaseMem,LT,$BASEMEM
   QUICKBAR "} Your system does not have enough base memory ","} Must have at least $BASEMEMK bytes. ","}Installation Cancelled."," OK "
   QUIT
ENDIF
/End
/*Ŀ
/*  Test for Extended Memory          
/*
/Begin_Check_For_XMSMem
IF %XMSMem,LT,$XMSMEM
   QUICKBAR "} Your system does not have enough extended memory ","} Must have at least $XMSMEMK bytes. ","}Installation Cancelled."," OK "
   QUIT
ENDIF
/End
/*Ŀ
/*  Test for Video Card               
/*
/Begin_Check_For_Video
IF %VideoNum,LT,$VIDEONUM
   QUICKBAR "} You must be using a $VIDEOTYPE graphics card or better ","}in order to run this program.","}Installation Cancelled."," OK "
   QUIT
ENDIF
/End
/*Ŀ
/*  Test for Coprocessor              
/*
/Begin_Check_For_MathCpu
IF @MATHCPU,EQ,N
   QUICKBAR "} A math coprocessor is required ","}in order to run this program.","}Installation Cancelled."," OK "
   QUIT
ENDIF
/End
/*Ŀ
/*  Test for Color                    
/*
/Begin_Check_For_Color
IF @COLOR,EQ,N
   QUICKBAR "} You must be using a color monitor ","}in order to run this program.","}Installation Cancelled."," OK "
   QUIT
ENDIF
/End
/*Ŀ
/*  Test for Sound Card               
/*
/Begin_Check_For_SoundCard
%SOUNDCARDPORT=CHECKSOUNDCARD
IF %SOUNDCARDPORT,EQ,0
   QUICKBAR "} Warning: A Sound Card is required ","} in order to run this program. ",," OK "
ENDIF
/End
/*Ŀ
/*  Test for Mouse Driver             
/*
/Begin_Check_For_Mouse
IF @MOUSE,EQ,N
   QUICKBAR "} Warning: A mouse driver and mouse are required ","}in order to run this program.",," OK "
ENDIF
/End
/*Ŀ
/*  Test for ANSI Driver              
/*
/Begin_Check_For_ANSI
IF @ANSI,EQ,N
   QUICKBAR "} Warning: An ANSI driver must be loaded ","}in order to run this program.",," OK "
ENDIF
/End
/*Ŀ
/*  Test for Network                  
/*
/Begin_Check_For_Network
/Begin_$Networknum_EQ_0
IF %Network,NE,0
   QUICKBAR "} A Network is not allowed when running this program. ","}Installation Cancelled.",," OK "
   QUIT
ENDIF
/End
/Begin_$Networknum_EQ_1
IF %Network,NE,1
   QUICKBAR "} A Novell network is required ","} in order to run this program. ","}Installation Cancelled."," OK "
   QUIT
ENDIF
/End
/Begin_$Networknum_EQ_2
IF %Network,NE,2
   QUICKBAR "} A Netbios network is required ","} in order to run this program. ","}Installation Cancelled."," OK "
   QUIT
ENDIF
/End
/Begin_$Networknum_EQ_9
IF %Network,EQ,0
   QUICKBAR "} A network is required ","} in order to run this program. ","}Installation Cancelled."," OK "
   QUIT
ENDIF
/End
/End
*Ŀ
*  Ask for Groups to Install         
*
/If_$GroupCount_GE_1 SETVALUE @GroupADir,$GroupADir
/If_$GroupCount_GE_2 SETVALUE @GroupBDir,$GroupBDir
/If_$GroupCount_GE_3 SETVALUE @GroupCDir,$GroupCDir
/If_$GroupCount_GE_4 SETVALUE @GroupDDir,$GroupDDir
/If_$GroupCount_GE_5 SETVALUE @GroupEDir,$GroupEDir
/If_$GroupCount_GE_6 SETVALUE @GroupFDir,$GroupFDir
/If_$GroupCount_GE_7 SETVALUE @GroupGDir,$GroupGDir
/If_$GroupCount_GE_8 SETVALUE @GroupHDir,$GroupHDir
/If_$GroupCount_GE_9 SETVALUE @GroupIDir,$GroupIDir
/If_$GroupCount_GE_10 SETVALUE @GroupJDir,$GroupJDir
/If_$GroupCount_GE_11 SETVALUE @GroupKDir,$GroupKDir
/If_$GroupCount_GE_12 SETVALUE @GroupLDir,$GroupLDir
/If_$GroupCount_GE_13 SETVALUE @GroupMDir,$GroupMDir
/If_$GroupCount_GE_14 SETVALUE @GroupNDir,$GroupNDir
/If_$GroupCount_GE_15 SETVALUE @GroupODir,$GroupODir
/If_$GroupCount_GE_16 SETVALUE @GroupPDir,$GroupPDir
/If_$GroupCount_GE_17 SETVALUE @GroupQDir,$GroupQDir
/If_$GroupCount_GE_18 SETVALUE @GroupRDir,$GroupRDir
/If_$GroupCount_GE_19 SETVALUE @GroupSDir,$GroupSDir
/If_$GroupCount_GE_20 SETVALUE @GroupTDir,$GroupTDir
/If_$GroupCount_GE_21 SETVALUE @GroupUDir,$GroupUDir
/If_$GroupCount_GE_22 SETVALUE @GroupVDir,$GroupVDir
/If_$GroupCount_GE_23 SETVALUE @GroupWDir,$GroupWDir
/If_$GroupCount_GE_24 SETVALUE @GroupXDir,$GroupXDir
/If_$GroupCount_GE_25 SETVALUE @GroupYDir,$GroupYDir
/If_$GroupCount_GE_26 SETVALUE @GroupZDir,$GroupZDir
*Ŀ
*  The following line will define the variable @Groups   
*
SETVALUE @GroupList,$PromptGroupList
/*Ŀ
/*                                                         
/* Include the following routine if NIME requests for any  
/* Groups be Prompted for Installation.                    
/*                                                         
/*
/Begin_$PromptGroupCount_GT_0
:GetGroups
SETCOLOR DefaultFG,DefaultBG
SETCLEARCHAR $ClearCharacter
CLEARSCREEN
SETCLEARCHAR 32
/* ----------------------------------------------------------------------------
%Row = 7
%Row + $PromptGroupCount
SETCOLOR EntryBoxFG,EntryBoxBG
BOX FSM,2,3,%Row,77
SETCOLOR CompanyBoxFG,CompanyBoxBG
DISPLAYTEXT 2,3,77,"}Please select groups for installation"
DISPLAYTEXT %Row,3,77,"}ESC=Cancel   SPACE/ENTER=Tag/Untag   F10=Continue"
SETCOLOR EntryBoxFG,EntryBoxBG
DISPLAYTEXT 3,3,,""
DISPLAYTEXT 4,3,,"  = Install Group                Group installation path"
DISPLAYTEXT 5,3,,""
%Row - 1
DISPLAYTEXT %Row,3,,""
%Row + 1
/* ----------------------------------------------------------------------------
/If_$PromptGroupCount_GE_1 DISPLAYTEXT  6,36,72," @Group$PromptGroup1LetterDir"
/If_$PromptGroupCount_GE_2 DISPLAYTEXT  7,36,72," @Group$PromptGroup2LetterDir"
/If_$PromptGroupCount_GE_3 DISPLAYTEXT  8,36,72," @Group$PromptGroup3LetterDir"
/If_$PromptGroupCount_GE_4 DISPLAYTEXT  9,36,72," @Group$PromptGroup4LetterDir"
/If_$PromptGroupCount_GE_5 DISPLAYTEXT 10,36,72," @Group$PromptGroup5LetterDir"
/If_$PromptGroupCount_GE_6 DISPLAYTEXT 11,36,72," @Group$PromptGroup6LetterDir"
/If_$PromptGroupCount_GE_7 DISPLAYTEXT 12,36,72," @Group$PromptGroup7LetterDir"
/If_$PromptGroupCount_GE_8 DISPLAYTEXT 13,36,72," @Group$PromptGroup8LetterDir"
/If_$PromptGroupCount_GE_9 DISPLAYTEXT 14,36,72," @Group$PromptGroup9LetterDir"
/If_$PromptGroupCount_GE_10 DISPLAYTEXT 15,36,72," @Group$PromptGroup10LetterDir"
/If_$PromptGroupCount_GE_11 DISPLAYTEXT 16,36,72," @Group$PromptGroup11LetterDir"
/If_$PromptGroupCount_GE_12 DISPLAYTEXT 17,36,72," @Group$PromptGroup12LetterDir"
/If_$PromptGroupCount_GE_13 DISPLAYTEXT 18,36,72," @Group$PromptGroup13LetterDir"
/If_$PromptGroupCount_GE_14 DISPLAYTEXT 19,36,72," @Group$PromptGroup14LetterDir"
/If_$PromptGroupCount_GE_15 DISPLAYTEXT 20,36,72," @Group$PromptGroup15LetterDir"
/If_$PromptGroupCount_GE_16 DISPLAYTEXT 21,36,72," @Group$PromptGroup16LetterDir"
/* -----------------------------------------------------------------------------
BARMENUSETUP MenuBarFG,MenuBarBG,31
/If_$PromptGroupCount_GE_1 BAROPTION  6,4,$PromptGroup1Letter," $PromptGroup1Name"
/If_$PromptGroupCount_GE_2 BAROPTION  7,4,$PromptGroup2Letter," $PromptGroup2Name"
/If_$PromptGroupCount_GE_3 BAROPTION  8,4,$PromptGroup3Letter," $PromptGroup3Name"
/If_$PromptGroupCount_GE_4 BAROPTION  9,4,$PromptGroup4Letter," $PromptGroup4Name"
/If_$PromptGroupCount_GE_5 BAROPTION 10,4,$PromptGroup5Letter," $PromptGroup5Name"
/If_$PromptGroupCount_GE_6 BAROPTION 11,4,$PromptGroup6Letter," $PromptGroup6Name"
/If_$PromptGroupCount_GE_7 BAROPTION 12,4,$PromptGroup7Letter," $PromptGroup7Name"
/If_$PromptGroupCount_GE_8 BAROPTION 13,4,$PromptGroup8Letter," $PromptGroup8Name"
/If_$PromptGroupCount_GE_9 BAROPTION 14,4,$PromptGroup9Letter," $PromptGroup9Name"
/If_$PromptGroupCount_GE_10 BAROPTION 15,4,$PromptGroup10Letter," $PromptGroup10Name"
/If_$PromptGroupCount_GE_11 BAROPTION 16,4,$PromptGroup11Letter," $PromptGroup11Name"
/If_$PromptGroupCount_GE_12 BAROPTION 17,4,$PromptGroup12Letter," $PromptGroup12Name"
/If_$PromptGroupCount_GE_13 BAROPTION 18,4,$PromptGroup13Letter," $PromptGroup13Name"
/If_$PromptGroupCount_GE_14 BAROPTION 19,4,$PromptGroup14Letter," $PromptGroup14Name"
/If_$PromptGroupCount_GE_15 BAROPTION 20,4,$PromptGroup15Letter," $PromptGroup15Name"
/If_$PromptGroupCount_GE_16 BAROPTION 21,4,$PromptGroup16Letter," $PromptGroup16Name"
/* -----------------------------------------------------------------------------
BARTAGMENU @GroupList
IF @LASTKEY,EQ,ESC
   GOTO Main
ENDIF
SETVALUE @GroupList,@BarTag
/End
/*
/*Ŀ
/*                                                         
/* Include the following routine if NIME requests for any  
/* Directories be Prompted for Installation.               
/*                                                         
/*
/Begin_$PromptGroupDirCount_GT_0
*Ŀ
*  Get Directories for Groups        
*
:GetGroupDirectories
SETCOLOR CompanyBoxFG,CompanyBoxBG
DISPLAYTEXT %Row,3,74,"}ESC=Cancel   F10=Continue"
SETCOLOR EntryBoxFG,EntryBoxBG
ENTRYMENUSETUP FieldEntryFG,FieldEntryBG
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir1
IF Tagged_$PromptGroup1Letter,EQ,Y
   ENTRYFIELD  6,38,39,@Group$PromptGroup1LetterDir
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir2
IF Tagged_$PromptGroup2Letter,EQ,Y
   ENTRYFIELD  7,38,39,@Group$PromptGroup2LetterDir
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir3
IF Tagged_$PromptGroup3Letter,EQ,Y
   ENTRYFIELD  8,38,39,@Group$PromptGroup3LetterDir
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir4
IF Tagged_$PromptGroup4Letter,EQ,Y
   ENTRYFIELD  9,38,39,@Group$PromptGroup4LetterDir
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir5
IF Tagged_$PromptGroup5Letter,EQ,Y
   ENTRYFIELD 10,38,39,@Group$PromptGroup5LetterDir
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir6
IF Tagged_$PromptGroup6Letter,EQ,Y
   ENTRYFIELD 11,38,39,@Group$PromptGroup6LetterDir
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir7
IF Tagged_$PromptGroup7Letter,EQ,Y
   ENTRYFIELD 12,38,39,@Group$PromptGroup7LetterDir
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir8
IF Tagged_$PromptGroup8Letter,EQ,Y
   ENTRYFIELD 13,38,39,@Group$PromptGroup8LetterDir
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir9
IF Tagged_$PromptGroup9Letter,EQ,Y
   ENTRYFIELD 14,38,39,@Group$PromptGroup9LetterDir
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir10
IF Tagged_$PromptGroup10Letter,EQ,Y
   ENTRYFIELD 15,38,39,@Group$PromptGroup10LetterDir
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir11
IF Tagged_$PromptGroup11Letter,EQ,Y
   ENTRYFIELD 16,38,39,@Group$PromptGroup11LetterDir
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir12
IF Tagged_$PromptGroup12Letter,EQ,Y
   ENTRYFIELD 17,38,39,@Group$PromptGroup12LetterDir
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir13
IF Tagged_$PromptGroup13Letter,EQ,Y
   ENTRYFIELD 18,38,39,@Group$PromptGroup13LetterDir
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir14
IF Tagged_$PromptGroup14Letter,EQ,Y
   ENTRYFIELD 19,38,39,@Group$PromptGroup14LetterDir
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir15
IF Tagged_$PromptGroup15Letter,EQ,Y
   ENTRYFIELD 20,38,39,@Group$PromptGroup15LetterDir
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir16
IF Tagged_$PromptGroup16Letter,EQ,Y
   ENTRYFIELD 21,38,39,@Group$PromptGroup16LetterDir
ENDIF
/End
/* ----------------------------------------------------------
ENTRYMENU
IF @LASTKEY,EQ,ESC
   GOTO GETGROUPS
ENDIF
SETVALUE %ERRORSW,0
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir1
IF @Group$PromptGroup1LetterDir,EQ,""
   SETVALUE @Group$PromptGroup1LetterDir,$PromptGroup1Dir
   SETVALUE %ERRORSW,1
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir2
IF @Group$PromptGroup2LetterDir,EQ,""
   SETVALUE @Group$PromptGroup2LetterDir,$PromptGroup2Dir
   SETVALUE %ERRORSW,1
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir3
IF @Group$PromptGroup3LetterDir,EQ,""
   SETVALUE @Group$PromptGroup3LetterDir,$PromptGroup3Dir
   SETVALUE %ERRORSW,1
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir4
IF @Group$PromptGroup4LetterDir,EQ,""
   SETVALUE @Group$PromptGroup4LetterDir,$PromptGroup4Dir
   SETVALUE %ERRORSW,1
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir5
IF @Group$PromptGroup5LetterDir,EQ,""
   SETVALUE @Group$PromptGroup5LetterDir,$PromptGroup5Dir
   SETVALUE %ERRORSW,1
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir6
IF @Group$PromptGroup6LetterDir,EQ,""
   SETVALUE @Group$PromptGroup6LetterDir,$PromptGroup6Dir
   SETVALUE %ERRORSW,1
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir7
IF @Group$PromptGroup7LetterDir,EQ,""
   SETVALUE @Group$PromptGroup7LetterDir,$PromptGroup7Dir
   SETVALUE %ERRORSW,1
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir8
IF @Group$PromptGroup8LetterDir,EQ,""
   SETVALUE @Group$PromptGroup8LetterDir,$PromptGroup8Dir
   SETVALUE %ERRORSW,1
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir9
IF @Group$PromptGroup9LetterDir,EQ,""
   SETVALUE @Group$PromptGroup9LetterDir,$PromptGroup9Dir
   SETVALUE %ERRORSW,1
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir10
IF @Group$PromptGroup10LetterDir,EQ,""
   SETVALUE @Group$PromptGroup10LetterDir,$PromptGroup10Dir
   SETVALUE %ERRORSW,1
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir11
IF @Group$PromptGroup11LetterDir,EQ,""
   SETVALUE @Group$PromptGroup11LetterDir,$PromptGroup11Dir
   SETVALUE %ERRORSW,1
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir12
IF @Group$PromptGroup12LetterDir,EQ,""
   SETVALUE @Group$PromptGroup12LetterDir,$PromptGroup12Dir
   SETVALUE %ERRORSW,1
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir13
IF @Group$PromptGroup13LetterDir,EQ,""
   SETVALUE @Group$PromptGroup13LetterDir,$PromptGroup13Dir
   SETVALUE %ERRORSW,1
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir14
IF @Group$PromptGroup14LetterDir,EQ,""
   SETVALUE @Group$PromptGroup14LetterDir,$PromptGroup14Dir
   SETVALUE %ERRORSW,1
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir15
IF @Group$PromptGroup15LetterDir,EQ,""
   SETVALUE @Group$PromptGroup15LetterDir,$PromptGroup15Dir
   SETVALUE %ERRORSW,1
ENDIF
/End
/* ----------------------------------------------------------
/Begin_Check_For_PromptDir16
IF @Group$PromptGroup16LetterDir,EQ,""
   SETVALUE @Group$PromptGroup16LetterDir,$PromptGroup16Dir
   SETVALUE %ERRORSW,1
ENDIF
/End
/* ----------------------------------------------------------
IF %ERRORSW,EQ,0
   GOTO UnPackFiles
ENDIF
*Ŀ
* Errors in one or more Directories.  
*
QUICKBAR "} All directory entries must be entered! ",,," OK "
GOTO GetGroupDirectories
/End
*Ŀ
* Start the Install Process           
*
:UnpackFiles
RESTORESCREEN 1
*Ŀ
*  Check if Input Drive Ready        
*
:CheckInputDrive
IF DriveReady_@InDrive,EQ,N
   QUICKBAR "} Input drive @InDrive: not ready! ","}Do you wish to continue?",," Yes "," No "
   IF @Lastkey,EQ,A
      GOTO CheckInputDrive
   ENDIF
   GOTO Main
ENDIF
*Ŀ
*  Check if Install Drive Ready      
*
:CheckInstallDrive
IF DriveReady_@InstallDrive,EQ,N
   QUICKBAR "} Install drive @InstallDrive: not ready! ","}Do you wish to continue?",," Yes "," No "
   IF @Lastkey,EQ,A
      GOTO CheckInstallDrive
   ENDIF
   GOTO Main
ENDIF
/*Ŀ
/*  Check if Master Environment wants to Test for Disk Space  
/*
/Begin_Check_For_DiskSpace
*Ŀ
* Test Disk Space on Install Drive                            
* Initialize %CheckSpace to 1 to allow for an additional 1K   
*
%CheckSpace = 1
/IF_$DISKSPACE_GT_0 %CheckSpace + $DiskSpace
/Begin_$DISKSPACE_EQ_0
/IF_$StandaloneCount_GT_0 %CheckSpace + $StandaloneBytes
/IF_$PackedCount_GT_0 EXTRACTFILES -T-G:$AlwaysGroupList@GroupList
/IF_$PackedCount_GT_0 %CheckSpace + %ExtractSpace
/End
IF SpaceAvailable_@InstallDrive,LT,%CheckSpace
   QUICKBAR "} Not enough space detected on drive @InstallDrive: ","} Must have at least %CheckSpaceK bytes. ",," Select another drive. "," Continue with selected drive. "
   IF @LastKey,EQ,A
      GOTO StartInstall
   ENDIF
ENDIF
/End

*Ŀ
* Setup Message View Area                   
*
SETCOLOR InfoMsgFG,InfoMsgBG
BOX FSM,9,4,18,75
SETCOLOR CompanyBoxFG,CompanyBoxBG
DISPLAYTEXT 9,4,75,}Installing @ApplicationName.
VIEWAREACONFIG InfoMsgFG,InfoMsgBG,10,5,18,74
/*Ŀ
/*  Check if Master Environment has StandAlone Files          
/*
/Begin_$StandAloneCount_GT_0

*Ŀ
* Copy the StandAlone Files           
*
MKDIR @InstallDrive:@InstallDir
VIEWAREADISPLAY "Copying files from @InDrive:@InDir to @InstallDrive:@InstallDir"
SETVALUE @CopyError,FALSE
/Begin_ProcessStandAlone
@StandAloneFile=$StandAloneFile
GOSUB COPYSTANDALONE
/End
VIEWAREADISPLAY ""
IF @CopyError,EQ,TRUE
   GOSUB INSTALLERROR
   GOTO Main
ENDIF
/End
/*Ŀ
/*  Check if Master Environment has Files to Pack             
/*
/Begin_$PackedCount_GT_0

*Ŀ
* Setup Status Bar for EXTRACTFILES command 
*
SETCOLOR StatBarFG,StatBarBG
BOX FSM,21,4,23,75
DISPLAYTEXT 22,6,,Percent Complete:
STATUSBAR StatBarFG,StatBarBG,22,24,0
*Ŀ
* Check Passwords.                    
*
/Begin_Not_Check_For_Password
/If_"$PASSWORD"_EQ_"" SETVALUE @PassWord,""
/If_"$PASSWORD"_NE_"" SETVALUE @PassWord,"-X:$PASSWORD"
/End
/Begin_Check_For_Password
:GetPassword
SAVESCREEN 4
SETCOLOR ErrorMsgFG,ErrorMsgBG
BOX FSM,11,9,13,72
DISPLAYTEXT 12,12,,"Please enter your password:"
SETVALUE @PassWord,""
EDITFIELD FieldEntryFG,FieldEntryBG,12,40,30,@Password
SETVALUE @PassWord,"-X:@Password"
IF @Lastkey,EQ,ESC
   GOTO Main
ENDIF
RESTORESCREEN 4
/End
*Ŀ
* Extract the Files                   
*
VIEWAREADISPLAY "Extracting compressed files....  Press ALT-X to cancel."
EXTRACTFILES -C-G:$AlwaysGroupList@GroupList @PassWord
IF %NIERROR,NE,0
   /Begin_Check_For_Password
   IF %NIERROR,EQ,178
      QUICKBAR "} You selected an invalid Password for Extracting Files. ",,," Try Again "," Cancel "
      IF @LastKey,EQ,A
         RESTORESCREEN 4
         GOTO GetPassword
      ENDIF
      GOTO Main
   ENDIF
   /End
   IF %NIERROR,LT,180
      GOSUB INSTALLERROR
   ENDIF
   GOTO Main
ENDIF
/End

*Ŀ
* Installation was Successful         
*
WAIT 2
RESTORESCREEN 1
SETVALUE @ProgramInstalled,TRUE
QUICKBAR "} Installation Complete! ",,," OK "
CHDRIVE @InstallDrive
CHDIR @InstallDrive:@InstallDir
/If_Check_For_Modify_System GOSUB MODIFYSYSTEM
GOTO Main

*Ŀ
*  Installation Error Routine.       
*
:INSTALLERROR
IF %NIERROR,EQ,53
   SETVALUE @ErrorMsg,'"File not found" error'
ELSE
   IF %NIERROR,EQ,71
      SETVALUE @ErrorMsg,'"Disk I/O" error'
   ELSE
      SETVALUE @ErrorMsg,'Error "%NIERROR"'
   ENDIF
ENDIF
QUICKBAR '} @ErrorMsg occured during install process. ','}Please contact Technical Support.',," OK "
RETURN

/*Ŀ
/*                                                         
/* The following routine will copy a standalone            
/* file to the install directory.                          
/*                                                         
/*
/Begin_$StandaloneCount_GT_0
*Ŀ
*  Copy One Standalone File Routine  
*
:COPYSTANDALONE
IF @CopyError,EQ,FALSE
   VIEWAREADISPLAY "Copying file @StandAloneFile"
   COPYFILE @InDrive:@InDir\@StandAloneFile,@InstallDrive:@InstallDir
   IF %NIERROR,NE,0
      SETVALUE @CopyError,TRUE
   ENDIF
ENDIF
RETURN

/End
/*Ŀ
/*                                                         
/* Include the following routine if NIME requests to view  
/* a File during the Installation.                         
/*                                                         
/*
/Begin_Check_For_Viewfile
*Ŀ
*  Display File to be Viewed.        
*
:DISPLAYFILE
SETALTEXITKEY F10
RESTORESCREEN 1
SETCOLOR DefaultFG,DefaultBG
CLEARSCREEN
SETCOLOR CompanyBoxFG,CompanyBoxBG
DISPLAYTEXT 25,1,80,"}Arrow Keys,  Page Up,  Page Dn,  Press Esc to Exit,  F10 to Print"
SETCOLOR DefaultFG,DefaultBG
DISPLAYFILE 1,1,24,80,@InstallDrive:@InstallDir\@ReadMeFile
IF %NIERROR,GT,0
   QUICKBAR "} Could Not Find File @ReadMeFile! ",,," OK "
ELSE
   IF @Lastkey,EQ,F10
      QUICKBARCONFIG FSM,PrinterMsgFG,PrinterMsgBG,MenuBarFG,MenuBarBG
      PRINTFILE @InstallDrive:@InstallDir\@ReadMeFile
      QUICKBARCONFIG FSM,ErrorMsgFG,ErrorMsgBG,MenuBarFG,MenuBarBG
   ENDIF
ENDIF
RETURN

/End
/*Ŀ
/*                                                         
/* Include the following routine if NIME requests to make  
/* changes the users AUTOEXEC.BAT or CONFIG.SYS.           
/*                                                         
/*
/Begin_Check_For_Modify_System
:MODIFYSYSTEM
*Ŀ
* Display to User the Modifications that need to be done 
*
SETCOLOR DefaultFG,DefaultBG
SETCLEARCHAR $ClearCharacter
CLEARSCREEN
SETCLEARCHAR 32
SETCOLOR EntryBoxFG,EntryBoxBG
BOX FSM,2,5,16,75
DISPLAYTEXT 3,5,75,"}The following modifications may need to be made your system files."
SETVALUE %Row,5
/*Ŀ
/* Check if Modifications need to be made to CONFIG.SYS    
/*
/Begin_Check_For_Modify_Config
DISPLAYTEXT %Row,6,74,"----- CONFIG.SYS -----"
/* ----------------------------------------------------------
/Begin_Check_For_Buffers
ADDVALUE %Row,1
DISPLAYTEXT %Row,6,74,BUFFERS=$BUFFERS
/End
/* ----------------------------------------------------------
/Begin_Check_For_Files
ADDVALUE %Row,1
DISPLAYTEXT %Row,6,74,FILES=$FILES
/End
/* ----------------------------------------------------------
/Begin_Check_For_Device
ADDVALUE %Row,1
DISPLAYTEXT %Row,6,74,DEVICE=$DEVICE
/End
/* ----------------------------------------------------------
/Begin_Check_For_Install
ADDVALUE %Row,1
DISPLAYTEXT %Row,6,74,INSTALL=$INSTALL
/End
/* ----------------------------------------------------------
/Begin_Check_For_LastDrive
ADDVALUE %Row,1
DISPLAYTEXT %Row,6,74,LASTDRIVE=$LASTDRIVE
/End
/* ----------------------------------------------------------
/Begin_Check_For_AddConfigLine
ADDVALUE %Row,1
DISPLAYTEXT %Row,6,74,Add Line: $ConfigLine
/End
/* ----------------------------------------------------------
ADDVALUE %Row,1
/End
/*Ŀ
/* Check if Modifications need to be made to AUTOEXEC.BAT  
/*
/Begin_Check_For_Modify_Autoexec
DISPLAYTEXT %Row,6,74,"---- AUTOEXEC.BAT ----"
/* ----------------------------------------------------------
/Begin_Check_For_SetEnv
/Begin_"$SETVARIABLE1"_NE_""
ADDVALUE %Row,1
DISPLAYTEXT %Row,6,74,SET $SETVARIABLE1=$SETCONTENTS1
/End
/Begin_"$SETVARIABLE2"_NE_""
ADDVALUE %Row,1
DISPLAYTEXT %Row,6,74,SET $SETVARIABLE2=$SETCONTENTS2
/End
/Begin_"$SETVARIABLE3"_NE_""
ADDVALUE %Row,1
DISPLAYTEXT %Row,6,74,SET $SETVARIABLE3=$SETCONTENTS3
/End
/Begin_"$SETVARIABLE4"_NE_""
ADDVALUE %Row,1
DISPLAYTEXT %Row,6,74,SET $SETVARIABLE4=$SETCONTENTS4
/End
/End
/* ----------------------------------------------------------
/Begin_Check_For_AddPath
ADDVALUE %Row,1
DISPLAYTEXT %Row,6,74,Add @InstallDrive:@InstallDir to your path.
/End
/* ----------------------------------------------------------
/Begin_Check_For_AddAutoExecLine
ADDVALUE %Row,1
DISPLAYTEXT %Row,6,74,Add Line: $AutoExecLine
/End
/End
*Ŀ
*  Ask the user how he would like changes to be made  
*
SETCOLOR EntryBoxFG,EntryBoxBG
BOX FSM,19,18,23,62
:LoopCheckModify
BARMENUSETUP MenuBarFG,MenuBarBG,41
BAROPTION 20,20,," Apply changes directly to System files"
BAROPTION 21,20,," Apply changes to copies of System files"
BAROPTION 22,20,," Do not apply any changes"
BARMENU
IF @Lastkey,EQ,A
   GOSUB DoModifications
   SYSTEMAPPLY
   RETURN
ENDIF
IF @Lastkey,EQ,B
   GOSUB DoModifications
   RETURN
ENDIF
IF @Lastkey,EQ,C
   RETURN
ENDIF
GOTO LoopCheckModify

*Ŀ
*  Modify the System Setup            
*
:DoModifications
SYSTEMSETUP @BOOTDRIVE
/If_Check_For_Buffers SYSTEMMODIFY BUFFERS,$BUFFERS
/If_Check_For_Files SYSTEMMODIFY FILES,$FILES
/If_Check_For_Device SYSTEMMODIFY DEVICE,$DEVICE
/If_Check_For_Install SYSTEMMODIFY INSTALL,$INSTALL
/If_Check_For_Lastdrive SYSTEMMODIFY LASTDRIVE,$LASTDRIVE
/Begin_Check_For_SetEnv
/If_"$SETVARIABLE1"_NE_"" SYSTEMMODIFY SET,$SETVARIABLE1,$SETCONTENTS1
/If_"$SETVARIABLE2"_NE_"" SYSTEMMODIFY SET,$SETVARIABLE2,$SETCONTENTS2
/If_"$SETVARIABLE3"_NE_"" SYSTEMMODIFY SET,$SETVARIABLE3,$SETCONTENTS3
/If_"$SETVARIABLE4"_NE_"" SYSTEMMODIFY SET,$SETVARIABLE4,$SETCONTENTS4
/End
/If_Check_For_AddPath SYSTEMMODIFY PATH,END,@InstallDrive:@InstallDir
/If_Check_For_AddConfigLine SYSTEMMODIFY CONFIGLINE,$CONFIGPOS,$CONFIGLINE
/If_Check_For_AddAutoExecLine SYSTEMMODIFY AUTOEXECLINE,$AUTOEXECPOS,$AUTOEXECLINE
SYSTEMCREATENEW
RETURN
/End
