// Stuff relating to the song class

union overall_am_vib_union {
  unsigned char byte;
  struct {
    unsigned : 6;
    unsigned deep_vibrato: 1;
    unsigned deep_amplitude_modulation: 1;
  } bitmap;
};

class song {
public:
  char *name;
  char *info_page;   // Points to 14 null-terminated lines.
  unsigned int highest_block;
  block *block_pointer[MAX_BLOCKS];
  unsigned int highest_pattern;
  unsigned int pattern_list[MAX_PATTERNS];
  unsigned int highest_instrument;
  instrument *instrument_pointer[MAX_INSTRUMENTS];
  unsigned int highest_stereo_left;
  unsigned int highest_track;
  enum sound_cards {adlib, sb, sbpro1, sbpro2} soundsystem;
  overall_am_vib_union overall_am_vib;
  unsigned int current_pattern;
  unsigned int current_block;
  unsigned int current_line;
  unsigned char *current_note[MAX_TRACKS];
  unsigned int tempo;
  unsigned int secondary_tempo;
  static const char tracker_id_string[][20];
  static const unsigned int tracker_id_length[];
#ifdef EDITOR_HOOKS
  static const char inst_id_string[][20];
  static const unsigned int inst_id_length[];
#endif

  song();
  ~song();
  void position_jump(unsigned int new_pattern, unsigned int new_line = 0);
  void block_jump(unsigned int new_block, unsigned int new_line = 0);
  void skip_note(unsigned char *&note);
  void advance_line();
  block *block_at_pattern(unsigned int pattern)
    {return block_pointer[pattern_list[pattern]];}
  unsigned char *find_line(unsigned char *note_pointer,
    unsigned int line);
#ifdef EDITOR_HOOKS
  void add_blank_effect(block *which_block, unsigned int which_channel,
    unsigned char *note);
  void remove_effect(block *which_block, unsigned int which_channel,
    unsigned char *effect);                    /* realloc()s - MUST resync
                                                  position pointers after
                                                  doing these! */
  void editor_reformat();
  unsigned int autoload_module(FILE *module);
  unsigned int load_rad(FILE *module);
  void save_gms(FILE *module);
  unsigned int autoload_instrument(FILE *inst_file, unsigned int inst_num);
  unsigned int load_gmi(FILE *inst_file, unsigned int inst_num);
  void save_gmi(FILE *inst_file, unsigned int inst_num);
#endif
  void wipe_old_song();
  unsigned int load_gms(FILE *module);
};

inline void song::skip_note(unsigned char *&note) {
  if (note)   // Don't advance an "empty" track
    if (*(note++) & 128)
      if (*(note++) & 128) {
        while (*note & 128)
          note += 2;
        note += 2;
      }
}

inline unsigned char *song::find_line(unsigned char *note_pointer,
  unsigned int line) {
  unsigned int stepper;

  for(stepper = 0;stepper < line;stepper++)
    skip_note(note_pointer);
  return note_pointer;
}

#ifdef COMPILING_SONG
const char song::tracker_id_string[][20] =
  {{'G', 'M', 'S', '-', 'R', 'C', 'A', '~', '~', '~',     // GMS x.x
   '~', '~', '~', '~', '~', '~', '~', '~', '~', '~'}
#ifdef EDITOR_HOOKS
,
   {'R', 'A', 'D', ' ', 'b', 'y', ' ', 'R', 'E', 'A',     // RAD x.x
   'L', 'i', 'T', 'Y', '!', '!', '~', '~', '~', '~'}};
#else
};
#endif
// The magic cookies that let GMS recognize tracker datafiles.

const unsigned int song::tracker_id_length[] =
  {7      // GMS x.x
#ifdef EDITOR_HOOKS
,
   16};   // RAD x.x
#else
};
#endif
// The number of characters in each magic cookie.
#endif

#define GMS_MOD_OFFSET 0
#define RAD_MOD_OFFSET 1
#define HIGHEST_MOD_OFFSET 1

#ifdef COMPILING_SONGEXT
const char song::inst_id_string[][20] =
  {{'G', 'M', 'I', '-', 'R', 'C', 'A', '~', '~', '~',     // GMS x.x
   '~', '~', '~', '~', '~', '~', '~', '~', '~', '~'}};
// Magic cookies for instruments.

const unsigned int song::inst_id_length[] =
  {7};   // GMS x.x

#define GMS_INST_OFFSET 0
#define HIGHEST_INST_OFFSET 0
#endif

#ifdef COMPILING_SONG
song song_obj;
#else
extern song song_obj;
#endif
