                    Quarterdeck Technical Note

     
     Patching QEMM-386 6.00 and 6.01 to cause QEMM-386 not to unmap 
     free pages when an Expanded Memory (EMS) handle is freed. 

     Background:  Beginning with version 6.00, QEMM-386 unmaps from the 
     page frame any pages of Expanded Memory that belong to an EMS 
     handle that is freed.  It is possible that an EMS user may rely on 
     memory being left in the page frame even after it has surrendered 
     its EMS handle.  Since QEMM-386 version 6 ensures that there is no 
     memory in the page frame after the program has freed its EMS 
     handle such a program malfunctions.  QEMM-386 does this for a good 
     purpose: to allow the ROM underlying the page frame to be visible 
     whenever Expanded Memory is not being used.  The drawback to not 
     unmapping free pages from the page frame is described below.  
     Quarterdeck considers it poor programming practice for a program 
     to use the page frame without taking out an EMS handle.  If you 
     find that this patch makes your program work where it previously 
     failed you should report this to the author of the program.  We at 
     Quarterdeck are willing to discuss this matter with the authors of 
     any commercial software that uses EMS in this manner.

     Glyphix 3.1 (dated 12/26/90) is one program that needs this patch.

     Drawbacks:  If you are using QEMM-386's Stealth feature, this 
     patch may cause some users with SuperVGA cards to need to exclude 
     C000-C0FF (or some portion of the address space occupied by the 
     VGA ROM) to run high-resolution video modes.  Before using the 
     patch, placing the page frame at C000 (the default location when 
     the ST:M option is in effect) should make such an exclusion 
     unnecessary.

     The following procedure prevents QEMM-386 from unmapping free EMS 
     pages when an EMS handle is freed.

         -------------------------------------------------

     1) Make a copy of the QEMM386.SYS file in your QEMM directory.  We 
     are about to alter your current copy of QEMM386.SYS; the copy you 
     make will serve as a backup in case this operation fails.

           COPY C:\QEMM\QEMM386.SYS C:\QEMM\QEMMOLD.SYS

     (If your QEMM386.SYS is not located in the QEMM directory of the 
     C: drive, change the path accordingly.)

     2) Go to the DOS directory on the hard disk and type:

                     DEBUG C:\QEMM\QEMM386.SYS

     (If your QEMM386.SYS is not located in the QEMM directory of the 
     C: drive, change the path accordingly.)

     Hit the Enter key; you should the the DEBUG prompt, which is a 
     hyphen.

     3) At the DEBUG prompt, type:

                        S 100 L FF00 3B E8 75

     Hit the Enter key; DEBUG should return a segment address and 
     offset:

                             xxxx:yyyy
     
     4) At the DEBUG prompt again, use the segment address and offset 
     that was just returned to give the DEBUG command:

                          E xxxx:yyyy 3B E8 EB 
   
     The address that DEBUG returned in step 3 should be used in place 
     of the address xxxx:yyyy, which we use as an example.  Hit the 
     Enter the key after the command; the DEBUG prompt should return in 
     a moment.

     5) At the DEBUG prompt, type

                                 W

     Hit the Enter key; DEBUG will announce that it is writing a 
     certain number of bytes, then it will return the DEBUG prompt.

     6) At the DEBUG prompt, type

                                 Q

     Hit the Enter key to exit DEBUG and return to DOS.

       --------------------------------------------------

     If the system fails after you perform this patch, copy the backup 
     of QEMM386 that you made back to its original name.  

           COPY C:\QEMM\QEMMOLD.SYS C:\QEMM\QEMM386.SYS

     (If your QEMM386.SYS is not located in the QEMM  directory of the 
     C: drive, change the path accordingly.)

     You may then wish to try the above procedure again, in case a 
     mistake was made.

             * * *   E N D   O F   F I L E    * * *
