/*
	TestPat.CPP version 1.0
	by Robert Schmidt of Ztiff Zox Softwear 1993

	Defines the member functions of the TestPatterns class declared in
		TestPat.HPP.
*/

#include <dos.h>
#include <mem.h>
#include <conio.h>
#include <iostream.h>
#include "Screen.HPP"
#include "TestPat.HPP"

extern char *graphScr;
extern unsigned *textScr;
extern unsigned editHeight;

// These are the text strings identifying each test to the user.

char *TestPatterns::string[TestPatterns::tests] =
	{
	"Text screen, 16 point",
	"Text screen, 8 point",
	"4 planes, 16 colors",
	"1 plane, 256 colors",
	"4 planes, 256 colors"
	};


// TestPatterns::run() puts the given test onto the screen.

void TestPatterns::run()
	{
	unsigned a,c;
	unsigned long offset;

	outportb(0x3c4,0x02);            	//get write plane enable
	unsigned plane=inportb(0x3c5);

	outportb(0x3d4,0x13);				//get screen width in words
	unsigned width=inportb(0x3d5)*2;	//convert to bytes

	// Now select the correct initialization method:

	switch (testNo)
		{
		case test1x256:
		case test4x16:
		case test4x256:
			// All graphics modes: clear the screen, but take care of
			//	write enabling all planes.
			outport(0x3c4,0x0f02);
			memset(graphScr, 0, 0xffff);
			outportb(0x3c4,0x02);
			outportb(0x3c5,plane);
			break;

		case testText16:				// set 8x16 font
			_AX = 0x1104;
			_BL = 0;
			geninterrupt(0x10);
			goto commonText;
		case testText8:					// set 8x8 font
			_AX = 0x1102;
			_BL = 0;
			geninterrupt(0x10);
commonText:
			// Just blank the text screen.
			memset(textScr, 0, 8000);
		}

	// Now for the selected pattern.  None of them are very impressive,
	//	but it kinda gives you an idea of the mode.  If you have ideas
	//	for more informative tests, please let me know!

	switch (testNo)
		{
		case testText16:
		case testText8:

			// Fill top line with the sequence "0123456789" lt grey/black:
			a = 0;
			for (c=0; c<width; c++)
				textScr[a++] = ('0'+(c+1)%10) | 0x0700;

			// Then fill 4 lines with the ASCII set in white on blue:
			for (c=0; c<5*width; c++)
				textScr[a++] = c | 0x1f00;

			// Now fill the rest with the sequence "ABCDEFGHIJ" in all color
			//	combinations (except blinking!):
			c = 0;
			while (a < 0x4800)
				textScr[a++] = ('A'+c%('K'-'A')) | ((c&0x7f)<<8), c++;
			break;

		case test1x256:

			// Fill the first 32 lines with 1 pixel wide colored vertical
			//	lines.
			for (c=0; c<width*4; c++)
				for (a=0; a<32; a++)
					graphScr[a*width*4+c]=c;

			// Fill the rest with 1 pixel high horizontal lines.
			c=0;
			offset=32*4*width;
			do	{
				memset(graphScr+offset, c++, width*4);
									//horizontal lines, 1 color each
				offset+=width<<2;
				}
			while (offset < (0xffff-width<<2));
			break;

		case test4x256:

			// This test is affected by the Write Plane Enable register.
			// First put up 32 horizontal lines in the 32 first colors.
			for (c=0; c<(width<<5); c++)
				graphScr[c]=c/width;

			// Then fill the rest with vertical lines.  This is too slow!
			offset=c;
			c=0;
			a=1;
			do	{
				outportb(0x3c5,a);	//Set write plane enable
				graphScr[offset]=c;

				if ((a<<=1)>8)
					{
					a=1;
					++offset;
					}
				if ((++c)==width<<2)
					c=0;
				}
			while (offset <= 0xffff);
			break;
		case test4x16:

			// Fill first 32 lines with thick vertical stripes alternating
			//	between black and the color selected by Write Plane Enable.
			for (c=0; c<(width<<5); c++)
				graphScr[c]=0x0f;

			// Fill the rest with various bit patterns, in all colors.
			for (a=0; a<256; a++)
				{
				outportb(0x3c5,a);
				memset(graphScr+4000+a*width, a, width);
				}
			break;
		}
	}


// tellTest() puts the name of the current test at the correct position on
//	the edit screen.

void TestPatterns::tellTest()
	{
	gotoxy(42,editHeight);
	textattr(TESTHEADER_COLOR);
	cprintf("Current test: ");
	textattr(TESTSTRING_COLOR);
	cprintf(string[testNo]);
	clreol();
	}
