/*
**   TRIM {filename} {number}
**
**         Trims a textfile {filename} down to the number of lines
**         specified in {number}.
**
*/

#include <io.h>
#include <stdio.h>
#include "gf.h"
#include "timedate.h"

#define BADUSAGE 1
#define NOFILE   2
#define NOWORK   3

main (argc, argv)

int   argc;
char  *argv[];

{
    FILE   *infile,*outfile;
    char   *temp_file = "TEMP$$$$.$$$";
    char   dummy[256];
    char   *cline;
    char   filename[15];
    int    i, nol, newlines, n, j;

    if (argc != 3)
    {
        printf ("USAGE: trim {filename} {number}\n");
        exit   (BADUSAGE);
    }
    newlines = (int)atol(argv[2]);
    cline    = argv[1];
    n = 0;
    while (!dossrch(cline,0,filename,(struct TIMEDATE *)0,(long *)0,(int *)0))
    {
      cline = NULL;
      printf ("%s  \n",filename);

      if ((infile = fopen (filename,"rt")) == NULL)
      {
          printf ("The file %s does not exist.\n",filename);
          exit (NOFILE);
      }

      nol = -1;
      while (! feof(infile))
      {
          nol++;
          fgets(dummy,255,infile);
      }
      rewind(infile);
      if (nol <= newlines) fclose(infile);
      else
      {
         outfile = fopen(temp_file,"wt");
         for (i = 0; i< (nol - newlines); i++)
             fgets(dummy,255,infile);
         for (;i<nol;i++)
         {
             fgets   (dummy,255,infile);
             fprintf (outfile,"%s",dummy);
         }
         fclose(infile);
         fclose(outfile);

         remove (filename);
         rename (temp_file,filename);
      }
    }

    exit(0);
}
