; Joystick control module
;  <bashing mode on>
;   Grrr! Why those wimpy IBM engineers chosed a stupid analog interface ?!?!?
;   Heck! If at least they included enough hardware support this 
;   could have been a little problem, but ...argh!... 
;   I hate polling things when lots of IRQs keeps knocking on the P.I.C. !!!!
;   Of course this is the "default stick" handling code, if you plan to
;   add cooler sticks, just write a XID driver and let it take control.
; <bashing mode off>
;
; Well, this is my "safe" joystick handling code
; there are better ways to handle sticks, but i know this works on anything


; What is needed to read the IBM joystick port:
;1.  Trigger the joystick oneshots with an 'out' to 0x201.
;    This will set all of the joystick bits on.

;2.  Read (in) 0x201, finding:

;	 Bit		 Contents
;	 0		 Joystick A X coordinate
;	 1		 Joystick A Y coordinate
;	 2		 Joystick B X coordinate
;	 3		 Joystick B Y coordinate
;	 4		 Button A 1
;	 5		 Button A 2
;	 6		 Button B 1
;	 7		 Button B 2
;
;3.  Continue reading 0x201 until ALL oneshots return to zero
;    (i've seen lots of joystic routines that seems to miss this)
;    recording the loop during which each bit falls to zero.
;    The duration of the pulse from each oneshot may be used to
;    determine the resistive load (from 0 to 100K) from each
;    Joystick, as: Time = 24.2msec. + .011 (r) msec.
;
;4.  To do this correctly, I recommend calibrating the joystick;
;    have the user move the stick to each corner, then center it,
;    while recording the resulting values.

; "Stick device group" indexes
; (this will be useful when i will expand joystick support
;  with "external" drivers).

; THIS IS THE ONLY SUPPORTED STICK (for now)
MAIN_JOYSTICK = 0

; these will be supported in 386P 3.00 , but you can add support
; for it as a programming exercise (hint: use 386menu for joystick
; configuration)
KEYB_JOYSTICK = 1
AUXA_JOYSTICK = 2
AUXB_JOYSTICK = 3


extrn _StickName:dword
        ; table of pointers (offsets) to "stick device names"
        ; NULL entries means the device is not present
        ; first entry  is the "main_joystick" name
        ; second entry is the "keyb_joystick" name
        ; and so on up to four entries

extrn _StickOK:near
        ; Checks if joystick device needs to be "initialized"
        ; before you can use it ( very useful with some joysticks)
        ; in: esi= stick device group index
        ; out: if carry clear then  joystick device doesn't need initialization

extrn _InitStick:near
        ; in: esi = stick device group index
        ; initializes and calibrates the sticks

extrn _ReadStick:near
        ; IN:   ESI = STICK DEVICE GROUP INDEX
        ; OUT:  EAX = STICK BITS for joystick 0,1
        ;       EDX = STICK BITS for joystick 2,3
        ;
        ; AX            = STICK0 
        ; EAX high word = STICK1
        ; DX            = STICK2
        ; EDX high word = STICK3
        ; Every joystick is described by 16 bits
        ; (it includes 3D motion and 3D rotation plus four buttons)
        ; bit  meaning
        ;   0  UP 
        ;   1  DOWN 
        ;   2  LEFT 
        ;   3  RIGHT 
        ;   4  FORWARD 
        ;   5  BACKWARD
        ;   6  TURN_UP      = rotate forward-->up
        ;   7  TURN_DOWN    = rotate forward-->down
        ;   8  TURN_LEFT    = rotate forward-->left
        ;   9  TURN_RIGHT   = rotate forward-->right
        ;  10  ROLL_LEFT    = rotate up-->left
        ;  11  ROLL_RIGHT   = rotate up-->right
        ;  12  BUTTON_0 
        ;  13  BUTTON_1 
        ;  14  BUTTON_2 
        ;  15  BUTTON_3
        
J_UP        =1
J_DOWN      =2
J_LEFT      =4
J_RIGHT     =8
J_FORWARD   =16
J_BACKWARD  =32
J_TUP       =64
J_TDOWN     =128
J_TLEFT     =256
J_TRIGHT    =512
J_RLEFT     =1024
J_RRIGHT    =2048
J_B0        =4096
J_B1        =8192
J_B2        =16384
J_B3        =32768
UPPER_STICK =65536

        ; N.B. A plain ibm-compatible analog joystick supports only two buttons
        ;      but because the "joystick control" routines can be overwritten
        ;      by a XID module, i added entries for up to four buttons.

