; XVD XGE Video Driver
; Header format
__XVD_SIGNATURE= 0
                ; It be the four byte signature 'XVD0'
                ; XGE Video Driver TYPE ZERO, four byte file marker
                ; use it to see if the binary file is  an XVD driver
                ; now here comes the driver base relative offsets
                ; of every function supported
__XVDBiosCheck=4
                ; driver-base relative pointer to  XVDBiosCheck
                ; Returns carry clear if video bios is present
                ; sets vram video pages count into driver table
                ; and available display mode mask
                ; in: edi= XVD driver table , ebp= driver base offset
__XVDChipSetCheck=8
                ; driver-base relative pointer to XVDChipSetCheck
                ; Returns carry clear if chipset is present
                ; sets vram video pages count into driver table
                ; and availabl;e display mode mask
                ; in: edi= XVD driver table , ebp= driver base offset

                  ; currently BOTH of these must be successful
                  ; to "get safe access" to the graphics extensions.
                  ;
                  ; If __XVDBiosCheck fails you should want the user
                  ; that bios is not recognized but it is possible to
                  ; test for the chipset and then try to set
                  ; the video mode hoping the mode set values
                  ; are not different.
                  ;
                  ; A future XGE release will try to use VESA functions
                  ; to set the video mode if _XXVDBiosCheck fails
                  ; and then if _XVDChipSetCheck is successful
                  ; it will "unlock" the extensions thru direct chipset access.
                  ;
                  ; To use "extended" multi-page mode 13h you only have
                  ; to check for the chipset (the bios entry is the same
                  ; for all boards) but remember to include in the bios check
                  ; the code needed to "unlock" the vga extensions.
                  ;
                  ; both __XVDBiosCheck and __XVDChipSetCheck
                  ; must be called with:
                  ; edi= XVD driver table ptr
                  ; ebp= driver base address
                  ; _XVDVPages,_XVDMappings,_XVDVModes and _XVDASize
                  ; will be updated to what the driver supports.

__XVDMode=12
                  ; driver-base relative pointer to XVDMode
                  ; Set video mode
                  ; eax=requested video mode
                  ; edi= XVD driver table ptr
                  ; ebp= driver base address
                  ; returns carry clear if successful

__XVDPage=16
                  ; driver-base relative pointer to XVDPage
                  ; Set the current "accessible"  64k video page
                  ; in: eax= video page number
                  ; out: edi= LINEAR address of video page
                  ;           (subtract _Code32Base to this to get
                  ;            the code32 relative offset)

__XVDVisible=20
                  ; driver-base relative pointer to XVDVisible
                  ; Set the base page of display buffer visible on screen
                  ; in: eax= video page number

__XVDOpen=24
                  ; driver-base relative pointer to XVDOpen
                  ; Opens the "linear aperture"
                  ; setting to the nearest aperture available on driver table
                  ; (the 386video module must write on _XVDAperture
                  ;  the "first" AVAILABLE PHYSICAL ADDRESS
                  ;  (nor a code32 relative address neither
                  ;   a "virtual memory" linear address, this functions
                  ;   needs a "raw" address).
                  ; edi=driver table, ebp=driver base address
                  ; Returns carry clear if successful

__XVDClose=28
                  ; driver-base relative pointer to XVDCLose
                  ; Closes the "linear aperture"
                  ; edi=driver table  ebp=driver base offset

__XVDLineSize=32
                  ; driver-base relative pointer to XVDLineSize
                  ; Set nex scanline width
                  ; in: eax= requested scanline size
                  ;     edi=driver table
                  ;     ebp=driver base address
                  ; out: nearest scanline size set into driver table

; RGB palette handling functions
; (identical to _Set1Pal,_Get1Pal,_Set256pal)
__XVDSet1Pal=36      ; driver-base relative pointer to XVDSet1Pal
__XVDGet1Pal=40      ; driver-base relative pointer to XVDGet1Pal
__XVDSet256Pal=44    ; driver-base relative pointer to XVDSet256Pal
__XVDCardType=48     ; driver-base relative pointer to ASCIIZ string
                     ; max. 30 character long
__XVDProgrammer=52   ; driver-base relative pointer to ASCIIZ string
                     ; with multiple lines of text,max. 40 char each
                     ; (use the LF char (code 10h) to mark newlines)
__XVDNotes=56        ; driver-base relative pointer to ASCIIZ string
                     ; with multiple lines of text,max. 40 char each
                     ; (use the LF char (code 10h) to mark newlines)
                     ; Of notes about the driver usage and supperted display
                     ; cards
