Area: CEchoFIDO			Date: 12-24-93
From: Richard Myers		To: All
Subj: Initialization file

I've searched through eight books on Borland C++ looking for information on
setting up application configuration or ????????.INI files. Also looked
through snippets (what is the most recent version of snippets?).

While the coding doesn't seem all that complicated, I am a bit surprised that
I haven't been able to find any examples.

The goal is simply to pass filename strings and path strings to the
application, and thereby give to the end-user the ability to modify the
program's selection of files by changing ascii text.

Does anyone have some example code for reading in strings from an ascii
configuration file? (String tables created with the Resource Workshop are
bundled with the executable, and therefore are not accessible as ascii.)

thanks!
Richard

-!- msged 2.07
 ! Origin: Long Distance Operations  (1:104/90.2)

Area: CEchoFIDO			Date: 12-24-93
From: Micah Dubinko		To: Charles Nance
Subj: Config file 1 of 2

CHARLES NANCE was once overheard saying:


CN>if (strncmp(strings[index],"DATA ",5) == 0)
CN> {......}

CN>This seems to me to be a very long and drawn out way to do it, with making
CN>checking for all keywords, and that no lines without keywords exist very
CN>difficult.  Does anyone have a sample of how they have coded to read a confi
CN>file that I may look at to kind of see some other possibilities.

Charles,

I've posted some .INI routines here before, but not my latest version here...
I agree, string processing in C does take some getting used to, especially if
you've worked with another language like BASIC or Pascal.

Well, here's the code, it's kinda long so I'll split it into two messages.
Let me know what you think!


/* INI routines and sample program--contributed into the public domain */
/* Written by Michael Stowe, and modified by Micah Dubinko             */
/* Fully ANSI compliant */

/* Global declarations  */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <conio.h>

#define MAX_CHARS 81          /* Maximum characters/line in INI file */
#define NEWLINE   "\r\n"

char *ini_buffer;             /* storage area for .INI file          */

int read_ini(char *ini_name);
char *find_header(char *header_name);
char *get_parameter(char *dest, char *param_name, char *offset);


int read_ini(char *ini_name)
{
/* This function prepares an *.INI file for processing.  There's no error */
/* checking on the filename you pass to it.  Returns the number of bytes  */
/* read, or NULL on an error condition                                    */

long len;
FILE *handle;
char temp_buf[MAX_CHARS];

if ((handle=fopen(ini_name, "rb"))==NULL)     /* Binary mode, no CR/LF */
   {                                          /* translation           */
   puts("Error opening INI file");
   return(NULL);
   }

if ((fseek(handle, 0, SEEK_END))!=NULL)
   {
   puts("Error Determining INI file size");
   }

len=ftell(handle);
rewind(handle);

if (len >65534)
   {
   puts("INI file too big");
   return(NULL);
   }

if ((ini_buffer=(char *)malloc(len + 1))==NULL)
   {
   puts("Out of memory");
   return(NULL);
   }

fread(ini_buffer, len, 1, handle);
ini_buffer[len]='\0';

return (strlen(ini_buffer));
}

char *find_header(char *header_name)
{
/* O.K. see my previous message for the SAMPLE.INI file to test this  */
/* program with.  You'll notice it has [Headers] enclosed in brackets, */
/* and always at the beginning of a line.  This routine will locate a  */
/* given header, and return a pointer to it, within the global string  */
/* ini_buffer.  If not found, returns a pointer to NULL                */

char temp_buf[MAX_CHARS];

strcpy(temp_buf, NEWLINE);              /* A newline                   */
strcat(temp_buf, "[");                  /*  and the opening bracket [  */
strcat(temp_buf, header_name);
strcat(temp_buf, "]");

return(strstr(ini_buffer, temp_buf)+strlen(NEWLINE));
}

char *get_parameter(char *dest, char *param_name, char *offset)
{
/* It's all downhill from here! (not)  Next, this routine scans through  */
/* the INI file, starting at offset, and looking for param_name followed */
/* immediately by an "=".  If found, a pointer to the string will be     */
/* returned (in the form Value=Parameter, or else a pointer to NULL.     */

char temp_buf1[MAX_CHARS];
char temp_buf2[MAX_CHARS];
char *start_ptr;
char *end_ptr;
char *too_far_ptr;

strcpy(temp_buf1, NEWLINE);
strcat(temp_buf1, param_name);
strcat(temp_buf1, "=");

if((start_ptr=strstr(offset, temp_buf1))==NULL)
   {
   *dest=NULL;
   return(dest);
   }
start_ptr+=strlen(NEWLINE);

if((too_far_ptr=strstr(offset+1, "["))==NULL)
   too_far_ptr=offset+strlen(offset);

if((end_ptr=strstr(start_ptr, NEWLINE))==NULL)
   end_ptr=start_ptr+strlen(start_ptr);

if (too_far_ptr<start_ptr)
   {
   *dest=NULL;
   return(dest);
   }

memcpy(temp_buf2, start_ptr, end_ptr-start_ptr);
temp_buf2[end_ptr-start_ptr]='\0';

strcpy(dest, temp_buf2);
return(dest);
}

int main(void)
{
char *offset;
char dest[MAX_CHARS];

clrscr();                      /*  Ok, ok, delete this line for true ANSI */
read_ini("SAMPLE.INI");
offset=find_header("ProgramInfo");    /* This _is_ case sensitive */
get_parameter(dest, "Date", offset);
puts(dest);
}

This worked last time I tested it, and compiled clean under ANSI restrictions
in the Borland C++ 2.0 compiler.  Please report any bugs to me ASAP!!!
The comments refer to a SAMPLE.INI file...  Here's a short .INI file instead:

[Data]
Today=December 24
  This line has no equals sign or square brackets, and will be ignored

[ProgramInfo]
Time=00:15:37
Date=12/24/93
... Look at a WIN.INI or CONFIG.SYS file if you need more.
\Micah

