/*	
	ASSUMPTIONS:
	EACH SCORE COULD AT MOST BE 100
	THERE ARE 5 TOTAL SCORES
*/
#define	MAX	5
#define NULL 0
struct student {
	char	name[40];
	int		scores[MAX];
	char	grade;
};
struct classr {
	int classnum;
	struct 	student	person[35];
	void (*process)(struct student *);
};

void ave( struct student *);
void totpoints( struct student *);
void calc( struct classr * );
void printclass( struct classr * );

main()
{
	int i, select;

	/* initialized data structure with all class information */
	static	struct	classr 	cis123 = {
		123456,  
		{
			{ "rick", { 90, 67, 87, 88, 100 } },
			{ "john", { 90, 78, 85, 56, 87 } },
			{ "jim", { 90, 95, 78, 93, 88 } },
			{ "deb", { 90, 95, 78, 84, 87 } },
			{ "sam", { 90, 95, 67, 86, 99 } },
			{ "paul", { 78, 93, 88, 67, 77 } },
			{ "gary", { 90, 75, 78, 93, 98 } },
			{ "malia", { 90, 65, 99, 82, 100 } },
			{ "rachel", { 90, 99, 76, 89, 99 } },
			{ "", { 0, 0, 0, 0, 0 } }
		},
		0  /* function pointer place holder */
	};

	/* Process type selection */
	printf("How will class score be determined?\n");
	printf("\t(1) Total Point Accumulation\n");
	printf("\t(2) Total Point Average\n");
	printf("\nEnter number: ");
	scanf("%d", &select);

	/* Total Point Accumulation */
	if(select == 1){
		cis123.process = totpoints;
		calc(&cis123);
	}
	/* Total Point Average */
	else if(select == 2){
		cis123.process = ave;
		calc(&cis123);
	}
	/* Error */
	else {
		printf("Wrong selection!\n");
		exit(1);
	}

	/* Now print the class grades ... */
	printclass(&cis123);
}

/* 
 * Calculate the grades of all students in a specific class
 */
void calc(struct classr *p1)
{
	int	i ;
	for(i=0; p1->person[i].name[0] != 0; i++){
		printf("Processing: %s's scores\n",p1->person[i].name); 
		/*
		 * call the grade processing function 
		 * pass the address of one student structure
		 * for processing
		 */
		(*p1->process)(&p1->person[i]) ;
	}
}

/* 
 * Print the grades of all students in a specific class
 */
void printclass(struct classr *p1)
{
	int	i;
	for(i=0; p1->person[i].name[0] != 0; i++)
		printf("%s - Grade = %c\n", 
		        p1->person[i].name, p1->person[i].grade);
}

/* 
 * Calculate a student's grade based on total point accumulation
 */
void totpoints( struct student *ptr)
{
	int	i, total=0;

	/* Calculate grade */
	for(total=0, i=0; i<MAX; i++)
		total += ptr->scores[i];

	/* Log grade */
	if(total > 450)
		ptr->grade = 'A';
	else if(total > 400)
		ptr->grade = 'B';
	else if(total > 350)
		ptr->grade = 'C';
	else if(total > 300)
		ptr->grade = 'D';
	else
		ptr->grade = 'F';
}

/* 
 * Calculate a student's grade based on total point average
 */
void ave( struct student *ptr )
{
	int	i, total=0;
	float	grade;

	/* Calculate grade */
	for(total=0, i=0; i<MAX; i++)
		total += ptr->scores[i];
	grade = total/MAX;

	/* Log grade */
	if(grade > 90)
		ptr->grade = 'A';
	else if(grade > 80)
		ptr->grade = 'B';
	else if(grade > 70)
		ptr->grade = 'C';
	else if(grade > 60)
		ptr->grade = 'D';
	else
		ptr->grade = 'F';
}
