/********************************************************
*	SHIFTLOK.C - manipulate the BIOS keyboard status	*
*	To compile: cl shiftlok								*
********************************************************/

#include <stdio.h>
#include <dos.h>

/* Key definitions in the BIOS data region */
#define RIGHT_SHIFT		0x0001
#define LEFT_SHIFT		0x0002
#define CTRL_KEY		0x0004
#define ALT_KEY			0x0008
#define SCROLLLOK_MODE	0x0010
#define NUMLOK_MODE		0x0020
#define CAPSLOK_MODE	0x0040
#define INSERT_MODE		0x0080
#define LEFT_CTRL		0x0100
#define LEFT_ALT		0x0200
#define SYS_REQ			0x0400
#define PAUSE_MODE		0x0800
#define	SCROLLLOK_KEY	0x1000
#define NUMLOK_KEY		0x2000
#define CAPSLOK_KEY		0x4000
#define INSERT_KEY		0x8000

/* Settings for setKbdStatus */
#define	OFF				10
#define ON				11
#define TOGGLE			12

/****************************************************************
*	setKbdStatus - set the status of a key or mode				*
*	INP:	key - key or mode to alter							*
*			setting - OFF, ON, or TOGGLE						*
****************************************************************/
void setKbdStatus(unsigned key, int setting)
	{
	unsigned int far *p;

	FP_SEG(p) = 0x0040;
	FP_OFF(p) = 0x0017;
	if (setting==TOGGLE)	*p ^= key;
	else if (setting==ON)	*p |= key;
	else if (setting==OFF)	*p &= !key;
	}

/****************************************************************
*	getKbdStatus - return the status of a key or mode			*
*	INP:	key - the key or mode to retrieve the status of		*
*	OUT:	0 if mode or key is OFF, 1=ON						*
****************************************************************/
int getKbdStatus(unsigned key)
	{
	unsigned int far *p;

	FP_SEG(p) = 0x0040;
	FP_OFF(p) = 0x0017;
	return *p & key;
	}

/****************************************************************
*	main() - demonstration program to show how to use the		*
*	getKbdStatus() and setKbdStatus() functions.				*
****************************************************************/
void main(void)
	{
	char buff[100];

	printf("Current right shift key status is: %s\n",
		getKbdStatus(RIGHT_SHIFT) ? "on" : "off");
	puts("Get a string with the current right shift key status");
	gets(buff);
	
	setKbdStatus(RIGHT_SHIFT,TOGGLE);
	puts("Get a string with the opposite right shift status");
	gets(buff);
	}
