Comment *
Ŀ
title	 : jzredscr							     
Purpose : read directly from the screen buffer without snow		     
Notes	 : Yes, even reading from the screen causes snow !!!		     
(C) JazSoft Software by Jack A. Zucker (301) 794-5950			     

 *
title	print directly to screen buffer
name	jzredscr

	assume cs:_text
_text	segment public byte 'code'
	public _jzredscr

_jzredscr	 proc	 near
	push bp
	mov bp,sp
	push si
	push di
	push ds
	push es
	mov al,[bp+6]		; get row
	mov bx,50h		; 50 columns (hex)
	mul bl			; row offset = # columns * row
	mov bx,ax		; put value back in bx
	add bx,[bp+8]		; add column
	shl bx,1		; multiply by 2
	mov si,bx		; screen seg:di = offset for writing

	mov cx,[bp+0Ah] 	; get length in cx

	push ds 		; save ds for mode check
	mov ax,40h		; low memory information segment
	mov ds,ax
	mov di,49h		; screen mode
	cmp byte ptr [di],7	; 7 = mono mode
	mov di,[bp+4]		; get offset of first character
	pop es			; restore our data into dest segment
	jz mono 		; [si] = 7 means mono mode
	mov ax,0b800h		; color screen segment
	mov ds,ax
next:
	mov dx,3dah		; address of 6845 Status register

Comment *
Ŀ
 This next section which only gets executed in color mode checks the status 
 register of the 6845 crt controller chip. When bit 0 is set to 1 we can    
 update the screen without snow. The process is to check to see if it's set 
 to one and loop until it's not. Then loop until it's High and fall out of  
 the loop and write the character. The reason it's done this way is in case 
 you initially check the status and it's at the very end of a retrace. In   
 that case, you would think that it is safe to write to the screen buffer   
 but my way takes care of a partially complete retrace on the first try.    
 Examine the code on pertaining to bios int 9 in the Ibm technical reference
 manual. Note that this code is unnecessary for many compatibles as they do 
 not have the same bug in their displays as the Ibm pc does.		     

 *

status_low:
	in al,dx		; get vertical retrace status
	ror al,1		; faster than test
	jc status_low		; wait for partially done retrace
	cli			; don't allow any more interrupts
status_high:
	in al,dx		; wait for beginning of new retrace
	ror al,1
	jnc status_high 	; retrace not started

	sti			; interrupt allowed now
	movsb			; screen to string
	inc si			; point to next position (attribute)
	loop next
	jmp endofdsp

mono:
	mov ax,0b000h		; Mono screen segment
	mov ds,ax
next2:
	movsb
	inc si			; point to next char position
	loop next2
endofdsp:
	mov bh,0
	mov es:[di],bh		; c needs a zero terminating byte
	mov cx,[bp+0Ah] 	; get length
	sub di,cx		;
	mov ax,di		; return pointer to destination string
	pop es
	pop ds
	pop di
	pop si
	mov sp,bp
	pop bp
	ret
_jzredscr endp
_text ends
end
