/*
Ŀ
jzrplstr.c								     
Replace characters in a string.					     
Notes, no check is done for the length exceeding the sizeof(fdestin) so     
you must be sure to allow enough space.				     
									     
synopsis:								     
   char *s="this is a test";                                                
   jzrplstr(s,"THIS",0,4);                                                  
   { becomes "THIS is a test" }                                             
									     
 (c) JazSoft 1986 by Jack A. Zucker @301-794-5950 | CIS:75766,1336	     

*/

#include <jaz.h>
jzrplstr(fdestin,fsource,fstart,fnum)
char *fdestin;		/* source string */
char *fsource;		/* destination string */
int fstart;		/* starting index */
int fnum;		/* number of chars to replace */
{

  int wslen,wdlen;		/* source and destination length */
  int wpos,w;

  wslen = strlen(fsource);	/* length of source */
  wdlen = strlen(fdestin);	/* length of destin */

  fnum = min(wslen,fnum);	/* don't put more chars then we have */

  wpos	= min(fstart,wdlen);	/* don't go beyond end of string */

  fdestin += wpos;		/* point to starting position */

  while (wpos < fstart) {	/* check for start pos > than destin string */
    *fdestin++ = ' ';           /* pad with blanks */
    fstart --;
  }

  for (w = 0 ; w < fnum ; w++)	/* insert the string */
    *fdestin++ = *fsource ++;

				/* did we pad with blanks earlier? */
  if (wpos + fnum >= wdlen) *fdestin = 0;

}

