/*
 * sample 10
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mgui.h"

void ExitCB(MOBJECT obj, void *a, void *b)
{
	obj = MObjectShell(obj);
	MShellUnrealize(obj);
	MShellDestroy(obj);
	MGUITerm();
	exit(0);
}

void ItemCheckCB(MOBJECT obj, void *item, void *udata)
{
	int status;
	char str[128];

	status = MToggleItemCheckStatus(obj, item);
	sprintf(str, "The selected menu item\nhas been %s",
		(status ? "Activated" : "Deactivated"));
	MMessageDialog("", str, "Ok", NULL);
}

void ItemSelectCB(MOBJECT obj, void *item, void *udata)
{
	char str[128];

	sprintf(str, "Menu item <%d> selected", (int)item);
	MMessageDialog("", str, "Ok", NULL);
}

void MGUIMain(int argc, char **argv)
{
	MOBJECT shell, menu, pdown, subpd;
	PULLDOWN_ITEM pd_item_id;

	shell = MCreateShell("Sample 10", 0);

	menu = MCreateMenuBar(shell, HELV_L_FONT);
	MMenuSetAcc(menu, F10);
	pdown = MCreatePullDown(menu, "File");
	MPullDownAddItem(pdown, "Quit", ExitCB, NULL);

	pdown = MCreatePullDown(menu, "Submenu");
	MPullDownAddItem(pdown, "Item 1", ItemCheckCB, NULL);
	pd_item_id = MPullDownAddItem(pdown, "Item 2", NULL, NULL);
	MPullDownAddItem(pdown, "Item 3", ItemCheckCB, NULL);

	subpd = MCreateSubPullDown(pdown, pd_item_id);
	MPullDownAddItem(subpd, "subItem 3-1", ItemSelectCB, NULL);
	MPullDownAddItem(subpd, "subItem 3-2", ItemSelectCB, NULL);
	MPullDownAddItem(subpd, "subItem 3-3", ItemSelectCB, NULL);

	MShellRealize(shell);

	MMainLoop();
}
