/*
 * This file is part of the MGUI (MORELLO Graphic User Interface)
 * development tool.
 * Cointains all MGUI function prototypes
 */


#ifndef _MGUI_H
#define _MGUI_H

#include "mguidefs.h"

int	MPaletteMode(void);
int	MGetScreenWidth(void);
int	MGetScreenHeight(void);
int	MGetNPlanes(void);
long	MGetNColors(void);
MTColor	MBlackColor(void);
MTColor	MWhiteColor(void);

char	*MGetSysDir(void);

void	MMainLoop(void);
void	MLoopWhileFlag(int *pflag, int value);
void	MLoopWhileEvents(int discard);
int	MPeekEvent(MEvent *pe, int remove);
void	MProcessEvent(MEvent *pe);
void    MGUITerm(void);


MTFont	MLoadFont(char *family, int h, int bold, int italic);
void	MUnloadFont(MTFont font);

int     MTextCharX(char *text, MTFont font, int x);
int     MTextHeight(char *text, MTFont font);
int     MCharHeight(char car, MTFont font);
int     MTextWidth(char *text, MTFont font);
int     MTextNWidth(char *text, MTFont font, int len);
int     MCharWidth(char car, MTFont font);

void    MBeep(void);

MTColor	MAllocColor(int r, int g, int b);
MTColor	MAllocShiftColor(MTColor col, int shift);
void	MFreeColor(MTColor col);
MTColor	MAllocCell(int r, int g, int b);
void	MSetCellColor(MTColor c, int r, int g, int b);
void    MFreeCell(MTColor c);
void    MQueryColor(MTColor col, int *pr, int *pg, int *pb);

void MGetDefaultBackgroundRGB(int *pr, int *pg, int *pb);
void MSetDefaultBackgroundRGB(int r, int g, int b);
MTColor  MAllocDefaultBackgroundColor(void);


void MDrawText(MOBJECT p, int x, int y, int w, int h, char *text,
		MTFont font, MTColor fgc, int align);
void MDrawNText(MOBJECT p, int x, int y, int w, int h, char *text,
		MTFont font, MTColor fgc, int align, int n);
void MDrawBGText(MOBJECT p, int x, int y, int w, int h, char *text,
		MTFont font, MTColor bgc, MTColor fgc, int align);
void MDrawBGNText(MOBJECT p, int x, int y, int w, int h, char *text,
		MTFont font, MTColor bgc, MTColor fgc, int align, int n);

void MDrawPoint(MOBJECT p, int x, int y, MTColor col);
void MDrawLine(MOBJECT p, int x1, int y1, int x2, int y2, MTColor col);
void MDrawPolyline(MOBJECT p, MPOINT *points, int n, MTColor col);
void MDrawFilledPolyline(MOBJECT p, MPOINT *points, int n, MTColor col);
void MDrawBox(MOBJECT p, int x, int y, int w, int h, MTColor bgc);
void MDrawFilledBox(MOBJECT p, int x, int y, int w, int h, MTColor bgc);
void MDrawCircle(MOBJECT p, int x, int y, int r, MTColor col);
void MDrawFilledCircle(MOBJECT p, int x, int y, int r, MTColor col);
void MDrawArc(MOBJECT p, int x, int y, int r, int a1, int a2, MTColor col);
void MDrawFilledArc(MOBJECT p, int x, int y, int r, int a1, int a2, MTColor c);
void MDrawPixmap(MOBJECT p, MPIXMAP gi, int pm_x, int pm_y, int w, int h,
		int x, int y);

void MDrawXorLine(MOBJECT p, int x1, int y1, int x2, int y2);
void MDrawXorBox(MOBJECT p, int x, int y, int w, int h);

void MObjectSetUnsensitive(MOBJECT obj);
void MObjectSetSensitive(MOBJECT obj);
void MObjectSetSensitivity(MOBJECT obj, int status);
int MObjectGetSensitivity(MOBJECT obj);

void MObjectSetUnselectable(MOBJECT obj);
void MObjectSetSelectable(MOBJECT obj);

char *MObjectGetText(MOBJECT obj, char *text);
void MObjectSetText(MOBJECT obj, char *text);
void MObjectSetName(MOBJECT obj, char *name);
void MObjectSetColor(MOBJECT obj, MTColor bgc, MTColor fgc);
void MObjectSetBackgroundRGB(MOBJECT obj, int r, int g, int b);
void MObjectSetForegroundRGB(MOBJECT obj, int r, int g, int b);
void MObjectSetFont(MOBJECT obj, MTFont font, int resize);
void MObjectSetShadow(MOBJECT obj, int type, int in, int out);
void MObjectSetResize(MOBJECT obj, int resize_w, int resize_h);

void MObjectRedraw(MOBJECT obj);
void MObjectMap(MOBJECT obj);
void MObjectUnmap(MOBJECT obj);
void MObjectResize(MOBJECT obj, int w, int h);
void MObjectDestroy(MOBJECT obj);

void MDispatchObjEvent(MOBJECT p, MEvent *pe);
void MObjectSetEventNotifyCallback(MOBJECT obj, OBJ_EVENT_CB cb, long mask,
		void *a_data);
void MObjectSetDestroyCallback(MOBJECT obj, MGUI_CB cb, void *a_data);

void *MObjectGetUserData(MOBJECT obj);
void MObjectSetUserData(MOBJECT obj, void *ud);
int  MObjectType(MOBJECT obj);
int  MObjectWidth(MOBJECT obj);
int  MObjectHeight(MOBJECT obj);
MOBJECT MObjectParent(MOBJECT obj);
MTColor MObjectBackgroundColor(MOBJECT obj);
MTColor MObjectForegroundColor(MOBJECT obj);
MTFont	MObjectGetFont(MOBJECT obj);

/* MPIXMAP */

MPIXMAP MReadPixmapFile(char *fname);
MOBJECT MCreatePixmapFromData(MOBJECT parent, MPIXMAP data);
MOBJECT MCreatePixmapFromFile(MOBJECT parent, char *fname);
void	MPixmapSetImage(MOBJECT pixmap, MPIXMAP gi);
void	MFreePixmap(MPIXMAP data);
void	MInstallPixmap(MPIXMAP data);
void	MUninstallPixmap(MPIXMAP data);


/* SHELL */

MOBJECT MCreateShell(char *title, int flags);
MOBJECT MObjectShell(MOBJECT obj);
Window  MShellGetWindow(MOBJECT s);
void    MShellDestroy(MOBJECT obj);
void MShellSetTitle(MOBJECT obj, char *title);
void MShellGetTitle(MOBJECT obj, char *title);
void MShellRealize(MOBJECT obj);
void MShellRealizeXY(MOBJECT obj, int x, int y);
void MShellRealizeXYWH(MOBJECT obj, int x, int y, int w, int h);
void MShellUnrealize(MOBJECT obj);
void MShellSetWMCloseCallback(MOBJECT p, WM_CLOSE_CB cb, void *a_data);

/* MLOG */

void	MLogInit(int level, int nr, int nvr, int nc, int nvc, char *fname);
void	MLog(int level, char *fmt, ...);
void	MMaskedLog(int level, CARD32 mask, char *fmt, ...);
void	MLogSetLevel(int level);
void	MLogSetMask(CARD32 a);
CARD32	MLogGetMask(void);
void	MLogSetMaskBits(CARD32 a);
void	MLogResetMaskBits(CARD32 a);

/* SPOOL */

int	MSpoolFile(char *fname);
int	MSpoolTempFile(char *fname);

/* FORM */

MOBJECT MCreateRowForm(MOBJECT parent);
MOBJECT MCreateColForm(MOBJECT parent);
MOBJECT MCreatePagedForm(MOBJECT parent, int npage);
MOBJECT MCreatePagedFormExt(MOBJECT parent, int npage);
MOBJECT MCreateScrolledForm(MOBJECT parent, int clip_w, int clip_h);
MOBJECT MCreateClippedForm(MOBJECT parent, int clip_w, int clip_h);
void    MFormSetSpacing(MOBJECT p, int offset);
void    MFormSetChildSelectCallback(MOBJECT p, OBJ_VALUE_CB cb, void *data);
MOBJECT MGetSelectedObject(MOBJECT f);
void    MSelectObject(MOBJECT f);
int	MSelectFirstChild(MOBJECT f);
int	MSelectLastChild(MOBJECT f);
void	MSelectNextBrother(MOBJECT f);
void	MSelectPreviousBrother(MOBJECT f);
void	MSelectNextCousin(MOBJECT p);
void	MSelectPreviousCousin(MOBJECT p);
void    MFormSetPrefAtt(MOBJECT p, int pref_att);
void    MTopAttach(MOBJECT child, int att_type, int off, MOBJECT obj);
void    MBottomAttach(MOBJECT child, int att_type, int off, MOBJECT obj);
void    MRightAttach(MOBJECT child, int att_type, int off, MOBJECT obj);
void    MLeftAttach(MOBJECT child, int att_type, int off, MOBJECT obj);
void    MFormSetFocusWrap(MOBJECT f, int true_false);
void 	MFormSetFocusHighlight(MOBJECT f, int true_false);
void    MFormFocusLink(MOBJECT obj1, MOBJECT obj2);
void    MPagedFormSetActivePage(MOBJECT form, int page);
void    MFormSetClipX(MOBJECT obj, int clip_x);
void    MFormSetClipY(MOBJECT obj, int clip_y);
int	MFormGetClipX(MOBJECT obj);
int	MFormGetClipY(MOBJECT obj);
void    MFormAddKeyCallback(MOBJECT shell, int key, OBJ_VALUE_CB cb, void *ad);
MOBJECT MFormGetFirstChild(MOBJECT form);
MOBJECT MFormGetNextChild(MOBJECT form);
int     MFormGetNChildren(MOBJECT form);
void	MInsertObject(MOBJECT parent, MOBJECT obj, MOBJECT where, int resize);
void	MDeleteObject(MOBJECT obj, int resize);
void	MReparentObject(MOBJECT parent, MOBJECT obj, MOBJECT where);
void	MObjectSetAttachment(MOBJECT obj, int top, int bot, int left, int rig);
void	MObjectSetOffset(MOBJECT obj, int t_o, int b_o, int l_o, int r_o);

/* DRAWAREA */

MOBJECT MCreateDrawArea(MOBJECT parent, int width, int height);
void    MDrawAreaSetExposeCallback(MOBJECT obj, OBJ_EVENT_CB cb, void *ad);
void    MDrawAreaSetInputCallback(MOBJECT obj, OBJ_EVENT_CB cb, void *ad);
void    MDrawAreaSetResizeCallback(MOBJECT obj, DRAWAREA_PREF_CB cb, void *ad);


/* LABEL */

MOBJECT MCreateLabel(MOBJECT parent, char *text, MTFont font);
void	MLabelSetMargin(MOBJECT p, int wm, int hm);
void	MLabelSetHSpacing(MOBJECT p, int hs);
void	MLabelSetAlignment(MOBJECT p, int align);
const char *MLabelValue(MOBJECT label);

/* PBUTTON */

MOBJECT MCreateDrawnPButton(MOBJECT parent, MPIXMAP pn, MPIXMAP pa, MPIXMAP pu);
MOBJECT MCreatePixmapPButton(MOBJECT parent, char *npf, char *apf, char *upf);
MOBJECT MCreatePButton(MOBJECT parent, char *text, MTFont font);
void    MPButtonSetCallback(MOBJECT button, MGUI_CB cb, void *data);
void    MPButtonSetAccelerator(MOBJECT button, int key);
void    MPButtonSetRepeatDelay(MOBJECT button, int first, int repeat);
void    MPButtonSetMargin(MOBJECT p, int wm, int hm);
void	MPButtonSetHSpacing(MOBJECT p, int hs);
void	MPButtonSetAlignment(MOBJECT p, int align);
void	MPButtonSetPixmap(MOBJECT obj, char *npf, char *apf, char *upf);

/* RBUTTON */

MOBJECT MCreateDrawnRButton(MOBJECT parent, MPIXMAP np, MPIXMAP ap, MPIXMAP up);
MOBJECT MCreatePixmapRButton(MOBJECT parent, char *npf, char *apf, char *upf);
MOBJECT MCreateRButton(MOBJECT parent, char *text, MTFont font);
void	MRButtonActivate(MOBJECT o);
void	MRButtonSetCallback(MOBJECT button, OBJ_VALUE_CB cb, void *data);
int	MRButtonGetActivationStatus(MOBJECT o);
void	MRButtonSetPixmap(MOBJECT obj, char *npf, char *apf, char *upf);

/* TBUTTON */

MOBJECT MCreateDrawnTButton(MOBJECT parent, MPIXMAP np, MPIXMAP ap, MPIXMAP up);
MOBJECT MCreatePixmapTButton(MOBJECT parent, char *npf, char *apf, char *upf);
MOBJECT MCreateTButton(MOBJECT parent, char *text, MTFont font);
void	MTButtonActivate(MOBJECT o);
void	MTButtonDeactivate(MOBJECT o);
void	MTButtonSetCallback(MOBJECT button, OBJ_VALUE_CB cb, void *data);
void	MTButtonSetActivationStatus(MOBJECT o, int status);
int	MTButtonGetActivationStatus(MOBJECT o);
void	MTButtonSetPixmap(MOBJECT obj, char *npf, char *apf, char *upf);


/*STATUSBAR */

MOBJECT MCreateStatusBar(MOBJECT parent, char *text, int max, MTFont font);
void    MStatusBarSetMax(MOBJECT p, int max);
void    MStatusBarSetWidth(MOBJECT p, int width);
void    MStatusBarSetPos(MOBJECT p, int pos);

/* SCROLLBAR */

MOBJECT MCreateScrollBar(MOBJECT parent, int type, long n, long max);
void    MScrollBarSetMax(MOBJECT p, long max);
void    MScrollBarSetPos(MOBJECT p, long pos);
void    MScrollBarSetN(MOBJECT p, long n);
void    MScrollBarSetIncr(MOBJECT p, int incr);
void    MScrollBarSetPosCallback(MOBJECT edit, OBJ_VALUE_CB cb, void *data);
long    MScrollBarGetMax(MOBJECT p);
long    MScrollBarGetPos(MOBJECT p);
long    MScrollBarGetN(MOBJECT p);

/* SBLIST */

MOBJECT MCreateSText(MOBJECT parent, char *text, MTFont font,
		int nrow, int ncol);
MOBJECT MCreateSTextClip(MOBJECT parent, NEW_BLOCK_CB nb, void *nbd,
		MTFont font, int nrow, int ncol, int xc, long xn);
MOBJECT MCreateSFile(MOBJECT parent, char *fname, MTFont font,
		int nrow, int ncol);
MOBJECT MCreateSList(MOBJECT parent, MTFont font, int row_len,
		int nrow, int ncol);
MOBJECT MCreateSListMultiSel(MOBJECT parent, MTFont font,
		int row_len, int nrow, int ncol);
MOBJECT MCreateSListClip(MOBJECT parent, NEW_BLOCK_CB nb, void *nbd,
		ITEM_SEEK_CB is, void *isd, MTFont font,
		int nrow, int ncol, int xc, long xn);
MOBJECT MCreateSListSkip(MOBJECT parent, NEW_BLOCK_CB nb, void *nbd,
		ITEM_SEEK_CB is, void *isd, MTFont font,
		int nrow, int ncol, int xc);

MOBJECT MCreateEditList(MOBJECT parent, MTFont font, EL_TEMPLATE *elt,
		int ne, int nrow, int ncol);

LIST_ACT *MSListGetFirstItem(MOBJECT p);
LIST_ACT *MSListGetFirstSelectedItem(MOBJECT p);
LIST_ACT *MSListGetNextItem(MOBJECT p);
LIST_ACT *MSListGetNextSelectedItem(MOBJECT p);
LIST_ACT *MSListGetFirstUnselectedItem(MOBJECT p);
LIST_ACT *MSListGetNextUnselectedItem(MOBJECT p);
long MSListGetNItem(MOBJECT p);

void MSListSelectItem(MOBJECT p, char *item);
void MSListDeselectItem(MOBJECT p, char *item);
void MSListSelectElement(MOBJECT p, long n);
void MSListDeselectElement(MOBJECT p, long n);
void    MSListClear(MOBJECT p);
int     MSListAddItem(MOBJECT p, char *item, void *data);
int     MSListDelItem(MOBJECT p, char *item);
int     MSListDelElement(MOBJECT p, long n);
void    MSListChangeItem(MOBJECT p, char *old, char *new, void *u_data);
void    MSListChangeElement(MOBJECT p, long n, char *new, void *u_data);
LIST_ACT *MSListGetItem(MOBJECT p, char *item);
char    *MSListGetElement(MOBJECT p, long n);
char    *MSListGetSelected(MOBJECT p);
void    MSListSetCallback(MOBJECT obj, LIST_ACT_CB cb, void *data);
void    MSListSetSortCallback(MOBJECT obj, STRCMP_CB cb);
void    MSListFreeze(MOBJECT obj);
void    MSListThaw(MOBJECT obj);
void    MSBLSetHead(MOBJECT obj, char *text);
void    MSBLHeadSetColor(MOBJECT obj, MTColor bgc, MTColor fgc);

void    MSTextSetString(MOBJECT p, char *text);

void    MSFileSetFile(MOBJECT obj, char *fname);

void    MSBLSetHMargin(MOBJECT p, int hm);

int     MEditListAddItem(MOBJECT p, char **argv, void *u_data);
void    MEditListChangeElement(MOBJECT p, long n, char **new, void *data);
void    MEditListDelElement(MOBJECT p, long n);
void    MEditListSeekItem(MOBJECT p, char **argv, long *pos, void **u_data);
void    MEditListGetItemField(MOBJECT el, char *item, int ii, char *buff);

int     MSListGetItemCheckStatus(MOBJECT p, char *item);
void    MSListSetItemCheckStatus(MOBJECT p, char *item, int status);
void	MSListReset(MOBJECT p);

/* EDIT */

MOBJECT MCreateClippedEdit(MOBJECT parent, char *text, int len, int clip_len,
		MTFont font);
MOBJECT MCreateEdit(MOBJECT parent, char *text, int len, MTFont font);
void MEditSetMargin(MOBJECT edit, int w_margin, int h_margin);
void MEditSetFilter(MOBJECT edit, int filter, char *extra_chars);

MOBJECT MCreateClippedMLEdit(MOBJECT parent, char *text,
		int width, int height, MTFont font);
MOBJECT MCreateScrolledMLEdit(MOBJECT parent, char *text,
		int width, int height, MTFont font);

void	MEditChangeText(MOBJECT edit, int off, int len, char *new, int chg_len);
void	MEditGetSubString(MOBJECT edit, int start, int end, char *str);
int	MEditFindSubStringForward(MOBJECT edit, int off, char *str, int icase);
int	MEditFindSubStringBackward(MOBJECT edit, int off, char *str, int icase);
void	MEditSetSelection(MOBJECT edit, int start, int end);
void	MEditGetSelection(MOBJECT edit, int *pstart, int *pend);
void	MEditSetCursorPos(MOBJECT edit, int pos);
int	MEditGetCursorPos(MOBJECT edit);
void	MEditSetCursorXY(MOBJECT edit, int x, int y);
void	MEditGetCursorXY(MOBJECT edit, int *px, int *py);
void	MEditSetAutoIndent(MOBJECT edit, int on_off);

void	MEditSetCursorPosCallback(MOBJECT edit, EDIT_CURS_CB cb, void *data);

void MEditSetTextExt(MOBJECT edit, char *text, int validated, int notify);
void MEditSetActCallback(MOBJECT edit, OBJ_STRING_CB cb, void *data);
void MEditSetValCallback(MOBJECT edit, EDIT_VAL_CB cb, void *data);
void MEditSetValueChangeCallback(MOBJECT edit, EDIT_CHANGE_CB cb, void *data);
void MEditSetNewValueCallback(MOBJECT edit, OBJ_STRING_CB cb, void *data);
void MEditSetHotKeyCallback(MOBJECT edit, int key, MGUI_CB cb, void *data);
void MEditSetValidatedColors(MOBJECT edit, MTColor bg_color, MTColor fg_color);
void MEditSetNotValidatedColors(MOBJECT edit, MTColor bgc, MTColor fgc);
void MEditSetValidationStatus(MOBJECT edit, int validated);
void MEditSetReplace(MOBJECT edit);
int MIsEditValidated(MOBJECT p);
int MEditGetFilter(MOBJECT p);
const char *MEditValue(MOBJECT edit);

/* OPTIONEDIT */

MOBJECT MCreateOptionEdit(MOBJECT parent, char *text, int len, int clip_len,
		int nrow, MTFont font);
MOBJECT MOptionEditGetList(MOBJECT ce);


/* MENU */

MOBJECT MCreateMenuBar(MOBJECT parent, MTFont font);
MOBJECT MCreatePullDown(MOBJECT menu, char *text);
MOBJECT MCreateSubPullDown(MOBJECT pd, PULLDOWN_ITEM item);
PULLDOWN_ITEM	MPullDownAddItem(MOBJECT pd, char *item, MGUI_CB cb, void *ad);
void MPullDownRealize(MOBJECT pd);
void MPullDownUnrealize(MOBJECT pd);
void MPullDownSetTitleText(MOBJECT pd, char *text);
void MPullDownSetItemText(MOBJECT pd, PULLDOWN_ITEM item, char *text);
void MPullDownSetItemAccel(MOBJECT pd, PULLDOWN_ITEM item, int acc, char *at);
void MPullDownSetItemSensitive(MOBJECT pd, PULLDOWN_ITEM item);
void MPullDownSetItemUnsensitive(MOBJECT pd, PULLDOWN_ITEM item);
void MPullDownSetItemSelectCB(MOBJECT p, MGUI_CB cb, void *ad);
void MMenuSetAcc(MOBJECT menu, int acc);
const char *MPullDownGetItemText(MOBJECT obj, PULLDOWN_ITEM item);
const char *MPullDownGetTitleText(MOBJECT obj);
void 	MDestroyPullDown(MOBJECT pd);
int     MSetItemCheckStatus(MOBJECT obj, PULLDOWN_ITEM item, int TrueFalse);
int     MGetItemCheckStatus(MOBJECT obj, PULLDOWN_ITEM item);
int     MToggleItemCheckStatus(MOBJECT obj, PULLDOWN_ITEM item);

/* MGUIUTIL */

int MMessageDialog(char *t, char *msg, char *btn1, char *btn2, ...);
int MInputPrompt(char *t, char *msg, char *text, int len, char *ok_btn,
	char *canc_btn);
char *MTextPrompt(char *t, char *msg, char *text, int w, int h, char *ok,
	char *cancel);

void	MSetInputPromptRGB(int r, int g, int b);
void	MSetMessageDialogRGB(int r, int g, int b);
void	MSetFileSelectionRGB(int r, int g, int b);
void	MGetInputPromptRGB(int *pr, int *pg, int *pb);
void	MGetMessageDialogRGB(int *pr, int *pg, int *pb);
void	MGetFileSelectionRGB(int *pr, int *pg, int *pb);

/* FSEL */

int MFileSelection(char *title, char *filter, char *fname, char *dname,
		int change_cur_dir);
char *MGetCurrentDirectory(void);

/* RS232 */

int MOpenRS232(int port, int baud, int parity, int bits, int stop_bits,
		int r_len, int w_len);
int MCloseRS232(int id);
int MReadRS232(int id, char *buff, int len);
int MWriteRS232(int id, char *buff, int len);
int MSetRS232(int id, int baud, int parity, int bits, int stop_bits);
void MRS232SetDataReadyCallback(int id, RS232_CB cb, void *data);
void MRS232SetReadGrantCallback(int id, int n, long tmout, RS232_CB cb,
		void *data);
void MRS232SetWriteGrantCallback(int id, int n, long tmout, RS232_CB cb,
		void *data);

/* Timeout */

TIMEOUT_ID MAddTimeout(CARD32 tmout, TIMEOUT_CB cb, void *ud);
void MRemoveTimeout(TIMEOUT_ID id);
void MCallAllTimeoutCallbacks(void);
void MRefreshTimeout(TIMEOUT_ID *pid, CARD32 msec, TIMEOUT_CB cb, void *ud);
void MClearTimeout(TIMEOUT_ID *pid);
void MCallExpiredTimeoutCallbacks(void);

/* File values read/write */

void MWriteCARD8(FILE *fp, CARD8 val);
void MWriteCARD16(FILE *fp, CARD16 val);
void MWriteCARD32(FILE *fp, CARD32 val);
CARD8 MReadCARD8(FILE *fp);
CARD16 MReadCARD16(FILE *fp);
CARD32 MReadCARD32(FILE *fp);

/*
 * for backwards compatibility...
 */
#define MPullDownSetItemAcc(a, b, c)	MPullDownSetItemAccel(a, b, c, NULL)

#endif
